#include <sys/types.h>
#include </usr/include/curses.h>
#include <stdio.h>
#include <string.h>
#include "admin.h"

char *
flag2str(flag)
	int flag;
{
	register i = 0;
	static char fbuf[16];

	if ((flag & UF_FLAGS) == UF_UNKNOWN)
		return strcpy(fbuf, "none");
	if ((flag & UF_FLAGS) == UF_GBANK)
		return strcpy(fbuf, "group");

	if (flag & UF_CHARGE)		fbuf[i++] = 'C';
	if (flag & UF_REGULAR)		fbuf[i++] = 'R';
	if (flag & UF_GROUP)		fbuf[i++] = 'G';
	if (flag & UF_BLOCKED)		fbuf[i++] = 'B';
	else if (flag & UF_INFINITY)	fbuf[i++] = 'I';
	if (flag & UF_TERMINATOR)	fbuf[i++] = 'T';
	fbuf[i] = '\0';
	return fbuf;
}

int
get_arrow_key()
{
	int ch;
	int ch1;
	
	ch = getch();
	if (ch == '[' || ch == 'O')
		ch = getch();
	switch (ch) {
		case '\0':	/* xterm */
			return KEYMAP_HOME;
		case 'A':
		case 'i':
			return KEYMAP_UP;

		case 'B':
			return KEYMAP_DOWN;

		case 'D':
			return KEYMAP_LEFT;

		case 'C':
			return KEYMAP_RIGHT;

		case 'I':		/* ansi  PgUp */
		case 'V':		/* at386 PgUp */
		case 'S':		/* 97801 PgUp */
		case 'v':		/* emacs style */
			return KEYMAP_PAGE_UP;

		case 'G':		/* ansi  PgDn */
		case 'U':		/* at386 PgDn */
		case 'T':		/* 97801 PgDn */
			return KEYMAP_PAGE_DOWN;

		case 'H':		/* at386  Home */
			return KEYMAP_HOME;
					
		case 'F':		/* ansi   End */
		case 'Y':		/* at386  End */
			return KEYMAP_END;

		case '5':		/* vt200 PgUp */
			ch = getch();	/* eat the ~ (interesting use of words :) */
			return KEYMAP_PAGE_UP;

		case '6':		/* vt200 PgUp */
			ch = getch();	/* eat the ~  */
			return KEYMAP_PAGE_DOWN;

		case '1':		/* vt200 PgUp */
			ch = getch();	/* eat the ~  */
			if (ch == '5') {	/* RS/6000 PgUp is 150g, PgDn is 154g */
				ch1 = getch();
				ch = getch();
				if (ch1 == '0') 
					return KEYMAP_PAGE_UP;
				if (ch1 == '4') 
					return KEYMAP_PAGE_DOWN;
			}
			return KEYMAP_HOME;
	
		case '4':		/* vt200 PgUp */
			ch = getch();	/* eat the ~  */
			return KEYMAP_END;

		case '2':	/* xterm */
			ch = getch();	/* eat the ~ */
		case 'L':
			return KEYMAP_INS;
		case 'M':
			return KEYMAP_F1;
		case 'N':
			return KEYMAP_F2;
		case 'O':
			return KEYMAP_F3;
		case 'P':
			return KEYMAP_F4;

		default:
			return KEYMAP_UNKNOWN;
	}
}
