#ifndef _SYS_IPC_H
#define _SYS_IPC_H

#include <sys/types.h>
#include <sys/stat.h>

#define EIDRM 43
#define S_IRUGO (S_IRUSR|S_IRGRP|S_IROTH)
#define S_IWUGO (S_IWUSR|S_IWGRP|S_IWOTH)

#if !defined(_KEY_T)
#define _KEY_T
typedef int key_t;
#endif

#define IPC_PRIVATE ((key_t) 0)

struct ipc_perm
{
        key_t  key;
        uid_t  uid;
        gid_t  gid;
        uid_t  cuid;
        gid_t  cgid;
        mode_t mode;
        unsigned short  seq;
};

/* resource get request flags */
#define IPC_CREAT  00001000   /* create if key is nonexistent */
#define IPC_EXCL   00002000   /* fail if key exists */
#define IPC_NOWAIT 00004000   /* return error on wait */


/*
 * Control commands used with semctl, msgctl and shmctl
 * see also specific commands in sem.h, msg.h and shm.h
 */
#define IPC_RMID 0     /* remove resource */
#define IPC_SET  1     /* set ipc_perm options */
#define IPC_STAT 2     /* get ipc_perm options */
#define IPC_INFO 3     /* see ipcs */

/* special shmsegs[id], msgque[id] or semary[id]  values */
#define IPC_UNUSED      ((void *) -1)
#define IPC_NOID        ((void *) -2)           /* being allocated/destroyed */

#endif /* _SYS_IPC_H */


