/*------------------------------------------------------------------
 * update.cmd
 *------------------------------------------------------------------
 * Modified by Bruce Dudley os2box@dingoblue.net.au on 05-12-2001
 * Adapted to suit the new DYNDNS update format
 * Changed the method in obtaining the local ppp0 IP number
 * Added return code reporting from the DYNDNS server
 * Only the update.cmd file required, no need for suspend.cmd any
 * longer (see dns-on.cmd/dns-off.cmd) for details.
 *
 * Modified by Vinicius Beltrao on 07-23-2000
 * in order to work properly with DYNDNS.ORG domains/update system
 *
 * Original by Dennis Peterson on 7-27-97 for usage with the old ml.org
 *
 * Archive includes b64rx.dll which encodes the userid:password string
 * The b64rx.dll code was created by Teet Knnussaar (teet@aetec.estnet.ee)
 *
 * Requires rxsock.dll
 * Requires registation with www.dyndns.org which is free for now
 *
 * This code is free to everyone.
 *------------------------------------------------------------------*/

/*-------------------
Basic Info from www.dyndns.org:

The host to connect to is: members.dyndns.org.
The protocol to use is HTTP or HTTPS.
The port number is 80 (HTTP) or (HTTPS).
The path is /nic/update?
Both PUT and GET methods can be used.
The arguments are (these are examples, but they're reasonable defaults):

command=Update+Host
do=mod
domain=HOST

This is an example of a line that could be sent to the ML server to
update a host artur.dyn.ml.org:

GET /nic/update?system=dydns&hostname=YES&hostname=yourhost.ourdomain.ext&myip=ipaddress&wildcard=OFF&mx=mail.exchanger.ext&backmx=NO HTTP/1.1

That line should be followed by the authorization data on one line, and an
empty line.

Authorization
The authorization line mentioned above is:
Authorization: Basic ENCODED_MID_AND_PASSWORD
Eg if artur1 is the MID and password is the password, then it is
formatted as "artur1:password" (w/o the qoutes) and encoded using
base64 (Authorization: Basic YXJ0dXIxOnBhc3N3b3Jk).
---------------------*/

/* -----------------------------------------------------------------
 * Initialize REXX utilities
 *------------------------------------------------------------------*/
if RxFuncQuery("SysLoadFuncs") then
  do
    Call RxFuncAdd "Sysloadfuncs","RexxUtil","Sysloadfuncs"
    Call SysLoadFuncs
  end

/*------------------------------------------------------------------
 * Initialize md5rx API package
 *------------------------------------------------------------------*/

call rxfuncadd 'B64encode','md5rx','B64encode'
call rxfuncadd 'B64decode','md5rx','B64decode'

/*------------------------------------------------------------------
 * Initialize socket package
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
    do
      rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
      rc = SockLoadFuncs(NoCopyright)
    end

/*-----------------------------------------------------------------
 * Setup some constants
 *-----------------------------------------------------------------*/

mydyn = ""
myppp = ""
crlf = "0d0a"x
noip = "255.255.255.255"
port = 80   /* Choose port number - http port is normally 80 or 8245
               to bypass proxys */

/*-----------------------------------------------------------------
 * Obtain variables from config file
 *----------------------------------------------------------------*/

parse arg domain userid password status .

if (domain = "?") then
   Usage()
if (domain = "") then
   Usage()

/*-----------------------------------------------------------------
 * Decide if we are to update the IP to DYNDNS
 *----------------------------------------------------------------*/

if (status = "online") then

/*------------------------------------------------------------------
 * Get IP from IFCONFIG
 *------------------------------------------------------------------*/
'@ifconfig ppp0 | find /i "inet" | rxqueue'
If queued() <> 0 then
    do
        Parse Pull lin
        Parse Var lin "." -5 . myppp . remoteip .
    end
else

myppp = noip

/*------------------------------------------------------------------
 * Initialize http variables - Yes -- rexx can to HTML!
 *------------------------------------------------------------------*/
server = "members.dyndns.org"
security = "Host:" || domain || crlf || "Authorization: Basic" B64Encode(userid || ":" || password) || crlf || "User-Agent: Vinicius Beltrao's for OS/2" || crlf || crlf

URL = "GET /nic/update?"
URL = URL || "system=dyndns"
URL = URL || "&hostname=" || domain
URL = URL || "&myip=" || myppp
URL = URL || "&wildcard=ON"
URL = URL || "&mx="
URL = URL || "&backmx=NO HTTP/1.1" || crlf

/*------------------------------------------------------------------
 * Get myip.hostname.name > IP
 *------------------------------------------------------------------*/
rc = SockGetHostByName(domain,"host.!")
if (rc = 0) then
   do
      say "Error" h_errno "calling SockGetHostByName("domain")"
      exit
   end

mydyn = host.!addr;

if compare(mydyn,myppp) = 0 then
    do
      say "No update nessary. The DNYDNS and your IP are the same"
      say "Current DYNDNS IP is -----:" mydyn
      say "Your current ppp0 IP is --:" myppp
      rc = SockDropFuncs()
      exit
    end

/*------------------------------------------------------------------
 * Get server name
 *------------------------------------------------------------------*/
rc = SockGetHostByName(server,"host.!")
if (rc = 0) then
   do
      say "Error" h_errno "calling SockGetHostByName("server")"
      exit
   end

server = host.!addr;

/*---------------------------------------------------------------
 * Open socket
 *---------------------------------------------------------------*/
socket  = SockSocket("AF_INET","SOCK_STREAM",0)
if (socket = -1) then
   do
      say "Error on SockSocket:" errno
      exit
   end

/*------------------------------------------------------------------
 * Catch breaks
 *------------------------------------------------------------------*/
signal on halt

/*---------------------------------------------------------------
 * Connect socket
 *---------------------------------------------------------------*/
server.!family = "AF_INET"
server.!port   = port
server.!addr   = server

rc = SockConnect(socket,"server.!")
if (rc = -1) then
   do
      say "Error on SockConnect:" errno
      exit
   end

rc = SockSend(socket, URL)
if (rc = -1) then
   do
      say "Error on SockSend URL:" errno
      exit
   end

rc = SockSend(socket, security)
if (rc = -1) then
   do
      say "Error on SockSend security:" errno
      exit
   end

/*------------------------------------------------------------------
 * Receive the result from the server
 *------------------------------------------------------------------*/

do until rc = 0
   rc = SockRecv(socket,"newData",512)
   returnData = returnData || newData
end


/*------------------------------------------------------------------
 * Check results sent from DYNDNS
 *------------------------------------------------------------------*/

select
   when pos('badauth',returnData) > 0 then do
        say 'Bad authorization (username and/or password).'
   end

   when pos('badsys',returnData) > 0 then do
        say 'The system parameter was not valid.'
   end

   when pos('badagent',returnData) > 0 then do
        say 'The useragent your client sent has been blocked at the access level.'
   end

   when pos('good',returnData) > 0 then do
        good = SubStr(returnData,(pos('good',returnData) + 5),15)
        say 'Update good and successful, IP updated to -:' good
   end

   when pos('nochg',returnData) > 0 then do
        say 'No changes, update considered abusive.'
   end

   when pos('notfqdn',returnData) > 0 then do
        say 'A Fully-Qualified Domain Name was not provided.'
   end

   when pos('nohost',returnData) > 0 then do
        say 'The hostname specified does not exist.'
   end

   when pos('abuse',returnData) > 0 then do
        say 'The hostname specified is blocked for abuse. contact support to be unblocked.'
   end

   when pos('!donator',returnData) > 0 then do
        say 'The offline setting was set, when the user is not a donator, this is only returned once.'
   end

   when pos('!yours',returnData) > 0 then do
        say 'The hostname specified exists, but not under the username currently being used.'
   end

   when pos('numhost',returnData) > 0 then do
        say 'Too many or too few hosts found.'
   end

   when pos('dnserr',returnData) > 0 then do
        say 'DNS error encounted.'
   end

   when pos('wxxh',returnData) > 0 then do
        wxxh = SubStr(returnData,(pos('wxxh',returnData) + 12),2)
        say 'DynDns has told me to wait for ' wxxh ' hours. ZZzzzz'
        call syssleep wxxh
   end

   when pos('wxxm',returnData) > 0 then do
        wxxm = SubStr(returnData,(pos('wxxm',returnData) + 12),2)
        say 'DynDns has told me to wait for ' wxxm ' minutes. ZZzzzz'
        call syssleep wxxm
   end

   when pos('wxxs',returnData) > 0 then do
        wxxs = SubStr(returnData,(pos('wxxs',returnData) + 12),2)
        say 'DynDns has told me to wait for ' wxxs ' seconds. ZZzzzz'
        call syssleep wxxs
   end

   when pos('911',returnData) > 0 then do
        say 'Shutdown until notified.'
   end

   when pos('999',returnData) > 0 then do
        say 'Shutdown until notified.'
   end

   otherwise
        say 'Ooops, not too sure whats going on here .....!'
   end

/*------------------------------------------------------------------
 * Close socket (and catch signals)
 *------------------------------------------------------------------*/
halt:

rc = SockSoClose(socket)
if (rc = -1) then
   do
   say "Error on SockSoClose:" errno
   exit
   end

rc = SockDropFuncs()
exit

/*------------------------------------------------------------------
 * Some simple help
 *------------------------------------------------------------------*/
Usage: procedure
   parse source . . me .

   say "usage:"
   say "   " me "domain userid password online/offline"
   say "    is used to activate the dynamin DNS"
   say "    domain becomes 'domain.dyndns.org'"
   say
   exit
