/* MakeList.cmd */

  parse arg server

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  call syscls

  version='1.70'

  say'MakeList 'version
  say''

  if (server = "") then do
     say "Expecting a news server name to be passed as a parameter."
     exit 1
     end /* if */

/*------------------------------------------------------------------
 * initialize socket function package
 *------------------------------------------------------------------*/

  if RxFuncQuery("SockLoadFuncs") then do
    rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
    rc = SockLoadFuncs()
    end /* if */

/*------------------------------------------------------------------
 * get address of server
 *------------------------------------------------------------------*/
  rc = SockGetHostByName(server,"host.!")

  if (rc = 0) then do
    say "Unable to resolve server name" server
    exit 1
    end /* if */

  server = host.!addr

/*------------------------------------------------------------------
 * open socket
 *------------------------------------------------------------------*/
  sock = SockSocket("AF_INET","SOCK_STREAM",0)

  if (sock = -1) then do
    say "Error opening socket:" errno
    exit 1
    end /* if */

/*------------------------------------------------------------------*
 * configure socket for large buffers                               *
 *------------------------------------------------------------------*/

  rc = SockSetSockOpt(sock, 'SOL_SOCKET', 'SO_RCVBUF', 16384)
  if (rc = -1) then Error(sock,rc,'Error in setting socket receive buffer size :'errno)

  rc = SockSetSockOpt(sock, 'SOL_SOCKET', 'SO_SNDBUF', 16384)
  if (rc = -1) then Error(sock,rc,'Error in setting socket send buffer size :'errno)

/*------------------------------------------------------------------
 * connect socket
 *------------------------------------------------------------------*/
  server.!family = "AF_INET"
  server.!port   = 119
  server.!addr   = server

  rc = SockConnect(sock,"server.!")

  if (rc = -1) then Error(sock,rc,"Error connecting to newsserver :" errno)

  trc = GetResponse(sock)

  do i = 1 to line.0
    say line.i
    end /* do */

  rc = Interact(sock, group, server)    /*Jump to interact function*/

/*------------------------------------------------------------------
 * quittin' time!
 *------------------------------------------------------------------*/
  rc = SendMessage(sock,"quit")
  rc = SockSoclose(sock)

  exit

/*------------------------------------------------------------------
 * get command and execute in a loop
 *------------------------------------------------------------------*/
  Interact:        procedure expose !.

    sock = arg(1)
    group = arg(2)
    serverName = arg(3)

    say "Getting current list of ALL newsgroups."
    say "This will take some time!"
    trc = SendMessage(sock,"list")

    trc = GetResponse(sock)

    say "Writing newsgroups to file."

    do i = 1 to line.0
     if pos('bina',line.i) > 0 then call lineout 'group.list',line.i
      end /* do */

    call lineout 'group.list'

    return ""

/*----------------------------------------------------------------------------*
 * send a string to the server:                                               *
 * This subroutine will loop endlessly until the last character of the data   *
 * is sent to the server. The loop will terminate with error if RC comes back *
 * with a value other than zero "0"                                           *
 *----------------------------------------------------------------------------*/

SendMessage: procedure expose !.

  sock = arg(1)
  data = arg(2) || d2c(13) || d2c(10)

  len = length(data)

  do while (len > 0)

    rc = SockSend(sock,data);

    if (errno <> 0) then Error(-1,rc,"Error sending data to server.")
    if (rc<= 0) then Error(sock,100,"Server closed the connection.")

    data = substr(data,len+1)
    len  = length(data)

  end /* do while */

  return 0

/*------------------------------------------------------------------
 * get a response from the server
 *------------------------------------------------------------------*/
  GetResponse:     procedure expose !. line.
    sock = arg(1)

    moreids = "100 215 220 221 222 223 230 231"

    line.0 = 1
    line.1 = GetResponseLine(sock)

    parse var line.1 rid .

    if (wordpos(rid,moreids) = 0) then return ""

    if rid = 223 then return ""

    do forever
      o = line.0 + 1
      line.o = GetResponseLine(sock)
      if (line.o == ".") then return ""
      line.0 = o
      end /* do */

   return ""

/*------------------------------------------------------------------
 * get a line from the server
 *------------------------------------------------------------------*/
  GetResponseLine: procedure expose !.
    sock = arg(1)

    crlf = d2c(13) || d2c(10)

    if (symbol('!.buff') = "LIT") then !.buff = ""

    do while (pos(crlf,!.buff) = 0)
      rc = SockRecv(sock,"data",8000)
      !.buff = !.buff || data
      end /* do */

    p = pos(crlf,!.buff)

    line = substr(!.buff,1,p-1)
    !.buff = substr(!.buff,p+2)

    return line

/*------------------------------------------------------------------
 * halting ...
 *------------------------------------------------------------------*/
  Halting:

    Error(sock,1,"error on line" sigl)

/*------------------------------------------------------------------
 * exit with a message and return code
 *------------------------------------------------------------------*/
  Error: procedure
    sock = arg(1)
    retc = arg(2)
    msg  = arg(3)

   if (sock <> -1) then rc = SockSoClose(sock)

   say sock retc msg

   exit retc

