/* BSParse.cmd - Used to convert 1.60 duplicates.log to 1.70 format */

  duplicateLogFilename='duplicates.log'
  duplicateLogDir='DuplicateLogs'

  rc=stream(duplicatelogfilename,'c','query exists')

  if rc='' then do
    say
    say"Sorry, I can't find the duplicates.log file!"
    say

    rc=errorSound(1)

    exit
    end /* rc='' */

/* check for dupebase directory */

  do forever
    rc=sysMkDir(duplicateLogDir)

    if rc=0 then do
      say'Created a new DuplicateLogs directory for the BinSuk 1.70 files'
      say''
      leave
      end /* if rc */

    say'ATTENTION!'
    say''
    say"You've already created the appropriate directory!"
    say'BSParse is terminating without processing 'duplicateLogFilename
    say''

    rc=errorSound(1)

    exit

    end /* do forever */

  say'Parsing 'duplicateLogFilename' into version 1.70 log file format...'
  say''

  do while lines(duplicatelogfilename)

    text  = translate(linein(duplicatelogfilename))

    prefix=left(text,1)

    rc=stream(duplicateLogDir||'\'||prefix||'.LOG','c','open')
    rc=stream(duplicateLogDir||'\'||prefix||'.LOG','c','seek <0')
    rc=lineout(duplicateLogDir||'\'||prefix||'.LOG',text||'/'||date('b'))
    rc=stream(duplicateLogDir||'\'||prefix||'.LOG','c','close')

    end /* do while */

  call stream duplicatelogfilename,'c','close'

  rc=doneSound(1)

  say'Finished the translation of the 1.60 duplicate log to the new 1.70 format'
  say''

  exit

errorSound: procedure

  SOUND=arg(1)

  if SOUND = 1 then do
    call beep 400, 25
    call beep 500, 25
    end /* if sound */

    return 0

doneSound: procedure

  SOUND=arg(1)

  if Sound = 1 then do
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100

    end /* if sound */

  return 0

