/* REXX deinstallation script for Auto WGet
 * Copyright (C) 1999 by Dmitry A.Steklenev
 *
 * $Revision: 1.5.1.2 $
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse source os what program tail
dll = substr( program, 1, lastpos( "\", program )) || "awget.dll"

call RxFuncAdd 'AwLoadFuncs', dll, 'AwLoadFuncs'
call AwLoadFuncs

'@echo off'

if translate( value( "REXX_TRACE",, "OS2ENVIRONMENT" )) == "YES" then do
   trace intermediate
   trace results
end

CfgFile = value( "ETC",, "OS2ENVIRONMENT" )"\awget.cfg"

/*------------------------------------------------------------------
 * Initialization
 *------------------------------------------------------------------*/

say "Auto WGet Daemon $Revision: 1.5.1.2 $ deinstallation"
say "Copyright (C) 1999 by Dmitry A.Steklenev"
say ""

call MsgRead "awget"

say msg.msg_warning
say ""

if MsgYesNo( "!!! "msg.msg_uninstl ) == 0 then
   exit

rc = SysDestroyObject( "<AWG_DAEMON>" )
rc = SysDestroyObject( "<AWG_TODO>"   )

say "Done!"
exit

/*------------------------------------------------------------------
 * National Messages Procedures
 *------------------------------------------------------------------*/
MsgRead: procedure expose msg.

  parse arg msgfile
  parse source OS2 what msgpath

  msgfile = filespec( "disk", msgpath ) ||,
            filespec( "path", msgpath ) || msgfile

  country = strip( SysIni( "BOTH", "PM_National", "iCountry" ),, '0'x )
  country = right( country, 3, "0" )

  if stream( msgfile"."country, "c", "query exists" ) == "" then
     country = "001"

  msgfile = msgfile"."country
  rc = stream( msgfile, "C", "OPEN READ" )

  if rc \= "READY:" then do
     say "ERROR: Error open message file: "msgfile
     exit
  end

  do while lines(msgfile) > 0
     line = linein(msgfile)

     if line \= "" then do
        parse value line with id "=" msg

        id  = translate(strip(id))
        msg = strip(msg)

        i = pos( "\n", msg )
        do while i > 0
           msg = substr( msg, 1, i-1 ) || '0A0D'x || substr( msg, i+2 )
           i = pos( "\n", msg )
        end

        msg.id = msg
     end
  end

  rc = stream( msgfile, "C", "CLOSE" )

return

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
MsgYesNo: procedure expose msg.

   parse arg prompt
   ok = 0

   do until ok
      call charout, prompt"? "
      pull reply
      reply = left(reply,1)

      ok = (reply == "Y") |,
           (reply == "N") |,
           (pos( reply, msg.msg_yes ) > 0 ) |,
           (pos( reply, msg.msg_no  ) > 0 )

      if \ok then do
         say msg.msg_badyn
      end
   end

return (reply = "Y") | (pos( reply, msg.msg_yes ) > 0 )

