/* Auto WGet Daemon $Revision: 1.5.1.2 $
 *
 * Great idea and first release (C) 1998 by Steve Trubachev
 * Final release (C) 1998-1999 by Dmitry A.Steklenev
 *
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse source os what program tail
dll = substr( program, 1, lastpos( "\", program )) || "awget.dll"

call RxFuncAdd 'AwLoadFuncs', dll, 'AwLoadFuncs'
call AwLoadFuncs

'@echo off'

if translate( value( "REXX_TRACE",, "OS2ENVIRONMENT" )) == "YES" then do
   trace intermediate
   trace results
end

CfgFile = value( "ETC",, "OS2ENVIRONMENT" )"\awget.cfg"

/*------------------------------------------------------------------
 * Initialization
 *------------------------------------------------------------------*/

say "Auto WGet Daemon $Revision: 1.5.1.2 $"
say "Great idea and first release (C) 1998 by Steve Trubachev"
say "Final release (C) 1998-1999 by Dmitry A.Steklenev"
say ""

pppOKey = 1

call MsgRead  "awget"
call CfgRead  CfgFile
call CfgShow
say  ""
call DirRead
call DirShow
say  ""

/*------------------------------------------------------------------
 * Start Daemon
 *------------------------------------------------------------------*/

do forever

   /* Check configuration file */

   call CfgCheck CfgFile

   rc = SysFileTree( dir.todo"\*"   ,'todo'   , 'FO' )
   rc = SysFileTree( dir.running"\*",'running', 'FO' )

   /* Recover interrupted files */

   refresh = 0

   do i = 1 to running.0

      fname = filespec( "name", running.i )

      if AwLockIs( fname ) == 0 then do

         call LogPut cfg.logfile, msg.msg_recover": "fname
         fname = WpsMove( dir.running"\"fname, dir.todo"\"fname )

         if  fname \= "" then do
             todolen = todo.0 + 1
             todo.todolen = fname
             todo.0  = todolen
             refresh = 1
         end
      end
   end

   if refresh then do
      rc = WpsRefresh( dir.todo    )
      rc = WpsRefresh( dir.running )
   end

   /* Scan DeskTop */

   if cfg.use_desktop then do

      refresh = 0
      rc = SysFileTree( dir.desktop"\*" ,'desktop','FO' )

      do i = 1 to desktop.0

         fname = filespec( "name", desktop.i )

         if IsURLFile( desktop.i ) then do
            fname = WpsMove( dir.desktop"\"fname, dir.todo"\"fname )

            if fname \= "" then do
               todolen = todo.0 + 1
               todo.todolen = fname
               todo.0  = todolen
               refresh = 1
            end
         end
      end
   end

   if refresh then do
      rc = WpsRefresh( dir.desktop )
      rc = WpsRefresh( dir.todo    )
   end

   /* Check PPP connection */

   if cfg.check_connection & todo.0 > 0 then do

      pppState = CheckPPP()
      if pppOKey \= pppState then do
         pppOkey  = pppState

         if pppOkey then
            call LogPut cfg.logfile, msg.msg_pppokey
         else
            call LogPut cfg.logfile, msg.msg_pppbad
      end

      if pppOKey == 0 then do
         call SysSleep cfg.scan_interval
         iterate
      end
   end

   /* Shedule */

   do i = 1 to todo.0

      rc = SysFileTree( dir.running"\*", 'running', 'FO' )

      if running.0 >= cfg.maximum_downloads then
         leave

      if \IsURLFile(todo.i) then do
         call logPut cfg.errorlog, msg.msg_invurl": "todo.i
         call WpsMove todo.i, dir.failed"\"filespec( "name", todo.i )
         rc = WpsRefresh( dir.failed )
         rc = WpsRefresh( dir.todo   )
         iterate
      end

      if cfg.messages then
         call beep 1000, 50

      url = GetURLFromFile(todo.i)
      run = WpsMove( todo.i, dir.running"\"filespec( "name", todo.i ))

      if run \= "" then do

         call LogPut cfg.logfile, msg.msg_getstart": "url

         if length(url) > 49 then
            url = "..." || right( url, 49 )

         rc = WpsRefresh( dir.running )
         rc = WpsRefresh( dir.todo    )

        'set REXX_TRACE='
        'start "Auto WGet: 'url'" /min /c /pgm "'directory()'\awgets.cmd" "'run'"'

         do wait_start = 1 to 30

            if AwLockIs( filespec( "name", run )) |,
               stream( run, "c", "query exists" ) == "" then
               leave

            call SysSleep(1)
         end
       end
   end
   call SysSleep cfg.scan_interval
end

/*------------------------------------------------------------------
 * National Messages Procedures
 *------------------------------------------------------------------*/
MsgRead: procedure expose msg.

  parse arg msgfile
  parse source OS2 what msgpath

  msgfile = filespec( "disk", msgpath ) ||,
            filespec( "path", msgpath ) || msgfile

  country = strip( SysIni( "BOTH", "PM_National", "iCountry" ),, '0'x )
  country = right( country, 3, "0" )

  if stream( msgfile"."country, "c", "query exists" ) == "" then
     country = "001"

  msgfile = msgfile"."country
  rc = stream( msgfile, "C", "OPEN READ" )

  if rc \= "READY:" then do
     say "ERROR: Error open message file: "msgfile
     exit
  end

  do while lines(msgfile) > 0
     line = linein(msgfile)

     if line \= "" then do
        parse value line with id "=" msg

        id  = translate(strip(id))
        msg = strip(msg)

        i = pos( "\n", msg )
        do while i > 0
           msg = substr( msg, 1, i-1 ) || '0A0D'x || substr( msg, i+2 )
           i = pos( "\n", msg )
        end

        msg.id = msg
     end
  end

  rc = stream( msgfile, "C", "CLOSE" )

return

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
MsgYesNo: procedure expose msg.

   parse arg prompt
   ok = 0

   do until ok
      call charout, prompt"? "
      pull reply
      reply = left(reply,1)

      ok = (reply == "Y") |,
           (reply == "N") |,
           (pos( reply, msg.msg_yes ) > 0 ) |,
           (pos( reply, msg.msg_no  ) > 0 )

      if \ok then do
         say msg.msg_badyn
      end
   end

return (reply = "Y") | (pos( reply, msg.msg_yes ) > 0 )

/*------------------------------------------------------------------
 * Get Configuration
 *------------------------------------------------------------------*/
CfgRead: procedure expose cfg. msg.

  parse arg CfgFile

  cfg.download          = "."
  cfg.maximum_downloads = 3
  cfg.messages          = 1
  cfg.message_done      = ""
  cfg.message_error     = ""
  cfg.wget_parameters   = "-c -t 0 -w 30"
  cfg.scan_interval     = 60
  cfg.check_connection  = 0
  cfg.logfile           = ""
  cfg.errorlog          = ""
  cfg.use_desktop       = 0
  cfg.keep_failed       = 1
  cfg.keep_done         = 0

  rc = stream( CfgFile, "C", "OPEN READ" )

  do while lines(CfgFile) > 0
     parse value linein(CfgFile) with command "=" argument

     command = translate(strip(command))
     argument = strip(argument)

     select
        when command == "DOWNLOAD" then
             cfg.download = argument
        when command == "MAXIMUM_DOWNLOADS_SIMULTANEOUSLY" then
             cfg.maximum_downloads = argument
        when command == "MESSAGES" then
             cfg.messages = (argument == "1")
        when command == "WGET_PARAMETERS" then
             cfg.wget_parameters = argument
        when command == "SCAN_INTERVAL" then
             cfg.scan_interval = argument
        when command == "LOG_FILE" then
             cfg.logfile = argument
        when command == "ERROR_LOG" then
             cfg.errorlog = argument
        when command == "MESSAGE_DONE" then
             cfg.message_done = argument
        when command == "MESSAGE_ERROR" then
             cfg.message_error = argument
        when command == "CHECK_CONNECTION" then
             cfg.check_connection = (argument == "1")
        when command == "USE_DESKTOP" then
             cfg.use_desktop = (argument == "1")
        when command == "KEEP_FAILED_URL" then
             cfg.keep_failed = (argument == "1")
        when command == "KEEP_DONE_URL" then
             cfg.keep_done = (argument == "1")
        otherwise
     end
  end

  if right( cfg.download, 1 ) = "\" then
     cfg.download = left( cfg.download, length(cfg.download) - 1 )

  setlocal
  cfg.download = directory( cfg.download )
  endlocal

  if cfg.download == "" then do
     call LogPut cfg.errorlog, msg.msg_invdown
     cfg.download = "."
  end

  rc = stream( CfgFile, "C", "CLOSE" )
  cfg.file_date = stream( CfgFile, "C", "QUERY DATETIME" )

return

/*------------------------------------------------------------------
 * Show Configuration
 *------------------------------------------------------------------*/
CfgShow: procedure expose cfg. msg.

  say "*** "msg.msg_downdir  || ": "cfg.download
  say "*** "msg.msg_maxcon   || ": "cfg.maximum_downloads
  say "*** "msg.msg_show     || ": "cfg.messages

  if cfg.message_done \= "" then
     say "*** "msg.msg_done  || ": "cfg.message_done

  if cfg.message_error \= "" then
     say "*** "msg.msg_error || ": "cfg.message_error

  say "*** "msg.msg_interval || ": "cfg.scan_interval
  say "*** "msg.msg_chckconn || ": "cfg.check_connection
  say "*** "msg.msg_parm     || ": "cfg.wget_parameters
  say "*** "msg.msg_usedesk  || ": "cfg.use_desktop
  say "*** "msg.msg_keepfail || ": "cfg.keep_failed
  say "*** "msg.msg_keepdone || ": "cfg.keep_done

return

/*------------------------------------------------------------------
 * Save Configuration
 *------------------------------------------------------------------*/
CfgSave: procedure expose cfg. msg.

  parse arg CfgFile

  if stream( CfgFile, "C", "QUERY EXISTS" ) \= "" then
     "del "CfgFile

  rc = stream( CfgFile, "C", "OPEN WRITE" )

  rc = lineout( CfgFile, "download = "cfg.download )
  rc = lineout( CfgFile, "maximum_downloads_simultaneously = "cfg.maximum_downloads )
  rc = lineout( CfgFile, "messages = "cfg.messages )

  if cfg.message_done  \= "" then
     rc = lineout( CfgFile, "message_done  = "cfg.message_done  )

  if cfg.message_error \= "" then
     rc = lineout( CfgFile, "message_error = "cfg.message_error )

  rc = lineout( CfgFile, "log_file = "cfg.logfile )
  rc = lineout( CfgFile, "error_log = "cfg.errorlog )
  rc = lineout( CfgFile, "wget_parameters = "cfg.wget_parameters )
  rc = lineout( CfgFile, "scan_interval = "cfg.scan_interval )
  rc = lineout( CfgFile, "check_connection = "cfg.check_connection )
  rc = lineout( CfgFile, "use_desktop = "cfg.use_desktop )
  rc = lineout( CfgFile, "keep_failed_url = "cfg.keep_failed )
  rc = lineout( CfgFile, "keep_done_url = "cfg.keep_done )

  rc = stream( CfgFile, "C", "CLOSE" )

return

/*------------------------------------------------------------------
 * Check Configuration
 *------------------------------------------------------------------*/
CfgCheck: procedure expose cfg. msg.

  parse arg CfgFile

  if cfg.file_date \= stream( CfgFile, "C", "QUERY DATETIME" ) then do

     call LogPut cfg.logfile, msg.msg_readcfg
     call CfgRead CfgFile
     say
     call CfgShow
     say
  end

return

/*------------------------------------------------------------------
 * Check PPP connection
 *------------------------------------------------------------------*/
CheckPPP: procedure

  NewQueue = RxQueue( 'create' )
  OldQueue = RxQueue( 'set', NewQueue )

  Connect  = 0

  '@netstat -a | RXQUEUE' NewQueue

  do while queued() > 0
     parse pull . IP1 . Interface . . . IP2
     if Interface >= '10' then do
        Connect = 1
     end
  end

  call RxQueue 'delete', NewQueue
  call RxQueue 'set'   , OldQueue

return Connect

/*------------------------------------------------------------------
 * Get URL from file
 *------------------------------------------------------------------*/
GetURLFromFile: procedure

  parse arg filename

  rc  = stream(filename, "c", "open read" )
  url = linein(filename)
  rc  = stream(filename, "c", "close" )

  do while pos( "%", url ) > 0

     i = pos( "%", url )

     url = substr( url, 1, i-1      ) ||,
           x2c(substr( url, i+1, 2 )) ||,
           substr( url, i+3         )
  end

return url

/*------------------------------------------------------------------
 * Get filename from URL
 *------------------------------------------------------------------*/
GetFileFromURL: procedure

  parse arg url

  pos_parm = pos( "?", url )
  if pos_parm \= 0 then
    url = substr( url, 1, pos_parm-1 )

  pos_name = lastpos( "/", url )
  if pos_name \= 0 then
    url = substr( url, pos_name+1 )

return url

/*------------------------------------------------------------------
 * Check valid URL file
 *------------------------------------------------------------------*/
IsURLFile: procedure

  parse arg filename

  rc  = stream(filename, "c", "open read" )
  url = translate( strip( charin(filename,1,16)))
  rc  = stream(filename, "c", "close" )

return substr( url, 1, 7 ) == "HTTP://" |,
       substr( url, 1, 6 ) == "FTP://"

/*------------------------------------------------------------------
 * Write Log Record
 *------------------------------------------------------------------*/
LogPut: procedure expose cfg.

  parse arg logfile, message

  say " "message
  if logfile \= "" then do
     call lineout logfile, date()" "time()" -> "message
     rc = stream( logfile, "c", "close" )
  end

return

/*------------------------------------------------------------------
 * Append Log Record
 *------------------------------------------------------------------*/
LogAdd: procedure expose cfg.

  parse arg logfile, message

  if logfile \= "" then do
     call lineout logfile, date()" "time()" -> "message
     rc = stream( logfile, "c", "close" )
  end

return


/*------------------------------------------------------------------
 * Move file
 *------------------------------------------------------------------*/
WpsMove: procedure expose msg. cfg.

  parse arg file_from, file_to

  rc = SysGetEA( file_from, ".LONGNAME", file_long )

  if file_long == "" then
     rc = WpsPutEA( file_from, ".LONGNAME", filespec( "name", file_from ))

  if stream( file_to, "c", "query exists" ) \= "" then do
     file_to = SysTempFileName( file_to"!???" )
  end

  'copy "'file_from'" "'file_to'" 1> nul 2> nul'

  if rc == 0 then
     'del "'file_from'" 1> nul 2> nul'
  else do
     call LogPut cfg.error_log msg.msg_notmove": "file_from" -> "file_to
     file_to = ""
  end

return file_to

/*------------------------------------------------------------------
 * Write a named ascii extended attribute to a file
 *------------------------------------------------------------------*/
WpsPutEA: procedure

  parse arg file, name, value

  value = 'FDFF'x ||,
           substr( d2c(length(value)), 1, 2, '00'x ) || value

return SysPutEA( file, name, value )

/*------------------------------------------------------------------
 * Refresh Folder
 *------------------------------------------------------------------*/
WpsRefresh: procedure

  parse arg path

return SysSetObjectData( path, "MENUITEMSELECTED=503" )

/*------------------------------------------------------------------
 * Get Directorys
 *------------------------------------------------------------------*/
DirRead: procedure expose dir. msg. cfg.

  dir.todo    = AwGetObjectPath( "<AWG_TODO>"   )
  dir.running = AwGetObjectPath( "<AWG_RUN>"    )
  dir.done    = AwGetObjectPath( "<AWG_DONE>"   )
  dir.failed  = AwGetObjectPath( "<AWG_ERROR>"  )
  dir.desktop = AwGetObjectPath( "<WP_DESKTOP>" )

  /* check it */

  if dir.todo    == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "ToDo"'
     exit 1
  end
  if dir.running == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "Running"'
     exit 1
  end
  if dir.done    == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "Done"'
     exit 1
  end
  if dir.failed  == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "Failed"'
     exit 1
  end
  if dir.desktop == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "Desktop"'
     exit 1
  end

return

/*------------------------------------------------------------------
 * Show Directorys
 *------------------------------------------------------------------*/
DirShow: procedure expose dir.

  say "*** ToDo:    "dir.todo
  say "*** Running: "dir.running
  say "*** Done:    "dir.done
  say "*** Failed:  "dir.failed
  say "*** Desktop: "dir.desktop
return
