/* Auto WGet Add Utility $Revision: 1.5.1.2 $
 *
 * Copyright (C) 1999 by Dmitry A.Steklenev
 *
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse source os what program tail
dll = substr( program, 1, lastpos( "\", program )) || "awget.dll"

call RxFuncAdd 'AwLoadFuncs', dll, 'AwLoadFuncs'
call AwLoadFuncs

'@echo off'

if translate( value( "REXX_TRACE",, "OS2ENVIRONMENT" )) == "YES" then do
   trace intermediate
   trace results
end

CfgFile = value( "ETC",, "OS2ENVIRONMENT" )"\awget.cfg"

/*------------------------------------------------------------------
 * Initialization
 *------------------------------------------------------------------*/

say "Auto WGet Url Add $Revision: 1.5.1.2 $"
say "Copyright (C) 1999 by Dmitry A.Steklenev"
say ""

"SET AWGADDURL=%1"
"SET AWGFOLDER=%2"

url = strip( value( "AWGADDURL",, "OS2ENVIRONMENT" ))
dir = strip( value( "AWGFOLDER",, "OS2ENVIRONMENT" ))

call MsgRead  "awget"
call CfgRead  CfgFile
call DirRead

if dir == "" then
   dir = dir.todo

if url == "" | url == '""' then do
   say "Usage: awgadd url [directory]"
   exit
end

if left(url,1) == '"' & right(url,1) == '"' then
   url = substr( url, 2, length(url) - 2 )

file = SysTempFileName( dir"\MANUAL ADDED!???" )

if SysOs2Ver() > "2.30" then
   rc = SysCreateObject( "WPUrl", filespec( "name", file ), dir, "URL="url, "R" )
else do
   call lineout file, url
   call stream file, "c", "close"
   call WpsRefresh dir
end

exit

/*------------------------------------------------------------------
 * National Messages Procedures
 *------------------------------------------------------------------*/
MsgRead: procedure expose msg.

  parse arg msgfile
  parse source OS2 what msgpath

  msgfile = filespec( "disk", msgpath ) ||,
            filespec( "path", msgpath ) || msgfile

  country = strip( SysIni( "BOTH", "PM_National", "iCountry" ),, '0'x )
  country = right( country, 3, "0" )

  if stream( msgfile"."country, "c", "query exists" ) == "" then
     country = "001"

  msgfile = msgfile"."country
  rc = stream( msgfile, "C", "OPEN READ" )

  if rc \= "READY:" then do
     say "ERROR: Error open message file: "msgfile
     exit
  end

  do while lines(msgfile) > 0
     line = linein(msgfile)

     if line \= "" then do
        parse value line with id "=" msg

        id  = translate(strip(id))
        msg = strip(msg)

        i = pos( "\n", msg )
        do while i > 0
           msg = substr( msg, 1, i-1 ) || '0A0D'x || substr( msg, i+2 )
           i = pos( "\n", msg )
        end

        msg.id = msg
     end
  end

  rc = stream( msgfile, "C", "CLOSE" )

return

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
MsgYesNo: procedure expose msg.

   parse arg prompt
   ok = 0

   do until ok
      call charout, prompt"? "
      pull reply
      reply = left(reply,1)

      ok = (reply == "Y") |,
           (reply == "N") |,
           (pos( reply, msg.msg_yes ) > 0 ) |,
           (pos( reply, msg.msg_no  ) > 0 )

      if \ok then do
         say msg.msg_badyn
      end
   end

return (reply = "Y") | (pos( reply, msg.msg_yes ) > 0 )

/*------------------------------------------------------------------
 * Get Configuration
 *------------------------------------------------------------------*/
CfgRead: procedure expose cfg. msg.

  parse arg CfgFile

  cfg.download          = "."
  cfg.maximum_downloads = 3
  cfg.messages          = 1
  cfg.message_done      = ""
  cfg.message_error     = ""
  cfg.wget_parameters   = "-c -t 0 -w 30"
  cfg.scan_interval     = 60
  cfg.check_connection  = 0
  cfg.logfile           = ""
  cfg.errorlog          = ""
  cfg.use_desktop       = 0
  cfg.keep_failed       = 1
  cfg.keep_done         = 0

  rc = stream( CfgFile, "C", "OPEN READ" )

  do while lines(CfgFile) > 0
     parse value linein(CfgFile) with command "=" argument

     command = translate(strip(command))
     argument = strip(argument)

     select
        when command == "DOWNLOAD" then
             cfg.download = argument
        when command == "MAXIMUM_DOWNLOADS_SIMULTANEOUSLY" then
             cfg.maximum_downloads = argument
        when command == "MESSAGES" then
             cfg.messages = (argument == "1")
        when command == "WGET_PARAMETERS" then
             cfg.wget_parameters = argument
        when command == "SCAN_INTERVAL" then
             cfg.scan_interval = argument
        when command == "LOG_FILE" then
             cfg.logfile = argument
        when command == "ERROR_LOG" then
             cfg.errorlog = argument
        when command == "MESSAGE_DONE" then
             cfg.message_done = argument
        when command == "MESSAGE_ERROR" then
             cfg.message_error = argument
        when command == "CHECK_CONNECTION" then
             cfg.check_connection = (argument == "1")
        when command == "USE_DESKTOP" then
             cfg.use_desktop = (argument == "1")
        when command == "KEEP_FAILED_URL" then
             cfg.keep_failed = (argument == "1")
        when command == "KEEP_DONE_URL" then
             cfg.keep_done = (argument == "1")
        otherwise
     end
  end

  if right( cfg.download, 1 ) = "\" then
     cfg.download = left( cfg.download, length(cfg.download) - 1 )

  setlocal
  cfg.download = directory( cfg.download )
  endlocal

  if cfg.download == "" then do
     call LogPut cfg.errorlog, msg.msg_invdown
     cfg.download = "."
  end

  rc = stream( CfgFile, "C", "CLOSE" )
  cfg.file_date = stream( CfgFile, "C", "QUERY DATETIME" )

return

/*------------------------------------------------------------------
 * Show Configuration
 *------------------------------------------------------------------*/
CfgShow: procedure expose cfg. msg.

  say "*** "msg.msg_downdir  || ": "cfg.download
  say "*** "msg.msg_maxcon   || ": "cfg.maximum_downloads
  say "*** "msg.msg_show     || ": "cfg.messages

  if cfg.message_done \= "" then
     say "*** "msg.msg_done  || ": "cfg.message_done

  if cfg.message_error \= "" then
     say "*** "msg.msg_error || ": "cfg.message_error

  say "*** "msg.msg_interval || ": "cfg.scan_interval
  say "*** "msg.msg_chckconn || ": "cfg.check_connection
  say "*** "msg.msg_parm     || ": "cfg.wget_parameters
  say "*** "msg.msg_usedesk  || ": "cfg.use_desktop
  say "*** "msg.msg_keepfail || ": "cfg.keep_failed
  say "*** "msg.msg_keepdone || ": "cfg.keep_done

return

/*------------------------------------------------------------------
 * Save Configuration
 *------------------------------------------------------------------*/
CfgSave: procedure expose cfg. msg.

  parse arg CfgFile

  if stream( CfgFile, "C", "QUERY EXISTS" ) \= "" then
     "del "CfgFile

  rc = stream( CfgFile, "C", "OPEN WRITE" )

  rc = lineout( CfgFile, "download = "cfg.download )
  rc = lineout( CfgFile, "maximum_downloads_simultaneously = "cfg.maximum_downloads )
  rc = lineout( CfgFile, "messages = "cfg.messages )

  if cfg.message_done  \= "" then
     rc = lineout( CfgFile, "message_done  = "cfg.message_done  )

  if cfg.message_error \= "" then
     rc = lineout( CfgFile, "message_error = "cfg.message_error )

  rc = lineout( CfgFile, "log_file = "cfg.logfile )
  rc = lineout( CfgFile, "error_log = "cfg.errorlog )
  rc = lineout( CfgFile, "wget_parameters = "cfg.wget_parameters )
  rc = lineout( CfgFile, "scan_interval = "cfg.scan_interval )
  rc = lineout( CfgFile, "check_connection = "cfg.check_connection )
  rc = lineout( CfgFile, "use_desktop = "cfg.use_desktop )
  rc = lineout( CfgFile, "keep_failed_url = "cfg.keep_failed )
  rc = lineout( CfgFile, "keep_done_url = "cfg.keep_done )

  rc = stream( CfgFile, "C", "CLOSE" )

return

/*------------------------------------------------------------------
 * Check Configuration
 *------------------------------------------------------------------*/
CfgCheck: procedure expose cfg. msg.

  parse arg CfgFile

  if cfg.file_date \= stream( CfgFile, "C", "QUERY DATETIME" ) then do

     call LogPut cfg.logfile, msg.msg_readcfg
     call CfgRead CfgFile
     say
     call CfgShow
     say
  end

return

/*------------------------------------------------------------------
 * Write Log Record
 *------------------------------------------------------------------*/
LogPut: procedure expose cfg.

  parse arg logfile, message

  say " "message
  if logfile \= "" then do
     call lineout logfile, date()" "time()" -> "message
     rc = stream( logfile, "c", "close" )
  end

return

/*------------------------------------------------------------------
 * Append Log Record
 *------------------------------------------------------------------*/
LogAdd: procedure expose cfg.

  parse arg logfile, message

  if logfile \= "" then do
     call lineout logfile, date()" "time()" -> "message
     rc = stream( logfile, "c", "close" )
  end

return


/*------------------------------------------------------------------
 * Move file
 *------------------------------------------------------------------*/
WpsMove: procedure expose msg. cfg.

  parse arg file_from, file_to

  rc = SysGetEA( file_from, ".LONGNAME", file_long )

  if file_long == "" then
     rc = WpsPutEA( file_from, ".LONGNAME", filespec( "name", file_from ))

  if stream( file_to, "c", "query exists" ) \= "" then do
     file_to = SysTempFileName( file_to"!???" )
  end

  'copy "'file_from'" "'file_to'" 1> nul 2> nul'

  if rc == 0 then
     'del "'file_from'" 1> nul 2> nul'
  else do
     call LogPut cfg.error_log msg.msg_notmove": "file_from" -> "file_to
     file_to = ""
  end

return file_to

/*------------------------------------------------------------------
 * Write a named ascii extended attribute to a file
 *------------------------------------------------------------------*/
WpsPutEA: procedure

  parse arg file, name, value

  value = 'FDFF'x ||,
           substr( d2c(length(value)), 1, 2, '00'x ) || value

return SysPutEA( file, name, value )

/*------------------------------------------------------------------
 * Refresh Folder
 *------------------------------------------------------------------*/
WpsRefresh: procedure

  parse arg path

return SysSetObjectData( path, "MENUITEMSELECTED=503" )

/*------------------------------------------------------------------
 * Get Directorys
 *------------------------------------------------------------------*/
DirRead: procedure expose dir. msg. cfg.

  dir.todo    = AwGetObjectPath( "<AWG_TODO>"   )
  dir.running = AwGetObjectPath( "<AWG_RUN>"    )
  dir.done    = AwGetObjectPath( "<AWG_DONE>"   )
  dir.failed  = AwGetObjectPath( "<AWG_ERROR>"  )
  dir.desktop = AwGetObjectPath( "<WP_DESKTOP>" )

  /* check it */

  if dir.todo    == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "ToDo"'
     exit 1
  end
  if dir.running == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "Running"'
     exit 1
  end
  if dir.done    == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "Done"'
     exit 1
  end
  if dir.failed  == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "Failed"'
     exit 1
  end
  if dir.desktop == "" then do
     call LogPut cfg.errorlog, msg.msg_notfound': "Desktop"'
     exit 1
  end

return

/*------------------------------------------------------------------
 * Show Directorys
 *------------------------------------------------------------------*/
DirShow: procedure expose dir.

  say "*** ToDo:    "dir.todo
  say "*** Running: "dir.running
  say "*** Done:    "dir.done
  say "*** Failed:  "dir.failed
  say "*** Desktop: "dir.desktop
return

/*------------------------------------------------------------------
 * Get URL from file
 *------------------------------------------------------------------*/
GetURLFromFile: procedure

  parse arg filename

  rc  = stream(filename, "c", "open read" )
  url = linein(filename)
  rc  = stream(filename, "c", "close" )

  do while pos( "%", url ) > 0

     i = pos( "%", url )

     url = substr( url, 1, i-1      ) ||,
           x2c(substr( url, i+1, 2 )) ||,
           substr( url, i+3         )
  end

return url

/*------------------------------------------------------------------
 * Get filename from URL
 *------------------------------------------------------------------*/
GetFileFromURL: procedure

  parse arg url

  pos_parm = pos( "?", url )
  if pos_parm \= 0 then
    url = substr( url, 1, pos_parm-1 )

  pos_name = lastpos( "/", url )
  if pos_name \= 0 then
    url = substr( url, pos_name+1 )

return url

/*------------------------------------------------------------------
 * Check valid URL file
 *------------------------------------------------------------------*/
IsURLFile: procedure

  parse arg filename

  rc  = stream(filename, "c", "open read" )
  url = translate( strip( charin(filename,1,16)))
  rc  = stream(filename, "c", "close" )

return substr( url, 1, 7 ) == "HTTP://" |,
       substr( url, 1, 6 ) == "FTP://"
