/*
 * Auto WGet Daemon Support Library
 * Copyright (C) 1998-1999 by Dmitry A.Steklenev
 *
 */

#define  INCL_REXXSAA
#define  INCL_WINWORKPLACE
#define  INCL_DOS
#define  INCL_ERRORS
#include <os2.h>

#include <rexxsaa.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>

#define HF_STDOUT 1
#define HF_STDERR 2

static PSZ AwFncTable[] =
{
  "AwDropFuncs"    ,
  "AwGetObjectPath",
  "AwPOpen"        ,
  "AwPClose"       ,
  "AwPRead"        ,
  "AwLockSet"      ,
  "AwLockRelease"  ,
  "AwLockIs"
};

#define INVALID_ROUTINE 40            /* Raise Rexx error           */
#define VALID_ROUTINE    0            /* Successful completion      */

#define ERROR_RETSTR    "ERROR:"
#define READY_RETSTR    "READY:"
#define ERROR_LENSTR    6
#define READY_LENSTR    6

#define LOCKS_PREFIX    "\\SEM32\\AWGET\\"

/*--------------------------------------------------
 * AwDropFuncs
 *--------------------------------------------------*/
ULONG AwDropFuncs( PUCHAR    name,
                   ULONG     numargs,
                   RXSTRING  args[],
                   PSZ       queuename,
                   PRXSTRING retstr     )
{
  INT entries;                /* Num of entries             */
  INT j;                      /* Counter                    */

  if (numargs != 0)           /* no arguments for this      */
    return INVALID_ROUTINE;   /* raise an error             */

  retstr->strlength = 0;      /* return a null string result*/

  entries = sizeof(AwFncTable)/sizeof(PSZ);

  for (j = 0; j < entries; j++)
    RexxDeregisterFunction(AwFncTable[j]);

  return VALID_ROUTINE;       /* no error on call           */
}

/*--------------------------------------------------
 * AwLoadFuncs
 *--------------------------------------------------*/
ULONG AwLoadFuncs( PUCHAR    name,
                   ULONG     numargs,
                   RXSTRING  args[],
                   PSZ       queuename,
                   PRXSTRING retstr     )
{
  INT entries;                /* Num of entries             */
  INT j;                      /* Counter                    */

  retstr->strlength = 0;      /* set return value           */
                              /* check arguments            */
  if (numargs > 0)
    return INVALID_ROUTINE;

  entries = sizeof(AwFncTable)/sizeof(PSZ);

  for (j = 0; j < entries; j++) {
    RexxRegisterFunctionDll(AwFncTable[j],
                   "AWGET", AwFncTable[j]);
  }
  return VALID_ROUTINE;
}

/*--------------------------------------------------
 * AwGetObjectPath
 *--------------------------------------------------*/
ULONG AwGetObjectPath( PUCHAR    Name,
                       ULONG     Argc,
                       RXSTRING  Argv[],
                       PSZ       Queuename,
                       PRXSTRING Retstr     )
{
  HOBJECT hObject;
  CHAR    szPath[CCHMAXPATH + 1] = "";
  BOOL    fSuccess;

  if( Argc != 1 )
    return INVALID_ROUTINE;

  hObject = WinQueryObject(Argv[0].strptr);

  if( hObject )
    fSuccess = WinQueryObjectPath( hObject, szPath, sizeof(szPath));

  strcpy( Retstr->strptr, szPath );
  Retstr->strlength  = strlen( Retstr->strptr );

  return VALID_ROUTINE;
}

/*--------------------------------------------------
 * AwPOpen
 *--------------------------------------------------*/
ULONG AwPOpen( PUCHAR    Name,
               ULONG     Argc,
               RXSTRING  Argv[],
               PSZ       Queuename,
               PRXSTRING Retstr     )
{
  HFILE  hfSaveStd, hfSaveErr,
         hfCurrStd, hfCurrErr,
         writePipe, readPipe;

  CHAR   szFailName[CCHMAXPATH];
  APIRET rc;
  char*  szExec;

  RESULTCODES resCodes;

  if( Argc == 1 ) return INVALID_ROUTINE;

  szExec = (char*)malloc( Argv[0].strlength +
                          Argv[1].strlength + sizeof(char));

  if( !szExec ) return INVALID_ROUTINE;

  strcpy( szExec,  Argv[0].strptr );
  strcpy( szExec + Argv[0].strlength + sizeof(char), Argv[1].strptr );

  hfSaveStd = -1;
  hfSaveErr = -1;
  hfCurrStd = HF_STDOUT;
  hfCurrErr = HF_STDERR;

  DosDupHandle ( HF_STDOUT, &hfSaveStd );
  DosDupHandle ( HF_STDERR, &hfSaveErr );

  DosCreatePipe( &readPipe, &writePipe, 255 );

  DosDupHandle ( writePipe, &hfCurrStd );
  DosDupHandle ( writePipe, &hfCurrErr );

  rc = DosExecPgm( szFailName, sizeof(szFailName ),
                   EXEC_ASYNCRESULT,
                   szExec,
                   (PSZ)NULL, &resCodes, Argv[0].strptr );

  DosClose    ( writePipe );
  DosDupHandle( hfSaveStd, &hfCurrStd );
  DosDupHandle( hfSaveErr, &hfCurrErr );
  DosClose    ( hfSaveStd );
  DosClose    ( hfSaveErr );

  free( szExec );

  if( rc != NO_ERROR )
  {
     /* return ERROR:rc */
     strcpy( Retstr->strptr,  ERROR_RETSTR );
     ltoa( rc, Retstr->strptr+ERROR_LENSTR, 10 );
  }
  else
  {
     /* Process ID      */
     ltoa( resCodes.codeTerminate, Retstr->strptr, 10 );
     strcat( Retstr->strptr, ":" );

     /* Pipe handle     */
     ltoa( readPipe, Retstr->strptr+strlen(Retstr->strptr), 10 );
  }

  Retstr->strlength  = strlen( Retstr->strptr );
  return VALID_ROUTINE;
}

/*--------------------------------------------------
 * AwPClose
 *--------------------------------------------------*/
ULONG AwPClose( PUCHAR    Name,
                ULONG     Argc,
                RXSTRING  Argv[],
                PSZ       Queuename,
                PRXSTRING Retstr     )
{
  APIRET rc;
  HFILE  readPipe;
  ULONG  pid;

  RESULTCODES resCodes;

  if( Argc != 1 ) return INVALID_ROUTINE;

  if( strnicmp( Argv[0].strptr, ERROR_RETSTR, ERROR_LENSTR ) == 0 )
  {
     /* return ERROR:6 (ERROR_INVALID_HANDLE) */
     strcpy( Retstr->strptr, ERROR_RETSTR );
     ltoa( ERROR_INVALID_HANDLE, Retstr->strptr+ERROR_LENSTR, 10 );
  }
  else
  {
     pid = atol( Argv[0].strptr );
     readPipe = atol( strchr( Argv[0].strptr, ':' ) + 1 );

     rc = DosWaitChild( DCWA_PROCESS, DCWW_WAIT, &resCodes, &pid, pid );
     DosClose( readPipe );

     /* return program exit code */
     ltoa( resCodes.codeResult, Retstr->strptr, 10 );
  }

  Retstr->strlength  = strlen( Retstr->strptr );
  return VALID_ROUTINE;
}

/*--------------------------------------------------
 * AwPRead
 *--------------------------------------------------*/
ULONG AwPRead( PUCHAR    Name,
               ULONG     Argc,
               RXSTRING  Argv[],
               PSZ       Queuename,
               PRXSTRING Retstr     )
{
  HFILE readPipe;
  ULONG ulRead;

  RESULTCODES resCodes;

  if( Argc != 1 ) return INVALID_ROUTINE;

  if( strnicmp( Argv[0].strptr, ERROR_RETSTR, ERROR_LENSTR ) == 0 )
  {
     Retstr->strlength = 0;
  }
  else
  {
     readPipe = atol( strchr( Argv[0].strptr, ':' ) + 1 );

     DosRead( readPipe, (PVOID)Retstr->strptr, 255, &ulRead );
     Retstr->strlength  = ulRead;
  }

  return VALID_ROUTINE;
}

/*--------------------------------------------------
 * AwLockSet
 *--------------------------------------------------*/
ULONG AwLockSet( PUCHAR    Name,
                 ULONG     Argc,
                 RXSTRING  Argv[],
                 PSZ       Queuename,
                 PRXSTRING Retstr     )
{
  char   semaphor_name[_MAX_PATH] = LOCKS_PREFIX;
  APIRET rc;
  HEV    hev;

  if( Argc != 1 ) return INVALID_ROUTINE;

  strncpy( semaphor_name+sizeof(LOCKS_PREFIX)-1,
           Argv[0].strptr,
           _MAX_PATH-sizeof(LOCKS_PREFIX));

  rc = DosCreateEventSem( semaphor_name, &hev, DC_SEM_SHARED, 0 );

  if( rc )
  {
     /* return ERROR:rc        */
     strcpy( Retstr->strptr,  ERROR_RETSTR );
     ltoa( rc, Retstr->strptr+ERROR_LENSTR, 10 );
  }
  else
  {
     /* return semaphor handle */
     ltoa( hev, Retstr->strptr, 10 );
  }

  Retstr->strlength = strlen( Retstr->strptr );
  return VALID_ROUTINE;
}

/*--------------------------------------------------
 * AwLockRelease
 *--------------------------------------------------*/
ULONG AwLockRelease( PUCHAR    Name,
                     ULONG     Argc,
                     RXSTRING  Argv[],
                     PSZ       Queuename,
                     PRXSTRING Retstr     )
{
  APIRET rc;
  HEV    hev;

  if( Argc != 1 ) return INVALID_ROUTINE;

  if( strnicmp( Argv[0].strptr, ERROR_RETSTR, ERROR_LENSTR ) == 0 )
  {
     /* return ERROR:6 (ERROR_INVALID_HANDLE) */
     strcpy( Retstr->strptr, ERROR_RETSTR );
     ltoa( ERROR_INVALID_HANDLE, Retstr->strptr+ERROR_LENSTR, 10 );
  }
  else
  {
     hev = atol( Argv[0].strptr );
     rc  = DosCloseEventSem( hev );

     /* return rc */
     ltoa( rc, Retstr->strptr, 10 );
  }

  Retstr->strlength = strlen( Retstr->strptr );
  return VALID_ROUTINE;
}

/*--------------------------------------------------
 * AwLockQuery
 *--------------------------------------------------*/
ULONG AwLockIs( PUCHAR    Name,
                ULONG     Argc,
                RXSTRING  Argv[],
                PSZ       Queuename,
                PRXSTRING Retstr     )
{
  char   semaphor_name[_MAX_PATH] = LOCKS_PREFIX;
  APIRET rc;
  HEV    hev = NULLHANDLE;

  if( Argc != 1 ) return INVALID_ROUTINE;

  strncpy( semaphor_name+sizeof(LOCKS_PREFIX)-1,
           Argv[0].strptr,
           _MAX_PATH-sizeof(LOCKS_PREFIX));

  rc = DosOpenEventSem( semaphor_name, &hev );

  ltoa( !rc, Retstr->strptr, 10 );
  Retstr->strlength = strlen( Retstr->strptr );

  if( rc == 0 )
    DosCloseEventSem( hev );

  return VALID_ROUTINE;
}



