;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;- Machine description for the 6502 for GNU C compiler
;;  Contributed by Dave McWherter at Franklin Electronic Publishers.
;;  (Dave_Mcwherter@franklin.com).

;; Registers (all 24-bit):
;;	r0-r15	general purpose
;;	16:sp	stack pointer (*** static ***)
;;	17:fp	frame pointer (*** not supported ***)
;;	cc	status flags
;;	pc	program counter
;;	t	temporary

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; gcc needs a nop insn:

(define_insn "nop"
	[	(const_int 0)
	]
	""
	"nop"
	[]
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn "return"
	[	(return)
	]
	"md_use_return()"
	"*{
		if (md_was_tail_call(insn)) {
			asm(\"		;; tail call\");
		}
		else {
			asm(\"rts		;; return\");
		}
		md_saw_return = 1;
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Moves:

(define_insn "mv_8"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(match_operand:QI 1 "md_gen_imm_op" "g")
		)
	]
	""
	"*{
		rtx	note = find_reg_note (insn, REG_EQUAL, NULL_RTX);

		if (	(GET_CODE(operands[1]) == REG) &&
			(note) &&
			(GET_CODE(XEXP(note, 0)) != EXPR_LIST) &&
			(CONSTANT_P(XEXP(note, 0))) &&
			(INTVAL(XEXP (note, 0)) == 0) &&
			(!md_need_y(operands[0]))
		   ) {
			asm(\"stz	%L0	;; mv_8\");
		}
		else if (immediate_operand(operands[1], VOIDmode)) {
			md_mv_imm_m(operands[1], operands[0], 8, \"mv_8\");
		}
		else {
			md_mv_m_m(operands[1], operands[0], 8, \"mv_8\");
		}
		return \"\";
	}"
)

(define_insn "mv_16"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
	]
	""
	"*{
		rtx	note = find_reg_note (insn, REG_EQUAL, NULL_RTX);

		if (	(GET_CODE(operands[1]) == REG) &&
			(note) &&
			(GET_CODE(XEXP(note, 0)) != EXPR_LIST) &&
			(CONSTANT_P(XEXP(note, 0))) &&
			(INTVAL(XEXP (note, 0)) == 0) &&
			(!md_need_y(operands[0]))
		   ) {
			asm(\"stz	%L0	;; mv_16\");
			asm(\"stz	%H0\");
		}
		else if (immediate_operand(operands[1], VOIDmode)) {
			md_mv_imm_m(operands[1], operands[0], 16, \"mv_16\");
		}
		else {
			md_mv_m_m(operands[1], operands[0], 16, \"mv_16\");
		}
		return \"\";
	}"
)

(define_insn "mv_24"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(match_operand:SI 1 "md_gen_imm_op" "g")
		)
	]
	""
	"*{
		rtx	note = find_reg_note (insn, REG_EQUAL, NULL_RTX);

		if (	(GET_CODE(operands[1]) == REG) &&
			(note) &&
			(GET_CODE(XEXP(note, 0)) != EXPR_LIST) &&
			(CONSTANT_P(XEXP(note, 0))) &&
			(INTVAL(XEXP (note, 0)) == 0) &&
			(!md_need_y(operands[0]))
		   ) {
			asm(\"stz	%L0	;; mv_24\");
			asm(\"stz	%H0\");
			asm(\"stz	%B0\");
		}
		else if (immediate_operand(operands[1], VOIDmode)) {
			md_mv_imm_m(operands[1], operands[0], 24, \"mv_24\");
		}
		else {
			md_mv_m_m(operands[1], operands[0], 24, \"mv_24\");
		}
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn "mv_indrxr_r_8"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(mem:QI	(plus:HI	(match_operand:HI 1 "md_gen_op" "g")
						(match_operand:HI 2 "md_gen_imm_op" "g")
				)
			)
		)
	]
	""
	"*{
		if (	(GET_CODE(operands[2]) == CONST_INT) &&
			((INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 256))
		   ) {
			if (md_is_zp_op(operands[1])) {
				asm(\"ldy	#%2	;; mv_indrxr_r_8, zp sym\");
				asm(\"lda	(%1),y\");
				asm(\"sta	%L0\");
			}
			else if (md_gpr_op(operands[1], GET_MODE(operands[1]))) {
				asm(\"ldy	#%2	;; mv_indrxr_r_8\");
				asm(\"lda	(%1),y\");
				asm(\"sta	%L0\");
			}
			else {
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; mv_indrxr_r_8\");
					asm(\"sta	t\");
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H1\");
					asm(\"sta	t+1\");
				}
				else {
					asm(\"sta	t	;; mv_indrxr_r_8\");
					asm(\"stx	t+1\");
				}
				asm(\"ldy	#%2\");
				asm(\"lda	(t),y\");
				asm(\"sta	%L0\");
			}
		}
		else if ((GET_CODE(operands[2]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			if (!md_is_axy(operands[1])) {
				asm(\"ldx	%L1	;; mv_indrxr_r_8\");
			}
			else {
				asm(\"tax		;; mv_indrxr_r_8\");
			}
			asm(\"lda	%2,x\");
			asm(\"sta	%L0\");
		}
		else {
			asm(\"clc		;; mv_indrxr_r_8\");
			if (md_is_axy(operands[1])) {
				asm(\"adc	%L2\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H2\");
				asm(\"sta	t+1\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			else {
				asm(\"lda	%L1\");
				asm(\"adc	%L2\");
				asm(\"sta	t\");
				if (	(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H1\");
				asm(\"adc	%H2\");
				asm(\"sta	t+1\");
			}
			asm(\"lda	(t),0\");
			asm(\"sta	%L0\");
		}
		md_remember_axy(operands[0]);
		return \"\";
	}"
)

(define_insn "mv_indrxr_r_16"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gen_op" "g")
						(match_operand:HI 2 "md_gen_imm_op" "g")
				)
			)
		)
	]
	""
	"*{
		if (	(GET_CODE(operands[2]) == CONST_INT) &&
			((INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 255))
		   ) {
			if (md_is_zp_op(operands[1])) {
				asm(\"ldy	#%2	;; mv_indrxr_r_16, zp sym\");
				asm(\"lda	(%1),y\");
				asm(\"sta	%L0\");
				asm(\"iny\");
				asm(\"lda	(%1),y\");
				asm(\"ldy	#1\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"sta	%H0\");
			}
			else if (md_gpr_op(operands[1], GET_MODE(operands[1]))) {
				asm(\"ldy	#%2	;; mv_indrxr_r_16\");
				asm(\"lda	(%1),y\");
				if (	(GET_CODE(operands[0]) == REG) &&
					(GET_CODE(operands[1]) == REG) &&
					(REGNO(operands[0]) == REGNO(operands[1]))
				   ) {
					asm(\"tax\");
				}
				else {
					asm(\"sta	%L0\");
				}
				asm(\"iny\");
				asm(\"lda	(%1),y\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"sta	%H0\");
				if (	(GET_CODE(operands[0]) == REG) &&
					(GET_CODE(operands[1]) == REG) &&
					(REGNO(operands[0]) == REGNO(operands[1]))
				   ) {
					if (md_need_y(operands[0])) {
						asm(\"txa\");
						asm(\"sta	%L0\");
					}
					else {
						asm(\"stx	%L0\");
					}
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; mv_indrxr_r_16\");
					asm(\"sta	t\");
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H1\");
					asm(\"sta	t+1\");
				}
				else {
					asm(\"sta	t	;; mv_indrxr_r_16\");
					asm(\"stx	t+1\");
				}
				asm(\"ldy	#%2\");
				asm(\"lda	(t),y\");
				asm(\"sta	%L0\");
				asm(\"iny\");
				asm(\"lda	(t),y\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"sta	%H0\");
			}
		}
		else if ((GET_CODE(operands[2]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			if (!md_is_axy(operands[1])) {
				asm(\"ldx	%L1	;; mv_indrxr_r_16\");
			}
			else {
				asm(\"tax		;; mv_indrxr_r_16\");
			}
			asm(\"lda	%2,x\");
			asm(\"sta	%L0\");
			asm(\"lda	%2+1,x\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
			}
			asm(\"sta	%H0\");
		}
		else {
			asm(\"clc		;; mv_indrxr_r_16\");
			if (md_is_axy(operands[1])) {
				asm(\"adc	%L2\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H2\");
				asm(\"sta	t+1\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			else {
				asm(\"lda	%L1\");
				asm(\"adc	%L2\");
				asm(\"sta	t\");
				if (	(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H1\");
				asm(\"adc	%H2\");
				asm(\"sta	t+1\");
			}
			asm(\"lda	(t),0\");
			asm(\"sta	%L0\");
			asm(\"ldy	#1\");
			asm(\"lda	(t),y\");
			asm(\"sta	%H0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "mv_indrxr_r_24"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(mem:SI	(plus:HI	(match_operand:HI 1 "md_gen_op" "g")
						(match_operand:HI 2 "md_gen_imm_op" "g")
				)
			)
		)
	]
	""
	"*{
		if (	(GET_CODE(operands[2]) == CONST_INT) &&
			((INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 254))
		   ) {
			if (md_is_zp_op(operands[1])) {
				asm(\"ldy	#%2	;; mv_indrxr_r_24, zp sym\");
				asm(\"lda	(%1),y\");
				asm(\"sta	%L0\");
				asm(\"iny\");
				asm(\"lda	(%1),y\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"sta	%H0\");
					asm(\"ldy	#%2+2\");
					asm(\"lda	(%1),y\");
					asm(\"ldy	#2\");
				}
				else {
					asm(\"sta	%H0\");
					asm(\"iny\");
					asm(\"lda	(%1),y\");
				}
				asm(\"sta	%B0\");
			}
			else if (md_gpr_op(operands[1], GET_MODE(operands[1]))) {
				asm(\"ldy	#%2	;; mv_indrxr_r_24\");
				asm(\"lda	(%1),y\");
				if (	(GET_CODE(operands[0]) == REG) &&
					(GET_CODE(operands[1]) == REG) &&
					(REGNO(operands[0]) == REGNO(operands[1]))
				   ) {
					asm(\"tax\");
				}
				else {
					asm(\"sta	%L0\");
				}
				asm(\"iny\");
				asm(\"lda	(%1),y\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					if (	(GET_CODE(operands[0]) == REG) &&
						(GET_CODE(operands[1]) == REG) &&
						(REGNO(operands[0]) == REGNO(operands[1]))
					   ) {
						asm(\"pha\");
					}
					else {
						asm(\"sta	%H0\");
					}
					asm(\"ldy	#%2+2\");
					asm(\"lda	(%1),y\");
					asm(\"ldy	#2\");
				}
				else {
                                        if (    (GET_CODE(operands[0]) == REG) &&
                                                (GET_CODE(operands[1]) == REG) &&
                                                (REGNO(operands[0]) == REGNO(operands[1]))
                                           ) {
                                                asm(\"pha\");
                                        }
                                        else {
                                                asm(\"sta       %H0\");
                                        }
					asm(\"iny\");
					asm(\"lda	(%1),y\");
				}
				asm(\"sta	%B0\");
				if (	(GET_CODE(operands[0]) == REG) &&
					(GET_CODE(operands[1]) == REG) &&
					(REGNO(operands[0]) == REGNO(operands[1]))
				   ) {
					if (md_need_y(operands[0])) {
						asm(\"txa\");
						asm(\"sta	%L0\");
						asm(\"pla\");
						asm(\"dey\");
						asm(\"sta	%H0\");
					}
					else {
						asm(\"stx	%L0\");
						asm(\"pla\");
						asm(\"sta	%H0\");
					}
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; mv_indrxr_r_24\");
					asm(\"sta	t\");
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H1\");
					asm(\"sta	t+1\");
				}
				else {
					asm(\"sta	t	;; mv_indrxr_r_24\");
					asm(\"stx	t+1\");
				}
				asm(\"ldy	#%2\");
				asm(\"lda	(t),y\");
				asm(\"sta	%L0\");
				asm(\"iny\");
				asm(\"lda	(t),y\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"sta	%H0\");
					asm(\"ldy	#%2+2\");
					asm(\"lda	(t),y\");
					asm(\"ldy	#2\");
				}
				else {
					asm(\"sta	%H0\");
					asm(\"iny\");
					asm(\"lda	(t),y\");
				}
				asm(\"sta	%B0\");
			}
		}
		else if ((GET_CODE(operands[2]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			if (!md_is_axy(operands[1])) {
				asm(\"ldx	%L1	;; mv_indrxr_r_24\");
			}
			else {
				asm(\"tax		;; mv_indrxr_r_24\");
			}
			asm(\"lda	%2,x\");
			asm(\"sta	%L0\");
			asm(\"lda	%2+1,x\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
			}
			asm(\"sta	%H0\");
			asm(\"lda	%2+2,x\");
			if (md_need_y(operands[0])) {
				asm(\"iny\");
			}
			asm(\"sta	%B0\");
		}
		else {
			asm(\"clc		;; mv_indrxr_r_24\");
			if (md_is_axy(operands[1])) {
				asm(\"adc	%L2\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H2\");
				asm(\"sta	t+1\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			else {
				asm(\"lda	%L1\");
				asm(\"adc	%L2\");
				asm(\"sta	t\");
				if (	(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H1\");
				asm(\"adc	%H2\");
				asm(\"sta	t+1\");
			}
			asm(\"lda	(t),0\");
			asm(\"sta	%L0\");
			asm(\"ldy	#1\");
			asm(\"lda	(t),y\");
			asm(\"sta	%H0\");
			asm(\"iny\");
			asm(\"lda	(t),y\");
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn "mv_r_indrxr_8"
	[	(set	(mem:QI	(plus:HI	(match_operand:HI 0 "md_gen_op" "g")
						(match_operand:HI 1 "md_gen_imm_op" "g")
				)
			)
			(match_operand:QI 2 "md_gen_imm_op" "g")
		)
	]
	""
	"*{
		if (	(GET_CODE(operands[1]) == CONST_INT) &&
			((INTVAL(operands[1]) >= 0) &&
			(INTVAL(operands[1]) < 256))
		   ) {
			if (md_is_zp_op(operands[0])) {
				asm(\"ldy	#%1	;; mv_r_indrxr_8, zp sym\");
				if (!md_is_axy(operands[2])) {
					asm(\"lda	%L2\");
				}
				asm(\"sta	(%0),y\");
			}
			else if (md_gpr_op(operands[0], GET_MODE(operands[0]))) {
				asm(\"ldy	#%1	;; mv_r_indrxr_8\");
				if (!md_is_axy(operands[2])) {
					asm(\"lda	%L2\");
				}
				asm(\"sta	(%0),y\");
			}
			else {
				if (!md_is_axy(operands[0])) {
					asm(\"lda	%L0	;; mv_r_indrxr_8\");
					asm(\"sta	t\");
					if (md_need_y(operands[0])) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H0\");
					asm(\"sta	t+1\");
				}
				else {
					asm(\"sta	t	;; mv_r_indrxr_8\");
					asm(\"stx	t+1\");
				}
				asm(\"ldy	#%1\");
				asm(\"lda	%L2\");
				asm(\"sta	(t),y\");
			}
		}
		else if ((GET_CODE(operands[1]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			if (!md_is_axy(operands[0])) {
				asm(\"ldx	%L0	;; mv_r_indrxr_8\");
			}
			else {
				asm(\"tax		;; mv_r_indrxr_8\");
			}
			if (!md_is_axy(operands[2])) {
				asm(\"lda	%L2\");
			}
			asm(\"sta	%1,x\");
		}
		else {
			asm(\"clc		;; mv_r_indrxr_8\");
			if (md_is_axy(operands[0])) {
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			else if (md_is_axy(operands[1])) {
				asm(\"adc	%L0\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H0\");
				asm(\"sta	t+1\");
			}
			else {
				asm(\"lda	%L0\");
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H0\");
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			asm(\"lda	%L2\");
			asm(\"sta	(t),0\");
		}
		md_remember_axy(operands[2]);
		return \"\";
	}"
)

(define_insn "mv_r_indrxr_16"
	[	(set	(mem:HI	(plus:HI	(match_operand:HI 0 "md_gen_op" "g")
						(match_operand:HI 1 "md_gen_imm_op" "g")
				)
			)
			(match_operand:HI 2 "md_gen_imm_op" "g")
		)
	]
	""
	"*{
		if (	(GET_CODE(operands[1]) == CONST_INT) &&
			((INTVAL(operands[1]) >= 0) &&
			(INTVAL(operands[1]) < 255))
		   ) {
			if (md_is_zp_op(operands[0])) {
				asm(\"ldy	#%1	;; mv_r_indrxr_16, zp sym\");
				if (!md_is_axy(operands[2])) {
					asm(\"lda	%L2\");
				}
				asm(\"sta	(%0),y\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
					asm(\"ldy	#%1+1\");
				}
				else {
					asm(\"iny\");
					if (!md_is_axy(operands[2])) {
						if (!md_are_high_low_same(operands[2])) {
							asm(\"lda	%H2\");
						}
					}
					else {
						asm(\"txa\");
					}
				}
				asm(\"sta	(%0),y\");
			}
			else if (md_gpr_op(operands[0], GET_MODE(operands[0]))) {
				asm(\"ldy	#%1	;; mv_r_indrxr_16\");
				if (!md_is_axy(operands[2])) {
					asm(\"lda	%L2\");
				}
				asm(\"sta	(%0),y\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
					asm(\"ldy	#%1+1\");
				}
				else {
					asm(\"iny\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
				}
				asm(\"sta	(%0),y\");
			}
			else {
				if (!md_is_axy(operands[0])) {
					asm(\"lda	%L0	;; mv_r_indrxr_16\");
					asm(\"sta	t\");
					if (md_need_y(operands[0])) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H0\");
					asm(\"sta	t+1\");
				}
				else {
					asm(\"sta	t	;; mv_r_indrxr_16\");
					asm(\"stx	t+1\");
				}
				asm(\"ldy	#%1\");
				asm(\"lda	%L2\");
				asm(\"sta	(t),y\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
					asm(\"ldy	#%1+1\");
				}
				else {
					asm(\"iny\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
				}
				asm(\"sta	(t),y\");
			}
		}
		else if ((GET_CODE(operands[1]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			if (md_need_y(operands[2])) {
				asm(\"ldy	#1	;; mv_r_indrxr_16\");
				asm(\"lda	%H2\");
				asm(\"tax\");
				asm(\"lda	%L2\");
				asm(\"ldy	%L0\");
				asm(\"sta	%1,y\");
				asm(\"iny\");
				asm(\"txa\");
				asm(\"sta	%1+1,y\");
			}
			else {
				if (!md_is_axy(operands[0])) {
					asm(\"ldy	%L0	;; mv_r_indrxr_16\");
				}
				else {
					asm(\"tay		;; mv_r_indrxr_16\");
				}
				if (!md_is_axy(operands[2])) {
					asm(\"lda	%L2\");
				}
				asm(\"sta	%1,y\");
				if (!md_are_high_low_same(operands[2])) {
					if (!md_is_axy(operands[2])) {
						asm(\"lda	%H2\");
					}
					else {
						asm(\"txa\");
					}
				}
				asm(\"sta	%1+1,y\");
			}
		}
		else {
			asm(\"clc		;; mv_r_indrxr_16\");
			if (md_is_axy(operands[0])) {
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			else if (md_is_axy(operands[1])) {
				asm(\"adc	%L0\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H0\");
				asm(\"sta	t+1\");
			}
			else {
				asm(\"lda	%L0\");
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H0\");
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			asm(\"lda	%L2\");
			asm(\"sta	(t),0\");
			asm(\"ldy	#1\");
			if (!md_are_high_low_same(operands[2])) {
				asm(\"lda	%H2\");
			}
			asm(\"sta	(t),y\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "mv_r_indrxr_24"
	[	(set	(mem:SI	(plus:HI	(match_operand:HI 0 "md_gen_op" "g")
						(match_operand:HI 1 "md_gen_imm_op" "g")
				)
			)
			(match_operand:SI 2 "md_gen_imm_op" "g")
		)
	]
	""
	"*{
		if (	(GET_CODE(operands[1]) == CONST_INT) &&
			((INTVAL(operands[1]) >= 0) &&
			(INTVAL(operands[1]) < 254))
		   ) {
			if (md_is_zp_op(operands[0])) {
				asm(\"ldy	#%1	;; mv_r_indrxr_24, zp sym\");
				if (!md_is_axy(operands[2])) {
					asm(\"lda	%L2\");
				}
				asm(\"sta	(%0),y\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
					asm(\"ldy	#%1+1\");
					asm(\"sta	(%0),y\");
					asm(\"ldy	#2\");
					if (!md_are_bank_high_same(operands[2])) {
						asm(\"lda	%B2\");
					}
					asm(\"ldy	#%1+2\");
				}
				else {
					asm(\"iny\");
					if (!md_is_axy(operands[2])) {
						if (!md_are_high_low_same(operands[2])) {
							asm(\"lda	%H2\");
						}
					}
					else {
						asm(\"txa\");
					}
					asm(\"sta	(%0),y\");
					asm(\"iny\");
					if (!md_are_bank_high_same(operands[2])) {
						asm(\"lda	%B2\");
					}
				}
				asm(\"sta	(%0),y\");
			}
			else if (md_gpr_op(operands[0], GET_MODE(operands[0]))) {
				asm(\"ldy	#%1	;; mv_r_indrxr_24\");
				if (!md_is_axy(operands[2])) {
					asm(\"lda	%L2\");
				}
				asm(\"sta	(%0),y\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
					asm(\"ldy	#%1+1\");
					asm(\"sta	(%0),y\");
					asm(\"ldy	#2\");
					if (!md_are_bank_high_same(operands[2])) {
						asm(\"lda	%B2\");
					}
					asm(\"ldy	#%1+2\");
				}
				else {
					asm(\"iny\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
					asm(\"sta	(%0),y\");
					asm(\"iny\");
					if (!md_are_bank_high_same(operands[2])) {
						asm(\"lda	%B2\");
					}
				}
				asm(\"sta	(%0),y\");
			}
			else {
				if (!md_is_axy(operands[0])) {
					asm(\"lda	%L0	;; mv_r_indrxr_24\");
					asm(\"sta	t\");
					if (md_need_y(operands[0])) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H0\");
					asm(\"sta	t+1\");
				}
				else {
					asm(\"sta	t	;; mv_r_indrxr_24\");
					asm(\"stx	t+1\");
				}
				asm(\"ldy	#%1\");
				asm(\"lda	%L2\");
				asm(\"sta	(t),y\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
					asm(\"ldy	#%1+1\");
					asm(\"sta	(t),y\");
					asm(\"ldy	#2\");
					if (!md_are_bank_high_same(operands[2])) {
						asm(\"lda	%B2\");
					}
					asm(\"ldy	#%1+2\");
				}
				else {
					asm(\"iny\");
					if (!md_are_high_low_same(operands[2])) {
						asm(\"lda	%H2\");
					}
					asm(\"sta	(t),y\");
					asm(\"iny\");
					if (!md_are_bank_high_same(operands[2])) {
						asm(\"lda	%B2\");
					}
				}
				asm(\"sta	(t),y\");
			}
		}
		else if ((GET_CODE(operands[1]) == SYMBOL_REF) && !TARGET_16BITX) {
				md_output_warning(\"using 8 bit index\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#2	;; mv_r_indrxr_24\");
					asm(\"lda	%B2\");
					asm(\"pha\");
					asm(\"dey\");
					asm(\"lda	%H2\");
					asm(\"tax\");
					asm(\"lda	%L2\");
					asm(\"ldy	%L0\");
					asm(\"sta	%1,y\");
					asm(\"iny\");
					asm(\"txa\");
					asm(\"sta	%1+1,y\");
					asm(\"iny\");
					asm(\"pla\");
					asm(\"sta	%1+2,y\");
				}
				else {
					if (!md_is_axy(operands[0])) {
						asm(\"ldy	%L0	;; mv_r_indrxr_24\");
					}
					else {
						asm(\"tay		;; mv_r_indrxr_24\");
					}
					if (!md_is_axy(operands[2])) {
						asm(\"lda	%L2\");
					}
					asm(\"sta	%1,y\");
					if (!md_are_high_low_same(operands[2])) {
						if (!md_is_axy(operands[2])) {
							asm(\"lda	%H2\");
						}
						else {
							asm(\"txa\");
						}
					}
					asm(\"sta	%1+1,y\");
					if (!md_are_bank_high_same(operands[2])) {
						asm(\"lda	%B2\");
					}
					asm(\"sta	%1+2,y\");
				}
		}
		else {
			asm(\"clc		;; mv_r_indrxr_24\");
			if (md_is_axy(operands[0])) {
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			else if (md_is_axy(operands[1])) {
				asm(\"adc	%L0\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H0\");
				asm(\"sta	t+1\");
			}
			else {
				asm(\"lda	%L0\");
				asm(\"adc	%L1\");
				asm(\"sta	t\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H0\");
				asm(\"adc	%H1\");
				asm(\"sta	t+1\");
			}
			asm(\"lda	%L2\");
			asm(\"sta	(t),0\");
			asm(\"ldy	#1\");
			if (!md_are_high_low_same(operands[2])) {
				asm(\"lda	%H2\");
			}
			asm(\"sta	(t),y\");
			asm(\"iny\");
			if (!md_are_bank_high_same(operands[2])) {
				asm(\"lda	%B2\");
			}
			asm(\"sta	(t),y\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn "mv_indrxr_indrxr_8"
	[	(set	(mem:QI	(plus:HI	(match_operand:HI 0 "md_gpr_op" "r")
						(match_operand:HI 1 "md_gen_imm_op" "g")
				)
			)
			(mem:QI	(plus:HI	(match_operand:HI 2 "md_gpr_op" "r")
						(match_operand:HI 3 "md_gen_imm_op" "g")
				)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (	(GET_CODE(operands[3]) == CONST_INT) &&
			((INTVAL(operands[3]) >= 0) &&
			(INTVAL(operands[3]) < 256))
		   ) {
			asm(\"ldy	#%3	;; mv_indrxr_indrxr_8\");
			asm(\"lda	(%2),y\");
		}
		else if ((GET_CODE(operands[3]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			if (!md_is_axy(operands[2])) {
				asm(\"ldx	%L2	;; mv_indrxr_indrxr_8\");
			}
			else {
				asm(\"tax		;; mv_indrxr_indrxr_8\");
			}
			asm(\"lda	%3,x\");
		}
		else {
			asm(\"clc		;; mv_indrxr_indrxr_8\");
			if (md_is_axy(operands[2])) {
				asm(\"adc	%L3\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[3])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"adc	%H3\");
				asm(\"sta	t+1\");
			}
			else if (md_is_axy(operands[3])) {
				asm(\"adc	%L2\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"adc	%H2\");
				asm(\"sta	t+1\");
			}
			else {
				asm(\"lda	%L2\");
				asm(\"adc	%L3\");
				asm(\"sta	t\");
				if (	(md_need_y(operands[2])) ||
					(md_need_y(operands[3]))
				   ) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H2\");
				asm(\"adc	%H3\");
				asm(\"sta	t+1\");
			}
			asm(\"lda	(t),0\");
		}

	/* src is in A */

		if (	(GET_CODE(operands[1]) == CONST_INT) &&
			((INTVAL(operands[1]) >= 0) &&
			(INTVAL(operands[1]) < 256))
		   ) {
			asm(\"ldy	#%1\");
			asm(\"sta	(%0),y\");
		}
		else if ((GET_CODE(operands[1]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			asm(\"ldx	%L0\");
			asm(\"sta	%1,x\");
		}
		else {
			asm(\"tax\");
			asm(\"clc\");
			asm(\"lda	%L0\");
			asm(\"adc	%L1\");
			asm(\"sta	t\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				if (y != 1) {
					asm(\"ldy	#1\");
				}
			}
			asm(\"lda	%H0\");
			asm(\"adc	%H1\");
			asm(\"sta	t+1\");
			asm(\"txa\");
			asm(\"sta	(t),0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "mv_indrxr_indrxr_16"
	[	(set	(mem:HI	(plus:HI	(match_operand:HI 0 "md_gpr_op" "r")
						(match_operand:HI 1 "md_gen_imm_op" "g")
				)
			)
			(mem:HI	(plus:HI	(match_operand:HI 2 "md_gpr_op" "r")
						(match_operand:HI 3 "md_gen_imm_op" "g")
				)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (	(GET_CODE(operands[3]) == CONST_INT) &&
			((INTVAL(operands[3]) >= 0) &&
			(INTVAL(operands[3]) < 254))
		   ) {
			asm(\"ldy	#%3	;; mv_indrxr_indrxr_16\");
			asm(\"lda	(%2),y\");
			asm(\"tax\");
			asm(\"iny\");
			asm(\"lda	(%2),y\");
		}
		else if ((GET_CODE(operands[3]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			if (!md_is_axy(operands[2])) {
				asm(\"ldx	%L2	;; mv_indrxr_indrxr_16\");
			}
			else {
				asm(\"tax		;; mv_indrxr_indrxr_16\");
			}
			asm(\"lda	%3,x\");
			asm(\"pha\");
			asm(\"lda	%3+1,x\");
			asm(\"plx\");
		}
		else {
			asm(\"clc		;; mv_indrxr_indrxr_16\");
			if (md_is_axy(operands[2])) {
				asm(\"adc	%L3\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[3])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"adc	%H3\");
				asm(\"sta	t+1\");
			}
			else if (md_is_axy(operands[3])) {
				asm(\"adc	%L2\");
				asm(\"sta	t\");
				asm(\"txa	\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"adc	%H2\");
				asm(\"sta	t+1\");
			}
			else {
				asm(\"lda	%L2\");
				asm(\"adc	%L3\");
				asm(\"sta	t\");
				if (	(md_need_y(operands[2])) ||
					(md_need_y(operands[3]))
				   ) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H2\");
				asm(\"adc	%H3\");
				asm(\"sta	t+1\");
			}
			asm(\"lda	(t),0\");
			asm(\"tax\");
			asm(\"ldy	#1\");
			y = 1;
			asm(\"lda	(t),y\");
		}

	/* src is in AX */

		if (	(GET_CODE(operands[1]) == CONST_INT) &&
			((INTVAL(operands[1]) >= 0) &&
			(INTVAL(operands[1]) < 254))
		   ) {
			asm(\"ldy	#%1+1\");
			asm(\"sta	(%0),y\");
			asm(\"dey\");
			asm(\"txa\");
			asm(\"sta	(%0),y\");
		}
		else if ((GET_CODE(operands[1]) == SYMBOL_REF) && !TARGET_16BITX) {
			md_output_warning(\"using 8 bit index\");
			asm(\"ldy	%L0\");
			asm(\"sta	%1+1,y\");
			asm(\"txa\");
			asm(\"sta	%1,y\");
		}
		else {
			asm(\"pha\");
			asm(\"clc\");
			asm(\"lda	%L0\");
			asm(\"adc	%L1\");
			asm(\"sta	t\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				if (y != 1) {
					asm(\"ldy	#1\");
				}
			}
			asm(\"lda	%H0\");
			asm(\"adc	%H1\");
			asm(\"sta	t+1\");
			asm(\"txa\");
			asm(\"sta	(t),0\");
			if (y != 1) {
				asm(\"ldy	#1\");
			}
			asm(\"pla\");
			asm(\"sta	(t),y\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_expand "movqi"
	[	(set	(match_operand:QI 0 "general_operand" "=")
			(match_operand:QI 1 "general_operand" "")
		)
	]
	""
	"{
		if (md_movmm (operands, QImode)) {
			DONE;
		}
	}"
)

(define_expand "movhi"
	[	(set	(match_operand:HI 0 "general_operand" "=")
			(match_operand:HI 1 "general_operand" "")
		)
	]
	""
	"{
		if (md_movmm (operands, HImode)) {
			DONE;
		}
	}"
)

(define_expand "movsi"
	[	(set	(match_operand:SI 0 "general_operand" "=")
			(match_operand:SI 1 "general_operand" "")
		)
	]
	""
	"{
		if (md_movmm (operands, SImode)) {
			DONE;
		}
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Jumps:

(define_insn "indirect_jump"
	[	(set	(pc)
			(match_operand 0 "md_addr_op" "")
		)
	]
	""
	"*{
		asm(\"jma	%0	;; jumpi\");
		return \"\";
	}"
)

(define_insn "jump"
	[	(set	(pc)
			(label_ref (match_operand 0 "" ""))
		)
	]
	""
	"*{
		asm(\"jma	%0	;; jump\");
		return \"\";
	}"
)

(define_insn "tablejump"
	[	(set	(pc)
			(match_operand:HI 0 "address_operand" "")
		)
		(use	(label_ref (match_operand 1 "" "")))
	]
	""
	"*{
		if (md_is_axy(operands[0])) {
			asm(\"jmp	lib_ind_jump	;; jump_indr\");
		}
		else {
			asm(\"lda	%L0	;; jump_indr\");
			asm(\"ldx	%H0\");
			asm(\"jmp	lib_ind_jump\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Stack

(define_insn "mv_addr_sp_r_16"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(match_operand:HI 1 "md_sp_op" "fx")
		)
	]
	""
	"*{
		if (REG_OK_FOR_FP(operands[0])) {
			asm(\"error_no_fp\");
		}
		else {
			asm(\"lda	#low %$	;; mv_addr_sp_r_16\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"lda	#high %$\");
				asm(\"ldy	#1\");
				asm(\"sta	%H0\");
				md_forget_axy();
			}
			else {
				asm(\"ldx	#high %$\");
				asm(\"stx	%H0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Arithmetic/logical:

(define_insn "addqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(plus:QI	(match_operand:QI 1 "md_gen_op" "g")
					(match_operand:QI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (	(rtx_equal_p(operands[0], operands[1])) &&
				(!md_need_y(operands[0]))
			   ) {
				if (INTVAL(operands[2]) == 1) {
					asm(\"inc	%L0	;; addqi3\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
					return \"\";
				}
				else if (INTVAL(operands[2]) == 2) {
					asm(\"inc	%L0	;; addqi3\");
					asm(\"inc	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
					return \"\";
				}
				else if ((INTVAL(operands[2]) & 0xFF) == 0xFF) {
					asm(\"dec	%L0	;; addqi3\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
					return \"\";
				}
				else if ((INTVAL(operands[2]) & 0xFF) == 0xFE) {
					asm(\"dec	%L0	;; addqi3\");
					asm(\"dec	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
					return \"\";
				}
			}
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; addqi3\");
				if (INTVAL(operands[2]) == 1) {
					asm(\"ina\");
				}
				else if ((INTVAL(operands[2]) & 0xFF) == 0xFF) {
					asm(\"dca\");
				}
				else {
					asm(\"clc\");
					asm(\"adc	#low %2\");
				}
			}
			else {
				if (INTVAL(operands[2]) == 1) {
					asm(\"ina		;; addqi3\");
				}
				else if ((INTVAL(operands[2]) & 0xFF) == 0xFF) {
					asm(\"dca		;; addqi3\");
				}
				else {
					asm(\"clc		;; addqi3\");
					asm(\"adc	#low %2\");
				}
			}
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		else {
			asm(\"clc		;; addqi3\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			asm(\"adc	%L2\");
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		return \"\";
	}"
)

(define_insn "addqihi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(plus:HI	(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
					(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same = md_are_ops_same_reg(operands[0], operands[2]);

		asm(\"clc		;; addqihi3\");
		if (md_is_axy(operands[1])) {
			asm(\"adc	%L2\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"adc	%L1\");
		}
		else {
			asm(\"lda	%L1\");
			asm(\"adc	%L2\");
		}
		if (regs_same) {
			asm(\"tax\");
		}
		else {
			asm(\"sta	%L0\");
		}
		if (	(md_need_y(operands[0])) ||
			(md_need_y(operands[2]))
		   ) {
			asm(\"ldy	#1\");
		}
		if (md_is_axy(operands[2]) && !regs_same) {
			asm(\"txa\");
		}
		else {
			asm(\"lda	%H2\");
		}
		asm(\"adc	#0\");
		asm(\"sta	%H0\");
		if (regs_same) {
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "addhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(plus:HI	(match_operand:HI 1 "md_gen_sp_op" "gfx")
					(match_operand:HI 2 "md_gen_sp_op" "gfx")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (GET_CODE(operands[2]) == CONST_INT) {
			if (REG_OK_FOR_SP(operands[1])) {
				asm(\"lda	#low (%$ + %2)	;; addhi3\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"lda	#high (%$ + %2)\");
					asm(\"ldy	#1\");
					asm(\"sta	%H0\");
					md_forget_axy();
				}
				else {
					asm(\"ldx	#high (%$ + %2)\");
					asm(\"stx	%H0\");
					md_remember_axy(operands[0]);
				}
			}
			else if (REG_OK_FOR_FP(operands[1])) {
				asm(\"error_no_fp\");
			}
			else {
				if (REG_OK_FOR_SP(operands[2])) {
					asm(\"clc		;; addhi3\");
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1\");
					}
					asm(\"adc	#low %$\");
					asm(\"sta	%L0\");
					if (md_is_axy(operands[1])) {
						asm(\"txa\");
					}
					else {
						asm(\"lda	%H1\");
					}
					asm(\"adc	#high %$\");
					if (md_need_y(operands[0])) {
						asm(\"ldy	#1\");
					}
					asm(\"sta	%H0\");
					md_forget_axy();
				}
				else if (REG_OK_FOR_FP(operands[2])) {
					asm(\"error_no_fp\");
				}
				else {
					if (	(INTVAL(operands[2]) == 1) &&
						(rtx_equal_p(operands[0], operands[1])) &&
						(!md_need_y(operands[0]))
					   ) {
						asm(\"inc	%L0	;; addhi3\");
						md_new_label();
						asm(\"bne	%@\");
						asm(\"inc	%H0\");
						md_output_md_label(md_labelnum);
						if (md_is_axy(operands[0])) {
							md_forget_axy();
						}
					}
					else if (	(INTVAL(operands[2]) == 1) &&
							(!md_need_y(operands[0])) &&
							(!md_need_y(operands[1]))
						) {
						if (!md_is_axy(operands[1])) {
							asm(\"lda	%L1	;; addhi3\");
							asm(\"ldx	%H1\");
							asm(\"ina\");
						}
						else {
							asm(\"ina		;; addhi3\");
						}
						md_new_label();
						asm(\"bne	%@\");
						asm(\"inx\");
						md_output_md_label(md_labelnum);
						asm(\"sta	%L0\");
						asm(\"stx	%H0\");
						md_remember_axy(operands[0]);
					}
					else if (	((INTVAL(operands[2]) & 0xFFFF) == 0xFFFF) &&
							(!md_need_y(operands[1])) &&
							(!md_need_y(operands[0]))
						) {
						asm(\"ldx	%H1	;; addhi3\");
						asm(\"lda	%L1\");
						md_new_label();
						asm(\"bne	%@\");
						asm(\"dex\");
						md_output_md_label(md_labelnum);
						asm(\"dca\");
						asm(\"sta	%L0\");
						asm(\"stx	%H0\");
						md_remember_axy(operands[0]);
					}
					else {
						asm(\"clc		;; addhi3\");
						if (!md_is_axy(operands[1])) {
							asm(\"lda	%L1\");
						}
						if (!md_is_low_zero(operands[2])) {
							asm(\"adc	%L2\");
						}
						if (regs_same) {
							asm(\"tax\");
							if (md_need_y(operands[1])) {
								asm(\"ldy	#1\");
								y = 1;
							}
							asm(\"lda	%H1\");
							asm(\"adc	%H2\");
							if (md_need_y(operands[0])) {
								if (y != 1) {
									asm(\"ldy	#1\");
								}
							}
							asm(\"sta	%H0\");
							if (md_need_y(operands[0])) {
								asm(\"txa\");
								asm(\"sta	%L0\");
							}
							else {
								asm(\"stx	%L0\");
							}
							md_forget_axy();
						}
						else {
							asm(\"sta	%L0\");
							if (md_is_axy(operands[1])) {
								asm(\"txa\");
							}
							else {
								if (md_need_y(operands[1])) {
									asm(\"ldy	#1\");
								}
								asm(\"lda	%H1\");
							}
							asm(\"adc	%H2\");
							if (	(md_need_y(operands[0])) &&
								(!md_need_y(operands[1]))
							   ) {
								asm(\"ldy	#1\");
							}
							asm(\"sta	%H0\");
							md_forget_axy();
						}
					}
				}
			}
		}
		else {
			if (REG_OK_FOR_SP(operands[2])) {
				asm(\"clc		;; addhi3\");
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1\");
				}
				asm(\"adc	#low %$\");
				asm(\"sta	%L0\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1]))
				   ) {
					asm(\"ldy	#1\");
				}
				if (md_is_axy(operands[1])) {
					asm(\"txa\");
				}
				else {
					asm(\"lda	%H1\");
				}
				asm(\"adc	#high %$\");
				asm(\"sta	%H0\");
				md_forget_axy();
			}
			else if (REG_OK_FOR_FP(operands[2])) {
				asm(\"error_no_fp\");
			}
			else if (REG_OK_FOR_SP(operands[1])) {
				asm(\"clc		;; addhi3\");
				if (!md_is_axy(operands[2])) {
					asm(\"lda	%L2\");
				}
				asm(\"adc	#low %$\");
				asm(\"sta	%L0\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				if (md_is_axy(operands[2])) {
					asm(\"txa\");
				}
				else {
					asm(\"lda	%H2\");
				}
				asm(\"adc	#high %$\");
				asm(\"sta	%H0\");
				md_forget_axy();
			}
			else if (REG_OK_FOR_FP(operands[1])) {
				asm(\"error_no_fp\");
			}
			else {
				asm(\"clc		;; addhi3\");
				if (regs_same) {
					if (md_is_axy(operands[1])) {
						asm(\"adc	%L2\");
					}
					else if (md_is_axy(operands[2])) {
						asm(\"adc	%L1\");
					}
					asm(\"tax\");
					if (	(md_need_y(operands[0])) ||
						(md_need_y(operands[1])) ||
						(md_need_y(operands[2]))
					   ) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H1\");
					asm(\"adc	%H2\");
					asm(\"sta	%H0\");
					if (md_need_y(operands[0])) {
						asm(\"txa\");
						asm(\"sta	%L0\");
					}
					else {
						asm(\"stx	%L0\");
					}
				}
				else if (md_is_axy(operands[1])) {
					if (!md_is_low_zero(operands[2])) {
						asm(\"adc	%L2\");
					}
					asm(\"sta	%L0\");
					asm(\"txa\");
					if (	(md_need_y(operands[0])) ||
						(md_need_y(operands[2]))
					   ) {
						asm(\"ldy	#1\");
					}
					asm(\"adc	%H2\");
					asm(\"sta	%H0\");
				}
				else if (md_is_axy(operands[2])) {
					if (!md_is_low_zero(operands[1])) {
						asm(\"adc	%L1\");
					}
					asm(\"sta	%L0\");
					asm(\"txa\");
					if (	(md_need_y(operands[0])) ||
						(md_need_y(operands[1]))
					   ) {
						asm(\"ldy	#1\");
					}
					asm(\"adc	%H1\");
					asm(\"sta	%H0\");
				}
				else {
					asm(\"lda	%L1\");
					if (!md_is_low_zero(operands[2])) {
						asm(\"adc	%L2\");
					}
					asm(\"sta	%L0\");
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1\");
						y = 1;
					}
					asm(\"lda	%H1\");
					if (	(md_need_y(operands[2])) &&
						(y != 1)
					   ) {
						asm(\"ldy	#1\");
						y = 1;
					}
					asm(\"adc	%H2\");
					if (	(md_need_y(operands[0])) &&
						(y != 1)
					   ) {
						asm(\"ldy	#1\");
					}
					asm(\"sta	%H0\");
				}
				md_forget_axy();
			}
		}
		return \"\";
	}"
)

(define_insn "addhisi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(plus:SI	(zero_extend:SI (match_operand:HI 1 "md_gen_op" "g"))
					(match_operand:SI 2 "md_gen_imm_op" "g")
					
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		asm(\"clc		;; addhisi3\");
		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"adc	%L2\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"adc	%L1\");
			}
			asm(\"tax\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"adc	%H2\");
			asm(\"pha\");
			if (md_need_y(operands[2])) {
				asm(\"iny\");
				y = 2;
			}
			asm(\"lda	#0\");
			asm(\"adc	%B2\");
			if (md_need_y(operands[0])) {
				if (y != 2) {
					asm(\"ldy	#2\");
				}
				asm(\"sta	%B0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
				asm(\"pla\");
				asm(\"dey\");
				asm(\"sta	%H0\");
			}
			else {
				asm(\"sta	%B0\");
				asm(\"stx	%L0\");
				asm(\"pla\");
				asm(\"sta	%H0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			asm(\"adc	%L2\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"adc	%H2\");
			asm(\"sta	%H0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"adc	%B2\");
			asm(\"sta	%B0\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"adc	%L1\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"adc	%H1\");
			asm(\"sta	%H0\");
			if (y == 1) {
				asm(\"iny\");
				y = 2;
				asm(\"lda	%B2\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"adc	#0\");
			if (md_need_y(operands[0])) {
				if (y != 2) {
					if (y == 1) {
						asm(\"iny\");
					}
					else {
						asm(\"ldy	#2\");
					}
				}
			}
			asm(\"sta	%B0\");
		}
		else {
			asm(\"lda	%L1\");
			asm(\"adc	%L2\");
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"adc	%H2\");
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"lda	#0\");
			asm(\"adc	%B2\");
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "addsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(plus:SI	(match_operand:SI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (GET_CODE(operands[2]) == CONST_INT) {
			if (	(INTVAL(operands[2]) == 1) &&
				(rtx_equal_p(operands[0], operands[1])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"inc	%L0	;; addsi3\");
				md_new_label();
				asm(\"bne	%@\");
				asm(\"inc	%H0\");
				asm(\"bne	%@\");
				asm(\"inc	%B0\");
				md_output_md_label(md_labelnum);
				if (md_is_axy(operands[0])) {
					md_forget_axy();
				}
			}
			else {
				asm(\"clc		;; addsi3\");
				if (regs_same) {
					if (md_is_axy(operands[1])) {
						asm(\"adc	#low %2\");
					}
					else {
						asm(\"lda	%L1\");
						asm(\"adc	#low %2\");
					}
					asm(\"tax\");
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H1\");
					asm(\"adc	#high %2\");
					asm(\"pha\");
					if (md_need_y(operands[1])) {
						asm(\"iny\");
						y = 2;
					}
					asm(\"lda	%B1\");
					asm(\"adc	#bank %2\");
					if (md_need_y(operands[0])) {
						if (y != 2) {
							asm(\"ldy	#2\");
						}
						asm(\"sta	%B0\");
						asm(\"txa\");
						asm(\"sta	%L0\");
						asm(\"pla\");
						asm(\"dey\");
						asm(\"sta	%H0\");
					}
					else {
						asm(\"sta	%B0\");
						asm(\"stx	%L0\");
						asm(\"pla\");
						asm(\"sta	%H0\");
					}
				}
				else if (md_is_axy(operands[1])) {
					asm(\"adc	#low %2\");
					asm(\"sta	%L0\");
					asm(\"txa\");
					asm(\"adc	#high %2\");
					if (md_need_y(operands[0])) {
						asm(\"ldy	#1\");
						asm(\"sta	%H0\");
						asm(\"iny\");
						asm(\"lda	%B1\");
						asm(\"adc	#bank %2\");
						asm(\"sta	%B0\");
					}
					else {
						asm(\"sta	%H0\");
						asm(\"tya\");
						asm(\"adc	#bank %2\");
						asm(\"sta	%B0\");
					}
				}
				else {
					asm(\"lda	%L1\");
					asm(\"adc	#low %2\");
					asm(\"sta	%L0\");
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1\");
					}
					asm(\"lda	%H1\");
					asm(\"adc	#high %2\");
					if (	(md_need_y(operands[0])) &&
						(!md_need_y(operands[1]))
					   ) {
						asm(\"ldy	#1\");
					}
					asm(\"sta	%H0\");
					if (md_need_y(operands[1])) {
						asm(\"iny\");
					}
					asm(\"lda	%B1\");
					asm(\"adc	#bank %2\");
					if (	(md_need_y(operands[0])) &&
						(!md_need_y(operands[1]))
					   ) {
						asm(\"iny	#1\");
					}
					asm(\"sta	%B0\");
				}
				md_forget_axy();
			}
		}
		else {
			asm(\"clc		;; addsi3\");
			if (regs_same) {
				if (md_is_axy(operands[1])) {
					asm(\"adc	%L2\");
				}
				else if (md_is_axy(operands[2])) {
					asm(\"adc	%L1\");
				}
				asm(\"tax\");
				if (	(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H1\");
				asm(\"adc	%H2\");
				asm(\"pha\");
				if (	(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"iny\");
					y = 2;
				}
				asm(\"lda	%B1\");
				asm(\"adc	%B2\");
				if (md_need_y(operands[0])) {
					if (y != 2) {
						asm(\"ldy	#2\");
					}
					asm(\"sta	%B0\");
					asm(\"txa\");
					asm(\"sta	%L0\");
					asm(\"pla\");
					asm(\"dey\");
					asm(\"sta	%H0\");
				}
				else {
					asm(\"sta	%B0\");
					asm(\"stx	%L0\");
					asm(\"pla\");
					asm(\"sta	%H0\");
				}
			}
			else if (md_is_axy(operands[1])) {
				asm(\"adc	%L2\");
				asm(\"sta	%L0\");
				asm(\"txa\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H2\");
				asm(\"sta	%H0\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"iny\");
					asm(\"lda	%B1\");
				}
				else {
					asm(\"tya\");
				}
				asm(\"adc	%B2\");
				asm(\"sta	%B0\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"adc	%L1\");
				asm(\"sta	%L0\");
				asm(\"txa\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"adc	%H1\");
				asm(\"sta	%H0\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1]))
				   ) {
					asm(\"iny\");
					asm(\"lda	%B2\");
				}
				else {
					asm(\"tya\");
				}
				asm(\"adc	%B1\");
				asm(\"sta	%B0\");
			}
			else {
				asm(\"lda	%L1\");
				asm(\"adc	%L2\");
				asm(\"sta	%L0\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H1\");
				asm(\"adc	%H2\");
				asm(\"sta	%H0\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"iny\");
				}
				asm(\"lda	%B1\");
				asm(\"adc	%B2\");
				asm(\"sta	%B0\");
			}
			md_forget_axy();
		}
		return \"\";
	}"
)

(define_insn "subqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(minus:QI	(match_operand:QI 1 "md_gen_op" "g")
					(match_operand:QI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		asm(\"sec		;; subqi3\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"sbc	%L2\");
		asm(\"sta	%L0\");
		md_remember_axy(operands[0]);
		return \"\";
	}"
)

(define_insn "subqihi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(minus:HI	(match_operand:HI 1 "md_gen_op" "g")
					(zero_extend:HI (match_operand:QI 2 "md_gen_imm_op" "g"))
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);

		asm(\"sec		;; subqihi3\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"sbc	%L2\");
		if (regs_same) {
			asm(\"tax\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"sbc	#0\");
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		else {
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			if (md_is_axy(operands[1])) {
				asm(\"txa\");
			}
			else {
				asm(\"lda	%H1\");
			}
			asm(\"sbc	#0\");
			asm(\"sta	%H0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "subhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(minus:HI	(match_operand:HI 1 "md_gen_op" "g")
					(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);

		asm(\"sec		;; subhi3\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"sbc	%L2\");
		if (regs_same) {
			asm(\"tax\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"sbc	%H2\");
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		else {
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			if (md_is_axy(operands[1])) {
				asm(\"txa\");
			}
			else {
				asm(\"lda	%H1\");
			}
			asm(\"sbc	%H2\");
			asm(\"sta	%H0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "subsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(minus:SI	(match_operand:SI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		asm(\"sec		;; subsi3\");
		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"sbc	%L2\");
			}
			else {
				asm(\"lda	%L1\");
				asm(\"sbc	%L2\");
			}
			asm(\"tax\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"sbc	%H2\");
			asm(\"pha\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
				y = 2;
			}
			asm(\"lda	%B1\");
			asm(\"sbc	%B2\");
			if (md_need_y(operands[0])) {
				if (y != 2) {
					asm(\"ldy	#2\");
				}
				asm(\"sta	%B0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
				asm(\"pla\");
				asm(\"dey\");
				asm(\"sta	%H0\");
			}
			else {
				asm(\"sta	%B0\");
				asm(\"stx	%L0\");
				asm(\"pla\");
				asm(\"sta	%H0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			asm(\"sbc	%L2\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[2])) ||
				(md_need_y(operands[0]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H2\");
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[2])) ||
				(md_need_y(operands[0]))
			   ) {
				asm(\"iny\");
				asm(\"lda	%B1\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"sbc	%B2\");
			asm(\"sta	%B0\");
		}
		else {
			asm(\"lda	%L1\");
			asm(\"sbc	%L2\");
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"sbc	%H2\");
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"lda	%B1\");
			asm(\"sbc	%B2\");
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "andqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(and:QI	(match_operand:QI 1 "md_gen_op" "g")
				(match_operand:QI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"and	%L2	;; andqi3\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"and	%L1	;; andqi3\");
		}
		else {
			asm(\"lda	%L1	;; andqi3\");
			asm(\"and	%L2\");
		}
		asm(\"sta	%L0\");
		md_remember_axy(operands[0]);
		return \"\";
	}"
)

(define_insn "andqihi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(and:HI	(subreg:HI	(match_operand:QI 1 "md_gen_op" "g")
						0
				)
				(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);

		if (md_is_axy(operands[1])) {
			asm(\"and	%L2	;; andqihi3\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"and	%L1	;; andqihi3\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		else {
			asm(\"lda	%L1	;; andqihi3\");
			asm(\"and	%L2\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		if (md_need_y(operands[0])) {
			asm(\"ldy	#1\");
			asm(\"lda	#0\");
			asm(\"sta	%H0\");
			if (regs_same) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
		}
		else {
			asm(\"stz	%H0\");
			if (regs_same) {
				asm(\"stx	%L0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "andhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(and:HI	(match_operand:HI 1 "md_gen_op" "g")
				(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"and	%L2	;; andhi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"and	%L1	;; andhi3\");
			}
			else {
				asm(\"lda	%L1	;; andhi3\");
				asm(\"and	%L2\");
			}
			asm(\"tax\");
			if (	(md_is_high_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%H0\");
			}
			else {
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H1\");
				asm(\"and	%H2\");
				asm(\"sta	%H0\");
				if (md_need_y(operands[0])) {
					asm(\"txa\");
					asm(\"sta	%L0\");
				}
				else {
					asm(\"stx	%L0\");
				}
			}
		}
		else if (md_is_axy(operands[1])) {
			if (	(md_is_low_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%L0	;; andhi3\");
			}
			else {
				asm(\"and	%L2	;; andhi3\");
				asm(\"sta	%L0\");
			}
			if (	(md_is_high_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%H0\");
			}
			else {
				asm(\"txa\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"and	%H2\");
				asm(\"sta	%H0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"and	%L1	;; andhi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"and	%H1\");
			asm(\"sta	%H0\");
		}
		else {
			if (	(md_is_low_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%L0	;; andhi3\");
			}
			else {
				asm(\"lda	%L1	;; andhi3\");
				asm(\"and	%L2\");
				asm(\"sta	%L0\");
			}
			if (	(md_is_high_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%H0\");
			}
			else {
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H1\");
				asm(\"and	%H2\");
				asm(\"sta	%H0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "andqisi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(and:SI	(subreg:SI	(match_operand:QI 1 "md_gen_op" "g")
						0
				)
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);

		if (md_is_axy(operands[1])) {
			asm(\"and	%L2	;; andqisi3\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"and	%L1	;; andqisi3\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		else {
			asm(\"lda	%L1	;; andqisi3\");
			asm(\"and	%L2\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		if (md_need_y(operands[0])) {
			asm(\"ldy	#1\");
			asm(\"lda	#0\");
			asm(\"sta	%H0\");
			asm(\"iny\");
			asm(\"sta	%B0\");
		}
		else {
			asm(\"stz	%H0\");
			asm(\"stz	%B0\");
		}
		if (regs_same) {
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "andhisi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(and:SI	(subreg:SI	(match_operand:HI 1 "md_gen_op" "g")
						0
				)
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"and	%L2	;; andhisi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"and	%L1	;; andhisi3\");
			}
			else {
				asm(\"lda	%L1	;; andhisi3\");
				asm(\"and	%L2\");
			}
			asm(\"tax\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H1\");
			asm(\"and	%H2\");
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				if (y == 1) {
					asm(\"iny\");
				}
				else {
					asm(\"ldy	#2\");
				}
				asm(\"lda	#0\");
				asm(\"sta	%B0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stz	%B0\");
				asm(\"stx	%L0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			asm(\"and	%L2	;; andhisi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[2])) ||
				(md_need_y(operands[0]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"and	%H2\");
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"iny\");
				asm(\"lda	#0\");
				asm(\"sta	%B0\");
			}
			else {
				asm(\"stz	%B0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"and	%L1	;; andhisi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[0]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"and	%H1\");
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"iny\");
				asm(\"lda	#0\");
				asm(\"sta	%B0\");
			}
			else {
				asm(\"stz	%B0\");
			}
		}
		else {
			asm(\"lda	%L1	;; andhisi3\");
			asm(\"and	%L2\");
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"and	%H2\");
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"iny\");
				asm(\"lda	#0\");
				asm(\"sta	%B0\");
			}
			else {
				asm(\"stz	%B0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "andsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(and:SI	(match_operand:SI 1 "md_gen_op" "g")
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"and	%L2	;; andsi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"and	%L1	;; andsi3\");
			}
			else {
				asm(\"lda	%L1	;; andsi3\");
				asm(\"and	%L2\");
			}
			asm(\"tax\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"and	%H2\");
			asm(\"pha\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
				y = 2;
			}
			asm(\"lda	%B1\");
			asm(\"and	%B2\");
			if (md_need_y(operands[0])) {
				if (y != 2) {
					asm(\"ldy	#2\");
				}
				asm(\"sta	%B0\");
				asm(\"pla\");
				asm(\"dey\");
				asm(\"sta	%H0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%B0\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"stx	%L0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			if (	(md_is_low_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%L0	;; andsi3\");
			}
			else {
				asm(\"and	%L2	;; andsi3\");
				asm(\"sta	%L0\");
			}
			if (	(md_is_high_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%H0\");
			}
			else {
				asm(\"txa\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"and	%H2\");
				asm(\"sta	%H0\");
			}
			if (	(md_is_bank_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%B0\");
			}
			else {
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"iny\");
					asm(\"lda	%B1\");
				}
				else {
					asm(\"tya\");
				}
				asm(\"and	%B2\");
				asm(\"sta	%B0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"and	%L1	;; andsi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"and	%H1\");
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"iny\");
				asm(\"lda	%B2\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"and	%B1\");
			asm(\"sta	%B0\");
		}
		else {
			if (	(md_is_low_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%L0\");
			}
			else {
				asm(\"lda	%L1	;; andsi3\");
				asm(\"and	%L2\");
				asm(\"sta	%L0\");
			}
			if (	(md_is_high_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%H0\");
			}
			else {
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"lda	%H1\");
				asm(\"and	%H2\");
				asm(\"sta	%H0\");
			}
			if (	(md_is_bank_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stz	%B0\");
			}
			else {
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[1])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"iny\");
				}
				asm(\"lda	%B1\");
				asm(\"and	%B2\");
				asm(\"sta	%B0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "iorqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(ior:QI	(match_operand:QI 1 "md_gen_op" "g")
				(match_operand:QI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"ora	%L2	;; iorqi3\");
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		else if (md_is_axy(operands[2])) {
			asm(\"ora	%L1	;; iorqi3\");
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		else if (	(rtx_equal_p(operands[0], operands[1])) &&
				(!md_need_y(operands[0]))
			) {
			asm(\"lda	%L2	;; iorqi3\");
			asm(\"tsb	%L0\");
			md_forget_axy();
		}
		else {
			asm(\"lda	%L1	;; iorqi3\");
			asm(\"ora	%L2\");
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		return \"\";
	}"
)

(define_insn "iorqihi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(ior:HI	(subreg:HI	(match_operand:QI 1 "md_gen_op" "g")
						0
				)
				(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);

		if (md_is_axy(operands[1])) {
			asm(\"ora	%L2	;; iorqihi3\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"ora	%L1	;; iorqihi3\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		else if (	(rtx_equal_p(operands[0], operands[1])) &&
				(!regs_same) &&
				(!md_need_y(operands[0]))
			) {
			asm(\"lda	%L2	;; iorqihi3\");
			asm(\"tsb	%L0\");
		}
		else {
			asm(\"lda	%L1	;; iorqihi3\");
			asm(\"ora	%L2\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		if (	(md_need_y(operands[0])) ||
			(md_need_y(operands[2]))
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"lda	%H2\");
		asm(\"sta	%H0\");
		if (regs_same) {
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "iorhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(ior:HI	(match_operand:HI 1 "md_gen_op" "g")
				(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"ora	%L2	;; iorhi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"ora	%L1	;; iorhi3\");
			}
			else {
				asm(\"lda	%L1	;; iorhi3\");
				if (!md_is_low_zero(operands[2])) {
					asm(\"ora	%L2\");
				}
			}
			asm(\"tax\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			if (!md_is_high_zero(operands[2])) {
				asm(\"ora	%H2\");
			}
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			if (md_is_low_zero(operands[2])) {
				asm(\"sta	%L0	;; iorhi3\");
			}
			else {
				asm(\"ora	%L2	;; iorhi3\");
				asm(\"sta	%L0\");
			}
			if (md_is_high_zero(operands[2])) {
				if (md_need_y(operands[0])) {
					asm(\"txa\");
					asm(\"ldy	#1\");
					asm(\"sta	%H0\");
				}
				else {
					asm(\"stx	%H0\");
				}
			}
			else {
				asm(\"txa\");
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"ora	%H2\");
				asm(\"sta	%H0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"ora	%L1	;; iorhi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"ora	%H1\");
			asm(\"sta	%H0\");
		}
		else if (	(rtx_equal_p(operands[0], operands[1])) &&
				(!md_need_y(operands[0]))
			) {
			if (!md_is_low_zero(operands[2])) {
				asm(\"lda	%L2	;; iorhi3\");
				asm(\"tsb	%L0\");
			}
			if (!md_is_high_zero(operands[2])) {
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H2\");
				if (	(md_need_y(operands[0])) &&
					(y != 1)
				   ) {
					asm(\"ldy	#1\");
				}
				asm(\"tsb	%H0\");
			}
		}
		else {
			asm(\"lda	%L1	;; iorhi3\");
			if (!md_is_low_zero(operands[2])) {
				asm(\"ora	%L2\");
			}
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H1\");
			if (!md_is_high_zero(operands[2])) {
				if (	(md_need_y(operands[2])) &&
					(y != 1)
				   ) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"ora	%H2\");
			}
			if (	(md_need_y(operands[0])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sta	%H0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "iorqisi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(ior:SI	(subreg:SI	(match_operand:QI 1 "md_gen_op" "g")
						0
				)
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (md_is_axy(operands[1])) {
			asm(\"ora	%L2	;; iorqisi3\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"ora	%L1	;; iorqisi3\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		else {
			asm(\"lda	%L1	;; iorqisi3\");
			asm(\"ora	%L2\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
		}
		if (md_need_y(operands[2])) {
			asm(\"ldy	#1\");
			y = 1;
		}
		asm(\"lda	%H2\");
		if (regs_same) {
			asm(\"pha\");
		}
		else {
			if (md_need_y(operands[0])) {
				if (y != 1) {
					asm(\"ldy	#1\");
				}
			}
			asm(\"sta	%H0\");
		}
		if (md_need_y(operands[2])) {
			asm(\"iny\");
			y = 2;
		}
		asm(\"lda	%B2\");
		if (regs_same) {
			if (md_need_y(operands[0])) {
				if (y != 2) {
					asm(\"ldy	#2\");
				}
				asm(\"sta	%B0\");
				asm(\"dey\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%B0\");
				asm(\"pla\")
				asm(\"sta	%H0\");
				asm(\"stx	%L0\");
			}
		}
		else {
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "iorhisi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(ior:SI	(subreg:SI	(match_operand:HI 1 "md_gen_op" "g")
						0
				)
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"ora	%L2	;; iorhisi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"ora	%L1	;; iorhisi3\");
			}
			else {
				asm(\"lda	%L1	;; iorhisi3\");
				asm(\"ora	%L2\");
			}
			asm(\"tax\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H1\");
			asm(\"ora	%H2\");
			asm(\"pha\");
			if (md_need_y(operands[2])) {
				asm(\"iny\");
				y = 2;
			}
			asm(\"lda	%B2\");
			if (md_need_y(operands[0])) {
				if (y != 2) {
					if (y == 1) {
						asm(\"iny\");
					}
					else {
						asm(\"ldy	#2\");
					}
				}
				asm(\"sta	%B0\");
				asm(\"dey\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%B0\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"stx	%L0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			asm(\"ora	%L2	;; iorhisi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"ora	%H2\");
			asm(\"sta	%H0\");
			asm(\"lda	%B2\");
			asm(\"sta	%B0\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"ora	%L1	;; iorhisi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"ora	%H1\");
			asm(\"sta	%H0\");
			asm(\"lda	%B2\");
			asm(\"sta	%B0\");
		}
		else {
			asm(\"lda	%L1	;; iorhisi3\");
			asm(\"ora	%L2\");
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"ora	%H2\");
			asm(\"sta	%H0\");
			asm(\"lda	%B2\");
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "iorsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(ior:SI	(match_operand:SI 1 "md_gen_op" "g")
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"ora	%L2	;; iorsi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"ora	%L1	;; iorsi3\");
			}
			else {
				asm(\"lda	%L1	;; iorsi3\");
				if (!md_is_low_zero(operands[2])) {
					asm(\"ora	%L2\");
				}
				asm(\"tax\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H1\");
				if (!md_is_high_zero(operands[2])) {
					if (md_need_y(operands[2])) {
						if (y != 1) {
							asm(\"ldy	#1\");
						}
					}
					asm(\"ora	%H2\");
				}
				asm(\"pha\");
				if (md_need_y(operands[1])) {
					asm(\"iny\");
					y = 2;
				}
				asm(\"lda	%B1\");
				if (!md_is_bank_zero(operands[2])) {
					if (md_need_y(operands[2])) {
						if (y != 2) {
							asm(\"iny\");
							y = 2;
						}
					}
					asm(\"ora	%B2\");
				}
				if (md_need_y(operands[0])) {
					if (y != 2) {
						asm(\"ldy	#2\");
					}
					asm(\"sta	%B0\");
					asm(\"dey\");
					asm(\"pla\");
					asm(\"sta	%H0\");
					asm(\"txa\");
					asm(\"sta	%L0\");
				}
				else {
					asm(\"sta	%B0\");
					asm(\"pla\");
					asm(\"sta	%H0\");
					asm(\"stx	%L0\");
				}
			}
		}
		else if (md_is_axy(operands[1])) {
			if (md_is_low_zero(operands[2])) {
				asm(\"sta	%L0	;; iorsi3\");
			}
			else {
				asm(\"ora	%L2	;; iorsi3\");
				asm(\"sta	%L0\");
			}
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			if (	(md_is_high_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"stx	%H0\");
			}
			else {
				asm(\"txa\");
				asm(\"ora	%H2\");
				asm(\"sta	%H0\");
			}
			if (	(md_is_bank_zero(operands[2])) &&
				(!md_need_y(operands[0]))
			   ) {
				asm(\"sty	%B0\");
			}
			else {
				if (	(md_need_y(operands[0])) ||
					(md_need_y(operands[2]))
				   ) {
					asm(\"iny\");
					asm(\"lda	%B1\");
				}
				else {
					asm(\"tya\");
				}
				asm(\"ora	%B2\");
				asm(\"sta	%B0\");
			}
		}
		else if (md_is_axy(operands[2])) {
			asm(\"ora	%L1	;; iorsi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"ora	%H1\");
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"iny\");
				asm(\"lda	%B2\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"ora	%B1\");
			asm(\"sta	%B0\");
		}
		else {
			asm(\"lda	%L1	;; iorsi3\");
			if (!md_is_low_zero(operands[2])) {
				asm(\"ora	%L2\");
			}
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			if (!md_is_high_zero(operands[2])) {
				asm(\"ora	%H2\");
			}
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"lda	%B1\");
			if (!md_is_bank_zero(operands[2])) {
				asm(\"ora	%B2\");
			}
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "xorqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(xor:QI	(match_operand:QI 1 "md_gen_op" "g")
				(match_operand:QI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"eor	%L2	;; xorqi3\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"eor	%L1	;; xorqi3\");
		}
		else {
			asm(\"lda	%L1	;; xorqi3\");
			asm(\"eor	%L2\");
		}
		asm(\"sta	%L0\");
		md_remember_axy(operands[0]);
		return \"\";
	}"
)

(define_insn "xorqihi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(xor:HI	(subreg:HI	(match_operand:QI 1 "md_gen_op" "g")
						0
				)
				(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"eor	%L2	;; xorqihi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"eor	%L1	;; xorqihi3\");
			}
			else {
				asm(\"lda	%L1	;; xorqihi3\");
				asm(\"eor	%L2\");
			}
			asm(\"tax\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			asm(\"eor	%L2	;; xorqihi3\");
			asm(\"sta	%L0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"eor	%L1	;; xorqihi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			asm(\"eor	#0\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
			}
			asm(\"sta	%H0\");
		}
		else {
			asm(\"lda	%L1	;; xorqihi3\");
			asm(\"eor	%L2\");
			asm(\"sta	%L0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "xorhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(xor:HI	(match_operand:HI 1 "md_gen_op" "g")
				(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"eor	%L2	;; xorhi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"eor	%L1	;; xorhi3\");
			}
			else {
				asm(\"lda	%L1	;; xorhi3\");
				asm(\"eor	%L2\");
			}
			asm(\"tax\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			asm(\"eor	%L2	;; xorhi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"eor	%L1	;; xorhi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H1\");
			asm(\"sta	%H0\");
		}
		else {
			asm(\"lda	%L1	;; xorhi3\");
			asm(\"eor	%L2\");
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "xorqisi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(xor:SI	(subreg:SI	(match_operand:QI 1 "md_gen_op" "g")
						0
				)
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"eor	%L2	;; xorqisi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"eor	%L1	;; xorqisi3\");
			}
			else {
				asm(\"lda	%L1	;; xorqisi3\");
				asm(\"eor	%L2\");
			}
			asm(\"tax\");
			asm(\"lda	#0\");
			if (md_need_y(operands[2])) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"pha\");
			asm(\"lda	#0\");
			if (md_need_y(operands[2])) {
				asm(\"iny\");
				y = 2;
			}
			asm(\"eor	%B2\");
			if (md_need_y(operands[0])) {
				if (y != 2) {
					asm(\"ldy	#2\");
				}
				asm(\"sta	%B0\");
				asm(\"dey\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%B0\");
				asm(\"pla\")
				asm(\"sta	%H0\");
				asm(\"stx	%L0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			asm(\"eor	%L2	;; xorqisi3\");
			asm(\"sta	%L0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"eor	%B2\");
			asm(\"sta	%B0\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"eor	%L1	;; xorqisi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			asm(\"eor	#0\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
			}
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"iny\");
				asm(\"lda	%B2\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"eor	#0\");
			asm(\"sta	%B0\");
		}
		else {
			asm(\"lda	%L1	;; xorqisi3\");
			asm(\"eor	%L2\");
			asm(\"sta	%L0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"eor	%B2\");
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "xorhisi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(xor:SI	(subreg:SI	(match_operand:HI 1 "md_gen_op" "g")
						0
				)
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"eor	%L2	;; xorhisi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"eor	%L1	;; xorhisi3\");
			}
			else {
				asm(\"lda	%L1	;; xorhisi3\");
				asm(\"eor	%L2\");
			}
			asm(\"tax\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H1\");
			asm(\"eor	%H2\");
			asm(\"pha\");
			asm(\"lda	#0\");
			if (md_need_y(operands[2])) {
				asm(\"iny\");
				y = 2;
			}
			asm(\"eor	%B2\");
			if (md_need_y(operands[0])) {
				if (y != 2) {
					if (y == 1) {
						asm(\"iny\");
					}
					else {
						asm(\"ldy	#2\");
					}
				}
				asm(\"sta	%B0\");
				asm(\"dey\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%B0\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"stx	%L0\");
			}
		}
		else if (md_is_axy(operands[1])) {
			asm(\"eor	%L2	;; xorhisi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"eor	%B2\");
			asm(\"sta	%B0\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"eor	%L1	;; xorhisi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			asm(\"eor	#0\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
			}
			asm(\"sta	%H0\");
			if (md_need_y(operands[0])) {
				asm(\"iny\");
				asm(\"lda	%B2\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"eor	#0\");
			asm(\"sta	%B0\");
		}
		else {
			asm(\"lda	%L1	;; xorhisi3\");
			asm(\"eor	%L2\");
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
			asm(\"lda	#0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"eor	%B2\");
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "xorsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(xor:SI	(match_operand:SI 1 "md_gen_op" "g")
				(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[0]) ||
						md_are_ops_same_reg(operands[2], operands[0])
					);
		int	y = 0;

		if (regs_same) {
			if (md_is_axy(operands[1])) {
				asm(\"eor	%L2	;; xorsi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"eor	%L1	;; xorsi3\");
			}
			else {
				asm(\"lda	%L1	;; xorsi3\");
				asm(\"eor	%L2\");
			}
			asm(\"tax\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"eor	%H2\");
			asm(\"pha\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
				y = 2;
			}
			asm(\"lda	%B1\");
			asm(\"eor	%B2\");
			if (md_need_y(operands[0])) {
				if (y != 2) {
					asm(\"ldy	#2\");
				}
				asm(\"sta	%B0\");
				asm(\"dey\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%B0\");
				asm(\"pla\");
				asm(\"sta	%H0\");
				asm(\"stx	%L0\");
			}
		}
		if (md_is_axy(operands[1])) {
			asm(\"eor	%L2	;; xorsi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
				asm(\"lda	%B1\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"eor	%B2\");
			asm(\"sta	%B0\");
		}
		else if (md_is_axy(operands[2])) {
			asm(\"eor	%L1	;; xorsi3\");
			asm(\"sta	%L0\");
			asm(\"txa\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"eor	%H1\");
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"iny\");
				asm(\"lda	%B2\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"eor	%B1\");
			asm(\"sta	%B0\");
		}
		else {
			asm(\"lda	%L1	;; xorsi3\");
			asm(\"eor	%L2\");
			asm(\"sta	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"eor	%H2\");
			asm(\"sta	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1])) ||
				(md_need_y(operands[2]))
			   ) {
				asm(\"iny\");
			}
			asm(\"lda	%B1\");
			asm(\"eor	%B2\");
			asm(\"sta	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "mulqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(mult:QI	(match_operand:QI 1 "md_gen_op" "g")
					(match_operand:QI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		rtx	dstreg = operands[0];
		rtx	op1reg = operands[1];
		rtx	op2 = operands[2];
		int	val;

		if (GET_CODE(op2) == CONST_INT) {
			val = INTVAL(op2);
			switch (val) {
			case 2:
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; mulqi3\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; mulqi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl	;; mulqi3\");
					}
					asm(\"sta	%L0\");
					md_remember_axy(operands[0]);
				}
				break;
			case 3:
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; mulqi3\");
					asm(\"asl\");
				}
				else {
					asm(\"asl	;; mulqi3\");
				}
				asm(\"clc\");
				asm(\"adc	%L1\");
				asm(\"sta	%L0\");
				md_remember_axy(operands[0]);
				break;
			case 4:
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; mulqi3\");
					asm(\"asl	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; mulqi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl	;; mulqi3\");
					}
					asm(\"asl\");
					asm(\"sta	%L0\");
					md_remember_axy(operands[0]);
				}
				break;
			case 8:
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; mulqi3\");
					asm(\"asl	%L0\");
					asm(\"asl	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; mulqi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl	;; mulqi3\");
					}
					asm(\"asl\");
					asm(\"asl\");
					asm(\"sta	%L0\");
					md_remember_axy(operands[0]);
				}
				break;
			default:
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; mulqi3\");
				}
				asm(\"ldy	#low %2\");
				asm(\"jsr	__mul_8_by_8\");
				asm(\"sta	%L0\");
				md_remember_axy(operands[0]);
				break;
			}
		}
		else {
			if (md_is_axy(operands[1])) {
				asm(\"ldy	%L2	;; mulqi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"ldy	%L1	;; mulqi3\");
			}
			else {
				asm(\"lda	%L1	;; mulqi3\");
				asm(\"ldy	%L2\");
			}
			asm(\"jsr	__mul_8_by_8\");
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		return \"\";
	}"
)

(define_insn "mulhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(mult:HI	(match_operand:HI 1 "md_gen_op" "g")
					(match_operand:HI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		rtx	dstreg = operands[0];
		rtx	op1reg = operands[1];
		rtx	op2 = operands[2];
		int	val;

		if (GET_CODE(op2) == CONST_INT) {
			val = INTVAL(op2);
			switch (val) {
			case 2:
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; mulhi3\");
					asm(\"rol	%H0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; mulhi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl	;; mulhi3\");
					}
					asm(\"sta	%L0\");
					if (!md_is_axy(operands[1])) {
						if (md_need_y(operands[1])) {
							asm(\"ldy	#1\");
						}
						asm(\"lda	%H1\");
						asm(\"rol\");
						if (	(!md_need_y(operands[1])) &&
							(md_need_y(operands[0]))
						   ) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
					}
					else {
						asm(\"txa\");
						asm(\"rol\");
						if (md_need_y(operands[0])) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
					}
					md_forget_axy();
				}
				break;
			case 3:
				if (!md_is_axy(operands[1])) {
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1	;; mulhi3\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"lda	%L1\");
					}
					else {
						asm(\"lda	%L1	;; mulhi3\");
						asm(\"ldx	%H1\");
					}
					asm(\"jsr	__mul_16_by_con_3\");
				}
				else {
					asm(\"jsr	__mul_16_by_con_3	;; mulhi3\");
				}
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"txa\");
					asm(\"ldy	#1\");
					asm(\"sta	%H0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					md_remember_axy(operands[0]);
				}
				break;
			default:
				if ((INTVAL(op2) & 0xFF00) == 0) {
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1	;; mulhi3\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"lda	%L1\");
						asm(\"tay\");
					}
					else {
						if (md_is_axy(operands[1])) {
							asm(\"tay		;; mulhi3\");
						}
						else {
							asm(\"ldy	%L1	;; mulhi3\");
						}
						asm(\"ldx	%H1\");
					}
					asm(\"lda	#low %2\");
					asm(\"jsr	__mul_8_by_16\");
				}
				else {
					if (md_is_axy(operands[1])) {
						asm(\"sta	t	;; mulhi3\");
						asm(\"stx	t+1\");
					}
					else {
						md_mv_r_t_16(operands[1], \"mulhi3\");
					}
					asm(\"lda	#low %2\");
					asm(\"ldx	#high %2\");
					asm(\"jsr	__mul_16_by_16\");
				}
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"txa\");
					asm(\"ldy	#1\");
					asm(\"sta	%H0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					md_remember_axy(operands[0]);
				}
				break;
			}
		}
		else {
			if (md_is_axy(operands[1])) {
				asm(\"sta	t	;; mulhi3\");
				asm(\"stx	t+1\");
				asm(\"lda	%L2\");
				asm(\"ldx	%H2\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"sta	t	;; mulhi3\");
				asm(\"stx	t+1\");
				asm(\"lda	%L1\");
				asm(\"ldx	%H1\");
			}
			else {
				md_mv_r_t_16(operands[1], \"mulhi3\");
				asm(\"lda	%L2\");
				asm(\"ldx	%H2\");
			}
			asm(\"jsr	__mul_16_by_16\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"ldy	#1\");
				asm(\"sta	%H0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

(define_insn "mulsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(mult:SI	(match_operand:SI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		rtx	dstreg = operands[0];
		rtx	op1reg = operands[1];
		rtx	op2 = operands[2];
		int	val;

		if (GET_CODE(op2) == CONST_INT) {
			val = INTVAL(op2);
			switch (val) {
			case 2:
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; mulsi3\");
					asm(\"rol	%H0\");
					asm(\"rol	%B0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; mulsi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl	;; mulsi3\");
					}
					asm(\"sta	%L0\");
					if (!md_is_axy(operands[1])) {
						if (md_need_y(operands[1])) {
							asm(\"ldy	#1\");
						}
						asm(\"lda	%H1\");
						asm(\"rol\");
						if (	(md_need_y(operands[0])) &&
							(!md_need_y(operands[1]))
						   ) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
					}
					else {
						asm(\"txa\");
						asm(\"rol\");
						if (md_need_y(operands[0])) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
					}
					if (!md_is_axy(operands[1])) {
						if (md_need_y(operands[1])) {
							asm(\"iny\");
						}
						asm(\"lda	%B1\");
						asm(\"rol\");
						if (	(md_need_y(operands[0])) &&
							(!md_need_y(operands[1]))
						   ) {
							asm(\"iny\");
						}
						asm(\"sta	%B0\");
					}
					else {
						if (md_need_y(operands[0])) {
							asm(\"ldy	%B1\");
						}
						else {
							asm(\"tya\");
						}
						asm(\"rol\");
						if (md_need_y(operands[0])) {
							asm(\"iny\");
						}
						asm(\"sta	%B0\");
					}
					md_forget_axy();
				}
				break;
			case 3:
				if (md_is_axy(operands[1])) {
					asm(\"jsr	__mul_24_by_con_3\	;; mulsi3\");
				}
				else {
					if (md_need_y(operands[1])) {
						asm(\"ldy	#2	;; mulsi3\");
						asm(\"lda	%B1\");
						asm(\"pha\");
						asm(\"dey\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"ply\");
						asm(\"lda	%L1\");
					}
					else {
						asm(\"lda	%L1	;; mulsi3\");
						asm(\"ldx	%H1\");
						asm(\"ldy	%B1\");
					}
					asm(\"jsr	__mul_24_by_con_3\");
				}
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"phy\");
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					asm(\"pla\");
					asm(\"iny\");
					asm(\"sta	%B0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					asm(\"sty	%B0\");
					md_remember_axy(operands[0]);
				}
				break;
			default:
				if (md_is_axy(operands[1])) {
					asm(\"sta	t	;; mulsi3\");
					asm(\"stx	t+1\");
					asm(\"sty	t+2\");
					asm(\"lda	#low %2\");
					asm(\"ldx	#high %2\");
					asm(\"ldy	#bank %2\");
				}
				else {
					md_mv_r_t_24(operands[1], \"mulsi3\");
					asm(\"lda	#low %2\");
					asm(\"ldx	#high %2\");
					asm(\"ldy	#bank %2\");
				}
				asm(\"jsr	__mul_24_by_24\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"phy\");
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					asm(\"pla\");
					asm(\"iny\");
					asm(\"sta	%B0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					asm(\"sty	%B0\");
					md_remember_axy(operands[0]);
				}
				break;
			}
		}
		else {
			if (md_is_axy(operands[1])) {
				asm(\"sta	t	;; mulsi3\");
				asm(\"stx	t+1\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#1\");
					asm(\"lda	%H2\");
					asm(\"tax\");
					asm(\"lda	%L2\");
				}
				else {
					asm(\"lda	%L2\");
					asm(\"ldx	%H2\");
				}
			}
			else if (md_is_axy(operands[2])) {
				asm(\"sta	t	;; mulsi3\");
				asm(\"stx	t+1\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					asm(\"lda	%H1\");
					asm(\"tax\");
					asm(\"lda	%L1\");
				}
				else {
					asm(\"lda	%L1\");
					asm(\"ldx	%H1\");
				}
			}
			else {
				md_mv_r_t_24(operands[1], \"mulsi3\");
				if (md_need_y(operands[2])) {
					asm(\"ldy	#2\");
					asm(\"lda	%B2\");
					asm(\"pha\");
					asm(\"dey\");
					asm(\"lda	%H2\");
					asm(\"tax\");
					asm(\"ply\");
					asm(\"lda	%L2\");
				}
				else {
					asm(\"lda	%L2\");
					asm(\"ldx	%H2\");
					asm(\"ldy	%B2\");
				}
			}
			asm(\"jsr	__mul_24_by_24\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"phy\");
				asm(\"ldy	#1\");
				asm(\"txa\");
				asm(\"sta	%H0\");
				asm(\"pla\");
				asm(\"iny\");
				asm(\"sta	%B0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				asm(\"sty	%B0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Shifts:

(define_insn "ashlqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(ashift:QI	(match_operand:QI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; ashlqi3\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; ashlqi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl		;; ashlqi3\");
					}
					asm(\"sta	%L0\");
					md_remember_axy(operands[0]);
				}
			}
			else if (INTVAL(operands[2]) == 2) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; ashlqi3\");
					asm(\"asl	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; ashlqi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl		;; ashlqi3\");
					}
					asm(\"asl\");
					asm(\"sta	%L0\");
					md_remember_axy(operands[0]);
				}
			}
			else if (INTVAL(operands[2]) == 3) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; ashlqi3\");
					asm(\"asl	%L0\");
					asm(\"asl	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; ashlqi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl		;; ashlqi3\");
					}
					asm(\"asl\");
					asm(\"asl\");
					asm(\"sta	%L0\");
					md_remember_axy(operands[0]);
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; ashlqi3\");
					asm(\"ldy	#%2\");
				}
				else {
					asm(\"ldy	#%2	;; ashlqi3\");
				}
				asm(\"jsr	__lsl8\");
				asm(\"sta	%L0\");
				md_remember_axy(operands[0]);
			}
		}
		else {
			if (md_is_axy(operands[1])) {
				asm(\"ldy	%L2	;; ashlqi3\");
			}
			else if (md_is_axy(operands[2])) {
				asm(\"ldy	%L1	;; ashlqi3\");
			}
			else {
				asm(\"lda	%L1	;; ashlqi3\");
				asm(\"ldy	%L2\");
			}
			asm(\"jsr	__lsl8\");
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		return \"\";
	}"
)

(define_insn "ashlhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(ashift:HI	(match_operand:HI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; ashlhi3\");
					asm(\"rol	%H0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; ashlhi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl		;; ashlhi3\");
					}
					asm(\"sta	%L0\");
					if (md_is_axy(operands[1])) {
						asm(\"txa\");
						asm(\"rol\");
						if (md_need_y(operands[0])) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
					}
					else {
						if (md_need_y(operands[1])) {
							asm(\"ldy	#1\");
						}
						asm(\"lda	%H1\");
						asm(\"rol\");
						if (	(md_need_y(operands[0])) &&
							(!md_need_y(operands[1]))
						   ) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
					}
					md_forget_axy();
				}
				return \"\";
			}
			if (INTVAL(operands[2]) == 2) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; ashlhi3\");
					asm(\"rol	%H0\");
					asm(\"asl	%L0\");
					asm(\"rol	%H0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
					return \"\";
				}
			}
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1	;; ashlhi3\");
					asm(\"lda	%H1\");
					asm(\"tax\");
					asm(\"lda	%L1\");
				}
				else {
					asm(\"lda	%L1	;; ashlhi3\");
					asm(\"ldx	%H1\");
				}
				asm(\"ldy	#%2\");
			}
			else {
				asm(\"ldy	#%2	;; ashlhi3\");
			}
			asm(\"jsr	__lsl16\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"txa\");
				asm(\"sta	%H0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				md_remember_axy(operands[0]);
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1	;; ashlhi3\");
					asm(\"lda	%H1\");
					asm(\"tax\");
					asm(\"lda	%L1\");
				}
				else {
					asm(\"lda	%L1	;; ashlhi3\");
					asm(\"ldx	%H1\");
				}
				if (md_need_y(operands[2])) {
					asm(\"pha\");
					asm(\"lda	%L2\");
					asm(\"tay\");
					asm(\"pla\");
				}
				else {
					asm(\"ldy	%L2\");
				}
			}
			else {
				if (md_need_y(operands[2])) {
					asm(\"pha\");
					asm(\"lda	%L2\");
					asm(\"tay\");
					asm(\"pla\");
				}
				else {
					asm(\"ldy	%L2	;; ashlhi3\");
				}
			}
			asm(\"jsr	__lsl16\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"txa\");
				asm(\"sta	%H0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

(define_insn "ashlsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(ashift:SI	(match_operand:SI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"asl	%L0	;; ashlsi3\");
					asm(\"rol	%H0\");
					asm(\"rol	%B0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; ashlsi3\");
						asm(\"asl\");
					}
					else {
						asm(\"asl		;; ashlsi3\");
					}
					asm(\"sta	%L0\");
					if (md_is_axy(operands[1])) {
						asm(\"txa\");
						asm(\"rol\");
						if (md_need_y(operands[0])) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
					}
					else {
						if (md_need_y(operands[1])) {
							asm(\"ldy	#1\");
						}
						asm(\"lda	%H1\");
						asm(\"rol\");
						if (	(md_need_y(operands[0])) &&
							(!md_need_y(operands[1]))
						   ) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
					}
					if (md_need_y(operands[1])) {
						asm(\"iny\");
					}
					asm(\"lda	%B1\");
					asm(\"rol\");
					if (	(md_need_y(operands[0])) &&
						(!md_need_y(operands[1]))
					   ) {
						asm(\"iny\");
					}
					asm(\"sta	%B0\");
					md_forget_axy();
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					if (md_need_y(operands[1])) {
						asm(\"lda	#%2	;; ashlsi3\");
						asm(\"sta	t\");
						asm(\"ldy	#2\");
						asm(\"lda	%B1\");
						asm(\"pha\");
						asm(\"dey\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"ply\");
					}
					else {
						asm(\"lda	%L1	;; ashlsi3\");
						asm(\"ldx	%H1\");
						asm(\"ldy	#%2\");
						asm(\"sty	t\");
						asm(\"ldy	%B1\");
					}
				}
				else {
					asm(\"lda	#%2	;; ashlsi3\");
					asm(\"sta	t\");
					asm(\"lda	%L1\");
				}
				asm(\"jsr	__lsl24\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"phy\");
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					asm(\"pla\");
					asm(\"iny\");
					asm(\"sta	%B0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					asm(\"sty	%B0\");
					md_remember_axy(operands[0]);
				}
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"lda	%L2	;; ashlsi3\");
					asm(\"sta	t\");
					asm(\"ldy	#2\");
					asm(\"lda	%B1\");
					asm(\"pha\");
					asm(\"dey\");
					asm(\"lda	%H1\");
					asm(\"tax\");
					asm(\"ply\");
				}
				else {
					asm(\"lda	%L1	;; ashlsi3\");
					asm(\"ldx	%H1\");
					asm(\"ldy	%L2\");
					asm(\"sty	t\");
					asm(\"ldy	%B1\");
				}
			}
			else {
				asm(\"lda	%L2	;; ashlsi3\");
				asm(\"sta	t\");
				asm(\"lda	%L1\");
			}
			asm(\"jsr	__lsl24\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"phy\");
				asm(\"ldy	#1\");
				asm(\"txa\");
				asm(\"sta	%H0\");
				asm(\"pla\");
				asm(\"iny\");
				asm(\"sta	%B0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				asm(\"sty	%B0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

(define_insn "lshrqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(lshiftrt:QI	(match_operand:QI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"lsr	%L0	;; lshrqi3\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; lshrqi3\");
						asm(\"lsr\");
					}
					else {
						asm(\"lsr		;; lshrqi3\");
					}
					asm(\"sta	%L0\");
				}
			}
			else if (INTVAL(operands[2]) == 2) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"lsr	%L0	;; lshrqi3\");
					asm(\"lsr	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; lshrqi3\");
						asm(\"lsr\");
					}
					else {
						asm(\"lsr		;; lshrqi3\");
					}
					asm(\"lsr\");
					asm(\"sta	%L0\");
				}
			}
			else if (INTVAL(operands[2]) == 3) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"lsr	%L0	;; lshrqi3\");
					asm(\"lsr	%L0\");
					asm(\"lsr	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; lshrqi3\");
						asm(\"lsr\");
					}
					else {
						asm(\"lsr		;; lshrqi3\");
					}
					asm(\"lsr\");
					asm(\"lsr\");
					asm(\"sta	%L0\");
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; lshrqi3\");
					asm(\"ldy	#low %2\");
				}
				else {
					asm(\"ldy	#low %2	;; lshrqi3\");
				}
				asm(\"jsr	__lsr8\");
				asm(\"sta	%L0\");
				md_remember_axy(operands[0]);
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; lshrqi3\");
				asm(\"ldy	%L2\");
			}
			else {
				asm(\"ldy	%L2	;; lshrqi3\");
			}
			asm(\"jsr	__lsr8\");
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		return \"\";
	}"
)

(define_insn "lshrhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(lshiftrt:HI	(match_operand:HI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"lsr	%H0	;; lshrhi3\");
					asm(\"ror	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%H1	;; lshrhi3\");
					}
					else {
						asm(\"txa		;; lshrhi3\");
					}
					asm(\"lsr\");
					if (md_need_y(operands[0])) {
						asm(\"ldy	#1\");
					}
					asm(\"sta	%H0\");
					asm(\"lda	%L1\");
					asm(\"ror\");
					asm(\"sta	%L0\");
					md_forget_axy();
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1	;; lshrhi3\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"lda	%L1\");
					}
					else {
						asm(\"lda	%L1	;; lshrhi3\");
						asm(\"ldx	%H1\");
					}
					asm(\"ldy	#%2\");
				}
				else {
					asm(\"ldy	#%2	;; lshrhi3\");
				}
				asm(\"jsr	__lsr16\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					md_remember_axy(operands[0]);
				}
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1	;; lshrhi3\");
					asm(\"lda	%H1\");
					asm(\"tax\");
					asm(\"lda	%L1\");
				}
				else {
					asm(\"lda	%L1	;; lshrhi3\");
					asm(\"ldx	%H1\");
				}
				if (md_need_y(operands[2])) {
					asm(\"pha\");
					asm(\"lda	%L2\");
					asm(\"tay\");
					asm(\"pla\");
				}
				else {
					asm(\"ldy	%L2\");
				}
			}
			else {
				if (md_need_y(operands[2])) {
					asm(\"pha\");
					asm(\"lda	%L2\");
					asm(\"tay\");
					asm(\"pla\");
				}
				else {
					asm(\"ldy	%L2	;; lshrhi3\");
				}
			}
			asm(\"jsr	__lsr16\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"txa\");
				asm(\"sta	%H0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

(define_insn "lshrsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(lshiftrt:SI	(match_operand:SI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"lsr	%B0	;; lshrsi3\");
					asm(\"ror	%H0\");
					asm(\"ror	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						if (md_need_y(operands[1])) {
							asm(\"ldy	#2	;; lshrsi3\");
							asm(\"lda	%B1\");
						}
						else {
							asm(\"lda	%B1	;; lshrsi3\");
						}
					}
					else {
						asm(\"tya		;; lshrsi3\");
					}
					asm(\"lsr\");
					if (	(md_need_y(operands[0])) &&
						(!md_need_y(operands[1]))
					   ) {
						asm(\"ldy	#2\");
					}
					asm(\"sta	%B0\");
					if (md_is_axy(operands[1])) {
						asm(\"txa\");
					}
					else {
						if (md_need_y(operands[1])) {
							asm(\"dey\");
						}
						asm(\"lda	%H1\");
					}
					asm(\"ror\");
					if (	(md_need_y(operands[0])) &&
						(!md_need_y(operands[1]))
					   ) {
						asm(\"dey\");
					}
					asm(\"sta	%H0\");
					asm(\"lda	%L1\");
					asm(\"ror\");
					asm(\"sta	%L0\");
					md_forget_axy();
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					if (md_need_y(operands[1])) {
						asm(\"lda	#%2	;; lshrsi3\");
						asm(\"sta	t\");
						asm(\"ldy	#2\");
						asm(\"lda	%B1\");
						asm(\"pha\");
						asm(\"dey\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"ply\");
					}
					else {
						asm(\"lda	%L1	;; lshrsi3\");
						asm(\"ldx	%H1\");
						asm(\"ldy	#%2\");
						asm(\"sty	t\");
						asm(\"ldy	%B1\");
					}
				}
				else {
					asm(\"lda	#%2	;; lshrsi3\");
					asm(\"sta	t\");
					asm(\"lda	%L1\");
				}
				asm(\"jsr	__lsr24\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"phy\");
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					asm(\"pla\");
					asm(\"iny\");
					asm(\"sta	%B0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					asm(\"sty	%B0\");
					md_remember_axy(operands[0]);
				}
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"lda	%L2	;; lshrsi3\");
					asm(\"sta	t\");
					asm(\"ldy	#2\");
					asm(\"lda	%B1\");
					asm(\"pha\");
					asm(\"dey\");
					asm(\"lda	%H1\");
					asm(\"tax\");
					asm(\"ply\");
				}
				else {
					asm(\"lda	%L1	;; lshrsi3\");
					asm(\"ldx	%H1\");
					asm(\"ldy	%L2\");
					asm(\"sty	t\");
					asm(\"ldy	%B1\");
				}
			}
			else {
				asm(\"lda	%L2	;; lshrsi3\");
				asm(\"sta	t\");
				asm(\"lda	%L1\");
			}
			asm(\"jsr	__lsr24\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"phy\");
				asm(\"ldy	#1\");
				asm(\"txa\");
				asm(\"sta	%H0\");
				asm(\"pla\");
				asm(\"iny\");
				asm(\"sta	%B0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				asm(\"sty	%B0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

(define_insn "ashrqi3"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(ashiftrt:QI	(match_operand:QI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (TARGET_DOASR) {
			if (GET_CODE(operands[2]) == CONST_INT) {
				if (INTVAL(operands[2]) == 1) {
					if (	(rtx_equal_p(operands[0], operands[1])) &&
						(!md_need_y(operands[0]))
					   ) {
						if (!md_is_axy(operands[0])) {
							asm(\"lda	%L0	;; ashrqi3\");
							asm(\"cmp	#$80\");
						}
						else {
							asm(\"cmp	#$80	;; ashrqi3\");
						}
						asm(\"ror	%L0\");
						if (md_is_axy(operands[0])) {
							md_forget_axy();
						}
					}
					else {
						if (!md_is_axy(operands[1])) {
							asm(\"lda	%L1	;; ashrqi3\");
							asm(\"cmp	#$80\");
							asm(\"ror\");
						}
						else {
							asm(\"cmp	#$80	;; ashrqi3\");
							asm(\"ror\");
						}
						asm(\"sta	%L0\");
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; ashrqi3\");
						asm(\"ldy	#low %2\");
					}
					else {
						asm(\"ldy	#low %2	;; ashrqi3\");
					}
					asm(\"jsr	__asr8\");
					asm(\"sta	%L0\");
					md_remember_axy(operands[0]);
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; ashrqi3\");
					asm(\"ldy	%L2\");
				}
				else {
					asm(\"ldy	%L2	;; ashrqi3\");
				}
				asm(\"jsr	__asr8\");
				asm(\"sta	%L0\");
				md_remember_axy(operands[0]);
			}
			return \"\";
		}

		md_output_warning(\"unsigned right shift\");
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"lsr	%L0	;; ashrqi3\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%L1	;; ashrqi3\");
						asm(\"lsr\");
					}
					else {
						asm(\"lsr		;; ashrqi3\");
					}
					asm(\"sta	%L0\");
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					asm(\"lda	%L1	;; ashrqi3\");
					asm(\"ldy	#low %2\");
				}
				else {
					asm(\"ldy	#low %2	;; ashrqi3\");
				}
				asm(\"jsr	__lsr8\");
				asm(\"sta	%L0\");
				md_remember_axy(operands[0]);
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; ashrqi3\");
				asm(\"ldy	%L2\");
			}
			else {
				asm(\"ldy	%L2	;; ashrqi3\");
			}
			asm(\"jsr	__lsr8\");
			asm(\"sta	%L0\");
			md_remember_axy(operands[0]);
		}
		return \"\";
	}"
)

(define_insn "ashrhi3"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(ashiftrt:HI	(match_operand:HI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (TARGET_DOASR) {
			if (GET_CODE(operands[2]) == CONST_INT) {
				if (INTVAL(operands[2]) == 1) {
					if (	(rtx_equal_p(operands[0], operands[1])) &&
						(!md_need_y(operands[0]))
					   ) {
						if (!md_is_axy(operands[0])) {
							asm(\"lda	%H0	;; ashrhi3\");
						}
						else {
							asm(\"txa	;; ashrhi3\");
						}
						asm(\"cmp	#$80\");
						asm(\"ror	%H0\");
						asm(\"ror	%L0\");
						if (md_is_axy(operands[0])) {
							md_forget_axy();
						}
					}
					else {
						if (!md_is_axy(operands[1])) {
							asm(\"lda	%H1	;; ashrhi3\");
						}
						else {
							asm(\"txa		;; ashrhi3\");
						}
						asm(\"cmp	#$80\");
						asm(\"ror\");
						if (md_need_y(operands[0])) {
							asm(\"ldy	#1\");
						}
						asm(\"sta	%H0\");
						asm(\"lda	%L1\");
						asm(\"ror\");
						asm(\"sta	%L0\");
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						if (md_need_y(operands[1])) {
							asm(\"ldy	#1	;; ashrhi3\");
							asm(\"lda	%H1\");
							asm(\"tax\");
							asm(\"lda	%L1\");
						}
						else {
							asm(\"lda	%L1	;; ashrhi3\");
							asm(\"ldx	%H1\");
						}
						asm(\"ldy	#%2\");
					}
					else {
						asm(\"ldy	#%2	;; ashrhi3\");
					}
					asm(\"jsr	__asr16\");
					asm(\"sta	%L0\");
					if (md_need_y(operands[0])) {
						asm(\"ldy	#1\");
						asm(\"txa\");
						asm(\"sta	%H0\");
						md_forget_axy();
					}
					else {
						asm(\"stx	%H0\");
						md_remember_axy(operands[0]);
					}
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1	;; ashrhi3\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"lda	%L1\");
					}
					else {
						asm(\"lda	%L1	;; ashrhi3\");
						asm(\"ldx	%H1\");
					}
					if (md_need_y(operands[2])) {
						asm(\"pha\");
						asm(\"lda	%L2\");
						asm(\"tay\");
						asm(\"pla\");
					}
					else {
						asm(\"ldy	%L2\");
					}
				}
				else {
					if (md_need_y(operands[2])) {
						asm(\"pha\");
						asm(\"lda	%L2\");
						asm(\"tay\");
						asm(\"pla\");
					}
					else {
						asm(\"ldy	%L2	;; ashrhi3\");
					}
				}
				asm(\"jsr	__asr16\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					md_remember_axy(operands[0]);
				}
			}
			return \"\";
		}

		md_output_warning(\"unsigned right shift\");
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"lsr	%H0	;; ashrhi3\");
					asm(\"ror	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						asm(\"lda	%H1	;; ashrhi3\");
					}
					else {
						asm(\"txa		;; ashrhi3\");
					}
					asm(\"lsr\");
					if (md_need_y(operands[0])) {
						asm(\"ldy	#1\");
					}
					asm(\"sta	%H0\");
					asm(\"lda	%L1\");
					asm(\"ror\");
					asm(\"sta	%L0\");
					md_forget_axy();
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					if (md_need_y(operands[1])) {
						asm(\"ldy	#1	;; ashrhi3\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"lda	%L1\");
					}
					else {
						asm(\"lda	%L1	;; ashrhi3\");
						asm(\"ldx	%H1\");
					}
					asm(\"ldy	#%2\");
				}
				else {
					asm(\"ldy	#%2	;; ashrhi3\");
				}
				asm(\"jsr	__lsr16\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					md_remember_axy(operands[0]);
				}
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1	;; ashrhi3\");
					asm(\"lda	%H1\");
					asm(\"tax\");
					asm(\"lda	%L1\");
				}
				else {
					asm(\"lda	%L1	;; ashrhi3\");
					asm(\"ldx	%H1\");
				}
				if (md_need_y(operands[2])) {
					asm(\"pha\");
					asm(\"lda	%L2\");
					asm(\"tay\");
					asm(\"pla\");
				}
				else {
					asm(\"ldy	%L2\");
				}
			}
			else {
				if (md_need_y(operands[2])) {
					asm(\"pha\");
					asm(\"lda	%L2\");
					asm(\"tay\");
					asm(\"pla\");
				}
				else {
					asm(\"ldy	%L2	;; ashrhi3\");
				}
			}
			asm(\"jsr	__lsr16\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"txa\");
				asm(\"sta	%H0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

(define_insn "ashrsi3"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(ashiftrt:SI	(match_operand:SI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		if (TARGET_DOASR) {
			if (GET_CODE(operands[2]) == CONST_INT) {
				if (INTVAL(operands[2]) == 1) {
					if (	(rtx_equal_p(operands[0], operands[1])) &&
						(!md_need_y(operands[0]))
					   ) {
						if (!md_is_axy(operands[0])) {
							asm(\"lda	%B0	;; ashrsi3\");
						}
						else {
							asm(\"tya	;; ashrsi3\");
						}
						asm(\"cmp	#$80\");
						asm(\"ror	%B0\");
						asm(\"ror	%H0\");
						asm(\"ror	%L0\");
						if (md_is_axy(operands[0])) {
							md_forget_axy();
						}
					}
					else {
						if (!md_is_axy(operands[1])) {
							if (md_need_y(operands[1])) {
								asm(\"ldy	#2	;; ashrsi3\");
								asm(\"lda	%B1\");
							}
							else {
								asm(\"lda	%B1	;; ashrsi3\");
							}
						}
						else {
							asm(\"tya		;; ashrsi3\");
						}
						asm(\"cmp	#$80\");
						asm(\"ror\");
						if (	(md_need_y(operands[0])) &&
							(!md_need_y(operands[1]))
						   ) {
							asm(\"ldy	#2\");
						}
						asm(\"sta	%B0\");
						if (md_is_axy(operands[1])) {
							asm(\"txa\");
						}
						else {
							if (md_need_y(operands[1])) {
								asm(\"dey\");
							}
							asm(\"lda	%H1\");
						}
						asm(\"ror\");
						if (	(md_need_y(operands[0])) &&
							(!md_need_y(operands[1]))
						   ) {
							asm(\"dey\");
						}
						asm(\"sta	%H0\");
						asm(\"lda	%L1\");
						asm(\"ror\");
						asm(\"sta	%L0\");
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						if (md_need_y(operands[1])) {
							asm(\"lda	#%2	;; ashrsi3\");
							asm(\"sta	t\");
							asm(\"ldy	#2\");
							asm(\"lda	%B1\");
							asm(\"pha\");
							asm(\"dey\");
							asm(\"lda	%H1\");
							asm(\"tax\");
							asm(\"ply\");
						}
						else {
							asm(\"lda	%L1	;; ashrsi3\");
							asm(\"ldx	%H1\");
							asm(\"ldy	#%2\");
							asm(\"sty	t\");
							asm(\"ldy	%B1\");
						}
					}
					else {
						asm(\"lda	#%2	;; ashrsi3\");
						asm(\"sta	t\");
						asm(\"lda	%L1\");
					}
					asm(\"jsr	__asr24\");
					asm(\"sta	%L0\");
					if (md_need_y(operands[0])) {
						asm(\"phy\");
						asm(\"ldy	#1\");
						asm(\"txa\");
						asm(\"sta	%H0\");
						asm(\"pla\");
						asm(\"iny\");
						asm(\"sta	%B0\");
						md_forget_axy();
					}
					else {
						asm(\"stx	%H0\");
						asm(\"sty	%B0\");
						md_remember_axy(operands[0]);
					}
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					if (md_need_y(operands[1])) {
						asm(\"lda	%L2	;; ashrsi3\");
						asm(\"sta	t\");
						asm(\"ldy	#2\");
						asm(\"lda	%B1\");
						asm(\"pha\");
						asm(\"dey\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"ply\");
					}
					else {
						asm(\"lda	%L1	;; ashrsi3\");
						asm(\"ldx	%H1\");
						asm(\"ldy	%L2\");
						asm(\"sty	t\");
						asm(\"ldy	%B1\");
					}
				}
				else {
					asm(\"lda	%L2	;; ashrsi3\");
					asm(\"sta	t\");
					asm(\"lda	%L1\");
				}
				asm(\"jsr	__asr24\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"phy\");
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					asm(\"pla\");
					asm(\"iny\");
					asm(\"sta	%B0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					asm(\"sty	%B0\");
					md_remember_axy(operands[0]);
				}
			}
			return \"\";
		}

		md_output_warning(\"unsigned right shift\");
		if (GET_CODE(operands[2]) == CONST_INT) {
			if (INTVAL(operands[2]) == 1) {
				if (	(rtx_equal_p(operands[0], operands[1])) &&
					(!md_need_y(operands[0]))
				   ) {
					asm(\"lsr	%B0	;; ashrsi3\");
					asm(\"ror	%H0\");
					asm(\"ror	%L0\");
					if (md_is_axy(operands[0])) {
						md_forget_axy();
					}
				}
				else {
					if (!md_is_axy(operands[1])) {
						if (md_need_y(operands[1])) {
							asm(\"ldy	#2	;; ashrsi3\");
							asm(\"lda	%B1\");
						}
						else {
							asm(\"lda	%B1	;; ashrsi3\");
						}
					}
					else {
						asm(\"tya		;; ashrsi3\");
					}
					asm(\"lsr\");
					if (	(md_need_y(operands[0])) &&
						(!md_need_y(operands[1]))
					   ) {
						asm(\"ldy	#2\");
					}
					asm(\"sta	%B0\");
					if (md_is_axy(operands[1])) {
						asm(\"txa\");
					}
					else {
						if (md_need_y(operands[1])) {
							asm(\"dey\");
						}
						asm(\"lda	%H1\");
					}
					asm(\"ror\");
					if (	(md_need_y(operands[0])) &&
						(!md_need_y(operands[1]))
					   ) {
						asm(\"dey\");
					}
					asm(\"sta	%H0\");
					asm(\"lda	%L1\");
					asm(\"ror\");
					asm(\"sta	%L0\");
					md_forget_axy();
				}
			}
			else {
				if (!md_is_axy(operands[1])) {
					if (md_need_y(operands[1])) {
						asm(\"lda	#%2	;; ashrsi3\");
						asm(\"sta	t\");
						asm(\"ldy	#2\");
						asm(\"lda	%B1\");
						asm(\"pha\");
						asm(\"dey\");
						asm(\"lda	%H1\");
						asm(\"tax\");
						asm(\"ply\");
					}
					else {
						asm(\"lda	%L1	;; ashrsi3\");
						asm(\"ldx	%H1\");
						asm(\"ldy	#%2\");
						asm(\"sty	t\");
						asm(\"ldy	%B1\");
					}
				}
				else {
					asm(\"lda	#%2	;; ashrsi3\");
					asm(\"sta	t\");
					asm(\"lda	%L1\");
				}
				asm(\"jsr	__lsr24\");
				asm(\"sta	%L0\");
				if (md_need_y(operands[0])) {
					asm(\"phy\");
					asm(\"ldy	#1\");
					asm(\"txa\");
					asm(\"sta	%H0\");
					asm(\"pla\");
					asm(\"iny\");
					asm(\"sta	%B0\");
					md_forget_axy();
				}
				else {
					asm(\"stx	%H0\");
					asm(\"sty	%B0\");
					md_remember_axy(operands[0]);
				}
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"lda	%L2	;; ashrsi3\");
					asm(\"sta	t\");
					asm(\"ldy	#2\");
					asm(\"lda	%B1\");
					asm(\"pha\");
					asm(\"dey\");
					asm(\"lda	%H1\");
					asm(\"tax\");
					asm(\"ply\");
				}
				else {
					asm(\"lda	%L1	;; ashrsi3\");
					asm(\"ldx	%H1\");
					asm(\"ldy	%L2\");
					asm(\"sty	t\");
					asm(\"ldy	%B1\");
				}
			}
			else {
				asm(\"lda	%L2	;; ashrsi3\");
				asm(\"sta	t\");
				asm(\"lda	%L1\");
			}
			asm(\"jsr	__lsr24\");
			asm(\"sta	%L0\");
			if (md_need_y(operands[0])) {
				asm(\"phy\");
				asm(\"ldy	#1\");
				asm(\"txa\");
				asm(\"sta	%H0\");
				asm(\"pla\");
				asm(\"iny\");
				asm(\"sta	%B0\");
				md_forget_axy();
			}
			else {
				asm(\"stx	%H0\");
				asm(\"sty	%B0\");
				md_remember_axy(operands[0]);
			}
		}
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Misc:

(define_insn "negqi2"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(neg:QI (match_operand:QI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; negqi2\");
			asm(\"eor	#$FF\");
		}
		else {
			asm(\"eor	#$FF	;; negqi2\");
		}
		asm(\"ina\");
		asm(\"sta	%L0\");
		md_remember_axy(operands[0]);
		return \"\";
	}"
)

(define_insn "neghi2"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(neg:HI (match_operand:HI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		asm(\"sec		;; neghi2\");
		asm(\"lda	#0\");
		asm(\"sbc	%L1\");
		asm(\"sta	%L0\");
		asm(\"lda	#0\");
		if (	(md_need_y(operands[1])) ||
			(md_need_y(operands[0]))
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H1\");
		asm(\"sta	%H0\");
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "negsi2"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(neg:SI (match_operand:SI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		asm(\"sec		;; negsi2\");
		asm(\"lda	#0\");
		asm(\"sbc	%L1\");
		asm(\"sta	%L0\");
		asm(\"lda	#0\");
		if (	(md_need_y(operands[1])) ||
			(md_need_y(operands[0]))
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H1\");
		asm(\"sta	%H0\");
		asm(\"lda	#0\");
		if (	(md_need_y(operands[1])) ||
			(md_need_y(operands[0]))
		   ) {
			asm(\"iny\");
		}
		asm(\"sbc	%B1\");
		asm(\"sta	%B0\");
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "one_cmplqi2"
	[	(set	(match_operand:QI 0 "md_gen_op" "=g")
			(not:QI (match_operand:QI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; one_cmplqi2\");
			asm(\"eor	#$FF\");
		}
		else {
			asm(\"eor	#$FF	;; one_cmplqi2\");
		}
		asm(\"sta	%L0\");
		md_remember_axy(operands[0]);
		return \"\";
	}"
)

(define_insn "one_cmplhi2"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(not:HI (match_operand:HI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; one_cmplhi2\");
			asm(\"eor	#$FF\");
		}
		else {
			asm(\"eor	#$FF	;; one_cmplhi2\");
		}
		asm(\"sta	%L0\");
		if (	(md_need_y(operands[1])) ||
			(md_need_y(operands[0]))
		   ) {
			asm(\"ldy	#1\");
		}
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%H1\");
		}
		else {
			asm(\"txa\");
		}
		asm(\"eor	#$FF\");
		asm(\"sta	%H0\");
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "one_cmplsi2"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(not:SI (match_operand:SI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; one_cmplsi2\");
			asm(\"eor	#$FF\");
		}
		else {
			asm(\"eor	#$FF	;; one_cmplsi2\");
		}
		asm(\"sta	%L0\");
		if (	(md_need_y(operands[1])) ||
			(md_need_y(operands[0]))
		   ) {
			asm(\"ldy	#1\");
		}
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%H1\");
		}
		else {
			asm(\"txa\");
		}
		asm(\"eor	#$FF\");
		asm(\"sta	%H0\");
		if (	(md_need_y(operands[1])) ||
			(md_need_y(operands[0]))
		   ) {
			asm(\"iny\");
			asm(\"lda	%B1\");
		}
		else if (!md_is_axy(operands[1])) {
			asm(\"lda	%B1\");
		}
		else {
			asm(\"tya\");
		}
		asm(\"eor	#$FF\");
		asm(\"sta	%B0\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Compares:

(define_insn "cmpqi"
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		asm(\"cmp8	%L0,%L1	;; cmpqi\");
		return \"\";
	}"
)

(define_insn "cmphi"
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		asm(\"cmp16	%L0,%L1	;; cmphi\");
		return \"\";
	}"
)

(define_insn "cmpsi"
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
	]
	""
	"*{
		asm(\"cmp24	%L0,%L1	;; cmpsi\");
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Extends:

(define_insn "extendhisi2"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(sign_extend:SI (match_operand:HI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		int	plab, elab;
		int	regs_same = md_are_ops_same_reg(operands[0], operands[1]);
		int	y = 0;

		if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
			(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
			(REGNO(operands[0]) == REGNO(operands[1]))
		   ) {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; sx16\");
				asm(\"sta	%L0\");
				if (	(md_need_y(operands[1])) ||
					(md_need_y(operands[0]))
				   ) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H1\");
			}
			else {
				asm(\"sta	%L0	;; sx16\");
				asm(\"txa\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					y = 1;
				}
			}
		}
		else {
			asm(\"lda	%L1	;; sx16\");
			if (regs_same) {
				asm(\"tax\");
			}
			else {
				asm(\"sta	%L0\");
			}
			if (md_need_y(operands[1])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H1\");
		}
		if (regs_same && md_need_y(operands[0])) {
			asm(\"pha\");
		}
		else {
			asm(\"sta	%H0\");
		}
		if (!md_need_y(operands[0])) {
			elab = md_new_label();
			asm(\"stz	%B0\");
			asm(\"bpl	%@\");
			asm(\"dec	%B0\");
			md_output_md_label(elab);
		}
		else {
			elab = md_new_label();
			plab = md_new_label();
			asm(\"bpl	%@\");	/* bpl .plus */
			asm(\"lda	#$FF\");
			if (y == 1) {
				asm(\"iny\");
			}
			else {
				asm(\"ldy	#2\");
			}
			y = 2;
			asm(\"sta	%B0\");
			md_make_label(elab);
			asm(\"bra	%@\");	/* bra .end */
			md_output_md_label(plab);
			asm(\"lda	#0\");	/* .plus: */
			asm(\"sta	%B0\");
			md_output_md_label(elab);			/* .end: */
		}
		if (regs_same) {
			if (md_need_y(operands[0])) {
				asm(\"pla\");
				if (y != 1) {
					if (y == 2) {
						asm(\"dey\");
					}
					else {
						asm(\"ldy	#1\");
					}
				}
				asm(\"sta	%H0\");
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "extendqihi2"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(sign_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		int	elab, plab;

		if (md_need_y(operands[0])) {
			asm(\"ldy	#1	;; sx8_16\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			else {
				asm(\"tax\");
			}
			if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
				(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
				(REGNO(operands[0]) == REGNO(operands[1]))
			   ) {
				;
			}
			else {
				asm(\"sta	%L0\");
			}
			plab = md_new_label();
			asm(\"bpl	%@\");
			asm(\"lda	#$FF\");
			elab = md_new_label();
			asm(\"bra	%@\");
			md_output_md_label(plab);
			asm(\"lda	#0\");
			md_output_md_label(elab);
			asm(\"sta	%H0\");
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; sx8_16\");
			}
			else {
				asm(\"tax		;; sx8_16\");
			}
			if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
				(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
				(REGNO(operands[0]) == REGNO(operands[1]))
			   ) {
				;
			}
			else {
				asm(\"sta	%L0\");
			}
			asm(\"stz	%H0\");
			md_new_label();
			asm(\"bpl	%@\");
			asm(\"dec	%H0\");
			md_output_md_label(md_labelnum);
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "extendqisi2"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(sign_extend:SI (match_operand:QI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		int	elab, plab;

		if (md_need_y(operands[0])) {
			asm(\"ldy	#1	;; sx8_24\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			else {
				asm(\"tax\");
			}
			if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
				(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
				(REGNO(operands[0]) == REGNO(operands[1]))
			   ) {
				;
			}
			else {
				asm(\"sta	%L0\");
			}
			plab = md_new_label();
			asm(\"bpl	%@\");
			asm(\"lda	#$FF\");
			elab = md_new_label();
			asm(\"bra	%@\");
			md_output_md_label(plab);
			asm(\"lda	#0\");
			md_output_md_label(elab);
			asm(\"sta	%H0\");
			asm(\"sta	%B0\");
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; sx8_24\");
			}
			else {
				asm(\"tax		;; sx8_24\");
			}
			if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
				(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
				(REGNO(operands[0]) == REGNO(operands[1]))
			   ) {
				;
			}
			else {
				asm(\"sta	%L0\");
			}
			asm(\"stz	%H0\");
			asm(\"stz	%B0\");
			md_new_label();
			asm(\"bpl	%@\");
			asm(\"dec	%H0\");
			asm(\"dec	%B0\");
			md_output_md_label(md_labelnum);
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "zero_extendhisi2"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(zero_extend:SI (match_operand:HI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		int	regs_same = md_are_ops_same_reg(operands[0], operands[1]);
		int	y = 0;

		if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
			(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
			(REGNO(operands[0]) == REGNO(operands[1]))
		   ) {
			asm(\"stz	%B0	;; zx16\");
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; zx16\");
				if (regs_same) {
					asm(\"tax\");
				}
				else {
					asm(\"sta	%L0\");
				}
			}
			else {
				if (regs_same) {
					asm(\"tax		;; zx16\");
				}
				else {
					asm(\"sta	%L0	;; zx16\");
				}
			}
			if (md_need_y(operands[1])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H1\");
			if (regs_same && md_need_y(operands[0])) {
				asm(\"pha\");
			}
			else {
				asm(\"sta	%H0\");
			}
			if (md_need_y(operands[0])) {
				if (y == 1) {
					asm(\"iny\");
				}
				else {
					asm(\"ldy	#2\");
				}
				y = 2;
				asm(\"lda	#0\");
				asm(\"sta	%B0\");
			}
			else {
				asm(\"stz	%B0\");
			}
			if (regs_same) {
				if (md_need_y(operands[0])) {
					if (y == 2) {
						asm(\"dey\");
					}
					else {
						asm(\"ldy	#1\");
					}
					asm(\"pla\");
					asm(\"sta	%H0\");
					asm(\"txa\");
					asm(\"sta	%L0\");
				}
				else {
					asm(\"stx	%L0\");
				}
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "zero_extendqihi2"
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
			(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
			(REGNO(operands[0]) == REGNO(operands[1]))
		   ) {
			asm(\"stz	%H0	;; zx8_16\");
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; zx8_16\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%L0	;; zx8_16\");
			}
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"lda	#0\");
				asm(\"sta	%H0\");
			}
			else {
				asm(\"stz	%H0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "zero_extendqisi2"
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(zero_extend:SI (match_operand:QI 1 "md_gen_op" "g"))
		)
	]
	""
	"*{
		if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
			(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
			(REGNO(operands[0]) == REGNO(operands[1]))
		   ) {
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1	;; zx8_24\");
				asm(\"lda	#0\");
				asm(\"sta	%H0\");
				asm(\"sta	%B0\");
			}
			else {
				asm(\"stz	%H0	;; zx8_24\");
				asm(\"stz	%B0\");
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; zx8_24\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%L0	;; zx8_24\");
			}
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"lda	#0\");
				asm(\"sta	%H0\");
				asm(\"sta	%B0\");
			}
			else {
				asm(\"stz	%H0\");
				asm(\"stz	%B0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Calls:

(define_expand "call"
;; Note that this expression is not used for generating RTL.
;; All the RTL is generated explicitly below.
	[	(call	(match_operand 0 "md_call_op" "")
			(match_operand 3 "" "i")
		)
	]
;; operands[0] = function to call
;; operands[1] = stack_size_rtx - number of arg bytes pushed,
;; operands[2] = next_arg_reg - number of register args
;; operands[3] = struct_value_size_rtx
	""
	"{
		rtx	fn_rtx = operands[0];

	/* operands[2] will be NULL if all arg passing registers are used up!!!
	If we then pass that via the gen_rtx(CALL...) the compiler will eventually
	crash. Pretty useless!
		rtx	nregs_rtx = operands[2];
	*/

		rtx	nregs_rtx;

		if (operands[2]) {
			nregs_rtx = gen_rtx(CONST_INT, VOIDmode, REGNO(operands[2]));
		}
		else {
			nregs_rtx = gen_rtx(CONST_INT, VOIDmode, 100);
		}

		if (GET_MODE(operands[0]) != FUNCTION_MODE) {
			abort();
		}

		emit_call_insn(gen_rtx(CALL, VOIDmode, fn_rtx, nregs_rtx));
		DONE;
	}"
)

;; We can't use the same pattern for these two insns, because then registers
;; in the address may not be properly reloaded.

(define_insn "call_symbol"
	[	(call	(mem:HI (match_operand:HI 0 "md_addr_op" ""))
			(match_operand 1 "" "") ;; junk number of arg registers
		)
	]
;;- Do not use operand 1 for most machines.
	""
	"*{
		strcpy(md_call_name, XSTR(operands[0], 0));
		if (!md_is_func_nowrap(md_call_name)) {
			strcat(md_call_name, \"_c2c\");
		}
		if (md_is_tail_call(insn)) {
			if (TARGET_FARCALL) {
				asm(\"jump	%#	;; nargs = %1\");
			}
			else {
				asm(\"jmp	%#	;; nargs = %1\");
			}
		}
		else if (md_is_func_noregs(insn)) {
			if (TARGET_FARCALL) {
				asm(\"call	%#	;; nargs = %1, no regs used\");
			}
			else {
				asm(\"jsr	%#	;; nargs = %1, no regs used\");
			}
		}
		else {
			if (TARGET_FARCALL) {
				asm(\"call	%#	;; nargs = %1\");
			}
			else {
				asm(\"jsr	%#	;; nargs = %1\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "call_ind"
	[	(call	(mem:HI (match_operand:HI 0 "register_operand" "r"))
			(match_operand 1 "" "") ;; junk number of arg registers
		)
	]
;;- Do not use operand 1 for most machines.
	""
	"*{
		if (md_is_axy(operands[0])) {
			asm(\"			;; call_ind\");
		}
		else {
			asm(\"lda	%L0	;; call_ind\");
			asm(\"ldx	%H0\");
		}
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %1\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %1\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_expand "call_value"
;; Note that this expression is not used for generating RTL.
;; All the RTL is generated explicitly below.
	[	(set	(match_operand 0 "register_operand" "=rf")
			(call	(match_operand:SI 1 "" "")
				(match_operand 4 "" "")
			)
		)
	]
;; operands[0] = return value register
;; operands[1] = function to call
;; operands[2] = stack_size_rtx - number of arg bytes pushed,
;; operands[3] = next_arg_reg - number of register args
;; operands[4] = NULL_RTX
	""
	"{
		rtx	fn_rtx = operands[1];

	/* operands[3] will be NULL if all arg passing registers are used up!!!
	If we then pass that via the gen_rtx(CALL...) the compiler will eventually
	crash. Pretty useless!
		rtx	nregs_rtx = operands[3];
	*/

		rtx	nregs_rtx;

		if (operands[3]) {
			nregs_rtx = gen_rtx(CONST_INT, VOIDmode, REGNO(operands[3]));
		}
		else {
			nregs_rtx = gen_rtx(CONST_INT, VOIDmode, 100);
		}

		if (GET_MODE(operands[1]) != FUNCTION_MODE) {
			abort();
		}

		emit_call_insn(gen_rtx(SET, VOIDmode,	operands[0],
							gen_rtx(CALL, VOIDmode, fn_rtx, nregs_rtx)
					)
				);
		DONE;
	}"
)

(define_insn "call_value_symbol"
	[	(set	(match_operand 0 "md_gpr_op" "=r")
			(call	(mem:HI (match_operand:HI 1 "md_addr_op" ""))
				(match_operand 2 "" "")
			)
		)
	]
;;- Do not use operand 2 for most machines.
	""
	"*{
		strcpy(md_call_name, XSTR(operands[1], 0));
		if (!md_is_func_nowrap(md_call_name)) {
			strcat(md_call_name, \"_c2c\");
		}
		if (TARGET_FARCALL) {
			if (md_is_tail_call(insn)) {
				asm(\"jump	%#	;; nargs = %2\");
			}
			else {
				asm(\"call	%#	;; nargs = %2\");
			}
		}
		else {
			if (md_is_tail_call(insn)) {
				asm(\"jmp	%#	;; nargs = %2\");
			}
			else {
				asm(\"jsr	%#	;; nargs = %2\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_insn "call_value_ind"
	[	(set	(match_operand 0 "md_gpr_op" "=r")
			(call	(mem:HI (match_operand:HI 1 "register_operand" "r"))
				(match_operand 2 "" "")
			)
		)
	]
;;- Do not use operand 2 for most machines.
	""
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"			;; call_value_ind\");
		}
		else {
			asm(\"lda	%L1	;; call_value_ind\");
			asm(\"ldx	%H1\");
		}
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Conditional branches:

(define_insn "beq"
	[	(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jeq_	%0\");
		return \"\";
	}"
)

(define_insn "bne"
	[	(set	(pc)
			(if_then_else	(ne (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jne_	%0\");
		return \"\";
	}"
)

(define_insn "bge"
	[	(set	(pc)
			(if_then_else	(ge (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jge_	%0\");
		return \"\";
	}"
)

(define_insn "bgt"
	[	(set	(pc)
			(if_then_else	(gt (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jgt_	%0\");
		return \"\";
	}"
)

(define_insn "ble"
	[	(set	(pc)
			(if_then_else	(le (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jle_	%0\");
		return \"\";
	}"
)

(define_insn "blt"
	[	(set	(pc)
			(if_then_else	(lt (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jlt_	%0\");
		return \"\";
	}"
)

(define_insn "bgeu"
	[	(set	(pc)
			(if_then_else	(geu (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jgeu_	%0\");
		return \"\";
	}"
)

(define_insn "bgtu"
	[	(set	(pc)
			(if_then_else	(gtu (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jgtu_	%0\");
		return \"\";
	}"
)

(define_insn "bleu"
	[	(set	(pc)
			(if_then_else	(leu (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jleu_	%0\");
		return \"\";
	}"
)

(define_insn "bltu"
	[	(set	(pc)
			(if_then_else	(ltu (cc0) (const_int 0))
					(label_ref (match_operand 0 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		asm(\"jltu_	%0\");
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jeq_8	op1,op2,label
;;	jeq_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tay		;; jeq_8 %L0, %V1, %2\");
				if (GET_MODE(axy_rtx) >= SImode) {
					md_forget_axy();
				}
			}
			else {
				asm(\"lda	%L0	;; jeq_8 %L0, %V1, %2\");
				md_remember_axy(operands[0]);
			}
		}
		else if (md_int_1_op(operands[1], GET_MODE(operands[1]))) {
			if (md_is_axy(operands[0])) {
				asm(\"dca		;; jne_8 %L0, %V1, %2\");
				md_forget_axy();
			}
			else {
				asm(\"lda	%L0	;; jne_8 %L0, %V1, %2\");
				asm(\"dca\");
				md_forget_axy();
			}
		}
		else {
			if (md_is_axy(operands[0])) {
				asm(\"cmp	%L1	;; jeq_8 %L0, %V1, %2\");
			}
			else if (md_is_axy(operands[1])) {
				asm(\"cmp	%L0	;; jeq_8 %L0, %V1, %2\");
			}
			else {
				asm(\"lda	%L0	;; jeq_8 %L0, %V1, %2\");
				asm(\"cmp	%L1\");
				md_remember_axy(operands[0]);
			}
		}
		asm(\"jeq	%2\");
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (md_is_zero(operands[1])) {
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0	;; jeq_16 %L0, %V1, %2\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"ora	%H0\");
				md_forget_axy();
			}
			else {
				md_new_label();
				asm(\"tay		;; jeq_16 %L0, %V1, %2\");
				asm(\"bne	%@\");
				asm(\"txa\");
				md_output_md_label(md_labelnum);
				md_forget_axy();
			}
		}
		else if (md_int_1_op(operands[1], GET_MODE(operands[1]))) {
			md_new_label();
			if (md_is_axy(operands[0])) {
				asm(\"dca		;; jeq_16 %L0, %V1, %2\");
				asm(\"bne	%@\");
				asm(\"txa\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"lda	%L0	;; jeq_16 %L0, %V1, %2\");
					asm(\"dca\");
					asm(\"bne	%@\");
					asm(\"ldy	#1\");
					asm(\"lda	%H0\");
				}
				else {
					asm(\"lda	%L0	;; jeq_16 %L0, %V1, %2\");
					asm(\"dca\");
					asm(\"bne	%@\");
					asm(\"ldx	%H0\");
				}
			}
			md_output_md_label(md_labelnum);
			md_forget_axy();
		}
		else {
			md_new_label();
			if (md_is_axy(operands[0])) {
				asm(\"cmp	%L1	;; jeq_16 %L0, %V1, %2\");
				asm(\"bne	%@\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cmp	%H1\");
					}
					md_forget_axy();
				}
				else {
					asm(\"cpx	%H1\");
				}
			}
			else if (md_is_axy(operands[1])) {
				asm(\"cmp	%L0	;; jeq_16 %L0, %V1, %2\");
				asm(\"bne	%@\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					if (!md_is_high_zero(operands[0])) {
						asm(\"cmp	%H0\");
					}
					md_forget_axy();
				}
				else {
					asm(\"cpx	%H0\");
				}
			}
			else {
				if (md_need_y(operands[0]) || md_need_y(operands[1])) {
					asm(\"lda	%L0	;; jeq_16 %L0, %V1, %2\");
					asm(\"cmp	%L1\");
					asm(\"bne	%@\");
					asm(\"ldy	#1\");
					asm(\"lda	%H0\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cmp	%H1\");
					}
					md_forget_axy();
				}
				else {
					asm(\"lda	%L0	;; jeq_16 %L0, %V1, %2\");
					asm(\"cmp	%L1\");
					asm(\"bne	%@\");
					asm(\"ldx	%H0\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cpx	%H1\");
					}
					md_forget_axy();
				}
			}
			md_output_md_label(md_labelnum);
		}
		asm(\"jeq	%2\");
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (md_is_zero(operands[1])) {
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0	;; jeq_24 %L0, %V1, %2\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"ora	%H0\");
				if (md_need_y(operands[0])) {
					asm(\"iny\");
				}
				asm(\"ora	%B0\");
				md_forget_axy();
			}
			else {
				md_new_label();
				asm(\"cmp	#0	;; jeq_24 %L0, %V1, %2\");
				asm(\"bne	%@\");
				asm(\"txa\");
				asm(\"bne	%@\");
				asm(\"tya\");
				md_output_md_label(md_labelnum);
				md_forget_axy();
			}
		}
		else {
			md_new_label();
			if (md_is_axy(operands[0])) {
				asm(\"cmp	%L1	;; jeq_24 %L0, %V1, %2\");
				asm(\"bne	%@\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cmp	%H1\");
					}
					asm(\"bne	%@\");
					asm(\"iny\");
					asm(\"lda	%B0\");
					if (!md_is_bank_zero(operands[1])) {
						asm(\"cmp	%B1\");
					}
					md_forget_axy();
				}
				else {
					asm(\"cpx	%H1\");
					asm(\"bne	%@\");
					asm(\"cpy	%B1\");
				}
			}
			else if (md_is_axy(operands[1])) {
				asm(\"cmp	%L0	;; jeq_24 %L0, %V1, %2\");
				asm(\"bne	%@\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					if (!md_is_high_zero(operands[0])) {
						asm(\"cmp	%H0\");
					}
					asm(\"bne	%@\");
					asm(\"iny\");
					asm(\"lda	%B1\");
					if (!md_is_bank_zero(operands[0])) {
						asm(\"cmp	%B0\");
					}
					md_forget_axy();
				}
				else {
					asm(\"cpx	%H0\");
					asm(\"bne	%@\");
					asm(\"cpy	%B0\");
				}
			}
			else {
				if (md_need_y(operands[0]) || md_need_y(operands[1])) {
					asm(\"lda	%L0	;; jeq_24 %L0, %V1, %2\");
					asm(\"cmp	%L1\");
					asm(\"bne	%@\");
					asm(\"ldy	#1\");
					asm(\"lda	%H0\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cmp	%H1\");
					}
					asm(\"iny\");
					asm(\"lda	%B0\");
					if (!md_is_bank_zero(operands[1])) {
						asm(\"cmp	%B1\");
					}
					md_forget_axy();
				}
				else {
					asm(\"lda	%L0	;; jeq_24 %L0, %V1, %2\");
					asm(\"cmp	%L1\");
					asm(\"bne	%@\");
					asm(\"ldx	%H0\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cpx	%H1\");
					}
					asm(\"bne	%@\");
					asm(\"ldy	%B0\");
					if (!md_is_bank_zero(operands[1])) {
						asm(\"cpy	%B1\");
					}
					md_forget_axy();
				}
			}
			md_output_md_label(md_labelnum);
		}
		asm(\"jeq	%2\");
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jne_8	op1,op2,label
;;	jne_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ne (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tay		;; jne_8 %L0, %V1, %2\");
				if (GET_MODE(axy_rtx) >= SImode) {
					md_forget_axy();
				}
			}
			else {
				asm(\"lda	%L0	;; jne_8 %L0, %V1, %2\");
				md_remember_axy(operands[0]);
			}
		}
		else if (md_int_1_op(operands[1], GET_MODE(operands[1]))) {
			if (md_is_axy(operands[0])) {
				asm(\"dca		;; jne_8 %L0, %V1, %2\");
				md_forget_axy();
			}
			else {
				asm(\"lda	%L0	;; jne_8 %L0, %V1, %2\");
				asm(\"dca\");
				md_forget_axy();
			}
		}
		else {
			if (md_is_axy(operands[0])) {
				asm(\"cmp	%L1	;; jne_8 %L0, %V1, %2\");
			}
			else if (md_is_axy(operands[1])) {
				asm(\"cmp	%L0	;; jne_8 %L0, %V1, %2\");
			}
			else {
				asm(\"lda	%L0	;; jne_8 %L0, %V1, %2\");
				asm(\"cmp	%L1\");
				md_remember_axy(operands[0]);
			}
		}
		asm(\"jne	%2\");
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ne (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (md_is_zero(operands[1])) {
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0	;; jne_16 %L0, %V1, %2\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"ora	%H0\");
				md_forget_axy();
			}
			else {
				md_new_label();
				asm(\"tay		;; jne_16 %L0, %V1, %2\");
				asm(\"bne	%@\");
				asm(\"txa\");
				md_output_md_label(md_labelnum);
				md_forget_axy();
			}
		}
		else if (md_int_1_op(operands[1], GET_MODE(operands[1]))) {
			md_new_label();
			if (md_is_axy(operands[0])) {
				asm(\"dca		;; jne_16 %L0, %V1, %2\");
				asm(\"bne	%@\");
				asm(\"txa\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"lda	%L0	;; jne_16 %L0, %V1, %2\");
					asm(\"dca\");
					asm(\"bne	%@\");
					asm(\"ldy	#1\");
					asm(\"lda	%H0\");
				}
				else {
					asm(\"lda	%L0	;; jne_16 %L0, %V1, %2\");
					asm(\"dca\");
					asm(\"bne	%@\");
					asm(\"ldx	%H0\");
				}
			}
			md_output_md_label(md_labelnum);
			md_forget_axy();
		}
		else {
			md_new_label();
			if (md_is_axy(operands[0])) {
				asm(\"cmp	%L1	;; jne_16 %L0, %V1, %2\");
				asm(\"bne	%@\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cmp	%H1\");
					}
					md_forget_axy();
				}
				else {
					asm(\"cpx	%H1\");
				}
			}
			else if (md_is_axy(operands[1])) {
				asm(\"cmp	%L0	;; jne_16 %L0, %V1, %2\");
				asm(\"bne	%@\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					if (!md_is_high_zero(operands[0])) {
						asm(\"cmp	%H0\");
					}
					md_forget_axy();
				}
				else {
					asm(\"cpx	%H0\");
				}
			}
			else {
				if (md_need_y(operands[0]) || md_need_y(operands[1])) {
					asm(\"lda	%L0	;; jne_16 %L0, %V1, %2\");
					asm(\"cmp	%L1\");
					asm(\"bne	%@\");
					asm(\"ldy	#1\");
					asm(\"lda	%H0\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cmp	%H1\");
					}
					md_forget_axy();
				}
				else {
					asm(\"lda	%L0	;; jne_16 %L0, %V1, %2\");
					asm(\"cmp	%L1\");
					asm(\"bne	%@\");
					asm(\"ldx	%H0\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cpx	%H1\");
					}
					md_forget_axy();
				}
			}
			md_output_md_label(md_labelnum);
		}
		asm(\"jne	%2\");
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ne (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (md_is_zero(operands[1])) {
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0	;; jne_24 %L0, %V1, %2\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
				}
				asm(\"ora	%H0\");
				if (md_need_y(operands[0])) {
					asm(\"iny\");
				}
				asm(\"ora	%B0\");
				md_forget_axy();
			}
			else {
				md_new_label();
				asm(\"cmp	#0	;; jne_24 %L0, %V1, %2\");
				asm(\"bne	%@\");
				asm(\"txa\");
				asm(\"bne	%@\");
				asm(\"tya\");
				md_output_md_label(md_labelnum);
				md_forget_axy();
			}
		}
		else {
			md_new_label();
			if (md_is_axy(operands[0])) {
				asm(\"cmp	%L1	;; jne_24 %L0, %V1, %2\");
				asm(\"bne	%@\");
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cmp	%H1\");
					}
					asm(\"bne	%@\");
					asm(\"iny\");
					asm(\"lda	%B0\");
					if (!md_is_bank_zero(operands[1])) {
						asm(\"cmp	%B1\");
					}
					md_forget_axy();
				}
				else {
					asm(\"cpx	%H1\");
					asm(\"bne	%@\");
					asm(\"cpy	%B1\");
				}
			}
			else if (md_is_axy(operands[1])) {
				asm(\"cmp	%L0	;; jne_24 %L0, %V1, %2\");
				asm(\"bne	%@\");
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					asm(\"txa\");
					if (!md_is_high_zero(operands[0])) {
						asm(\"cmp	%H0\");
					}
					asm(\"bne	%@\");
					asm(\"iny\");
					asm(\"lda	%B1\");
					if (!md_is_bank_zero(operands[0])) {
						asm(\"cmp	%B0\");
					}
					md_forget_axy();
				}
				else {
					asm(\"cpx	%H0\");
					asm(\"bne	%@\");
					asm(\"cpy	%B0\");
				}
			}
			else {
				if (md_need_y(operands[0]) || md_need_y(operands[1])) {
					asm(\"lda	%L0	;; jne_24 %L0, %V1, %2\");
					asm(\"cmp	%L1\");
					asm(\"bne	%@\");
					asm(\"ldy	#1\");
					asm(\"lda	%H0\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cmp	%H1\");
					}
					asm(\"iny\");
					asm(\"lda	%B0\");
					if (!md_is_bank_zero(operands[1])) {
						asm(\"cmp	%B1\");
					}
					md_forget_axy();
				}
				else {
					asm(\"lda	%L0	;; jne_24 %L0, %V1, %2\");
					asm(\"cmp	%L1\");
					asm(\"bne	%@\");
					asm(\"ldx	%H0\");
					if (!md_is_high_zero(operands[1])) {
						asm(\"cpx	%H1\");
					}
					asm(\"bne	%@\");
					asm(\"ldy	%B0\");
					if (!md_is_bank_zero(operands[1])) {
						asm(\"cpy	%B1\");
					}
					md_forget_axy();
				}
			}
			md_output_md_label(md_labelnum);
		}
		asm(\"jne	%2\");
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jgt_8	op1,op2,label
;;	jgt_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(gt (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		md_new_label();
		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tay		;; jgt_8 %L0, %V1, %2\");
				if (GET_MODE(axy_rtx) >= SImode) {
					md_forget_axy();
				}
			}
			else {
				asm(\"lda	%L0	;; jgt_8 %L0, %V1, %2\");
				md_remember_axy(operands[0]);
			}
			asm(\"bmi	%@\");
			asm(\"jne	%2\");
			md_output_md_label(md_labelnum);
		}
		else {
			asm(\"sec		;; jgt_8 %L0, %V1, %2\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			asm(\"sbc	%L0\");
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jpl	%2\");
			md_forget_axy();
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(gt (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		md_new_label();
		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"txa		;; jgt_16 %L0, %V1, %2\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1	;; jgt_16 %L0, %V1, %2\");
					asm(\"lda	%H0\");
				}
				else {
					asm(\"lda	%H0	;; jgt_16 %L0, %V1, %2\");
				}
			}
			asm(\"bmi	%@\");
			asm(\"ora	%L0\");
			asm(\"jne	%2\");
			md_output_md_label(md_labelnum);
		}
		else {
			asm(\"sec		;; jgt_16 %L0, %V1, %2\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			asm(\"sbc	%L0\");
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H1\");
			}
			else {
				asm(\"txa\");
			}
			if (	(md_need_y(operands[0])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H0\");
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jpl	%2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(gt (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		md_new_label();
		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tya		;; jgt_24 %L0, %V1, %2\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#2	;; jgt_24 %L0, %V1, %2\");
					y = 2;
					asm(\"lda	%B0\");
				}
				else {
					asm(\"lda	%B0	;; jgt_24 %L0, %V1, %2\");
				}
			}
			asm(\"bmi	%@\");
			asm(\"ora	%L0\");
			if (md_need_y(operands[0])) {
				if (y == 2) {
					asm(\"dey\");
				}
				else {
					asm(\"ldy	#1\");
				}
			}
			asm(\"ora	%H0\");
			asm(\"jne	%2\");
			md_output_md_label(md_labelnum);
		}
		else {
			asm(\"sec		;; jgt_24 %L0, %V1, %2\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			asm(\"sbc	%L0\");
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H1\");
			}
			else {
				asm(\"txa\");
			}
			if (	(md_need_y(operands[0])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H0\");
			if (	(!md_is_axy(operands[1])) ||
				(md_need_y(operands[0]))
			   ) {
				if (md_need_y(operands[1])) {
					asm(\"iny\");
					y = 2;
				}
				asm(\"lda	%B1\");
			}
			else {
				asm(\"tya\");
			}
			if (	(md_need_y(operands[0])) &&
				(y != 2)
			   ) {
				asm(\"iny\");
			}
			asm(\"sbc	%B0\");
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jpl	%2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jgtu_8	op1,op2,label
;;	jgtu_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(gtu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (immediate_operand(operands[1], GET_MODE(operands[1]))) {
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0	;; jgtu_8 %L0, %V1, %2\");
				asm(\"cmp	%L1+1\");
			}
			else {
				asm(\"cmp	%L1+1	;; jgtu_8 %L0, %V1, %2\");
			}
			asm(\"jcs	%2\");
			md_remember_axy(operands[0]);
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; jgtu_8 %L0, %V1, %2\");
				asm(\"cmp	%L0\");
			}
			else {
				asm(\"cmp	%L0	;; jgtu_8 %L0, %V1, %2\");
			}
			asm(\"jcc	%2\");
			md_remember_axy(operands[1]);
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(gtu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; jgtu_16 %L0, %V1, %2\");
			asm(\"cmp	%L0\");
			if (md_need_y(operands[1])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H1\");
		}
		else {
			asm(\"cmp	%L0	;; jgtu_16 %L0, %V1, %2\");
			asm(\"txa\");
		}
		if (	(md_need_y(operands[0])) &&
			(y != 1)
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H0\");
		asm(\"jcc	%2\");
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(gtu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; jgtu_24 %L0, %V1, %2\");
			asm(\"cmp	%L0\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[0]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"sbc	%H0\");
			if (	(md_need_y(operands[1])) ||
				(md_need_y(operands[0]))
			   ) {
				asm(\"iny\");
			}
			asm(\"lda	%B1\");
		}
		else {
			asm(\"cmp	%L0	;; jgtu_24 %L0, %V1, %2\");
			asm(\"txa\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"sbc	%H0\");
				asm(\"iny\");
				asm(\"lda	%B1\");
			}
			else {
				asm(\"sbc	%H0\");
				asm(\"tya\");
			}
		}
		asm(\"sbc	%B0\");
		asm(\"jcc	%2\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jlt_8	op1,op2,label
;;	jlt_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(lt (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tay		;; jlt_8 %L0, %V1, %2\");
				if (GET_MODE(axy_rtx) >= SImode) {
					md_forget_axy();
				}
			}
			else {
				asm(\"lda	%L0	;; jlt_8 %L0, %V1, %2\");
				md_remember_axy(operands[0]);
			}
			asm(\"jmi	%2\");
		}
		else {
			asm(\"sec		;; jlt_8 %L0, %V1, %2\");
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0\");
			}
			asm(\"sbc	%L1\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jpl	%2\");
			md_forget_axy();
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(lt (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"txa		;; jlt_16 %L0, %V1, %2\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1	;; jlt_16 %L0, %V1, %2\");
					asm(\"lda	%H0\");
				}
				else {
					asm(\"lda	%H0	;; jlt_16 %L0, %V1, %2\");
				}
			}
			asm(\"jmi	%2\");
		}
		else {
			asm(\"sec		;; jlt_16 %L0, %V1, %2\");
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0\");
			}
			asm(\"sbc	%L1\");
			if (!md_is_axy(operands[0])) {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H0\");
			}
			else {
				asm(\"txa\");
			}
			if (	(md_need_y(operands[1])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H1\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jpl	%2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(lt (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tya		;; jlt_24 %L0, %V1, %2\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#2	;; jlt_24 %L0, %V1, %2\");
					asm(\"lda	%B0\");
				}
				else {
					asm(\"lda	%B0	;; jlt_24 %L0, %V1, %2\");
				}
			}
			asm(\"jmi	%2\");
		}
		else {
			asm(\"sec		;; jlt_24 %L0, %V1, %2\");
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0\");
			}
			asm(\"sbc	%L1\");
			if (!md_is_axy(operands[0])) {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H0\");
			}
			else {
				asm(\"txa\");
			}
			if (	(md_need_y(operands[1])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H1\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"iny\");
				asm(\"lda	%B0\");
			}
			else if (!md_is_axy(operands[0])) {
				asm(\"lda	%B0\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"sbc	%B1\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jpl	%2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jltu_8	op1,op2,label
;;	jltu_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ltu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L0	;; jltu_8 %L0, %V1, %2\");
			asm(\"cmp	%L1\");
			md_remember_axy(operands[0]);
		}
		else {
			asm(\"cmp	%L1	;; jltu_8 %L0, %V1, %2\");
		}
		asm(\"jcc	%2\");
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ltu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L0	;; jltu_16 %L0, %V1, %2\");
			asm(\"cmp	%L1\");
		}
		else {
			asm(\"cmp	%L1	;; jltu_16 %L0, %V1, %2\");
		}
		if (!md_is_axy(operands[0])) {
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H0\");
		}
		else {
			asm(\"txa\");
		}
		if (	(md_need_y(operands[1])) &&
			(y != 1)
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H1\");
		asm(\"jcc	%2\");
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ltu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L0	;; jltu_24 %L0, %V1, %2\");
			asm(\"cmp	%L1\");
		}
		else {
			asm(\"cmp	%L1	;; jltu_24 %L0, %V1, %2\");
		}
		if (!md_is_axy(operands[0])) {
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H0\");
		}
		else {
			asm(\"txa\");
		}
		if (	(md_need_y(operands[1])) &&
			(y != 1)
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H1\");
		if (	(md_need_y(operands[0])) ||
			(md_need_y(operands[1]))
		   ) {
			asm(\"iny\");
			asm(\"lda	%B0\");
		}
		else if (!md_is_axy(operands[0])) {
			asm(\"lda	%B0\");
		}
		else {
			asm(\"tya\");
		}
		asm(\"sbc	%B1\");
		asm(\"jcc	%2\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jge_8	op1,op2,label
;;	jge_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ge (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tay		;; jge_8 %L0, %V1, %2\");
				if (GET_MODE(axy_rtx) >= SImode) {
					md_forget_axy();
				}
			}
			else {
				asm(\"lda	%L0	;; jge_8 %L0, %V1, %2\");
				md_remember_axy(operands[0]);
			}
			asm(\"jpl	%2\");
		}
		else {
			asm(\"sec		;; jge_8 %L0, %V1, %2\");
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0\");
			}
			asm(\"sbc	%L1\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jmi	%2\");
			md_forget_axy();
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ge (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"txa		;; jge_16 %L0, %V1, %2\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1	;; jge_16 %L0, %V1, %2\");
					asm(\"lda	%H0\");
				}
				else {
					asm(\"lda	%H0	;; jge_16 %L0, %V1, %2\");
				}
			}
			asm(\"jpl	%2\");
		}
		else {
			asm(\"sec		;; jge_16 %L0, %V1, %2\");
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0\");
			}
			asm(\"sbc	%L1\");
			if (!md_is_axy(operands[0])) {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H0\");
			}
			else {
				asm(\"txa\");
			}
			if (	(md_need_y(operands[1])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H1\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jmi	%2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(ge (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tya		;; jge_24 %L0, %V1, %2\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#2	;; jge_24 %L0, %V1, %2\");
					asm(\"lda	%B0\");
				}
				else {
					asm(\"lda	%B0	;; jge_24 %L0, %V1, %2\");
				}
			}
			asm(\"jpl	%2\");
		}
		else {
			asm(\"sec		;; jge_24 %L0, %V1, %2\");
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0\");
			}
			asm(\"sbc	%L1\");
			if (!md_is_axy(operands[0])) {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H0\");
			}
			else {
				asm(\"txa\");
			}
			if (	(md_need_y(operands[1])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H1\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"iny\");
				asm(\"lda	%B0\");
			}
			else if (!md_is_axy(operands[0])) {
				asm(\"lda	%B0\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"sbc	%B1\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jmi	%2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jgeu_8	op1,op2,label
;;	jgeu_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(geu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L0	;; jgeu_8 %L0, %V1, %2\");
			asm(\"cmp	%L1\");
			md_remember_axy(operands[0]);
		}
		else {
			asm(\"cmp	%L1	;; jgeu_8 %L0, %V1, %2\");
		}
		asm(\"jcs	%2\");
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(geu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L0	;; jgeu_16 %L0, %V1, %2\");
			asm(\"cmp	%L1\");
		}
		else {
			asm(\"cmp	%L1	;; jgeu_16 %L0, %V1, %2\");
		}
		if (!md_is_axy(operands[0])) {
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H0\");
		}
		else {
			asm(\"txa\");
		}
		if (	(md_need_y(operands[1])) &&
			(y != 1)
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H1\");
		asm(\"jcs	%2\");
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(geu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L0	;; jgeu_24 %L0, %V1, %2\");
			asm(\"cmp	%L1\");
		}
		else {
			asm(\"cmp	%L1	;; jgeu_24 %L0, %V1, %2\");
		}
		if (!md_is_axy(operands[0])) {
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H0\");
		}
		else {
			asm(\"txa\");
		}
		if (	(md_need_y(operands[1])) &&
			(y != 1)
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H1\");
		if (	(md_need_y(operands[0])) ||
			(md_need_y(operands[1]))
		   ) {
			asm(\"iny\");
			asm(\"lda	%B0\");
		}
		else if (!md_is_axy(operands[0])) {
			asm(\"lda	%B0\");
		}
		else {
			asm(\"tya\");
		}
		asm(\"sbc	%B1\");
		asm(\"jcs	%2\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jle_8	op1,op2,label
;;	jle_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(le (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	yes, no;

		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tay		;; jle_8 %L0, %V1, %2\");
				if (GET_MODE(axy_rtx) >= SImode) {
					md_forget_axy();
				}
			}
			else {
				asm(\"lda	%L0	;; jle_8 %L0, %V1, %2\");
				md_remember_axy(operands[0]);
			}
			yes = md_new_label();
			asm(\"bmi	%@\");
			no = md_new_label();
			asm(\"bne	%@\");
			md_output_md_label(yes);
			asm(\"jma	%2\");
			md_output_md_label(no);
		}
		else {
			asm(\"sec		;; jle_8 %L0, %V1, %2\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			asm(\"sbc	%L0\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jmi	%2\");
			md_forget_axy();
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(le (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	yes, no;
		int	y = 0;

		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"txa		;; jle_16 %L0, %V1, %2\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#1	;; jle_16 %L0, %V1, %2\");
					asm(\"lda	%H0\");
				}
				else {
					asm(\"lda	%H0	;; jle_16 %L0, %V1, %2\");
				}
			}
			yes = md_new_label();
			asm(\"bmi	%@\");
			asm(\"ora	%L0\");
			no = md_new_label();
			asm(\"bne	%@\");
			md_output_md_label(yes);
			asm(\"jma	%2\");
			md_output_md_label(no);
		}
		else {
			asm(\"sec		;; jle_16 %L0, %V1, %2\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			asm(\"sbc	%L0\");
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H1\");
			}
			else {
				asm(\"txa\");
			}
			if (	(md_need_y(operands[0])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H0\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jmi	%2\");
			md_forget_axy();
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(le (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	yes, no;
		int	y = 0;

		if (md_is_zero(operands[1])) {
			if (md_is_axy(operands[0])) {
				asm(\"tya		;; jle_24 %L0, %V1, %2\");
			}
			else {
				if (md_need_y(operands[0])) {
					asm(\"ldy	#2	;; jle_24 %L0, %V1, %2\");
					y = 2;
					asm(\"lda	%B0\");
				}
				else {
					asm(\"lda	%B0	;; jle_24 %L0, %V1, %2\");
				}
			}
			yes = md_new_label();
			asm(\"bmi	%@\");
			asm(\"ora	%L0\");
			if (md_need_y(operands[0])) {
				if (y == 2) {
					asm(\"dey\");
				}
				else {
					asm(\"ldy	#1\");
				}
			}
			asm(\"ora	%H0\");
			no = md_new_label();
			asm(\"bne	%@\");
			md_output_md_label(yes);
			asm(\"jma	%2\");
			md_output_md_label(no);
		}
		else {
			asm(\"sec		;; jle_24 %L0, %V1, %2\");
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1\");
			}
			asm(\"sbc	%L0\");
			if (!md_is_axy(operands[1])) {
				if (md_need_y(operands[1])) {
					asm(\"ldy	#1\");
					y = 1;
				}
				asm(\"lda	%H1\");
			}
			else {
				asm(\"txa\");
			}
			if (	(md_need_y(operands[0])) &&
				(y != 1)
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"sbc	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"iny\");
				asm(\"lda	%B1\");
			}
			else if (!md_is_axy(operands[1])) {
				asm(\"lda	%B1\");
			}
			else {
				asm(\"tya\");
			}
			asm(\"sbc	%B0\");
			md_new_label();
			asm(\"bvs	%@\");
			asm(\"eor	#$80\");
			md_output_md_label(md_labelnum);
			asm(\"jmi	%2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original		Peephole
;;
;;	cmp8	op1,op2		jleu_8	op1,op2,label
;;	jleu_	label

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:QI 0 "md_gen_op" "g")
					(match_operand:QI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(leu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (immediate_operand(operands[1], GET_MODE(operands[1]))) {
			if (!md_is_axy(operands[0])) {
				asm(\"lda	%L0	;; jleu_8 %L0, %V1, %2\");
				asm(\"cmp	%L1+1\");
			}
			else {
				asm(\"cmp	%L1+1	;; jleu_8 %L0, %V1, %2\");
			}
			asm(\"jcc	%2\");
			md_remember_axy(operands[0]);
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; jleu_8 %L0, %V1, %2\");
				asm(\"cmp	%L0\");
			}
			else {
				asm(\"cmp	%L0	;; jleu_8 %L0, %V1, %2\");
			}
			asm(\"jcs	%2\");
			md_remember_axy(operands[1]);
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:HI 0 "md_gen_op" "g")
					(match_operand:HI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(leu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		int	y = 0;

		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; jleu_16 %L0, %V1, %2\");
			asm(\"cmp	%L0\");
			if (md_need_y(operands[1])) {
				asm(\"ldy	#1\");
				y = 1;
			}
			asm(\"lda	%H1\");
		}
		else {
			asm(\"cmp	%L0	;; jleu_16 %L0, %V1, %2\");
			asm(\"txa\");
		}
		if (	(md_need_y(operands[0])) &&
			(y != 1)
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H0\");
		asm(\"jcs	%2\");
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(cc0)
			(compare	(match_operand:SI 0 "md_gen_op" "g")
					(match_operand:SI 1 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(leu (cc0) (const_int 0))
					(label_ref (match_operand 2 "" ""))
					(pc)
			)
		)
	]
	""
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; jleu_24 %L0, %V1, %2\");
			asm(\"cmp	%L0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"ldy	#1\");
			}
			asm(\"lda	%H1\");
			asm(\"sbc	%H0\");
			if (	(md_need_y(operands[0])) ||
				(md_need_y(operands[1]))
			   ) {
				asm(\"iny\");
			}
			asm(\"lda	%B1\");
		}
		else {
			asm(\"cmp	%L0	;; jleu_24 %L0, %V1, %2\");
			asm(\"txa\");
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"sbc	%H0\");
				asm(\"iny\");
				asm(\"lda	%B1\");
			}
			else {
				asm(\"sbc	%H0\");
				asm(\"tya\");
			}
		}
		asm(\"sbc	%B0\");
		asm(\"jcs	%2\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 10
;;
;;	lda	sym	;; mv_m_r_16		lda	sym
;;	sta	rx				ldx	sym+1
;;	ldx	sym+1				jsr	lib_ind_jump
;;	stx	rx+1
;;
;;	lda	rx	;; call_ind
;;	ldx	rx+1
;;	jsr	lib_ind_jump

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_mem_op" "")
			(match_operand:HI 1 "md_mem_op" "")
		)
		(call	(mem:HI (match_operand:HI 2 "address_operand" "p"))
			(match_operand 3 "" "") ;; junk number of arg registers
		)
	]
	"	(	(register_operand(operands[0], Pmode)) &&
			(rtx_equal_p(operands[0], operands[2]))
		)
	"
	"*{
		if (md_need_y(operands[1])) {
			asm(\"ldy	#1	;; peep 10\");
			asm(\"lda	%H1\");
			asm(\"tax\");
			asm(\"lda	%L1\");
		}
		else {
			asm(\"lda	%L1	;; peep 10\");
			asm(\"ldx	%H1\");
		}
		asm(\"jsr	lib_ind_jump\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 11b
;;
;;	lda	ry	;; zx8_16		lda	ry
;;	sta	rx				asl
;;	stz	rx+1				tax
;;						jmp	(lab),x
;;	asl	rx	;; ashlhi3
;;	rol	rx+1
;;
;;	ldx	rx	;; mv_indrximm_r_16
;;	lda	lab,x
;;	sta	rx
;;	lda	lab+1,x
;;	sta	rx+1
;;
;;	lda	rx	;; jump_indr
;;	ldx	rx+1
;;	jmp	lib_ind_jump

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_dup 0)
			(ashift:HI	(match_dup 0)
					(match_operand 2 "md_int_1_op" "")
			)
		)
		(set	(match_dup 0)
			(mem:HI	(plus:HI	(match_dup 0)
						(label_ref (match_operand 3 "" ""))
				)
			)
		)
		(parallel [
			(set	(pc)
				(match_dup 0)
			)
			(use	(label_ref (match_operand 4 "" "")))
		] )
	]
	""
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; peep 11b\");
			asm(\"asl\");
		}
		else {
			asm(\"asl		;; peep 11b\");
		}
		if (XVECLEN(PATTERN(next_active_insn(insn)), 0) < 128) {
			asm(\"tax\");
			asm(\"jmp	(%3,x)\");
		}
		else {
			asm(\"tay\");
			asm(\"lda	#0\");
			asm(\"rol\");
			asm(\"tax\");
			asm(\"clc\");
			asm(\"tya\");
			asm(\"adc	#low %3\");
			asm(\"sta	t\");
			asm(\"txa\");
			asm(\"adc	#high %3\");
			asm(\"sta	t+1\");
			asm(\"lda	(t),0\");
			asm(\"pha\");
			asm(\"ldy	#1\");
			asm(\"lda	(t),y\");
			asm(\"tax\");
			asm(\"pla\");
			asm(\"jmp	lib_ind_jump\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 11
;;
;;	asl	rx	;; ashlhi3		lda	rx
;;	rol	rx+1				asl
;;						tax
;;	ldx	rx	;; mv_indrximm_r_16	jmp	(lab,x)
;;	lda	lab,x
;;	sta	rx
;;	lda	lab+1,x
;;	sta	rx+1
;;
;;	lda	rx	;; jump_indr
;;	ldx	rx+1
;;	jmp	lib_ind_jump

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_mem_op" "")
			(ashift:HI	(match_dup 0)
					(match_operand 1 "md_int_1_op" "")
			)
		)
		(set	(match_dup 0)
			(mem:HI	(plus:HI	(match_dup 0)
						(label_ref (match_operand 2 "" ""))
				)
			)
		)
		(parallel [
			(set	(pc)
				(match_dup 0)
			)
			(use	(label_ref (match_operand 3 "" "")))
		] )
	]
	""
	"*{
		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L0	;; peep 11\");
			asm(\"asl\");
		}
		else {
			asm(\"asl		;; peep 11\");
		}
		if (XVECLEN(PATTERN(next_active_insn(insn)), 0) < 128) {
			asm(\"tax\");
			asm(\"jmp	(%2,x)\");
		}
		else {
			asm(\"tay\");
			asm(\"lda	%H0\");
			asm(\"rol\");
			asm(\"tax\");
			asm(\"clc\");
			asm(\"tya\");
			asm(\"adc	#low %2\");
			asm(\"sta	t\");
			asm(\"txa\");
			asm(\"adc	#high %2\");
			asm(\"sta	t+1\");
			asm(\"lda	(t),0\");
			asm(\"pha\");
			asm(\"ldy	#1\");
			asm(\"lda	(t),y\");
			asm(\"tax\");
			asm(\"pla\");
			asm(\"jmp	lib_ind_jump\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 13
;;
;;	lda	sym	;; mv_m_r_8		lda	sym
;;	sta	rx				jeq	lab
;;
;;	zcmp8	rx	;; cmpqi
;;
;;	jeq_	lab
;; If rx is dead

(define_peephole
	[	(set	(match_operand:QI 0 "md_gpr_mem_op" "")
			(match_operand:QI 1 "md_mem_op" "")
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand 2 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 3 "" ""))
					(pc)
			)
		)
	]
	"md_dead_or_set_p(previous_insn(insn), operands[0])"
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"tay		;; peep 13\");
		}
		else {
			asm(\"lda	%L1	;; peep 13\");
		}
		asm(\"jeq	%3\");
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_mem_op" "")
			(match_operand:HI 1 "md_mem_op" "")
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand 2 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 3 "" ""))
					(pc)
			)
		)
	]
	"md_dead_or_set_p(previous_insn(insn), operands[0])"
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; peep 13\");
			if (md_need_y(operands[1])) {
				asm(\"ldy	#1\");
			}
			asm(\"ora	%H1\");
		}
		else {
			if (md_need_y(operands[1])) {
				asm(\"ldy	#1	;; peep 13\");
				asm(\"ora	%H1\");
			}
			else {
				asm(\"ora	%H1	;; peep 13\");
			}
		}
		asm(\"jeq	%3\");
		md_forget_axy();
		return \"\";
	}"
)

(define_peephole
	[	(set	(match_operand:SI 0 "md_gpr_mem_op" "")
			(match_operand:SI 1 "md_mem_op" "")
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand 2 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 3 "" ""))
					(pc)
			)
		)
	]
	"md_dead_or_set_p(previous_insn(insn), operands[0])"
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; peep 13\");
			if (md_need_y(operands[1])) {
				asm(\"ldy	#1\");
			}
			asm(\"ora	%H1\");
		}
		else {
			if (md_need_y(operands[1])) {
				asm(\"ldy	#1	;; peep 13\");
				asm(\"ora	%H1\");
			}
			else {
				asm(\"ora	%H1	;; peep 13\");
			}
		}
		if (md_need_y(operands[1])) {
			asm(\"iny\");
		}
		asm(\"ora	%B1\");
		asm(\"jeq	%3\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 15
;;
;;	lda	#low imm1  ;; mv_imm_r_8	lda	#low imm1
;;	sta	rx				sta	rx
;;						sta	ry
;;	lda	#low imm2  ;; mv_imm_r_8
;;	sta	ry
;; If imm1 == imm2

(define_peephole
	[	(set	(match_operand:QI 0 "md_gpr_mem_op" "")
        		(match_operand 1 "const_int_operand" "")
		)
		(set	(match_operand:QI 2 "md_gpr_mem_op" "")
        		(match_operand 3 "const_int_operand" "")
		)
	]
	"(INTVAL(operands[1]) == INTVAL(operands[3]))"
	"*{
		if (	(md_is_zero(operands[1])) &&
			(!md_need_y(operands[0])) &&
			(!md_need_y(operands[2]))
		   ) {
			asm(\"stz	%L0	;; peep 15\");
			asm(\"stz	%L2\");
			md_forget_axy();
		}
		else {
			asm(\"lda	#low %1	;; peep 15\");
			asm(\"sta	%L0\");
			asm(\"sta	%L2\");
			if (md_gpr_op(operands[2], GET_MODE(operands[2]))) {
				md_remember_axy(operands[2]);
			}
			else {
				md_remember_axy(operands[1]);
			}
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_mem_op" "")
        		(match_operand 1 "const_int_operand" "")
		)
		(set	(match_operand:HI 2 "md_gpr_mem_op" "")
        		(match_operand 3 "const_int_operand" "")
		)
	]
	"(INTVAL(operands[1]) == INTVAL(operands[3]))"
	"*{
		if (md_is_zero(operands[1])) {
			if (md_need_y(operands[0]) || md_need_y(operands[1])) {
				asm(\"lda	#0	;; peep 15\");
				asm(\"sta	%L0\");
				asm(\"sta	%L2\");
				asm(\"ldy	#1\");
				asm(\"sta	%H0\");
				asm(\"sta	%H2\");
			}
			else {
				asm(\"stz	%L0	;; peep 15\");
				asm(\"stz	%H0\");
				asm(\"stz	%L2\");
				asm(\"stz	%H2\");
			}
			md_forget_axy();
		}
		else {
			asm(\"lda	#low %1	;; peep 15\");
			asm(\"sta	%L0\");
			asm(\"sta	%L2\");
			if (md_need_y(operands[0]) || md_need_y(operands[1])) {
				asm(\"lda	#high %1\");
				asm(\"ldy	#1\");
				asm(\"sta	%H0\");
				asm(\"sta	%H2\");
				md_forget_axy();
			}
			else {
				asm(\"ldx	#high %1\");
				asm(\"stx	%H0\");
				asm(\"stx	%H2\");
				md_remember_axy(operands[2]);
			}
		}
		return \"\";
	}"
)

(define_peephole
	[	(set	(match_operand:SI 0 "md_gpr_mem_op" "")
        		(match_operand 1 "const_int_operand" "")
		)
		(set	(match_operand:SI 2 "md_gpr_mem_op" "")
        		(match_operand 3 "const_int_operand" "")
		)
	]
	"(INTVAL(operands[1]) == INTVAL(operands[3]))"
	"*{
		if (md_is_zero(operands[1])) {
			if (md_need_y(operands[0]) || md_need_y(operands[1])) {
				asm(\"lda	#0	;; peep 15\");
				asm(\"sta	%L0\");
				asm(\"sta	%L2\");
				asm(\"ldy	#1\");
				asm(\"sta	%H0\");
				asm(\"sta	%H2\");
				asm(\"iny\");
				asm(\"sta	%B0\");
				asm(\"sta	%B2\");
			}
			else {
				asm(\"stz	%L0	;; peep 15\");
				asm(\"stz	%H0\");
				asm(\"stz	%B0\");
				asm(\"stz	%L2\");
				asm(\"stz	%H2\");
				asm(\"stz	%B2\");
			}
			md_forget_axy();
		}
		else {
			asm(\"lda	#low %1	;; peep 15\");
			asm(\"sta	%L0\");
			asm(\"sta	%L2\");
			if (md_need_y(operands[0]) || md_need_y(operands[1])) {
				asm(\"lda	#high %1\");
				asm(\"ldy	#1\");
				asm(\"sta	%H0\");
				asm(\"sta	%H2\");
				asm(\"lda	#bank %1\");
				asm(\"iny\");
				asm(\"sta	%B0\");
				asm(\"sta	%B2\");
				md_forget_axy();
			}
			else {
				asm(\"ldx	#high %1\");
				asm(\"stx	%H0\");
				asm(\"stx	%H2\");
				asm(\"ldy	#bank %1\");
				asm(\"sty	%B0\");
				asm(\"sty	%B2\");
				md_remember_axy(operands[2]);
			}
		}
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 16
;;
;;	dec	rx	;; addqi3		dec	rx
;;						jne	lab
;;	lda	rx	;; jne_r_z_8
;;	jne	lab

(define_peephole
	[	(set	(match_operand:QI 0 "md_gpr_mem_op" "")
			(plus:QI	(match_dup 0)
					(match_operand 1 "const_int_operand" "")
			)
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand 2 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(ne (cc0) (const_int 0))
					(label_ref (match_operand 3 "" ""))
					(pc)
			)
		)
	]
	"	(	((INTVAL(operands[1]) & 0xFF) == 0xFF) &&
			(!md_need_y(operands[0]))
		)
	"
	"*{
		asm(\"dec	%L0	;; peep 16\");
		asm(\"jne	%3\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 17
;;
;;	dec	rx	;; addqi3		dec	rx
;;						jeq	lab
;;	lda	rx	;; jne_r_z_8
;;	jeq	lab

(define_peephole
	[	(set	(match_operand:QI 0 "md_gpr_mem_op" "")
			(plus:QI	(match_dup 0)
					(match_operand 1 "const_int_operand" "")
			)
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand 2 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 3 "" ""))
					(pc)
			)
		)
	]
	"	(	((INTVAL(operands[1]) & 0xFF) == 0xFF) &&
			(!md_need_y(operands[0]))
		)
	"
	"*{
		asm(\"dec	%L0	;; peep 17\");
		asm(\"jeq	%3\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 20b
;;
;;	lda	rx	;; zx8_16		lda	rx
;;	sta	ry				ldy	#low imm
;;	stz	ry+1				jsr	__mul_8_by_8
;;						clc
;;	ldy	ry	;; mulhi3		adc	ra
;;	ldx	ry+1				sta	rz
;;	lda	#low imm			txa
;;	jsr	__mul_8_by_16			adc	ra+1
;;	sta	rz				sta	rz+1
;;	stx	rz+1
;;
;;	clc		;; addhi3
;;	adc	ra
;;	sta	rz
;;	txa
;;	adc	ra+1
;;	sta	rz+1
;; If ry is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:HI 2 "md_gen_op" "=g")
			(mult:HI	(match_dup 0)
					(match_operand:HI 3 "md_gen_imm_op" "g")
			)
		)
		(set	(match_operand:HI 4 "md_gen_op" "=g")
			(plus:HI	(match_dup 2)
					(match_operand:HI 5 "md_gen_imm_op" "g")
			)
		)
	]
	"	(	(	(md_dead_or_set_p(insn, operands[0])) ||
				(md_is_reg_dead(next_insn(insn), operands[0]))
			) &&
			(md_is_high_zero(operands[3])) &&
			(rtx_equal_p(operands[2], operands[4]))
		)
	"
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; peep 20b\");
			asm(\"ldy	%L3\");
		}
		else {
			asm(\"ldy	%L3	;; peep 20b\");
		}
		asm(\"jsr	__mul_8_by_8\");
		asm(\"clc\");
		asm(\"adc	%L5\");
		asm(\"sta	%L4\");
		asm(\"txa\");
		if (md_need_y(operands[5]) || md_need_y(operands[4])) {
			asm(\"ldy	#1\");
		}
		asm(\"adc	%H5\");
		asm(\"sta	%H4\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 20
;;
;;	lda	rx	;; zx8_16		lda	rx
;;	sta	ry				ldy	#low imm
;;	stz	ry+1				jsr	__mul_8_by_8
;;						sta	rz
;;	ldy	ry	;; mulhi3		stx	rz+1
;;	ldx	ry+1
;;	lda	#low imm
;;	jsr	__mul_8_by_16
;;	sta	rz
;;	stx	rz+1
;; If ry is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:HI 2 "md_gen_op" "=g")
			(mult:HI	(match_dup 0)
					(match_operand:HI 3 "md_gen_imm_op" "g")
			)
		)
	]
	"	(	(	(md_dead_or_set_p(insn, operands[0])) ||
				(md_is_reg_dead(next_insn(insn), operands[0]))
			) &&
			(md_is_high_zero(operands[3]))
		)
	"
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; peep 20\");
			asm(\"ldy	%L3\");
		}
		else {
			asm(\"ldy	%L3	;; peep 20\");
		}
		asm(\"jsr	__mul_8_by_8\");
		asm(\"sta	%L2\");
		if (md_need_y(operands[2])) {
			asm(\"ldy	#1\");
			asm(\"txa\");
			asm(\"sta	%H2\");
			md_forget_axy();
		}
		else {
			asm(\"stx	%H2\");
			md_remember_axy(operands[2]);
		}
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 24
;;
;;	lda	op1	;; zx8_16		clc
;;	sta	rx				lda	op1
;;	stz	rx+1				adc	op2
;;						sta	op3
;;	clc		;; addhi3		lda	op2+1
;;	lda	rx				adc	#0
;;	adc	op2+1				sta	op3+1
;;	sta	op3+1
;;	lda	rx+1
;;	adc	op2+1+1
;;	sta	op3+1+1
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:HI 2 "md_gen_op" "=g")
			(plus:HI	(match_operand:HI 3 "md_gpr_op" "r")
					(match_operand:HI 4 "md_gen_sp_op" "gfx")
			)
		)
	]
	"	(	(	(md_dead_or_set_p(insn, operands[0])) ||
				(md_is_reg_dead(next_insn(insn), operands[0]))
			) &&
			(REGNO(operands[0]) == REGNO(operands[3]))
		)
	"
	"*{
		asm(\"clc		;; peep 24\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"adc	%L4\");
		asm(\"sta	%L2\");
		if (md_need_y(operands[4]) || md_need_y(operands[2])) {
			asm(\"ldy	#1\");
		}
		asm(\"lda	%H4\");
		asm(\"adc	#0\");
		asm(\"sta	%H2\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 25b
;;
;;	lda	op	;; zx8_16		lda	op
;;	sta	rx				asl
;;	stz	rx+1				tax
;;						lda	op1,x
;;	asl	rx	;; ashlhi3		sta	op2
;;	rol	rx+1				lda	op1+1,x
;;						sta	op2+1,x
;;	ldx	rx	;; mv_indrximm_r_16
;;	lda	op1,x
;;	sta	op2
;;	lda	op1+1,x
;;	sta	op2+1

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_dup 0)
			(ashift:HI	(match_dup 0)
					(match_operand 2 "md_int_1_op" "")
			)
		)
		(set	(match_operand:HI 3 "md_gen_op" "=g")
			(mem:HI	(plus:HI	(match_dup 0)
						(match_operand 4 "immediate_operand" "")
				)
			)
		)
	]
	"(!TARGET_16BITX)"
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; peep 25b\");
			asm(\"asl\");
		}
		else {
			asm(\"asl		;; peep 25b\");
		}
		asm(\"tax\");
		asm(\"lda	%4,x\");
		asm(\"sta	%L3\");
		asm(\"lda	%4+1,x\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"sta	%H3\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 25
;;
;;	lda	op	;; zx8_16		lda	op
;;	sta	rx				asl
;;	stz	rx+1				sta	rx
;;						stz	rx+1
;;	asl	rx	;; ashlhi3		rol	rx+1
;;	rol	rx+1

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:HI 2 "md_gpr_op" "=r")
			(ashift:HI	(match_dup 2)
					(match_operand 3 "md_int_1_op" "")
			)
		)
	]
	"	(	(REGNO(operands[0]) == REGNO(operands[2])) &&
			(!TARGET_16BITX)
		)
	"
	"*{
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1	;; peep 25\");
			asm(\"asl\");
		}
		else {
			asm(\"asl		;; peep 25\");
		}
		asm(\"sta	%L2\");
		if (md_need_y(operands[2])) {
			asm(\"ldy	#1\");
			asm(\"lda	#0\");
			asm(\"rol\");
			asm(\"sta	%H2\");
		}
		else {
			asm(\"stz	%H2\");
			asm(\"rol	%H2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 28
;;
;;	lda	op1	;; zx8_16		lda	op1
;;	sta	rx				sta	rx
;;	stz	rx+1				stz	rx+1
;;						lda	op2
;;	lda	op2	;; jgtu_16 rx,op2,lab	cmp	rx
;;	cmp	rx				jcc	lab
;;	lda	op2+1
;;	sbc	rx+1
;;	jcc	lab

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(cc0)
			(compare	(match_operand:HI 2 "md_gpr_op" "r")
					(match_operand:HI 3 "md_gen_imm_op" "g")
			)
		)
		(set	(pc)
			(if_then_else	(gtu (cc0) (const_int 0))
					(label_ref (match_operand 4 "" ""))
					(pc)
			)
		)
	]
	"(REGNO(operands[0]) == REGNO(operands[2]))"
	"*{
		if (	(md_gpr_op(operands[0], GET_MODE(operands[0]))) &&
			(md_gpr_op(operands[1], GET_MODE(operands[1]))) &&
			(REGNO(operands[0]) == REGNO(operands[1]))
		   ) {
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1	;; peep 28\");
				asm(\"lda	#0\");
				asm(\"sta	%H0\");
			}
			else {
				asm(\"stz	%H0	;; peep 28\");
			}
		}
		else {
			if (!md_is_axy(operands[1])) {
				asm(\"lda	%L1	;; peep 28\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"sta	%L0	;; peep 28\");
			}
			if (md_need_y(operands[0])) {
				asm(\"ldy	#1\");
				asm(\"lda	#0\");
				asm(\"sta	%H0\");
			}
			else {
				asm(\"stz	%H0\");
			}
		}
		asm(\"lda	%L3\");
		asm(\"cmp	%L0\");
		asm(\"jcc	%4\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 30
;;
;;	lda	op1	;; zx8_16		ldx	op1
;;	sta	rx				lda	imm,x
;;	stz	rx+1				sta	op2
;;
;;	ldx	rx	;; mv_indrximm_r_8
;;	lda	imm,x
;;	sta	op2
;; If rx is dead

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
			(set	(match_operand:QI 2 "md_gen_op" "=g")
			(mem:QI	(plus:HI	(match_operand:HI 3 "md_gpr_op" "r")
						(match_operand 4 "immediate_operand" "")
				)
			)
		)
	]
	"	(	(	(md_dead_or_set_p(insn, operands[0])) ||
				(md_is_reg_dead(next_insn(insn), operands[0]))
			) &&
			(REGNO(operands[0]) == REGNO(operands[3])) &&
			(GET_CODE(operands[4]) != CONST_INT)
		)
	"
	"*{
		if (md_need_y(operands[1])) {
			asm(\"lda	%L1	;; peep 30\");
			asm(\"tax\");
		}
		else {
			if (md_is_axy(operands[1])) {
				asm(\"tax		;; peep 30\");
			}
			else {
				asm(\"ldx	%L1	;; peep 30\");
			}
		}
		asm(\"lda	%4,x\");
		asm(\"sta	%L2\");
		md_remember_axy(operands[2]);
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ***!!!*** Since Peephole 34 says not to use it, and it's almost exactly
;; ***!!!*** the same as this one, and because this peephole is causing
;; ***!!!*** problems, I'm removing it.
;; ***!!!*** 960909 PRB
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 33
;;
;;	lda	op	; mv_8			lda	op
;;	sta	rx				jne	lab
;;
;;	tay		;; jne_8 rx,#low 0,lab
;;	jne	lab
;; If rx is dead

;;(define_peephole
;;	[	(set	(match_operand:QI 0 "md_gpr_op" "=r")
;;			(match_operand:QI 1 "md_gen_imm_op" "g")
;;		)
;;		(set	(cc0)
;;			(compare	(match_dup 0)
;;					(match_operand 2 "md_int_0_op" "")
;;			)
;;		)
;;		(set	(pc)
;;			(if_then_else	(ne (cc0) (const_int 0))
;;					(label_ref (match_operand 3 "" ""))
;;					(pc)
;;			)
;;		)
;;	]
;;	"	(	(md_dead_or_set_p(previous_insn(insn), operands[0])) ||
;;			(md_is_reg_dead(next_insn(insn), operands[0]))
;;		)
;;	"
;;	"*{
;;		if (md_is_axy(operands[1])) {
;;			asm(\"tax		;; peep 33\");
;;		}
;;		else {
;;			asm(\"lda	%L1	;; peep 33\");
;;		}
;;		asm(\"jne	%3\");
;;		md_forget_axy();
;;		return \"\";
;;	}"
;;)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ***!!!*** Do not use this peephole. The jeq could jump to code that
;; ***!!!*** 'knows' that rx is zero. So rx is not really dead after the
;; ***!!!*** jump. Our md_is_reg_dead() isn't sophisticated enough to
;; ***!!!*** follow jumps.

;;	Original				Peephole 34
;;
;;	lda	op	; mv_8			lda	op
;;	sta	rx				jeq	lab
;;
;;	tay		;; jeq_8 rx,#low 0,lab
;;	jeq	lab
;; If rx is dead

;;(define_peephole
;;	[	(set	(match_operand:QI 0 "md_gpr_op" "=r")
;;			(match_operand:QI 1 "md_gen_imm_op" "g")
;;		)
;;		(set	(cc0)
;;			(compare	(match_dup 0)
;;					(match_operand 2 "md_int_0_op" "")
;;			)
;;		)
;;		(set	(pc)
;;			(if_then_else	(eq (cc0) (const_int 0))
;;					(label_ref (match_operand 3 "" ""))
;;					(pc)
;;			)
;;		)
;;	]
;;	"	(	(md_dead_or_set_p(previous_insn(insn), operands[0])) ||
;;			(md_is_reg_dead(next_insn(insn), operands[0]))
;;		)
;;	"
;;	"*{
;;		if (md_is_axy(operands[1])) {
;;			asm(\"tax		;; peep 34\");
;;		}
;;		else {
;;			asm(\"lda	%L1	;; peep 34\");
;;		}
;;		asm(\"jeq	%3\");
;;		md_forget_axy();
;;		return \"\";
;;	}"
;;)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 40
;;
;;	lda	rx	;; zx8_16		clc
;;	sta	ry				lda	rx
;;	stz	ry+1				adc	rz
;;						sta	t
;;	clc		;; mv_indrxr_r_8	lda	rz+1
;;	lda	rz				adc	#0
;;	adc	ry				sta	t+1
;;	sta	t				lda	(t),0
;;	lda	rz+1				sta	ry
;;	adc	ry+1
;;	sta	t+1
;;	lda	(t),0
;;	sta	ry

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:QI 2 "md_gpr_op" "=r")
			(mem:QI	(plus:HI	(match_operand:HI 3 "md_gpr_op" "r")
						(match_dup 0)
				)
			)
		)
	]
	"(REGNO(operands[0]) == REGNO(operands[2]))"
	"*{
		asm(\"clc		;; peep 40\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"adc	%L3\");
		asm(\"sta	t\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"lda	%H3\");
		asm(\"adc	#0\");
		asm(\"sta	t+1\");
		asm(\"lda	(t),0\");
		asm(\"sta	%L0\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 41
;;
;;	lda	(rx),0	;; mv_16		lda	(rx),0
;;	sta	ry				ldy	#1
;;	ldy	#1				ora	(rx),y
;;	lda	(rx),y				jeq	lab
;;	sta	ry+1
;;
;;	lda	ry	;; jeq_16 ry, 0, lab
;;	ora	ry+1
;;	jeq	lab
;; If ry is dead

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI (match_operand:HI 1 "md_gpr_op" "r"))
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand:HI 2 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 3 "" ""))
					(pc)
			)
		)
	]
	"	(	(md_dead_or_set_p(previous_insn(insn), operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		asm(\"lda	(%1),0	;; peep 41\");
		asm(\"ldy	#1\");
		asm(\"ora	(%1),y\");
		asm(\"jeq	%3\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 42
;;
;;	lda	(rx),0	;; mv_16		lda	(rx),0
;;	sta	ry				ldy	#1
;;	ldy	#1				ora	(rx),y
;;	lda	(rx),y				jne	lab
;;	sta	ry+1
;;
;;	lda	ry	;; jne_16 ry, 0, lab
;;	ora	ry+1
;;	jne	lab
;; If ry is dead

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI (match_operand:HI 1 "md_gpr_op" "r"))
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand:HI 2 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(ne (cc0) (const_int 0))
					(label_ref (match_operand 3 "" ""))
					(pc)
			)
		)
	]
	"	(	(md_dead_or_set_p(previous_insn(insn), operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		asm(\"lda	(%1),0	;; peep 42\");
		asm(\"ldy	#1\");
		asm(\"ora	(%1),y\");
		asm(\"jne	%3\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 43
;;
;;	ldy	#imm	;; mv_indrximm_r_16	clc
;;	lda	(rx),y				ldy	#imm
;;	sta	ry				lda	(rx),y
;;	iny					adc	op
;;	lda	(rx),y				sta	(rx),y
;;	sta	ry+1				iny
;;						lda	(rx),y
;;	clc		;; addhi3		adc	op+1
;;	lda	ry				sta	(rx),y
;;	adc	op
;;	sta	ry
;;	lda	ry+1
;;	adc	op+1
;;	sta	ry+1
;;
;;	lda	ry	;; mv_r_indrximm_16
;;	ldy	#imm
;;	sta	(rx),y
;;	lda	ry+1
;;	iny
;;	sta	(rx),y
;; If ry is dead

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(match_dup 0)
			(plus:HI	(match_dup 0)
					(match_operand:HI 3 "md_gen_op" "g")
			)
		)
		(set	(mem:HI (plus:HI	(match_dup 1)
						(match_dup 2)
				)
			)
			(match_dup 0)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 254)
		)
	"
	"*{
		asm(\"clc		;; peep 43\");
		asm(\"ldy	#%2\");
		asm(\"lda	(%1),y\");
		asm(\"adc	%L3\");
		asm(\"sta	(%1),y\");
		asm(\"iny\");
		asm(\"lda	(%1),y\");
		if (md_need_y(operands[3])) {
			asm(\"phy\");
			asm(\"ldy	#1\");
			asm(\"adc	%H3\");
			asm(\"ply\");
		}
		else {
			asm(\"adc	%H3\");
		}
		asm(\"sta	(%1),y\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 44
;;
;;	ldy	#imm	;; mv_indrximm_r_16	sec
;;	lda	(rx),y				ldy	#imm
;;	sta	ry				lda	rz
;;	iny					sbc	(rx),y
;;	lda	(rx),y				sta	ra
;;	sta	ry+1				iny
;;						lda	rz+1
;;	sec		;; subhi3		sbc	(rx),y
;;	lda	rz				sta	ra+1
;;	sbc	ry
;;	sta	ra
;;	lda	rz+1
;;	sbc	ry+1
;;	sta	ra+1

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(match_operand:HI 3 "md_gen_op" "=g")
			(minus:HI	(match_operand:HI 4 "md_gen_op" "g")
					(match_dup 0)
			)
		)
	]
	"	(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 254) &&
			(	(md_dead_or_set_p(insn, operands[0])) ||
				(md_is_reg_dead(next_insn(insn), operands[0]))
			)
		)
	"
	"*{
		int	regs_same = md_are_ops_same_reg(operands[1], operands[3]);

		asm(\"sec		;; peep 44\");
		asm(\"ldy	#%2\");
		asm(\"lda	%L4\");
		asm(\"sbc	(%1),y\");
		if (regs_same) {
			asm(\"tax\");
		}
		else {
			asm(\"sta	%L3\");
		}
		asm(\"iny\");
		if (md_need_y(operands[4])) {
			asm(\"phy\");
			asm(\"ldy	#1\");
			asm(\"lda	%H4\");
			asm(\"ply\");
		}
		else {
			asm(\"lda	%H4\");
		}
		asm(\"sbc	(%1),y\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"sta	%H3\");
		if (regs_same) {
			if (md_need_y(operands[3])) {
				asm(\"txa\");
				asm(\"sta	%L3\");
			}
			else {
				asm(\"stx	%L3\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 45
;;
;;	lda	rx	;; ashlhi3		lda	rx
;;	asl					asl
;;	sta	ry				tay
;;	lda	rx+1				lda	rx+1
;;	rol					rol
;;	sta	ry+1				tax
;;						clc
;;	clc		;; addhi3		tya
;;	lda	ry				adc	rz
;;	adc	rz				sta	ry
;;	sta	ry				txa
;;	lda	ry+1				adc	rz+1
;;	adc	rz+1				sta	ry+1
;;	sta	ry+1

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(ashift:HI	(match_operand:HI 1 "md_gpr_op" "r")
					(match_operand 2 "md_int_1_op" "")
			)
		)
		(set	(match_dup 0)
			(plus:HI	(match_dup 0)
					(match_operand:HI 3 "md_gen_op" "g")
			)
		)
	]
	""
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"asl		;; peep 45\");
			asm(\"tay\");
			asm(\"txa\");
		}
		else {
			asm(\"lda	%L1	;; peep 45\");
			asm(\"asl\");
			asm(\"tay\");
			asm(\"lda	%H1\");
		}
		asm(\"rol\");
		asm(\"tax\");
		asm(\"clc\");
		asm(\"tya\");
		asm(\"adc	%L3\");
		asm(\"sta	%L0\");
		asm(\"txa\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"adc	%H3\");
		asm(\"sta	%H0\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 46
;;
;;	ldy	#imm	;; mv_indrximm_r_16	ldy	#imm
;;	lda	(rx),y				lda	(rx),y
;;	sta	ry				iny
;;	iny					ora	(rx),y
;;	lda	(rx),y				jeq	lab
;;	sta	ry+1
;;
;;	lda	ry	;; jeq_16 ry, 0, lab
;;	ora	ry+1
;;	jeq	lab
;; If ry is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand:HI 3 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(eq (cc0) (const_int 0))
					(label_ref (match_operand 4 "" ""))
					(pc)
			)
		)
	]
	"	(	(md_dead_or_set_p(previous_insn(insn), operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 254)
		)
	"
	"*{
		asm(\"ldy	#%2	;; peep 46\");
		asm(\"lda	(%1),y\");
		asm(\"iny\");
		asm(\"ora	(%1),y\");
		asm(\"jeq	%4\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 47
;;
;;	ldy	#imm	;; mv_indrximm_r_16	ldy	#imm
;;	lda	(rx),y				lda	(rx),y
;;	sta	ry				iny
;;	iny					ora	(rx),y
;;	lda	(rx),y				jne	lab
;;	sta	ry+1
;;
;;	lda	ry	;; jne_16 ry, 0, lab
;;	ora	ry+1
;;	jne	lab
;; If ry is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand:HI 3 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(ne (cc0) (const_int 0))
					(label_ref (match_operand 4 "" ""))
					(pc)
			)
		)
	]
	"	(	(md_dead_or_set_p(previous_insn(insn), operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 254)
		)
	"
	"*{
		asm(\"ldy	#%2	;; peep 47\");
		asm(\"lda	(%1),y\");
		asm(\"iny\");
		asm(\"ora	(%1),y\");
		asm(\"jne	%4\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 48
;;
;;	lda	rx	;; lshrsi3		lda	rx+2
;;	ldx	rx+1				asl
;;	ldy	#23				rol
;;	sty	t				and	#1
;;	ldy	rx+2				sta	ry
;;	jsr	__lsr24				stz	ry+1
;;	sta	ry				stz	ry+2
;;	stx	ry+1
;;	sty	ry+2

(define_peephole
	[	(set	(match_operand:SI 0 "md_gen_op" "=g")
			(lshiftrt:SI	(match_operand:SI 1 "md_gen_op" "g")
					(match_operand 2 "const_int_operand" "")
			)
		)
	]
	"(INTVAL(operands[2]) == 23)"
	"*{
		int	y = 0;

		if (!md_is_axy(operands[1])) {
			if (md_need_y(operands[1])) {
				asm(\"ldy	#2	;; peep 48\");
				y = 2;
				asm(\"lda	%B1\");
			}
			else {
				asm(\"lda	%B1	;; peep 48\");
			}
			asm(\"asl\");
		}
		else {
			asm(\"asl		;; peep 48\");
		}
		asm(\"rol\");
		asm(\"and	#1\");
		asm(\"sta	%L0\");
		if (md_need_y(operands[0])) {
			if (y == 2) {
				asm(\"dey\");
			}
			else {
				asm(\"ldy	#1\");
			}
			asm(\"lda	#0\");
			asm(\"sta	%H0\");
			asm(\"sta	%B0\");
		}
		else {
			asm(\"stz	%H0\");
			asm(\"stz	%B0\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 49
;;
;;	clc		;; addhi3		lda	op
;;	lda	op				bne	.l1
;;	adc	#low -1				dec	op+1
;;	sta	op			.l1	dec	op
;;	lda	op+1
;;	adc	#high -1
;;	sta	op+1

(define_peephole
	[	(set	(match_operand:HI 0 "md_gen_op" "=g")
			(plus:HI	(match_dup 0)
					(match_operand 1 "const_int_operand" "")
			)
		)
	]
	"	(	((INTVAL(operands[1]) & 0xFFFF) == 0xFFFF) &&
			(!md_need_y(operands[0]))
		)
	"
	"*{
		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L0	;; peep 49\");
		}
		else {
			asm(\"tay		;; peep 49\");
		}
		md_new_label();
		asm(\"bne	%@\");
		asm(\"dec	%H0\");
		md_output_md_label(md_labelnum);
		asm(\"dec	%L0\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 50
;;
;;	lda	op	;; mv_8			lda	op
;;	sta	rx				ldy	#imm
;;						sta	(ry),y
;;	lda	rx	;; mv_r_indrximm_8
;;	ldy	#imm
;;	sta	(ry),y
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:QI 0 "md_gpr_op" "=r")
			(match_operand:QI 1 "md_gen_imm_op" "g")
		)
		(set	(mem:QI (plus:HI	(match_operand:HI 2 "md_gpr_op" "r")
						(match_operand 3 "const_int_operand" "")
				)
			)
			(match_dup 0)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(INTVAL(operands[3]) >= 0) &&
			(INTVAL(operands[3]) < 256)
		)
	"
	"*{
		if (!md_is_axy(operands[0])) {
			asm(\"lda	%L1	;; peep 50\");
			asm(\"ldy	#%3\");
		}
		else {
			asm(\"ldy	#%3	;; peep 50\");
		}
		asm(\"sta	(%2),y\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 51
;;
;;	lda	op1	;; zx8_16		ldx	op1
;;	sta	rx				lda	op3
;;	stz	rx+1				sta	op2,x
;;
;;	lda	#low op2  ;; mv_addr
;;	sta	ry
;;	ldx	#high op2
;;	stx	ry+1
;;
;;	clc		;; mv_r_indrxr_8
;;	adc	rx
;;	sta	t
;;	txa	
;;	adc	rx+1
;;	sta	t+1
;;	lda	op3
;;	sta	(t),0
;; If rx and ry are dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:HI 2 "md_gpr_op" "=r")
			(match_operand:HI 3 "md_addr_op" "")
		)
		(set	(mem:QI	(plus:HI	(match_dup 0)
						(match_dup 2)
				)
			)
			(match_operand:QI 4 "md_gen_imm_op" "g")
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(md_dead_or_set_p(insn, operands[2])) ||
			(md_is_reg_dead(next_insn(insn), operands[2]))
		)
	"
	"*{
		if (!md_is_axy(operands[1])) {
			if (md_need_y(operands[1])) {
				asm(\"lda	%L1	;; peep 51\");
				asm(\"tax\");
			}
			else {
				asm(\"ldx	%L1	;; peep 51\");
			}
		}
		else {
			asm(\"tax		;; peep 51\");
		}
		if (md_is_zero(operands[4])) {
			asm(\"stz	%3,x\");
		}
		else {
			asm(\"lda	%L4\");
			asm(\"sta	%3,x\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 52
;;
;;	lda	op1	;; zx8_16		ldy	op1
;;	sta	rx				lda	op2
;;	stz	rx+1				sta	(ry),y
;;
;;	clc		;; mv_r_indrxr_8
;;	lda	rx
;;	adc	ry
;;	sta	t
;;	lda	rx+1
;;	adc	ry+1
;;	sta	t+1
;;	lda	op2
;;	sta	(t),0
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 2 "md_gpr_op" "r")
				)
			)
			(match_operand:QI 3 "md_gen_imm_op" "g")
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		if (!md_is_axy(operands[1])) {
			if (md_need_y(operands[1])) {
				asm(\"lda	%L1	;; peep 52\");
				asm(\"tay\");
			}
			else {
				asm(\"ldy	%L1	;; peep 52\");
			}
		}
		else {
			asm(\"tay		;; peep 52\");
		}
		asm(\"lda	%L3\");
		asm(\"sta	(%2),y\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 53
;;
;;	ldy	#imm1	;; mv_indrximm_r_8	ldy	#imm1
;;	lda	(rx),y				lda	(rx),y
;;	sta	ry				and	#low imm2
;;						jne	lab
;;	and	#low imm2	;; andqi3
;;	sta	ry
;;
;;	tay		;; jne_8 ry, 0, L74
;;	jne	lab
;; If ry is dead.

(define_peephole
	[	(set	(match_operand:QI 0 "md_gpr_op" "=r")
			(mem:QI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(match_dup 0)
			(and:QI	(match_dup 0)
				(match_operand:QI 3 "md_gen_imm_op" "g")
			)
		)
		(set	(cc0)
			(compare	(match_dup 0)
					(match_operand 4 "md_int_0_op" "")
			)
		)
		(set	(pc)
			(if_then_else	(ne (cc0) (const_int 0))
					(label_ref (match_operand 5 "" ""))
					(pc)
			)
		)
	]
	"	(	(md_dead_or_set_p(previous_insn(insn), operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 256)
		)
	"
	"*{
		asm(\"ldy	#%2	;; peep 53\");
		asm(\"lda	(%1),y\");
		asm(\"and	%L3\");
		asm(\"jne	%5\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 53b
;;
;;	ldy	#imm1	;; mv_indrximm_r_8	ldy	#imm1
;;	lda	(rx),y				lda	(rx),y
;;	sta	ry				and	#low imm2
;;						jeq	lab
;;	and	#low imm2	;; andqi3
;;	sta	ry
;;
;;	tay		;; jeq_8 ry, 0, L74
;;	jeq	lab
;; If ry is dead.
;;
;; FIXME - doesn't work - md_is_reg_return_value crashes on Sun!!!

;;(define_peephole
;;	[	(set	(match_operand:QI 0 "md_gpr_op" "=r")
;;			(mem:QI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
;;						(match_operand 2 "const_int_operand" "")
;;				)
;;			)
;;		)
;;		(set	(match_dup 0)
;;			(and:QI	(match_dup 0)
;;				(match_operand:QI 3 "md_gen_imm_op" "g")
;;			)
;;		)
;;		(set	(cc0)
;;			(compare	(match_dup 0)
;;					(match_operand 4 "md_int_0_op" "")
;;			)
;;		)
;;		(set	(pc)
;;			(if_then_else	(eq (cc0) (const_int 0))
;;					(label_ref (match_operand 5 "" ""))
;;					(pc)
;;			)
;;		)
;;	]
;;	"	(	(md_dead_or_set_p(previous_insn(insn), operands[0])) ||
;;			(md_is_reg_dead(next_insn(insn), operands[0]))
;;		) &&
;;		(	(INTVAL(operands[2]) >= 0) &&
;;			(INTVAL(operands[2]) < 256)
;;		)
;;	"
;;	"*{
;;		asm(\"ldy	#%2	;; peep 53b\");
;;		asm(\"lda	(%1),y\");
;;		asm(\"and	%L3\");
;;			/* Careful - result might be used as a return value
;;			if we jeq to the return of the function!! */
;;		if (md_is_reg_return_value(operands[0], operands[5])) {
;;			asm(\"sta	%L0\");
;;		}
;;		asm(\"jeq	%5\");
;;		md_forget_axy();
;;		return \"\";
;;	}"
;;)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 54
;;
;;	ldy	#imm	;; mv_indrxr_r_16	ldy	#imm
;;	lda	(rx),y				clc
;;	sta	ry				lda	(rx),y
;;	iny					adc	rz
;;	lda	(rx),y				sta	ry
;;	sta	ry+1				iny
;;						lda	(rx),y
;;	clc		;; addhi3		adc	rz+1
;;	lda	rz				sta	ry+1
;;	adc	ry
;;	sta	ry
;;	lda	rz+1
;;	adc	ry+1
;;	sta	ry+1

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(match_dup 0)
			(plus:HI	(match_operand:HI 3 "md_gen_op" "g")
					(match_dup 0)
			)
		)
	]
	"	(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 256)
		)
	"
	"*{
		int	regs_same = md_are_ops_same_reg(operands[0], operands[1]);

		asm(\"ldy	#%2	;; peep 54\");
		asm(\"clc\");
		asm(\"lda	(%1),y\");
		asm(\"adc	%L3\");
		if (regs_same) {
			asm(\"tax\");
		}
		else {
			asm(\"sta	%L0\");
		}
		asm(\"iny\");
		asm(\"lda	(%1),y\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"adc	%H3\");
		asm(\"sta	%H0\");
		if (regs_same) {
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 55
;;
;;	sec		;; subqi3		sec
;;	lda	op1				lda	op1
;;	sbc	op2				sbc	op2
;;	sta	rx				ina
;;						sta	ry
;;	ina		;; addqi3
;;	sta	ry
;; If rx is dead

(define_peephole
	[	(set	(match_operand:QI 0 "md_gpr_op" "=r")
			(minus:QI	(match_operand:QI 1 "md_gen_op" "g")
					(match_operand:QI 2 "md_gen_imm_op" "g")
			)
		)
		(set	(match_operand:QI 3 "md_gen_op" "=g")
			(plus:QI	(match_dup 0)
					(match_operand:QI 4 "md_int_1_op" "")
			)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		asm(\"sec		;; peep 55\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"sbc	%L2\");
		asm(\"ina\");
		asm(\"sta	%L3\");
		md_remember_axy(operands[3]);
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 56
;;
;;	ldy	#imm	;; mv_indrximm_r_16	ldy	#imm
;;	lda	(rx),y				sec
;;	sta	ry				lda	(rx),y
;;	iny					sbc	rz
;;	lda	(rx),y				sta	(rx),y
;;	sta	ry+1				iny
;;						lda	(rx),y
;;	sec		;; subhi3		sbc	rz+1
;;	lda	ry				sta	(rx),y
;;	sbc	rz
;;	sta	ry
;;	lda	ry+1
;;	sbc	rz+1
;;	sta	ry+1
;;
;;	lda	ry	;; mv_r_indrximm_16
;;	ldy	#15
;;	sta	(rx),y
;;	lda	ry+1
;;	iny
;;	sta	(rx),y
;; If ry is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(match_dup 0)
			(minus:HI	(match_dup 0)
					(match_operand:HI 3 "md_gen_imm_op" "g")
			)
		)
		(set	(mem:HI (plus:HI	(match_dup 1)
						(match_dup 2)
				)
			)
			(match_dup 0)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 256)
		)
	"
	"*{
		asm(\"ldy	#%2	;; peep 56\");
		asm(\"sec\");
		asm(\"lda	(%1),y\");
		asm(\"sbc	%L3\");
		asm(\"sta	(%1),y\");
		asm(\"iny\");
		asm(\"lda	(%1),y\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H3\");
		asm(\"sta	(%1),y\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 57
;;
;;	ldy	#imm	;; mv_indrximm_r_16	ldy	#imm
;;	lda	(rx),y				sec
;;	sta	ry				lda	(rx),y
;;	iny					sbc	rz
;;	lda	(rx),y				sta	(rx),y
;;	sta	ry+1				sta	ry
;;						iny
;;	sec		;; subhi3		lda	(rx),y
;;	lda	ry				sbc	rz+1
;;	sbc	rz				sta	(rx),y
;;	sta	ry				sta	ry+1
;;	lda	ry+1
;;	sbc	rz+1
;;	sta	ry+1
;;
;;	lda	ry	;; mv_r_indrximm_16
;;	ldy	#15
;;	sta	(rx),y
;;	lda	ry+1
;;	iny
;;	sta	(rx),y
;; If ry is not dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(match_dup 0)
			(minus:HI	(match_dup 0)
					(match_operand:HI 3 "md_gen_imm_op" "g")
			)
		)
		(set	(mem:HI (plus:HI	(match_dup 1)
						(match_dup 2)
				)
			)
			(match_dup 0)
		)
	]
	"	(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 256)
		)
	"
	"*{
		int	regs_same = md_are_ops_same_reg(operands[0], operands[1]);

		asm(\"ldy	#%2	;; peep 57\");
		asm(\"sec\");
		asm(\"lda	(%1),y\");
		asm(\"sbc	%L3\");
		asm(\"sta	(%1),y\");
		if (regs_same) {
			asm(\"tax\");
		}
		else {
			asm(\"sta	%L0\");
		}
		asm(\"iny\");
		asm(\"lda	(%1),y\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"sbc	%H3\");
		asm(\"sta	(%1),y\");
		asm(\"sta	%H0\");
		if (regs_same) {
			if (md_need_y(operands[0])) {
				asm(\"txa\");
				asm(\"sta	%L0\");
			}
			else {
				asm(\"stx	%L0\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 60
;;
;;	ldy	#imm	;; mv_indrximm_r_16	ldy	#imm
;;	lda	(rx),y				clc
;;	tax					lda	(rx),y
;;	iny					adc	op1
;;	lda	(rx),y				sta	rz
;;	sta	ry+1				iny
;;	stx	ry				lda	(rx),y
;;						adc	op1+1
;;	clc		;; addhi3		sta	rz+1
;;	lda	ry
;;	adc	op1
;;	sta	rz
;;	lda	ry+1
;;	adc	op1+1
;;	sta	rz+1
;; If ry is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(mem:HI	(plus:HI	(match_operand:HI 1 "md_gpr_op" "r")
						(match_operand 2 "const_int_operand" "")
				)
			)
		)
		(set	(match_operand:HI 3 "md_gpr_op" "=r")
			(plus:HI	(match_dup 0)
					(match_operand:HI 4 "md_gen_sp_op" "gfx")
			)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(INTVAL(operands[2]) >= 0) &&
			(INTVAL(operands[2]) < 256)
		)
	"
	"*{
		int	regs_same = md_are_ops_same_reg(operands[1], operands[3]);
	
		asm(\"ldy	#%2	;; peep 60\");
		asm(\"clc\");
		asm(\"lda	(%1),y\");
		asm(\"adc	%L4\");
		if (regs_same) {
			asm(\"tax\");
		}
		else {
			asm(\"sta	%L3\");
		}
		asm(\"iny\");
		asm(\"lda	(%1),y\");
		if (	(md_need_y(operands[3])) ||
			(md_need_y(operands[4]))
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"adc	%H4\");
		asm(\"sta	%H3\");
		if (regs_same) {
			if (md_need_y(operands[3])) {
				asm(\"txa\");
				asm(\"sta	%L3\");
			}
			else {
				asm(\"stx	%L3\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 63
;;
;;	lda	op1	;; zx8_16		sec
;;	sta	ry				lda	op2
;;	stz	ry+1				sbc	op1
;;						sta	op3
;;	sec		;; subhi3		lda	op2+1
;;	lda	op2				sbc	#0
;;	sbc	ry				sta	op3+1
;;	sta	op3
;;	lda	op2+1
;;	sbc	ry+1
;;	sta	op3+1
;; If ry is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:HI 2 "md_gen_op" "=g")
			(minus:HI	(match_operand:HI 3 "md_gen_op" "g")
					(match_dup 0)
			)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		int	regs_same = md_are_ops_same_reg(operands[2], operands[3]);

		asm(\"sec		;; peep 63\");
		if (!md_is_axy(operands[3])) {
			asm(\"lda	%L3\");
		}
		asm(\"sbc	%L1\");
		if (regs_same) {
			asm(\"tax\");
		}
		else {
			asm(\"sta	%L2\");
		}
		if (	(md_need_y(operands[3])) ||
			(md_need_y(operands[2]))
		   ) {
			asm(\"ldy	#1\");
		}
		asm(\"lda	%H3\");
		asm(\"sbc	#0\");
		asm(\"sta	%H2\");
		if (regs_same) {
			if (md_need_y(operands[2])) {
				asm(\"txa\");
				asm(\"sta	%L2\");
			}
			else {
				asm(\"stx	%L2\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 64
;;
;;	lda	op1	;; mv_16		clc
;;	sta	rx				lda	op1
;;	ldx	op1+1				adc	op2
;;	stx	rx+1				sta	t
;;						lda	op1+1
;;	clc		;; mv_indrxr_r_8	adc	op2+1
;;	adc	op2				sta	t+1
;;	sta	t				lda	(t),0
;;	txa					sta	rx
;;	adc	op2+1
;;	sta	t+1
;;	lda	(t),0
;;	sta	rx

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:QI 2 "md_gpr_op" "=r")
			(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 3 "md_gpr_op" "r")
				)
			)
		)
	]
	"(REGNO(operands[0]) == REGNO(operands[2]))"
	"*{
		asm(\"clc		;; peep 64\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"adc	%L3\");
		asm(\"sta	t\");
		if (md_need_y(operands[1])) {
			asm(\"ldy	#1\");
		}
		if (md_is_axy(operands[1])) {
			asm(\"txa\");
		}
		else {
			asm(\"lda	%H1\");
		}
		asm(\"adc	%H3\");
		asm(\"sta	t+1\");
		asm(\"lda	(t),0\");
		asm(\"sta	%L2\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 65
;;
;;	lda	op1	;; mv_16		clc
;;	sta	rx				lda	op1
;;	ldx	op1+1				adc	ry
;;	stx	rx+1				sta	t
;;						lda	op1+1
;;	clc		;; mv_indrxr_r_8	adc	ry+1
;;	adc	ry				sta	t+1
;;	sta	t				lda	(t),0
;;	txa					sta	op2
;;	adc	ry+1
;;	sta	t+1
;;	lda	(t),0
;;	sta	op2
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:QI 2 "md_gen_op" "=g")
			(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 3 "md_gpr_op" "r")
				)
			)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		asm(\"clc		;; peep 65\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"adc	%L3\");
		asm(\"sta	t\");
		if (md_need_y(operands[1])) {
			asm(\"ldy	#1\");
		}
		if (md_is_axy(operands[1])) {
			asm(\"txa\");
		}
		else {
			asm(\"lda	%H1\");
		}
		asm(\"adc	%H3\");
		asm(\"sta	t+1\");
		asm(\"lda	(t),0\");
		asm(\"sta	%L2\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 66
;;
;;	lda	op1	;; mv_16		clc
;;	sta	rx				lda	op1
;;	ldx	op1+1				adc	op2
;;	stx	rx+1				sta	op3
;;						lda	op1+1
;;	clc		;; addhi3		adc	op2+1
;;	adc	op2				sta	op3+1
;;	sta	op3
;;	txa
;;	adc	op2+1
;;	sta	op3+1
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:HI 2 "md_gen_op" "=g")
			(plus:HI	(match_dup 0)
					(match_operand:HI 3 "md_gen_op" "g")
			)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		int	regs_same =	(	md_are_ops_same_reg(operands[1], operands[2]) ||
						md_are_ops_same_reg(operands[2], operands[3])
					);

		asm(\"clc		;; peep 66\");
		if (!md_is_axy(operands[1])) {
			asm(\"lda	%L1\");
		}
		asm(\"adc	%L3\");
		if (regs_same) {
			asm(\"tax\");
		}
		else {
			asm(\"sta	%L2\");
		}
		if (	(md_need_y(operands[1])) ||
			(md_need_y(operands[2])) ||
			(md_need_y(operands[3]))
		   ) {
			asm(\"ldy	#1\");
		}
		if (md_is_axy(operands[1])) {
			asm(\"txa\");
		}
		else {
			asm(\"lda	%H1\");
		}
		asm(\"adc	%H3\");
		asm(\"sta	%H2\");
		if (regs_same) {
			if (md_need_y(operands[2])) {
				asm(\"txa\");
				asm(\"sta	%L2\");
			}
			else {
				asm(\"stx	%L2\");
			}
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 67
;;
;;	lda	op	;; zx8_16		ldx	op
;;	sta	rx				lda	sym,x
;;	stz	rx+1				inc	op
;;						sta	rx
;;	inc	op	;; addqi3
;;
;;	clc		;; mv_indrxr_r_8
;;	lda	rx
;;	adc	#low sym
;;	sta	t
;;	lda	rx+1
;;	adc	#high sym
;;	sta	t+1
;;	lda	(t),0
;;	sta	rx

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_dup 1)
			(plus:QI	(match_dup 1)
					(match_operand 2 "const_int_operand" "")
			)
		)
		(set	(match_operand:QI 3 "md_gpr_op" "=r")
			(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 4 "md_sym_op" "")
				)
			)
		)
	]
	"	(	(INTVAL(operands[2]) == 1) &&
			(REGNO(operands[0]) == REGNO(operands[3]))
		)
	"
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"tax		;; peep 67\");
		}
		else if (md_need_y(operands[1])) {
			asm(\"lda	%L1	;; peep 67\");
			asm(\"tax\");
		}
		else {
			asm(\"ldx	%L1	;; peep 67\");
		}
		asm(\"lda	%4,x\");
		asm(\"inc	%L1\");
		asm(\"sta	%L3\");
		md_remember_axy(operands[3]);
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 67b
;;
;;	lda	op	;; zx8_16		ldx	op
;;	sta	rx				lda	sym,x
;;	stz	rx+1				inc	op
;;						sta	ry
;;	inc	op	;; addqi3
;;
;;	clc		;; mv_indrxr_r_8
;;	lda	rx
;;	adc	#low sym
;;	sta	t
;;	lda	rx+1
;;	adc	#high sym
;;	sta	t+1
;;	lda	(t),0
;;	sta	ry
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_dup 1)
			(plus:QI	(match_dup 1)
					(match_operand 2 "const_int_operand" "")
			)
		)
		(set	(match_operand:QI 3 "md_gpr_op" "=r")
			(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 4 "md_sym_op" "")
				)
			)
		)
	]
	"	(	(	(md_dead_or_set_p(insn, operands[0])) ||
				(md_is_reg_dead(next_insn(insn), operands[0]))
			) &&
			(INTVAL(operands[2]) == 1)
		)
	"
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"tax		;; peep 67\");
		}
		else if (md_need_y(operands[1])) {
			asm(\"lda	%L1	;; peep 67\");
			asm(\"tax\");
		}
		else {
			asm(\"ldx	%L1	;; peep 67\");
		}
		asm(\"lda	%4,x\");
		asm(\"inc	%L1\");
		asm(\"sta	%L3\");
		md_remember_axy(operands[3]);
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 68
;;
;;	lda	op1	;; zx8_16		lda	#low op2
;;	sta	rx				sta	ry
;;	stz	rx+1				ldx	#high op2
;;						stx	ry+1
;;	lda	#low op2  ;; mv_addr		ldy	op1
;;	sta	ry				lda	rz
;;	ldx	#high op2			sta	(ry),y
;;	stx	ry+1
;;
;;	clc		;; mv_r_indrxr_8
;;	adc	rx
;;	sta	t
;;	txa	
;;	adc	rx+1
;;	sta	t+1
;;	lda	rz
;;	sta	(t),0
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:HI 2 "md_gpr_op" "=r")
			(match_operand:HI 3 "md_addr_op" "")
		)
		(set	(mem:QI	(plus:HI	(match_dup 0)
						(match_dup 2)
				)
			)
			(match_operand:QI 4 "md_gen_imm_op" "g")
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		asm(\"lda	%L3	;; peep 68\");
		asm(\"sta	%L2\");
		asm(\"ldx	%H3\");
		asm(\"stx	%H2\");
		asm(\"ldy	%L1\");
		asm(\"lda	%L4\");
		asm(\"sta	(%2),y\");
		md_remember_axy(operands[4]);
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 69
;;
;;	lda	op	;; zx8_16		ldy	op
;;	sta	rx				lda	#0
;;	stz	rx+1				sta	ry
;;						sta	(rz),y
;;	stz	ry	;; mv_8
;;
;;	clc		;; mv_r_indrxr_8
;;	lda	rx
;;	adc	rz
;;	sta	t
;;	lda	rx+1
;;	adc	rz+1
;;	sta	t+1
;;	lda	ry
;;	sta	(t),0
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:QI 2 "md_gpr_op" "=r")
			(match_operand 3 "md_int_0_op" "")
		)
		(set	(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 4 "md_gpr_op" "r")
				)
			)
			(match_dup 2)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"tay		;; peep 69\");
		}
		else if (md_need_y(operands[1])) {
			asm(\"lda	%L1	;; peep 69\");
			asm(\"tay\");
		}
		else {
			asm(\"ldy	%L1	;; peep 69\");
		}
		asm(\"lda	#0\");
		asm(\"sta	%L2\");
		asm(\"sta	(%4),y\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 69b
;;
;;	lda	op	;; zx8_16		ldy	op
;;	sta	rx				lda	#0
;;	stz	rx+1				sta	(rz),y
;;
;;	stz	ry	;; mv_8
;;
;;	clc		;; mv_r_indrxr_8
;;	lda	rx
;;	adc	rz
;;	sta	t
;;	lda	rx+1
;;	adc	rz+1
;;	sta	t+1
;;	lda	ry
;;	sta	(t),0
;; If rx and ry are dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:QI 2 "md_gpr_op" "=r")
			(match_operand 3 "md_int_0_op" "")
		)
		(set	(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 4 "md_gpr_op" "r")
				)
			)
			(match_dup 2)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		) &&
		(	(md_dead_or_set_p(insn, operands[2])) ||
			(md_is_reg_dead(next_insn(insn), operands[2]))
		)
	"
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"tay		;; peep 69\");
		}
		else if (md_need_y(operands[1])) {
			asm(\"lda	%L1	;; peep 69b\");
			asm(\"tay\");
		}
		else {
			asm(\"ldy	%L1	;; peep 69b\");
		}
		asm(\"lda	#0\");
		asm(\"sta	(%4),y\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 70
;;
;;	lda	op	;; mv_16		lda	op
;;	sta	rx				ldx	op+1
;;	ldx	op+1				jsr	lib_ind_jump
;;	stx	rx+1
;;
;;			;; call_ind
;;	jsr	lib_ind_jump	;; nargs = 0

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(call	(mem:HI (match_dup 0))
			(match_operand 2 "" "") ;; junk number of arg registers
		)
	]
	""
	"*{
		asm(\"lda	%L1	;; peep 70\");
		asm(\"ldx	%H1\");
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 70b
;;
;;	lda	op1	;; mv_16		lda	op2
;;	sta	rx				sta	r0
;;	ldx	op1+1				lda	op1
;;	stx	rx+1				ldx	op1+1
;;						jsr	lib_ind_jump
;;	lda	op2	;; mv_8
;;	sta	r0
;;
;;			;; call_ind
;;	jsr	lib_ind_jump	;; nargs = 0

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:QI 2 "md_gpr_op" "=r")
			(match_operand:QI 3 "md_gen_imm_op" "g")
		)
		(call	(mem:HI (match_dup 0))
			(match_operand 4 "" "") ;; junk number of arg registers
		)
	]
	""
	"*{
		asm(\"lda	%L3	;; peep 70b\");
		asm(\"sta	%L2\");
		asm(\"lda	%L1\");
		asm(\"ldx	%H1\");
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 70c
;;
;;	lda	op1	;; mv_16		lda	op2
;;	sta	rx				sta	r0
;;	ldx	op1+1				lda	op2+1
;;	stx	rx+1				sta	r0+1
;;						sta	op1
;;	lda	op2	;; mv_16		ldx	op1+1
;;	sta	r0				jsr	lib_ind_jump
;;	ldx	op2+1
;;	stx	r0+1
;;
;;			;; call_ind
;;	jsr	lib_ind_jump	;; nargs = 0

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:HI 2 "md_gpr_op" "=r")
			(match_operand:HI 3 "md_gen_imm_op" "g")
		)
		(call	(mem:HI (match_dup 0))
			(match_operand 4 "" "") ;; junk number of arg registers
		)
	]
	""
	"*{
		asm(\"lda	%L3	;; peep 70c\");
		asm(\"sta	%L2\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"lda	%H3\");
		asm(\"sta	%H2\");
		asm(\"lda	%L1\");
		asm(\"ldx	%H1\");
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 70d
;;
;;	lda	op1	;; mv_16		lda	op2
;;	sta	rx				sta	r0
;;	ldx	op1+1				lda	op2+1
;;	stx	rx+1				sta	r0+1
;;						lda	op2+2
;;	lda	op2	;; mv_24		sta	r0+2
;;	sta	r0				lda	op1+1
;;	ldx	op2+1				ldx	op1+1
;;	stx	r0+1				jsr	lib_ind_jump
;;	lda	op2+2
;;	sta	r0+2
;;
;;			;; call_ind
;;	jsr	lib_ind_jump	;; nargs = 0

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:SI 2 "md_gpr_op" "=r")
			(match_operand:SI 3 "md_gen_imm_op" "g")
		)
		(call	(mem:HI (match_dup 0))
			(match_operand 4 "" "") ;; junk number of arg registers
		)
	]
	""
	"*{
		asm(\"lda	%L3	;; peep 70d\");
		asm(\"sta	%L2\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"lda	%H3\");
		asm(\"sta	%H2\");
		if (md_need_y(operands[3])) {
			asm(\"iny\");
		}
		asm(\"lda	%B3\");
		asm(\"sta	%B2\");
		asm(\"lda	%L1\");
		asm(\"ldx	%H1\");
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 71
;;
;;	lda	op	;; mv_16		lda	op
;;	sta	rx				ldx	op+1
;;	ldx	op+1				jsr	lib_ind_jump
;;	stx	rx+1
;;
;;			;; call_value_ind
;;	jsr	lib_ind_jump	;; nargs = 0

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand 2 "md_gpr_op" "=r")
			(call	(mem:HI (match_dup 0))
				(match_operand 3 "" "")
			)
		)
	]
	""
	"*{
		asm(\"lda	%L1	;; peep 71\");
		asm(\"ldx	%H1\");
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 71b
;;
;;	lda	op1	;; mv_16		lda	op2
;;	sta	rx				sta	r0
;;	ldx	op1+1				lda	op1
;;	stx	rx+1				ldx	op1+1
;;						jsr	lib_ind_jump
;;	lda	op2	;; mv_8
;;	sta	r0
;;
;;			;; call_value_ind
;;	jsr	lib_ind_jump	;; nargs = 0

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:QI 2 "md_gpr_op" "=r")
			(match_operand:QI 3 "md_gen_imm_op" "g")
		)
		(set	(match_operand 4 "md_gpr_op" "=r")
			(call	(mem:HI (match_dup 0))
				(match_operand 5 "" "")
			)
		)
	]
	""
	"*{
		asm(\"lda	%L3	;; peep 71b\");
		asm(\"sta	%L2\");
		asm(\"lda	%L1\");
		asm(\"ldx	%H1\");
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 71c
;;
;;	lda	op1	;; mv_16		lda	op2
;;	sta	rx				sta	r0
;;	ldx	op1+1				lda	op2+1
;;	stx	rx+1				sta	r0+1
;;						lda	op1
;;	lda	op2	;; mv_16		ldx	op1+1
;;	sta	r0				jsr	lib_ind_jump
;;	lda	op2+1
;;	sta	r0+1
;;
;;			;; call_value_ind
;;	jsr	lib_ind_jump	;; nargs = 0

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:HI 2 "md_gpr_op" "=r")
			(match_operand:HI 3 "md_gen_imm_op" "g")
		)
		(set	(match_operand 4 "md_gpr_op" "=r")
			(call	(mem:HI (match_dup 0))
				(match_operand 5 "" "")
			)
		)
	]
	""
	"*{
		asm(\"lda	%L3	;; peep 71c\");
		asm(\"sta	%L2\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"lda	%H3\");
		asm(\"sta	%H2\");
		asm(\"lda	%L1\");
		asm(\"ldx	%H1\");
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 71d
;;
;;	lda	op1	;; mv_16		lda	op2
;;	sta	rx				sta	r0
;;	ldx	op1+1				lda	op2+1
;;	stx	rx+1				sta	r0+1
;;						lda	op2+2
;;	lda	op2	;; mv_24		sta	r0+2
;;	sta	r0				lda	op1
;;	lda	op2+1				ldx	op1+1
;;	sta	r0+1				jsr	lib_ind_jump
;;	lda	op2+2
;;	sta	r0+2
;;
;;			;; call_value_ind
;;	jsr	lib_ind_jump	;; nargs = 0

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_operand:SI 2 "md_gpr_op" "=r")
			(match_operand:SI 3 "md_gen_imm_op" "g")
		)
		(set	(match_operand 4 "md_gpr_op" "=r")
			(call	(mem:HI (match_dup 0))
				(match_operand 5 "" "")
			)
		)
	]
	""
	"*{
		asm(\"lda	%L3	;; peep 71d\");
		asm(\"sta	%L2\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"lda	%H3\");
		asm(\"sta	%H2\");
		if (md_need_y(operands[3])) {
			asm(\"iny\");
		}
		asm(\"lda	%B3\");
		asm(\"sta	%B2\");
		asm(\"lda	%L1\");
		asm(\"ldx	%H1\");
		if (md_is_tail_call(insn)) {
			asm(\"jmp	lib_ind_jump	;; nargs = %2\");
		}
		else {
			asm(\"jsr	lib_ind_jump	;; nargs = %2\");
		}
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 72
;;
;;	lda	op1	;; zx8_16		ldx	op1
;;	sta	rx				lda	sym,x
;;	stz	rx+1				sta	ry
;;
;; WARNING: using 8 bit index
;;	ldx	rx	;; mv_indrxr_r_8
;;	lda	sym,x
;;	sta	ry
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(match_operand:QI 2 "md_gpr_op" "=r")
			(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 3 "md_sym_op" "")
						
						
				)
			)
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0])) ||
			(REGNO(operands[0]) == REGNO(operands[2]))
		)
	"
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"tax		;; peep 72\");
		}
		else {
			asm(\"ldx	%L1	;; peep 72\");
		}
		asm(\"lda	%3,x\");
		asm(\"sta	%L2\");
		md_remember_axy(operands[2]);
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 73
;;
;;	lda	op1	;; zx8_16		ldx	op1
;;	sta	rx				lda	op2
;;	stz	rx+1				sta	op3,x
;;
;; WARNING: using 8 bit index
;;	ldx	rx	;; mv_r_indrxr_8
;;	lda	op2
;;	sta	sym,x
;; If rx is dead.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(zero_extend:HI (match_operand:QI 1 "md_gen_op" "g"))
		)
		(set	(mem:QI	(plus:HI	(match_dup 0)
						(match_operand:HI 2 "md_sym_op" "")
				)
			)
			(match_operand:QI 3 "md_gen_imm_op" "g")
		)
	]
	"	(	(md_dead_or_set_p(insn, operands[0])) ||
			(md_is_reg_dead(next_insn(insn), operands[0]))
		)
	"
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"tax		;; peep 73\");
		}
		else {
			asm(\"ldx	%L1	;; peep 73\");
		}
		asm(\"lda	%L3\");
		asm(\"sta	%2,x\");
		md_remember_axy(operands[3]);
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 74
;;
;;	lda	op1	;; mv_16		lda	op1
;;	sta	rx				sta	rx
;;	ldx	op1+1				lda	op1+1
;;	stx	rx+1				sta	rx+1
;;						lda	(rx),0
;;	ina		;; addhi3		sta	rx
;;	bne	.l4				inc	op1
;;	inx					bne	.l4
;; .l4						inc	op1+1
;;	sta	op1			.l4
;;	stx	op1+1
;;
;;	lda	(rx),0	;; mv_8
;;	sta	rx

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(match_operand:HI 1 "md_gen_imm_op" "g")
		)
		(set	(match_dup 1)
			(plus:HI	(match_dup 0)
					(match_operand:HI 2 "md_int_1_op" "")
			)
		)
		(set	(match_operand:QI 3 "md_gen_op" "=g")
			(match_operand:QI 4 "md_gen_op" "")
		)
	]
	"	(	(md_are_ops_same_reg(operands[0], operands[4])) &&
			(md_are_ops_same_reg(operands[3], operands[4]))
		) &&
		(md_gpr_ind_op(operands[4])) &&
		(!md_need_y(operands[1]))
	"
	"*{
		if (md_is_axy(operands[1])) {
			asm(\"sta	%L0	;; peep 74\");
			asm(\"stx	%H0\");
		}
		else {
			asm(\"lda	%L1	;; peep 74\");
			asm(\"sta	%L0\");
			asm(\"lda	%H1\");
			asm(\"sta	%H0\");
		}
		asm(\"lda	%L4\");
		asm(\"sta	%L3\");
		asm(\"inc	%L1\");
		md_new_label();
		asm(\"bne	%@\");
		asm(\"inc	%H1\");
		md_output_md_label(md_labelnum);
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 75
;;
;;	lda	op1	;; ashlhi3		lda	op1
;;	asl					asl
;;	sta	rx				tax
;;	lda	op1+1				lda	op2
;;	rol					sta	sym,x
;;	sta	rx+1				lda	op2+1
;;						sta	sym+1,x
;; WARNING: using 8 bit index
;;	ldy	rx	;; mv_r_indrxr_16
;;	lda	op2
;;	sta	sym,y
;;	lda	op2+1
;;	sta	sym+1,y
;; If rx dead and !TARGET_16BITX.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(ashift:HI	(match_operand:HI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_int_1_op" "")
			)
		)
		(set	(mem:HI	(plus:HI	(match_dup 0)
						(match_operand:HI 3 "md_sym_op" "")
				)
			)
			(match_operand:HI 4 "md_gen_imm_op" "g")
		)
	]
	"	(	(!TARGET_16BITX) &&
			(	(md_dead_or_set_p(insn, operands[0])) ||
				(md_is_reg_dead(next_insn(insn), operands[0]))
			)
		)
	"
	"*{
		md_output_warning(\"using 7 bit index\");
		if (md_is_axy(operands[1])) {
			asm(\"asl		;; peep 75\");
		}
		else {
			asm(\"lda	%L1	;; peep 75\");
			asm(\"asl\");
		}
		asm(\"tax\");
		asm(\"lda	%L4\");
		asm(\"sta	%3,x\");
		asm(\"lda	%H4\");
		asm(\"sta	%3+1,x\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;	Original				Peephole 76
;;
;;	lda	op1	;; ashlhi3		lda	op1
;;	asl					asl
;;	sta	rx				tax
;;	lda	op1+1				lda	sym,x
;;	rol					sta	op2
;;	sta	rx+1				lda	sym+1,x
;;						sta	op2+1
;; WARNING: using 8 bit index
;;	ldx	rx	;; mv_indrxr_r_16
;;	lda	sym,x
;;	sta	op2
;;	lda	sym+1,x
;;	sta	op2+1
;; If rx dead and !TARGET_16BITX.

(define_peephole
	[	(set	(match_operand:HI 0 "md_gpr_op" "=r")
			(ashift:HI	(match_operand:HI 1 "md_gen_op" "g")
					(match_operand:SI 2 "md_int_1_op" "")
			)
		)
		(set	(match_operand:HI 3 "md_gen_op" "=g")
			(mem:HI	(plus:HI	(match_dup 0)
						(match_operand:HI 4 "md_sym_op" "")
				)
			)
		)
	]
	"	(	(!TARGET_16BITX) &&
			(	(md_dead_or_set_p(insn, operands[0])) ||
				(md_is_reg_dead(next_insn(insn), operands[0]))
			)
		)
	"
	"*{
		md_output_warning(\"using 7 bit index\");
		if (md_is_axy(operands[1])) {
			asm(\"asl		;; peep 76\");
		}
		else {
			asm(\"lda	%L1	;; peep 76\");
			asm(\"asl\");
		}
		asm(\"tax\");
		asm(\"lda	%4,x\");
		asm(\"sta	%L3\");
		asm(\"lda	%4+1,x\");
		if (md_need_y(operands[3])) {
			asm(\"ldy	#1\");
		}
		asm(\"sta	%H3\");
		md_forget_axy();
		return \"\";
	}"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

