#ifndef	TM_PROTOS_H
#define	TM_PROTOS_H

extern int md_labelnum;
extern char md_call_name[];
void	md_output_label(FILE *file, char *name);
void	md_make_label(int labelnum);
void	md_remember_axy(rtx reg);
extern	rtx	axy_rtx;

extern	int	md_saw_return;

#ifdef __MWERKS__

int	md_movmm(rtx *operands, enum machine_mode mode);
int	md_gen_op(rtx op, enum machine_mode mode);
int	md_gen_imm_op(rtx op, enum machine_mode mode);
int	md_gen_sp_op(rtx op, enum machine_mode mode);
int	md_gpr_op(rtx op, enum machine_mode mode);
int	md_mem_op(rtx op, enum machine_mode mode);
int	md_imm_op(rtx op, enum machine_mode mode);

int	md_gpr_mem_op(rtx op, enum machine_mode mode);
int	md_sp_op(rtx op, enum machine_mode mode);
int	md_gpr_imm_op(rtx op, enum machine_mode mode);
int	md_gpr_sp_op(rtx op, enum machine_mode mode);
int	md_sp_ind_op(rtx op, enum machine_mode mode);
int	md_sp_off_op(rtx op, enum machine_mode mode);
int	md_addr_op(rtx op, enum machine_mode mode);
int	md_sym_op(rtx op, enum machine_mode mode);

int	md_call_op(rtx op, enum machine_mode mode);

int	md_int_0_op(rtx op, enum machine_mode mode);
int	md_int_1_op(rtx op, enum machine_mode mode);
int	md_int_3_op(rtx op, enum machine_mode mode);
int	md_gpr_ind_op(rtx op);
int	md_is_zero(rtx op);
int	md_is_low_zero(rtx op);
int	md_is_high_zero(rtx op);
int	md_is_bank_zero(rtx op);
int	md_are_high_low_same(rtx op);
int	md_are_bank_high_same(rtx op);
int	md_need_y(rtx op);

void	md_output_ascii(FILE *file, char *p, int len);
void	md_output_function_epilogue (FILE *file, int size);
void	md_output_function_prologue (FILE *file, int size);
int	md_first_parm_offset(tree fundecl);
void	md_print_operand (FILE *file, rtx x, int code);
void	md_print_operand_address(FILE *file, rtx addr);

void	md_init(void);
void	md_increment_profiler_label(FILE *file, int labelno);
void	md_block_profiler_init(FILE *file, int labelno);
void	md_block_profiler_increment(FILE *, int blockno);
void	md_output_trampoline_template(FILE *file);
void	md_initialize_trampoline (rtx tramp, rtx fnaddr, rtx cxt);
rtx	md_builtin_saveregs (tree arglist);
unsigned long	md_compute_frame_size (int size);
unsigned long	md_compute_frame_pointer_offset (void);

void	md_declare_function_name(FILE *file, char *name, tree decl);
void	md_file_start(FILE * file);
void	md_identify_gcc(FILE * file);
void	md_output_source_line(FILE *file, int lineno);
void	md_output_label(FILE *file, char *name);
void	md_globalize_label(FILE *file, char *name);
void	md_output_external(FILE *file, tree decl, char *name);
void	md_output_labelref(FILE *file, char *name);
void	md_output_internal_label(FILE *file, char *prefix, int num);
void	md_generate_internal_label(char *label, char *prefix, int num);
void	md_output_int(FILE *file, rtx value);
void	md_output_short(FILE *file, rtx value);
void	md_output_char(FILE *file, rtx value);
void	md_output_byte(FILE *file, int value);
void	md_output_addr_vec_elt(FILE *file, int value);
void	md_output_skip(FILE *file, int size);
void	md_output_common(FILE *file, char *name, int size, int rounded);
void	md_output_local(FILE *file, char *name, int size, int rounded);
char	*md_text_section_asm_op(void);
char	*md_data_section_asm_op(void);
void	md_encode_section_info(tree decl);

int	md_caller_save_profitable(int refs, int calls);
int	md_address_cost(rtx addr);
int	md_rtx_costs(rtx x, enum rtx_code code, enum rtx_code outer_code);
int	md_register_move_cost(int class1, int class2);
int	md_memory_move_cost(enum machine_mode mode);
int	md_move_ratio(void);

int	md_is_reg_dead(rtx insn, rtx reg);
int	md_dead_or_set_p(rtx insn, rtx reg);
int	md_is_tail_call(rtx insn);
int	md_was_tail_call(rtx insn);
int	md_use_return(void);
int	md_new_label(void);
void	md_make_label(int labelnum);
void	md_output_md_label(int labelnum);
void	md_output_warning(char *warning);

void	md_mv_m_m(rtx src, rtx dest, int size, char *cmt);
void	md_mv_imm_m(rtx src, rtx dest, int size, char *cmt);
void	md_mv_r_t_16(rtx src, char *cmt);
void	md_mv_r_t_24(rtx src, char *cmt);

rtx	md_legitimize_address(rtx x, rtx oldx, enum machine_mode mode);
int	md_go_if_legitimate_address(rtx addr, enum machine_mode mode);

extern	char	md_call_name[];
extern	char	md_comment[];
extern	char	md_label[];
extern	int	md_labelnum;

void	md_remember_axy(rtx op);
void	md_forget_axy(void);
int	md_is_axy(rtx op);

int	md_is_reg_return_value(rtx reg, rtx jmp_label);
int	md_are_ops_same_reg(rtx op1, rtx op2);

#endif	/* __MWERKS__ */

typedef enum {
	OP_GPR,
	OP_GPR_IND,
	OP_ZP_IND,
	OP_MEM,
	OP_SP,
	OP_SP_OFF,
	OP_ADDR,
	OP_IMM,
	OP_NONE
} OP_TYPE;

OP_TYPE	md_get_op_type(rtx op);

int	md_is_symbol_zp(char *name);
int	md_is_func_noregs(rtx call_insn);
int	md_is_func_nowrap(char *name);
int	md_is_zp_op(rtx op);

#endif	/* TM_PROTOS_H */
