/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Strings
 */

#include <stdio.h>

#include "core.h"
#include "strings.h"

/*
 * Constants
 */

/* Copyright message */
char psInfo[] = "\n"
"ACME - the ACME Crossassembler for Multiple Environments\n"
"Release 0.85 alpha (\"Roosta\"), 3 Jul 2001\n"
"Copyright (C) 1998-2001 Marco Baye\n\n"
"Dedicated to the wisest being I ever had the pleasure of reading\n"
"books of (currently spending some time dead for tax reasons).\n\n"
PLATFORM_VERSION
"ACME comes with ABSOLUTELY NO WARRANTY; for details read the help file.\n"
"This is free software, and you are welcome to redistribute it under\n"
"certain conditions; as outlined in the GNU General Public License.\n\n"
"Syntax: acme [options] [file]\n\n"
"Options:\n"
"-v<digit>       Set verbosity level.\n"
"-h              Help. Show this message.\n"
PORT_SWITCHES
"\n";

/* Exception messages during assembly */
char Exception_MissingString[] = "No string given.";
char Exception_NeedValue[] = "Value not yet defined.";
char Exception_NoMemLeft[] = "Out of memory.";
char Exception_NoPC[] = "Program counter is unset.";
char Exception_NotYet[] = "Sorry, feature not yet implemented.";
char Exception_OffsetOn[] = "Offset assembly still active at end of segment. Switched it off.";
char Exception_Syntax[] = "Syntax error.";
char Exception_TooBig[] = "Number out of range.";
char Exception_TooDeep[] = "Recursion too deep.";
char Exception_TooLong[] = "String too long.";
char Exception_WrongCPU[] = "Chosen CPU does not support this command and/or addressing mode.";

/* Exception messages for block routines */
char Exception_eEndOfFile[] = "End of file expected.";


/* Other messages */
char psvSegment[] = "Segment size is %d ($%x) bytes ($%x - $%x exclusive).\n";

/* Other strings */
char psUntitled[] = "<untitled>";

/*
 * Convert string to lowercase
 * (not quite right this way, but is only used for keywords anyway)
 */
void MiscString_ToLower() {
  byte b;
  byte *p = MiscString;

  while((b = *p)) {
    *(p++) = b |= 32;
  }
}

/*
 * Show copyright and usage message if not already shown
 */
void String_ShowInfo() {
  if((Process_Flags & FPROGRAM_INFOSHOWN) == 0) {
    Process_Flags |= FPROGRAM_INFOSHOWN;
    printf(psInfo);
  }
}

/*
 * Show start and end of current segment
 */
void String_EndSegment() {
  if(PC_Mem != CPU_PC) ThrowWarning(Exception_OffsetOn);
  if(Pass_Flags & PASS_ISFIRST) {
    Segment_Link(SegmentStart, PC_Mem-SegmentStart);
    if(Process_Verbosity > 1) {
      printf(psvSegment, PC_Mem-SegmentStart, PC_Mem-SegmentStart, SegmentStart, PC_Mem);
    }
  }
}
