/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Stream stuff
 */

#ifndef stream_H
#define stream_H

#include <stdio.h>

/*
 * Constants
 */

/* Byte sources */
enum {
  BYTESOURCE_FILE,
  BYTESOURCE_RAM
};

typedef struct file file;
struct file {
  file* Next;/* pointer to next file structure */
  FILE* FileHandle;/* file descriptor of this file */
};

extern char FILE_READBINARY[];
extern char FILE_WRITEBINARY[];
extern char FILE_WRITETEXT[];

/*
 * Variables
 */

extern byte  pPathname[];/* universal file name */
extern char* psLibPath;/* Pointer to header string of library tree */
extern byte  QuoteChar;/* Current quoting character */
#define NO_QUOTE_CHAR   0
extern file* FileList;/* pointer to linked list of file structures */

/*
 * Prototypes
 */

byte  Stream_ConvertNL(void);
byte  Stream_GetRawByte(void);
byte  GetByte(void);
int   Stream_ReadKeyword(byte*, int);
int   Stream_ReadFilename(byte*, int, int);
int   Stream_FinishQuoted(byte*, int, int);
int   Stream_Comma(void);
FILE* File_OpenFile(byte*, char*);
void  File_CloseFile(FILE*);
void  File_CloseAll(void);

#endif
