/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_H
#define platform_H

/*
 * Platform specific stuff (in this case, for RISC OS)
 */

typedef signed long value;/* At least 32 bit */

#define PLATFORM_VERSION "Ported to RISC OS by Marco Baye.\n"

#define PORT_SWITCHES \
"-t              Use throwback protocol of DDEUtils module.\n"

/* Integer-to-character conversion routine */
#define PLATFORM_INT2BYTE(x)    \
  x ^= x >> 16;                 \
  x ^= x >>  8;                 \
  x &= 255

/* Closedown sequence */
#define PLATFORM_EXIT   RISC_OS_Exit()

/* Convert UNIX-style pathname to system-style pathname */
#define PLATFORM_CONVERTPATH(a) RISC_OS_ConvertPath(a)

/* Platform specific message output */
#define PLATFORM_WARNING(a)     RISC_OS_Throwback(a, 0)
#define PLATFORM_ERROR(a)       RISC_OS_Throwback(a, 1)
#define PLATFORM_SERIOUS(a)     RISC_OS_Throwback(a, 2)
/* 0, 1 and 2 are the matching DDEUtils message type values */

/* Maximum length of filenames in sources */
#define LNFMAX          255

/* Maximum length of paths */
#define LNPMAX          255

/* Setting the created files' types */
#define PLATFORM_SETFILETYPE(a, b)      RISC_OS_SetType(a, b);

/* Platform specific command line switches */
#define PLATFORM_SWITCHCODE     \
  case 't':                     \
  ffPlatform |= FUSETHROWBACK;  \
  break;

/* File types used */
#define FILETYPE_CBM    0x064
#define FILETYPE_PLAIN  0xffd
#define FILETYPE_TEXT   0xfff

/* Bitflags for "ffPlatform" */
extern int ffPlatform;/* Holds platform-specific flags */
/* If set, use throwback protocol */
#define FUSETHROWBACK   (1u << 0)
/* If set, throwback is active */
#define FTHROWBACKON    (1u << 1)

/* SWIs */
#define  OS_FILE                        0x00008
#define XDDEUTILS_THROWBACKEND          0x62589
#define XDDEUTILS_THROWBACKSEND         0x62588
#define XDDEUTILS_THROWBACKSTART        0x62587

/*
 * Prototypes
 */

void _kernel_swi(int, int[], int[]);
void Platform_FindLib(void);
void RISC_OS_ConvertPath(byte*);
void RISC_OS_SetType(byte*, int);
void RISC_OS_Throwback(byte*, int);
void RISC_OS_Exit(void);

#endif
