/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_C
#define platform_C

/*
 * Platform specific stuff (in this case, for RISC OS)
 */

/*
 * Variables
 */

int ffPlatform = 0;/* Used to store platform-specific flags */

/*
 * Find out the path of ACME's library
 */
void Platform_FindLib() {
  psLibPath = "ACME_Lib:";
}

/*
 * Convert UNIX-style pathname to system-style pathname
 */
void RISC_OS_ConvertPath(byte *p) {
  int  a = 0;
  byte b;

  while((b = p[a]) != 0) {
    if(b == '.') p[a] = '/';
    if(b == '/') p[a] = '.';
    if(b == '?') p[a] = '#';
    if(b == '#') p[a] = '?';
    a++;
  }
}

/*
 * Setting the created files' types
 */
void RISC_OS_SetType(byte* pnf, int type) {
  int Register[10];

  Register[0] = 18;
  Register[1] = (int) pnf;
  Register[2] = type;
  _kernel_swi(OS_FILE, Register, Register);
}

/*
 * Throwback protocol
 */
void RISC_OS_Throwback(byte* Message, int Type) {
  int Register[10];

  if(ffPlatform & FUSETHROWBACK) {
    if((ffPlatform & FTHROWBACKON) == 0) {
      /* this is the first throwback, so set it up and send info */
      ffPlatform |= FTHROWBACKON;
      _kernel_swi(XDDEUTILS_THROWBACKSTART, Register, Register);
      Register[0] = 0;
      Register[1] = 0;
      Register[2] = (int) pnfTop;
      _kernel_swi(XDDEUTILS_THROWBACKSEND, Register, Register);
    }
    /* send throwback message */
    Register[0] = 1;
    Register[1] = 0;
    Register[2] = (int) Context[nContext].pSourceFile;
    Register[3] = Context[nContext].nLines;
    Register[4] = Type;
    Register[5] = (int) Message;
    _kernel_swi(XDDEUTILS_THROWBACKSEND, Register, Register);
  }
}

/*
 * If throwback was used, de-register now
 */
void RISC_OS_Exit() {
  int Register[10];

  if(ffPlatform & FTHROWBACKON) {
    _kernel_swi(XDDEUTILS_THROWBACKEND, Register, Register);
    ffPlatform &= ~FTHROWBACKON;
  }
}

#endif
