/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_C
#define platform_C

/*
 * Platform specific stuff (in this case, for DOS)
 */

/*
 * Find out the path of ACME's library
 */
void Platform_FindLib() {
  int    c;
  char*  p;

  p = getenv("ACME");
  if(p) {
    strncpy(pPathname, p, LNPMAX - 1);/* Minus one because of backslash */
    c = strlen(pPathname);
    pPathname[c++] = '\\';/* Add directory separator at end */
    pPathname[c]   = 0;/* Terminate again */
    psLibPath = (char *) ALLOC_PROCESS(c + 1);
    strcpy(psLibPath, pPathname);
  } else {
    psLibPath = NULL;
  }
}

/*
 * Convert UNIX-style pathname to system-style pathname
 */
void DOS_ConvertPath(byte* p) {
  int  a = 0;
  byte b;

  while((b = p[a]) != 0) {
    if(b == '/') p[a] = '\\';
    if(b == '\\') p[a] = '/';
    a++;
  }
}

#endif
