/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Output stuff
 */

#ifndef output_H
#define output_H

/*
 * Constants
 */

/* Format of output file */
enum {
  OUTFORMAT_NONE,
  OUTFORMAT_CBM,
  OUTFORMAT_PLAIN,
  OUTFORMAT_O65
};

/*
 * Variables
 */

extern byte  OutputBuffer[];/* to hold assembled code */
#define OUTBUFFERSIZE   65536
extern int   hOutformat;/* Output file format */
extern byte  pnfOut[];/* Filename of output file */

/*
 * Prototypes
 */

void  Output_8b(value);
void  Output_16b(value);
void  Output_24b(value);
void  Output_32b(value);
void  Output_Byte(value);
void  Output_ToFile(value, value);
void  Output_InitMem(byte);

#endif
