/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Label stuff
 */

#ifndef label_H
#define label_H

/* the "label" definition */
struct label {
  value Value;/* numerical value */
  int   Flags;/* defined, unsure, isbyte etc. */
  int   Refs;/* number of treeItems referencing this label */
  int   Usage;/* usage count */
};

/* Flags for newly created labels */
#define LABELFLAG_DEFAULT       0

/*
 * Constants
 */

/*
 * Variables
 */

extern FILE* hfDump;/* dump file handle */

/*
 * Prototypes
 */

label* Label_Create(int, int);
void   Label_Remove(label*);
void   Label_SetValue(label*, value, int, int);
void   Label_ParseDefinition(zone);
label* Label_Find(zone, int);
int    Label_PO_set(void);
int    Label_PO_sl(void);
void   Label_DumpAll(void);

#endif
