/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Flow control stuff (macro calls, loops, etc.)
 */

#ifndef flowpo_H
#define flowpo_H

#include <stdio.h>

#include "config.h"

/*
 * Constants
 */

/* Handles to store instead of the UNTIL and WHILE keywords */
enum {
  ID_UNTIL = 'u',/* These characters should not have any meaning */
  ID_WHILE = 'w' /* to any of GetByte()'s filtering rules */
};

/*
 * Variables
 */

/*
 * Prototypes
 */

int   FlowPO_pseudopc(void);
int   FlowPO_realpc(void);
int   FlowPO_zone(void);
int   FlowPO_subzone(void);
int   FlowPO_eof(void);
int   FlowPO_source(void);
int   FlowPO_ifdef(void);
int   FlowPO_if(void);
int   FlowPO_for(void);
int   FlowPO_do(void);
byte* Flow_StoreCondition(byte*);

#endif
