/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#include "data.h"

/*
 * Constants
 */

/*
 * Flag table:
 *
 * This table contains flags for all the 256 possible byte values. The
 * assembler reads the table whenever it needs to know whether a byte is
 * allowed to be in a label name, for example.
 *
 * $00-$1f   control characters
 * $20-$2f   " !"#$%&'()*+,-./"
 * $30-$3f   digits and ":;<=>?"
 * $40-$5f   uppercase characters
 * $60-$7f   lowercase characters
 * $80-$ff   upper half of codes
 *
 * Format:
 *
 * Bit         Meaning when set
 *
 * 7.......    Byte is forbidden in keyword names
 * .6......    Byte is uppercase, can be converted to lowercase by "OR 32"
 * ..5.....    (reserved, currently zero)
 * ...4....    Byte is legal instruction of Z80    (unimplemented)
 * ....3...    Byte is legal instruction of 65816
 * .....2..    Byte is legal instruction of 65c02
 * ......1.    Byte is illegal instruction of 6510 (unimplemented)
 * .......0    Byte is legal instruction of 6502
 */

byte pFlagTable[256] = {

  0x8d, 0x8d, 0x88, 0x88, 0x8c, 0x8d, 0x8d, 0x88,
  0x8d, 0x8d, 0x8d, 0x88, 0x8c, 0x8d, 0x8d, 0x88,

  0x8d, 0x8d, 0x8c, 0x88, 0x8c, 0x8d, 0x8d, 0x88,
  0x8d, 0x8d, 0x8c, 0x88, 0x8c, 0x8d, 0x8d, 0x88,

  0x8d, 0x8d, 0x88, 0x88, 0x8d, 0x8d, 0x8d, 0x88,
  0x8d, 0x8d, 0x8d, 0x88, 0x8d, 0x8d, 0x8d, 0x88,

  0x0d, 0x0d, 0x0c, 0x08, 0x0c, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x8c, 0x88, 0x8c, 0x8d, 0x8d, 0x88,
  0x8d, 0x4d, 0x48, 0x48, 0x48, 0x4d, 0x4d, 0x48,
  0x4d, 0x4d, 0x4d, 0x48, 0x4d, 0x4d, 0x4d, 0x48,

  0x4d, 0x4d, 0x4c, 0x48, 0x48, 0x4d, 0x4d, 0x48,
  0x4d, 0x4d, 0x4c, 0x88, 0x88, 0x8d, 0x8d, 0x08,

  0x8d, 0x0d, 0x08, 0x08, 0x0c, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0d, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0c, 0x08, 0x0c, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0c, 0x88, 0x8c, 0x8d, 0x8d, 0x88,

  0x0c, 0x0d, 0x08, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0c, 0x0d, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0c, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0d, 0x08, 0x0c, 0x0d, 0x0c, 0x08,
  0x0d, 0x0d, 0x0d, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0d, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0c, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0d, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x08, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0d, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0c, 0x08, 0x08, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0c, 0x08, 0x08, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x08, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0d, 0x08, 0x0d, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0c, 0x08, 0x08, 0x0d, 0x0d, 0x08,
  0x0d, 0x0d, 0x0c, 0x08, 0x08, 0x0d, 0x0d, 0x08,
};
