/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Main definitions
 */

#ifndef core_H
#define core_H

/* Structure for linked list of segment data */
typedef struct SegmentStruct SegmentStruct;
struct SegmentStruct {
  SegmentStruct* Next;
  value          Start;
  value          Length;
};

/* Macros for claiming and releasing memory blocks */
#define ALLOC_PROCESS(Size)   MyAlloc(Size, &pToBeFreed_Process)
#define ALLOC_TRY(Size)       MyAlloc(Size, &pToBeFreed_Try)
#define ALLOC_PASS(Size)      MyAlloc(Size, &pToBeFreed_Pass)
#define FREE_PROCESS()        MyFree(pToBeFreed_Process)
#define FREE_TRY()            MyFree(pToBeFreed_Try)
#define FREE_PASS()           MyFree(pToBeFreed_Pass)

/*
 * Variables
 */

enum {
  SKIP_REST,
  ENSURE_EOL,
  PARSE_REST
};

extern char Exception_NoRightBrace[];
extern char Exception_NoLeftBrace[];
extern byte MiscString[];/* temporary string buffer */

extern int Process_Flags;/* Program flags variable and its bitfields */
/* Copyright and usage message has been shown */
#define FPROGRAM_INFOSHOWN      (1u << 0)

extern int Pass_Flags;/* Pass flags and its bitfields */
/* Do stuff that only has to be done once (only in first pass) */
#define PASS_ISFIRST    (1u << 0)
/* Show errors when values are undefined (only in additional pass) */
#define PASS_ISERROR    (1u << 1)
/* Memory buffer has been initialised */
#define PASS_MEMINIT    (1u << 2)

extern int   Process_Verbosity;/* Level of additional output */
extern byte  GotByte;/* Last byte read (processed) */
extern byte* pnfTop;/* => top level file name as given in CLI */

/* Global counters */
extern int nNeedValue_Now;/* "NeedValue" type errors in current pass */
extern int nNeedValue_Last;/* "NeedValue" type errors in previous pass */
extern int nErrors;/* Errors yet */

extern value PC_Mem;/* Current program counter (real memory address) */
extern value PC_inc;/* Increase PC by this amount after statement */
extern value PC_Lowest;/* Start address of program (first PC given) */
extern value PC_Highest;/* End address of program plus one */
extern value SegmentStart;/* Start of current segment */
extern value SegmentMax;/* Highest address segment may use */

extern byte pConvTable[];/* holds conversion table from file */

extern void* pToBeFreed_Process;/* linked list, holds malloc blocks */
extern void* pToBeFreed_Try;/* linked list, holds malloc blocks */
extern void* pToBeFreed_Pass;/* linked list, holds malloc blocks */

/*
 * Prototypes
 */

int   main(int, char* []);
void  Core_DoPass(int);
void  ParseBlock(void);
void  SkipRest(void);
void  EnsureEOL(void);
void  NeedValue(void);
void  ReadParameters(int, byte* []);
void  CleanExit(int);
byte  ConvertChar(byte, int);
void  Segment_Link(value, value);
void  Segment_FindMax(value);
void  Segment_Check(value);
void  ThrowWarning(char*);
void  ThrowError(char*);
void  ThrowSerious(char*);
void  ThrowMessage(char*, char*);
void  BugFound(char*);
inline void* SafeAlloc(size_t);
void* MyAlloc(size_t, void**);
void  MyFree(void*);
void  Process_Init(void);
void  Try_Init(void);

#endif
