/*	UTIL.C		07/01/1988		Dan Brown		    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    Copyright (c) 1988,1992 Digital Research Inc.                         */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
/*****************************************************************************
$Header: m:/davinci/users//groups/panther/dsk/rcs/util.c 3.5 92/03/13 14:43:50 sbc Exp $
$Log:	util.c $
 * Revision 3.5  92/03/13  14:43:50  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 

Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
911119  K.H		Optimized by DRJ. (#if JOPTIMIZE)
******************************************************************************/

#include "shell.h"

#define	JOPTIMIZE	0

#if JOPTIMIZE

EXTERN	SCRN	screen;			/* Misc. screen information.	    */

/*----------------------------------------------------------------------*/
/*  Converts rectangles from x,y,w,h format to x1,y1,x2,y2 format	*/
    GLOBAL VOID
xywh_to_xyxy(WORD	pts[],
	     RECT	*rect
	     )
{
    pts[ 0 ] = rect->x ;
    pts[ 1 ] = rect->y ;
    pts[ 2 ] = rect->x + rect->w - 1;
    pts[ 3 ] = rect->y + rect->h - 1;
}

/*----------------------------------------------------------------------*/
    GLOBAL VOID
do_vs_clip( RECT  	*rect 
	    )
{
WORD	pts[ 4 ] ;

    xywh_to_xyxy( pts, rect) ;
    vs_clip( 1, pts ) ;
} /* do_vs_clip */

/*----------------------------------------------------------------------*/
    GLOBAL WORD
okcan( TREE	tree,
       WORD okob,
       WORD canob
       )
{
    FDOBJECT	*can_ptr;
    FDOBJECT	*ok_ptr ;
    
    ok_ptr = ( tree + okob ) ;
    if ( ok_ptr->ob_state & SELECTED)
    {
	ok_ptr->ob_state &= ~(SELECTED);
	return( 1 ) ;
    }
    can_ptr = ( tree + canob ) ;
    if ( can_ptr->ob_state & SELECTED )
    {
	can_ptr->ob_state &= ~(SELECTED) ;
	return( -1 ) ;
    }
    return( 0 ) ;
} /* okcan() */

#endif /* JOPTIMIZE */

/*-----------------------------------------------------------------*/
MLOCAL void r_to_xy( RECT *rect, WORD * xy )
{
    xy[ 6 ] = xy[ 0 ] = rect->x ;
    xy[ 3 ] = xy[ 1 ] = rect->y ;
    xy[ 4 ] = xy[ 2 ] = rect->x + rect->w - 1 ;
    xy[ 5 ] = xy[ 7 ] = rect->y + rect->h - 1 ;
} /* r_to_xy */

/*----------------------------------------------------------------------*/
GLOBAL VOID do_linebox( RECT * rect )
{
    WORD	pts[10];
    
    r_to_xy( rect, pts ) ;
    pts[ 8 ] = pts[ 0 ] ;
    pts[ 9 ] = pts[ 1 ] + 1 ;
    v_pline( 5, pts ) ;
} /* do_linebox */

/* util.c */
