/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/optimize.c 3.4 92/04/03 17:12:24 sbc Exp $
* $Log:	optimize.c $
 * Revision 3.4  92/04/03  17:12:24  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 3.3  92/03/12  13:58:39  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 3.2  92/02/19  16:16:02  sbc
 * country => _country
 * 
 * Revision 3.1  91/08/19  16:40:14  system
 * ViewMAX 2 sources
 * 
*****************************************************************************/

/****************************************************************************
* File:		optimize.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/


#include "shell.h"

extern UWORD	intin[];
extern UWORD	intout[];
extern UWORD	contrl[];


/****************************************************************
 *
 ****************************************************************/
WORD v_sound(WORD isfreq, WORD freq, WORD dura)
{
	WORD		cnt;

	intin[0] = freq;
	intin[1] = dura;
	if (isfreq)
	{
						/* make a sound		*/
	  contrl[5] = 61;
	  cnt = 2;
	}
	else
	{
						/* get / set mute status*/
	  contrl[5] = 62;
	  cnt = 1;
	}
	gsx_ncode(5, 0, cnt);
	return(intout[0]);
}

/****************************************************************
 *
 ****************************************************************/
void rc_union(GRECT *p1, GRECT *p2)
{
	WORD		tx, ty, tw, th;

	tw = max(p1->g_x + p1->g_w, p2->g_x + p2->g_w);
	th = max(p1->g_y + p1->g_h, p2->g_y + p2->g_h);
	tx = min(p1->g_x, p2->g_x);
	ty = min(p1->g_y, p2->g_y);
	p2->g_x = tx;
	p2->g_y = ty;
	p2->g_w = tw - tx;
	p2->g_h = th - ty;
}

/****************************************************************
 *
 ****************************************************************/
WORD rc_intersect(GRECT *p1, GRECT *p2)
{
	WORD		tx, ty, tw, th;

	tw = min(p2->g_x + p2->g_w, p1->g_x + p1->g_w);
	th = min(p2->g_y + p2->g_h, p1->g_y + p1->g_h);
	tx = max(p2->g_x, p1->g_x);
	ty = max(p2->g_y, p1->g_y);
	p2->g_x = tx;
	p2->g_y = ty;
	p2->g_w = tw - tx;
	p2->g_h = th - ty;
	return( (tw > tx) && (th > ty) );
}

/****************************************************************
 *  Strip out period and turn into raw data.
 ****************************************************************/
void fmt_str(BYTE *instr, BYTE *outstr)
{
	WORD		count;
	BYTE		*pstr;

	pstr = instr;
	while( (*pstr) && (*pstr != '.') )
	  *outstr++ = *pstr++;
	if (*pstr)
	{
	  count = 8 - (pstr - instr);
	  while ( count-- )
	    *outstr++ = ' ';
	  pstr++;
	  while (*pstr)
	    *outstr++ = *pstr++;
	}
	*outstr = NULL;
}

/****************************************************************
 *  Insert in period and make into true data.
 ****************************************************************/
void unfmt_str(BYTE *instr, BYTE *outstr)
{
	BYTE		*pstr, temp;

	pstr = instr;
	while( (*pstr) && ((pstr - instr) < 8) )
	{
	  temp = *pstr++;
	  if (temp != ' ')
	    *outstr++ = temp;
	}
	if (*pstr)
	{
	  *outstr++ = '.';
	  while (*pstr)
	  {
	    temp = *pstr++;
	    if (temp != ' ')
	      *outstr++ = temp;
	  }
	}
	*outstr = NULL;
}

/****************************************************************
 *
 ****************************************************************/
void tedinfo_set( TREE tree, WORD obj, BYTE far *pstr)
{
TEDINFO far *pTed ;

    pTed = (TEDINFO far *)(tree+obj)->ob_spec ;
    fstrcpy( pTed->te_ptext, pstr ) ;
}

/****************************************************************
 *
 ****************************************************************/
void tedinfo_get(TREE tree, WORD obj, BYTE far *pstr)
{
TEDINFO far *pTed ;

    pTed = (TEDINFO far *)(tree+obj)->ob_spec ;
    fstrcpy( pstr, pTed->te_ptext );
}

/****************************************************************
 *
 ****************************************************************/
WORD radio_get( TREE tree, WORD baseobj, WORD numobj )
{
	WORD		retobj;

	for (retobj=0; retobj < numobj; retobj++)
	{
	  if ( (tree+baseobj+retobj)->ob_state & SELECTED)
	    return(retobj);
	}
	return(-1);
} /* radio_get() */

/****************************************************************
 *  Return 0 if cancel was selected, 1 if okay was selected, 
 *  -1 if nothing was selected.
 ****************************************************************/
WORD inf_what(TREE tree, WORD okobj, WORD canobj )
{
WORD	obj = -1 ;

    if ( SELECTED & ((TREE)tree+okobj)->ob_state )
	obj = okobj;
    else if ( SELECTED & ((TREE)tree+canobj)->ob_state )
	obj = canobj;
    
    if (obj != -1)
	((TREE)tree+obj)->ob_state &= ~SELECTED ;

    return( obj == okobj ? 1 : obj == canobj ? 0 : -1 );
    
} /* inf_what() */

/****************************************************************
 *  See if the test filename matches one of a set of comma
 *  delimited wildcard strings.
 *    e.g.,	pwld = "*.COM,*.EXE,*.BAT"
 *		ptst = "MYFILE.BAT"
 ****************************************************************/
WORD wildcmp( BYTE *pwld, BYTE *ptst )
{
	BYTE		*pwild;
	BYTE		*ptest;
						/* skip over *.*, and	*/
						/*   *.ext faster	*/
	while(*pwld)
	{
	  ptest = ptst;
	  pwild = pwld;
						/* move on to next 	*/
						/*   set of wildcards	*/
	  pwld = strchr( pwld, ',');
	  if (*pwld)
	    pwld++;
						/* start the checking	*/
	  if (pwild[0] == '*')
	  {
	    if (pwild[2] == '*')
	      return(TRUE);
	    else
	    {
	      pwild = &pwild[2];
	      ptest = strchr( ptest, '.');
	      if (*ptest)
	        ptest++;
	    }
	  }
						/* finish off comparison*/
	  while( (*ptest) && 
	         (*pwild) &&
		 (*pwild != ',') &&
		 (*ptest != ';') )	/* Cope with passwords */
	  {
	    if (*pwild == '?')
	    {
	       pwild++;
	       if (*ptest != '.')
	         ptest++;
	    }
	    else
	    {
	      if (*pwild == '*')
	      {
	        if (*ptest != '.')
		  ptest++;
	        else		
		  pwild++;
	      }
	      else
	      {
	        if (*ptest == *pwild)
	        {
	          pwild++;
	          ptest++;
	        }
	        else
	          break;
	      }
	    }
	  }
						/* eat up remaining 	*/
						/*   wildcard chars	*/
	  while( (*pwild == '*') ||
	         (*pwild == '?') ||
	         (*pwild == '.') )
	    pwild++;
						/* if any part of wild-	*/
						/*   card or test is	*/
						/*   left then no match	*/
	  if ( ((*pwild == NULL) || (*pwild == ',')) && 
	       ((!*ptest) || (*ptest == ';' )) )
	    return( TRUE );
	}
	return(FALSE);
}


/*
 *	EOF:	optimize.c
 */
