/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991  Digital Research Inc.  All rights reserved.    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/obdefs.h 4.2 92/04/03 17:13:14 sbc Exp $
* $Log:	obdefs.h $
 * Revision 4.2  92/04/03  17:13:14  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 4.1  92/01/06  13:12:17  anderson
 * Color icon work from Becky.
 * 
 * Revision 3.1  91/08/19  16:30:25  system
 * ViewMAX 2 sources
 * 
* Revision 3.4  91/06/13  09:21:54  sbc
* change CC_BUTTON, etc defs to be longs for convenience in deskclrs.c
* 
* Revision 3.3  91/06/04  13:01:28  sbc
* misc housekeeping and other ravings...
* 
* Revision 3.2  91/05/24  14:18:49  system
* add text alignment defines
* 
* Revision 3.1  91/05/16  14:48:33  fontes
* Separate branch for Beta bug fixes, separate from split-mode windows
* 
* Revision 2.1.1.5  91/04/27  10:49:21  fontes
* Add color category defs
* 
* Revision 2.1.1.4  91/04/09  21:12:39  fontes
* 3-D on listbox scrollbars
* 
* Revision 2.1.1.2  91/03/25  14:40:29  anderson
* Converted to medium model, prototyped, and generally cleaned up.
* 
Date	Who	SPR#	Comments
-------	-------	----	-----------------------------------------------------
911210	RSF		Add G_CLRICON and structures for BMP/ICO files.
910427	RSF		Add color categories
910408	RSF		Add new AES flags for 3D and Color categories
910405	RSF		Change LONG to SLONG in ext obj defs where needed.
910321	RSF		Folded in new object defs for extended objects.
*****************************************************************************/

/****************************************************************************
* File:		obdefs.h
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/


#define ROOT 0
#define NIL -1
						/* keybd states		*/
#define K_RSHIFT 0x0001
#define K_LSHIFT 0x0002
#define K_CTRL 0x0004
#define K_ALT 0x00008
						/* max string length	*/
#define MAX_LEN 81
						/* max depth of search	*/
						/*   or draw for objects*/
#define MAX_DEPTH 8
						/* inside patterns	*/
#define IP_HOLLOW 0
#define IP_1PATT 1
#define IP_2PATT 2
#define IP_3PATT 3
#define IP_4PATT 4
#define IP_5PATT 5
#define IP_6PATT 6
#define IP_SOLID 7
						/* system foreground and*/
						/*   background rules	*/
						/*   but transparent	*/
#define SYS_FG 0x1100

#define WTS_FG 0x11a1				/* window title selected*/
						/*   using pattern 2 &	*/
						/*   replace mode text 	*/
#define WTN_FG 0x1100				/* window title normal	*/
						/* gsx modes		*/
#define MD_REPLACE 1
#define MD_TRANS 2
#define MD_XOR 3
#define MD_ERASE 4
						/* gsx styles		*/
#define FIS_HOLLOW 0
#define FIS_SOLID 1
#define FIS_PATTERN 2
#define FIS_HATCH 3
#define FIS_USER 4

/* MFDB FORMS           */
#define DVCFORM 0
#define STNDFORM 1

						/* bit blt rules	*/
#define ALL_WHITE 0
#define S_AND_D 1
#define S_ONLY 3
#define NOTS_AND_D 4
#define S_XOR_D 6
#define S_OR_D 7
#define D_INVERT 10
#define NOTS_OR_D 13
#define ALL_BLACK 15
						/* font types		*/
#define IBM 3
#define SMALL 5

#define ALI_LEFT         0			/* horiz text alignment */
#define ALI_CENTER       1
#define ALI_RIGHT        2

#define ALI_BASE         0			/* vertical text alignment */
#define ALI_HALF         1
#define ALI_ASCENT       2
#define ALI_BOTTOM       3
#define ALI_DESCENT      4
#define ALI_TOP          5

/* Object Drawing Types */
						/* Graphic types of obs	*/
#define G_BOX 20
#define G_TEXT 21
#define G_BOXTEXT 22
#define G_IMAGE 23
#define G_USERDEF 24
#define G_IBOX 25
#define G_BUTTON 26
#define G_BOXCHAR 27
#define G_STRING 28
#define G_FTEXT 29
#define G_FBOXTEXT 30
#define G_ICON 31
#define G_TITLE 32
#define G_CLRICN 33
						/* Object flags		 */
#define NONE 0x0
#define SELECTABLE 0x1
#define DEFAULT 0x2
#define EXIT 0x4
#define EDITABLE 0x8
#define RBUTTON 0x10
#define LASTOB 0x20
#define TOUCHEXIT 0x40
#define HIDETREE 0x80
#define INDIRECT 0x100
#define ESCCANCEL 0x200
#define HALFVSHIFT 0x400
#define HALFVSIZE 0x800
#define FLAG3D	0x1000
#define USECOLORCAT 0x2000
						/* Object states	*/
#define NORMAL 0x0
#define SELECTED 0x1
#define CROSSED 0x2
#define CHECKED 0x4
#define DISABLED 0x8
#define OUTLINED 0x10
#define SHADOWED 0x20
#define WHITEBAK 0x40
#define DRAW3D 0x80
						/* Object colors	*/
#define WHITE 0
#define BLACK 1
#define RED 2
#define GREEN 3
#define BLUE 4
#define CYAN 5
#define YELLOW 6
#define MAGENTA 7
#define LWHITE 8
#define LBLACK 9
#define LRED 10
#define LGREEN 11
#define LBLUE 12
#define LCYAN 13
#define LYELLOW 14
#define LMAGENTA 15

				/* Color categories used by Window Manager */
#define	CC_NAME		8
#define	CC_SLIDER	9L
#define	CC_DESKTOP	10L
#define	CC_BUTTON	11L
#define	CC_INFO		12
#define	CC_ALERT	13
#define	CC_SLCTDNAME	14
#define	CC_MAX		16


/* LINE TYPE    */
#define LT_SOLID    1
#define LT_LDASH    2
#define LT_DOT      3
#define LT_DASHDOT  4
#define LT_DASH     5
#define LT_DASHDOTDOT   6
#define LT_USERDEF  7

/* LINE END STYLES */
#define LE_SQUARE 0
#define LE_ARROW 1
#define LE_ROUND 2

#define OBJECT struct object

OBJECT
{
	WORD		ob_next;	/* -> object's next sibling	*/
	WORD		ob_head;	/* -> head of object's children */
	WORD		ob_tail;	/* -> tail of object's children */
	UWORD		ob_type;	/* type of object- BOX, CHAR,...*/
	UWORD		ob_flags;	/* flags			*/
	UWORD		ob_state;	/* state- SELECTED, OPEN, ...	*/
	FBYTE		*ob_spec;	/* "out"- -> anything else	*/
	WORD		ob_x;		/* upper left corner of object	*/
	WORD		ob_y;		/* upper left corner of object	*/
	WORD		ob_width;	/* width of obj			*/
	WORD		ob_height;	/* height of obj		*/
};

#define FOBJECT		OBJECT FAR

#define ORECT	struct orect

ORECT
{
	ORECT	*o_link;
	WORD	o_x;
	WORD	o_y;
	WORD	o_w;
	WORD	o_h;
} ;


#define GRECT	struct grect

GRECT
{
	WORD	g_x;
	WORD	g_y;
	WORD	g_w;
	WORD	g_h;
} ;


#define TEDINFO struct text_edinfo
#define FTEDINFO TEDINFO FAR

TEDINFO
{
	FBYTE		*te_ptext;	/* ptr to text (must be 1st)	*/
	FBYTE		*te_ptmplt;	/* ptr to template		*/
	FBYTE		*te_pvalid;	/* ptr to validation chrs.	*/
	WORD		te_font;	/* font				*/
	WORD		te_junk1;	/* junk word			*/
	WORD		te_just;	/* justification- left, right...*/
	WORD		te_color;	/* color information word	*/
	WORD		te_junk2;	/* junk word			*/
	WORD		te_thickness;	/* border thickness		*/
	WORD		te_txtlen;	/* length of text string	*/
	WORD		te_tmplen;	/* length of template string	*/
};


#define ICONBLK struct icon_block

ICONBLK
{
	LONG	ib_pmask;
	LONG	ib_pdata;
	LONG	ib_ptext;
	WORD	ib_char;
	WORD	ib_xchar;
	WORD	ib_ychar;
	WORD	ib_xicon;
	WORD	ib_yicon;
	WORD	ib_wicon;
	WORD	ib_hicon;
	WORD	ib_xtext;
	WORD	ib_ytext;
	WORD	ib_wtext;
	WORD	ib_htext;
};

#define BITBLK struct bit_block

BITBLK
{
	LONG	bi_pdata;		/* ptr to bit forms data	*/
	WORD	bi_wb;			/* width of form in bytes	*/
	WORD	bi_hl;			/* height in lines		*/
	WORD	bi_x;			/* source x in bit form		*/
	WORD	bi_y;			/* source y in bit form		*/
	WORD	bi_color;		/* fg color of blt 		*/
};


#define FBITBLK	 BITBLK FAR

#define PARMBLK struct parm_blk
#define FPARMBLK PARMBLK FAR
PARMBLK
{
	FOBJECT		*pb_tree;
	WORD		pb_obj;
	WORD		pb_prevstate;
	WORD		pb_currstate;
	WORD		pb_x, pb_y, pb_w, pb_h;
	WORD		pb_xc, pb_yc, pb_wc, pb_hc;
	FPARMBLK	*pb_parm;
};


typedef struct mouse_state		/* Mouse state			    */
{
    UWORD	mst_x;			/* X coordinate of the mouse	    */
    UWORD	mst_y;			/* Y coordinate of the mouse	    */
    UWORD	mst_b;			/* Mouse button state		    */
    UWORD	mst_ks;			/* Keyboard state		    */
} MSTAT;

#define EDSTART 0
#define EDINIT 1
#define EDCHAR 2
#define EDEND 3

#define TE_LEFT 0
#define TE_RIGHT 1
#define TE_CNTR 2


typedef struct bh
{
	WORD	type;
	LONG	size;
	LONG	reserved;
	LONG	offset;
} BMP_HEADER;


typedef struct bi
{
	LONG	size;
	LONG	width;
	LONG	height;
	WORD	planes;
	WORD	bit_count;
	LONG	compression;
	LONG	size_image;
	LONG	xpels_per_me;
	LONG	ypels_per_me;
	LONG	clr_used;
	LONG	clr_important;
} BMP_INFO;

typedef struct ih
{
	WORD	reserved;
	WORD	type;
	WORD	count;
} ICO_HEADER;

typedef struct rd	/* Resource Descriptor */
{
	BYTE	width;
	BYTE	height;
	BYTE	color_count;
	BYTE	resvd_1;
	WORD	resvd_2;
	WORD	resvd_3;
	LONG	dib_size;
	LONG	dib_offset;
} RES_DESC;


typedef struct ci
{
	FDB FAR	*image;		/* transformed image for color icon	*/
	FDB FAR *mask;		/* transformed mask for color icon	*/
	BOOLEAN	is_app;		/* TRUE if app icon, FALSE if file icon	*/
	BYTE	file_icon;	/* Index of corresponding file icon, -1	*/
				/* if this is a file icon.		*/
	BYTE	fname[9];	/* .ICO/.ICF extension is assumed	*/
} CICON;

/*----------------------------------------------------------------------*/
/* "New" style structures.  Supports extended objects			*/
/*----------------------------------------------------------------------*/

typedef struct rshdr			/* Resource header data structure.  */
{
    UWORD	rsh_vrsn;		/* Resource version number.	    */

    /* Offsets to the parts of the resource file.			    */
    UWORD	rsh_object;		/* Objects offset.		    */
    UWORD	rsh_tedinfo;		/* Tedinfo offset.		    */
    UWORD	rsh_iconblk;		/* Icon block offset.		    */
    UWORD	rsh_bitblk;		/* Bit block offset.		    */
    UWORD	rsh_frstr;		/* Free string offset.		    */
    UWORD	rsh_string;		/* String offset.		    */
    UWORD	rsh_imdata;		/* image data offset.		    */
    UWORD	rsh_frimg;		/* Free image data offset.	    */
    UWORD	rsh_trindex;		/* Offset to tree pointers.	    */
    
    /* Number of items in each part of the resource.			    */
    WORD	rsh_nobs;		/* Number of objects.		    */
    WORD	rsh_ntree;		/* Number of trees.		    */
    WORD	rsh_nted;		/* Number of tedinfo's.		    */
    WORD	rsh_nib;		/* Number of icon blocks.	    */
    WORD	rsh_nbb;		/* Number of bit blocks.	    */
    WORD	rsh_nstring;		/* Number of strings.		    */
    WORD	rsh_nimages;		/* Number of images.		    */
    
    UWORD	rsh_rssize;		/* total bytes in resource	    */
}RSHDR;

#define   FRSHDR RSHDR FAR		/* Far pointer to resource header.  */

/* RECTANGLE */
typedef struct ser_rect
{
    WORD	x;			/* Left x coordinate.		    */
    WORD	y;			/* Top y coordinate.		    */
    WORD	w;			/* Width.			    */
    WORD	h;			/* Height.			    */
} RECT;

#define    FRECT	RECT FAR		/* Far rectangle.	    */

/* SERVICES OBJECT							    */

typedef struct srv_obj			/* New style object structure.	    */
{
    WORD        ob_next;		/* -> object's next sibling	    */
    WORD        ob_head;		/* -> head of object's children	    */
    WORD        ob_tail;		/* -> tail of object's children	    */
    UWORD       ob_type;		/* type of object- BOX, CHAR,...    */
    UWORD       ob_flags;		/* flags			    */
    UWORD       ob_state;		/* state- SELECTED, OPEN, ...	    */
    BYTE FAR    *ob_spec;		/* "out"- -> anything else	    */
    RECT        ob_box;			/* extent of bpject		    */
} DOBJECT;

#define  FDOBJECT DOBJECT FAR		/* Far object.			    */
#define	 TREE	FDOBJECT *		/* Pointer to the root of a tree.   */

/* ICON BLOCK */
typedef struct srv_icon
{
    FWORD	*ib_pmask;		/* Pointer to mask.		    */
    FWORD	*ib_pdata;		/* Pointer to data.		    */
    FBYTE	*ib_ptext;		/* Pointer to icon string.	    */
    WORD	ib_char;		/* Icon character.		    */
    WORD	ib_xchar;		/* Character x coordinate.	    */
    WORD	ib_ychar;		/* Character y coordinate.	    */
    RECT	ib_boxicon;		/* Position of Icon in object.	    */
    RECT	ib_textbox;		/* Position of text in object.	    */
} DICONBLK;

#define	FDICONBLK	DICONBLK FAR	/* Far icon block.		    */


/* GLOBAL ARRAY */
typedef struct srv_glb
{
    UWORD	ap_version;		/* AES version number.		    */
    UWORD	ap_count;		/* Number of applications supported */
    UWORD	ap_id;			/* Application ID number.	    */
    LONG	ap_desk_obspec;		/* Obspec for desktop.		    */
    TREE FAR	*ap_tree;		/* Pointer to array of tree addr.   */
    FRSHDR	*ap_rsc;		/* Pointer to resource header.	    */
    UWORD	ap_rlength;		/* Length of resource.		    */
    WORD	ap_np;			/* Number of planes for screen.	    */
    WORD	ap_rsv1;		/* Unused.			    */
    WORD	ap_rsv2;		/* Unused.			    */
    UWORD	ap_drives;		/* Drives bit flags.		    */
    UWORD	ap_harddrives;		/* Hard drives bit flags.	    */
}GM_GLOB;

typedef struct srv_parm			/* New style parameter block.	    */
{
    TREE	pb_tree;		/* Pointer to tree of object.	    */
    WORD	pb_obj;			/* Object number of object.	    */
    WORD	pb_prevstate;		/* Previous state.		    */
    WORD	pb_currstate;		/* Current state.		    */
    RECT	pb_r;			/* Object extent.		    */
    RECT	pb_rc;			/* Clip rectangle.		    */
    LONG	pb_parm;		/* For application use.		    */
} DPARMBLK;

#define	FDPARMBLK	DPARMBLK FAR	/* Far parameter block.		    */

/* APPL BLOCK */

typedef struct srv_applblk		/* New style application block.	    */
{
#if MICROSOFT
    WORD    (FAR    * ab_code)();	/* Pointer to drawing code.	    */
#else
    WORD FAR  (* ab_code)();
#endif
    PARMBLK far *    ab_parm;			/* For application use.		    */
} APPLBLK;

#define FAPPLBLK	APPLBLK FAR		/* Far application block.	    */

typedef union rorw_msg			/* Union of WORD or RECT	    */
{
    WORD	rw_ary[4];		/* Array of words		    */
    SLONG	rw_lary[2];		/* Array of longs		    */
    WORD	rw_w;			/* Word value			    */
    SLONG	rw_l;			/* Long value			    */
    RECT	rw_r;			/* Rectangle in X,Y,W,H form	    */
} RORW;

typedef struct message			/* AES message			    */
{
    WORD	ms_type;		/* Message type id		    */
    WORD	ms_apid;		/* ID of app that sent message	    */
    WORD	ms_length;		/* Length of message - 16	    */
    WORD	ms_handle;		/* Window handle or menu title	    */
    RORW	ms_body;		/* Message body			    */
} MSSG;

typedef struct evmlt			/* Event Multi parameters	    */
{
    UWORD	em_events;		/* Event flags			    */
    
    /* Mouse button state sought for button event			    */
    UWORD	em_bclk;		/* Max number of clicks		    */
    UWORD	em_bmsk;		/* Mouse button to wait for	    */
    UWORD	em_bst;			/* Button state to wait for	    */
    
    /* Wait rectangle 1							    */
    UWORD	em_1inout;		/* waiting for in or out	    */
    RECT	em_1box;		/* wait box			    */
    
    /* Wait rectangle 2							    */
    UWORD	em_2inout;		/* waiting for in or out	    */
    RECT	em_2box;		/* wait box			    */
    
    MSSG	em_msg;			/* Message buffer		    */
    SLONG	em_time;		/* Time for timer event		    */
    
    /* Return of event info						    */
    MSTAT	em_mstat;    		/* Current mouse state		    */
    UWORD	em_key;			/* Key struck at event		    */
    UWORD	em_nclk;		/* Number of clicks at event	    */
} EVMULT;


/*
 *	EOF:	obdefs.h
 */
