/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/machine.h 3.4 92/04/03 17:13:09 sbc Exp $
* $Log:	machine.h $
 * Revision 3.4  92/04/03  17:13:09  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 3.3  92/03/23  12:54:38  sbc
 * add define WORD_ALIGN to replace function align_x() in desktype.c
 * 
 * Revision 3.2  92/03/13  14:44:04  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 3.1  91/08/19  16:30:20  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
-------	-------	----	-------------------------------------------------------
911128	K.H		Add FSAFMT definition.
911028	K.H		Add DBCS definition.
*****************************************************************************/

#ifndef MACHINE_INCLUDED
#define MACHINE_INCLUDED

#define FSAFMT		1	/* if not enough memory to execute 	*/
				/* FORMAT program, use full stepaside.	*/

#define	DBCS		1	/* Support Doubl Byte Character Set */

#define SMALLICONS	1	/* code to support small icons in text view */
#define	TREEICONS	1	/* code to support small icons in tree window */

#define LETTERS_IN_DISK_DRIVE_ICONS 0 /* code to support drive id IN icon */

#define FAKEFOLDERICON	1	/* code to show fake folder at top of dirs */
#define CLOSEFOLDERICON	1	/* code to support ".." instead of mkdir */

#define HELP_ALERTS	1	/* code to support help alerts		*/
#define CUA_BUTTONS	1	/* code to support radio buttons	*/

#define NUM_WIN 8		/* 8 for main app and 3 desk accs	*/
#define NUM_ACCS 3		/* 3 for number of desk accs	*/

/* return low word of a long value	*/
#define LOWORD(x) ((unsigned short)(x))

/* return high word of a long value	*/
#define HIWORD(x) ((unsigned short)(x >> 16))

/* return low byte of a word value	*/
#define LOBYTE(x) ((unsigned char)(x))

/* return high byte of a word value	*/
#define HIBYTE(x) ((unsigned char)(x >> 8))

/* return low nibble of a byte value	*/
#define LONIBL(x) ( 0x0f & (x) )

/* return high nibble of a byte value	*/
#define HINIBL(x) ( (0xf0 & x) >> 4 )

#define MAKELONG(x,y)	(((unsigned long)(x) << 16) | (unsigned)(y))

/* round to nearest word		*/
#define WORD_ALIGN(x)	((x) + 8 & 0xfff0)

/************************************************************************/

#define FAR	far				/* long pointer		*/

/* return long address of short ptr */
#define ADDR(x) ((LONG) (void far *) (x))

/* convert offset to long pointer */
#define LSEGOFF(x) ((((x)+15)&0xFFFFFFF0)<<12)

#endif /* ndef MACHINE_INCLUDED */

/*
 *	EOF:	machine.h
 */
