/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/gemdos.c 4.6 92/03/13 14:42:39 sbc Exp $
* $Log:	gemdos.c $
 * Revision 4.6  92/03/13  14:42:39  sbc
 * Merge in Keiko's changes required for Double Byte Character Support
 * 
 * Revision 4.5  92/02/19  14:02:40  sbc
 * remove unused define of MK_FP().
 * 
 * Revision 4.4  92/02/05  17:59:54  anderson
 * Just removed unused tree calls.
 * 
 * Revision 4.3  92/01/31  16:34:34  sbc
 * change params for dos_sdta() and dos_gdta() to take far FCB pointers.
 * Change dos_sfirst() to take a char far *. Change all refs to DTA
 * to FCB.
 * 
 * Revision 4.2  92/01/28  15:01:14  rsf
 * *** empty log message ***
 * 
 * Revision 4.2  92/01/21  13:36:19  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.1  91/09/17  13:56:02  system
 * Initial work for DOS window, screen saver, etc.
 * 
 * Revision 3.1  91/08/19  16:40:06  system
 * ViewMAX 2 sources
 * 
Date	Who	SPR#	Comments
----	---	----	-----------------------------------------------------
911016  K.H		Add supporting double byte character set. (#if DBCS)
910621	RSF		Empty routine for getting swap space. To be completed
			when API info rec'd.
910612	RSF		New tm_ routines.
910523	WHF		Improve error handling for passwords
910424	RSF		Remove tm_create_task - now in deskosif.a86
910416	RSF		Modify tm_status parms.
910411	RSF		Add TaskMAX API calls.
910325	RSF		Make dos_gdta global.
910401	RSF		Re-activate dos_gdir.
*****************************************************************************/

#include "shell.h"
#include "viewapps.h"

#define MAX_TM_TASKS	20

#define PATH_CANCEL 0
#define PATH_OK 1
#define PATH_CHANGED 2
#define ATTR_SUBDIR 0x0010

GLOBAL UWORD	DOS_AX;
GLOBAL UWORD	DOS_BX;
GLOBAL UWORD	DOS_CX;
GLOBAL UWORD	DOS_DX;
GLOBAL UWORD	DOS_DS;
GLOBAL UWORD	DOS_ES;
GLOBAL UWORD	DOS_SI;
GLOBAL UWORD	DOS_DI;
GLOBAL UWORD	DOS_ERR;

EXTERN GLOBES	G;

/****************************************************************
 *  dos_func()
 ****************************************************************/
VOID dos_func(UWORD ax, LONG dsdx)
{
    	  DOS_AX = ax;
	  DOS_DX = LOWORD(dsdx);	/* Do the function	*/
	  DOS_DS = HIWORD(dsdx);
	  __DOS();
}

/****************************************************************
 *
 ****************************************************************/
VOID dos_chdir(LONG pdrvpath)
{
	DOS_AX = 0x3b00;
	DOS_DX = LOWORD(pdrvpath);
	DOS_DS = HIWORD(pdrvpath);
	__DOS();
}


/****************************************************************
 *
 ****************************************************************/
WORD dos_gdir(WORD drive, LONG pdrvpath)
{
	DOS_AX = 0x4700;
	DOS_DX = (UWORD) drive;
	DOS_SI = LOWORD(pdrvpath);
	DOS_DS = HIWORD(pdrvpath);

	__DOS();

	return(TRUE);
}

	  
/****************************************************************
 *
 ****************************************************************/
WORD dos_gdrv(VOID)
{
	DOS_AX = 0x1900;

	__DOS();
	return(DOS_AX & 0x00ff);
}

/****************************************************************
 *
 ****************************************************************/
WORD dos_sdrv(WORD newdrv)
{
	DOS_AX = 0x0e00;
	DOS_DX = newdrv & 0x00ff;

	__DOS();

	return(DOS_AX & 0x00ff);
}

/****************************************************************
 *
 ****************************************************************/
/*
*  VOID dos_term(VOID)
*  {
*  	DOS_AX = 0x4c00;
* 	__DOS();
*  }
*/

/****************************************************************
 *
 ****************************************************************/
VOID dos_sdta( FCB far *pFCB )
{
	dos_func(0x1a00, (LONG)pFCB );
}


/****************************************************************
 *
 ****************************************************************/
FCB far * dos_gdta( void )
{
	dos_func(0x2f00, LLDS() );
	return( (FCB far *)MAKELONG( DOS_ES, DOS_BX ) );
}

/****************************************************************
 *
 ****************************************************************/
WORD dos_sfirst( char far * pspec, WORD attr)
{
	WORD	ret,n,i;
	WORD	cnt = 0;
	BYTE	tmp_path[LEN_ZPATH];
	BYTE	wild_str[LEN_ZFNAME];
#if DBCS
	WORD	type = CT_ADE;
#endif /* DBCS */

 	fmemcpy( (void far *)tmp_path, (void far *)pspec , LEN_ZPATH );
	
	DOS_CX = attr;

	do{

	  dos_func(0x4e00, ADDR( &tmp_path[0] ));
	  if( DOS_ERR && DOS_AX==E_PASSWFAIL ){
	    passw_strip( ADDR( &tmp_path[0] ) );
	    for( ret=0 ; tmp_path[ret] && 	/* Strip wildcards */
	    		 tmp_path[ret]!='*' && 
			 tmp_path[ret]!='?' 
#if DBCS
	    			; ret++ )
		type = chkctype(tmp_path[ret], type);
	    if (type == CT_ADE)
#else /* DBCS */
	    			; ret++ );
#endif /* DBCS */
	    if( tmp_path[ret-1]=='\\' ) ret--;
	    if( tmp_path[ret] ){
/* Save wild spec */
	      for( n=0,i=ret ; tmp_path[i] ; i++,n++ )
	        wild_str[n] = tmp_path[i];
	      wild_str[n]=0;
	      tmp_path[ret]=0; /* Chop off wildcards */
	    }
	    
	    ret = passw_perror( (BYTE far *)&tmp_path[0], cnt++, TRUE );
	    
	    strcat( &tmp_path[0] ,  &wild_str[0] ); /* Reattach wildspec */
	  }
	      
	}while( ret && (DOS_ERR && DOS_AX==E_PASSWFAIL) );

	fstrcpy( pspec, (char far *)tmp_path );

	return(!DOS_ERR);
	
} /* end dos_sfirst() */

/****************************************************************
 *
 ****************************************************************/
WORD dos_snext(VOID)
{
	DOS_AX = 0x4f00;

	__DOS();

	return(!DOS_ERR);
}

/****************************************************************
 * Subroutine to check path for password violations
 * returns: PATH_CANCEL, PATH_OK, PATH_CHANGED
 * assumes pn can be changed, and pn=="X:\dir1\...\fspec"
 ****************************************************************/
MLOCAL WORD _dos_chkpath( BYTE *pn )
{
    FCB FAR *dt;
    FCB	    dtaBlk;
    BYTE    *pnp, *tnp, tmp_name[LEN_ZPATH];
    WORD    ret, cnt;

	/* for each slash-terminated segment in path
		dos_sfirst
		if passwd err handle; cancel if requested */
	pnp = pn;
	tmp_name[0] = NULL;			/* Init temp str to NULL */
	dt = dos_gdta();		/* Save DTA for restore */
	dos_sdta( (FCB far *)&dtaBlk );
	ret = TRUE;
	do {
		for( tnp=tmp_name; *tnp; tnp++ ) ; /* Find EOS */
		if( *pnp == '\\' ) *tnp++ = *pnp++; /* Xfer slash */
#if DBCS
		while( *pnp  &&  *pnp!='\\' ) 
		{
			if (dbcs_lead(*pnp) && *(pnp+1))
				*tnp++ = *pnp++;
			*tnp++ = *pnp++;
		}
#else /* DBCS */
		while( *pnp  &&  *pnp!='\\' ) 
			*tnp++ = *pnp++;	/* Xfer next sgmnt */
#endif /* DBCS */
		*tnp = NULL;
		if( *pnp == NULL ) break;	/* Last sgmnt: fname */
		if( pnp[-1] == ':' ) continue;	/* First segmnt: drvspc */

		cnt = 0;
		do {				/* Check dir for password */
		    for( tnp=tmp_name; *tnp; tnp++ ) ;
		    strcpy(tnp, "\\*.*" );	
		    dos_func(0x4e00, ADDR( &tmp_name[0] ));
		    *tnp = NULL;
		    if( DOS_ERR && DOS_AX == E_PASSWFAIL )
		    {
			passw_strip( ADDR( &tmp_name[0] ) );
			ret = passw_perror( (BYTE far *)&tmp_name[0], cnt++, 
				TRUE );
		    }
		} while( ret && (DOS_ERR && DOS_AX==E_PASSWFAIL) );

	} while(ret);

	dos_sdta( dt );
	if( !ret ) return PATH_CANCEL;
	if( strlen(pn) == strlen(tmp_name) )
		ret = PATH_OK;
	else	ret = PATH_CHANGED;
	strcpy( pn ,  tmp_name );			/* Copy back w passwds */
	DOS_ERR = TRUE; DOS_AX = E_PASSWFAIL;		/* Restore error state */
	return ret;
	
} /* end _dos_chkpath() */

/****************************************************************
 *
 ****************************************************************/
WORD dos_open(LONG pname, WORD access)
{
	WORD	cont;
	WORD	cnt = 0;
	BYTE	tmp_name[LEN_ZPATH];

 	fmemcpy( (void far *)tmp_name, (void far *)pname , LEN_ZPATH );
	
	cont = FALSE;
	do{

	  dos_func(0x3d00 + access, ADDR( &tmp_name[0] ));
	  passw_strip( ADDR( &tmp_name[0] ) );
	  if( DOS_ERR && DOS_AX == E_PASSWFAIL )
	  {
	    /* Fail for two reasons: protected FILE or PATH */
	    cont = _dos_chkpath( tmp_name );
	    if( cont==PATH_OK )
	      cont = passw_ferror( (BYTE far *)&tmp_name[0], cnt++ );
	  }
	}while( cont && (DOS_ERR && DOS_AX==E_PASSWFAIL) );

	return(DOS_AX);
}

/****************************************************************
 *
 ****************************************************************/
WORD dos_close(WORD handle)
{
	DOS_AX = 0x3e00;
	DOS_BX = handle;

	__DOS();

	return(!DOS_ERR);
}

/****************************************************************
 *
 ****************************************************************/
WORD dos_read(WORD handle, WORD cnt, LONG pbuffer)
{
	DOS_CX = cnt;
	DOS_BX = handle;
	dos_func(0x3f00, pbuffer);
	return(DOS_AX);
}

/****************************************************************
 *
 ****************************************************************/
LONG dos_lseek(WORD handle, WORD smode, LONG sofst)
{
	DOS_AX = 0x4200;
	DOS_AX += smode;
	DOS_BX = handle;
	DOS_CX = HIWORD(sofst);
	DOS_DX = LOWORD(sofst);

	__DOS();

	return( MAKELONG( DOS_DX, DOS_AX ) );
}

/****************************************************************
 *
 ****************************************************************/
LONG dos_alloc(LONG nbytes)
{
	LONG		maddr;

	DOS_AX = 0x4800;
	if (nbytes == 0xFFFFFFFFL)
	  DOS_BX = 0xffff;
	else
	  DOS_BX = (UWORD)((nbytes + 15L) >> 4L);

	__DOS();

	if (DOS_ERR)
	  maddr = 0x0L;
	else
	  maddr = MAKELONG( DOS_AX, 0 ) ;

	return(maddr);
}

/****************************************************************
 *  Returns the amount of memory available in bytes.
 ****************************************************************/
LONG dos_avail(VOID)
{
	LONG		mlen;

	DOS_AX = 0x4800;
	DOS_BX = 0xffff;

	__DOS();

	mlen = ((LONG) DOS_BX) << 4;
	return(mlen);
}

/****************************************************************
 *
 ****************************************************************/
WORD dos_free(LONG maddr)
{
	DOS_AX = 0x4900;
	DOS_ES = HIWORD(maddr);

	__DOS();

	return(DOS_AX);
}

/****************************************************************
*
*****************************************************************/
VOID	dos_gettime(WORD* hours, WORD *minutes, WORD *seconds, WORD* hsec)
{
	DOS_AX=0x2C00;
	__DOS();

	*hours = (DOS_CX >> 8) & 0xFF;
	*minutes = DOS_CX & 0xFF;
	*seconds = (DOS_DX >> 8) & 0xFF;
	*hsec = DOS_DX & 0xFF;
	
}

/****************************************************************
 *
 ****************************************************************/
	VOID
dos_label(drive, plabel)
	BYTE		drive;
	BYTE		*plabel;
{
	BYTE		label_buf[128];
	BYTE		ex_fcb[40];

	dos_sdta( (FCB far *)label_buf ) ;
	ex_fcb[0] = 0xff;
	memset( (void *)&ex_fcb[1], 0, 5 ) ;
	ex_fcb[6] = 0x08;		/* volume label	*/
	ex_fcb[7] = drive;
	memset( (void *)&ex_fcb[8], '?', 11 ) ;
	memset( (void *)&ex_fcb[19], 0, 21 ) ;

	dos_func(0x1100, ADDR(&ex_fcb[0]));

	if ( (DOS_AX & 0x00ff) == 0xff )
	  *plabel = NULL;
	else
	{
	  label_buf[19] = 0x0;
	  strcpy( plabel, &label_buf[8] );
	}
}

/****************************************************************
 *
 ****************************************************************/     
VOID dos_space(WORD drv, LONG *ptotal, LONG *pavail)
{
	DOS_AX = 0x3600;
	DOS_DX = drv;
	__DOS();
	
	DOS_AX *= DOS_CX;
	*ptotal = (LONG) DOS_AX * (LONG) DOS_DX;
	*pavail = (LONG) DOS_AX * (LONG) DOS_BX;
}

/****************************************************************
 *  Return drive type.  0 = 'A', ....
 ****************************************************************/     
WORD dos_dtype(WORD drv)
{
	DOS_AX = 0x0E00;	/* Select a given drive */
	DOS_DX = drv;
	__DOS();

	DOS_AX = 0x1900;	/* Was the select successful? */
	__DOS();		/* If not it's joined or just not there */
	if( (DOS_AX & 0xFF) != drv ) return( 0x0F );
			
	if( drv+'A' == 'B' ){ 
	  DOS_AX = 0x440E;  /* Is drive B: a ghost (>1 logical device on A:) */
	  DOS_BX = 0; 		/*drv;*/
	  __DOS();
	  if( (DOS_AX&0xFF) > 0 ) return( 0x0F );	
	}

	DOS_AX = 0x4408;	/* Removable media check */
	DOS_BX = drv+1;
	__DOS();
	
	if(/* (DOS_AX&0x00FF) == 0x0F || */(DOS_AX&0x00FF) == 0 )
	  return( DOS_AX&0x00FF );	/* Invalid or Removable (floppy) */
	
	DOS_AX = 0x4409;	/* local media check */
	DOS_BX = drv+1;
	__DOS();
	if( DOS_ERR ) return( 0x0F );
	if( DOS_DX & 0x1000 )  
	  return( 2 );	/* remote (network) */
	else
	  return( 1 );	/* local (hard) */
}

/****************************************************************
 *  Return DOS logical drive count.
 ****************************************************************/     
WORD dos_ldt(VOID)
{
	DOS_AX = 0x0E00;
	DOS_DX = 0x0000;
	__DOS();
	return( DOS_AX & 0xFF );
}

/****************************************************************
 *
 ****************************************************************/     
WORD dos_rmdir(LONG ppath)
{
	BYTE		tmp_path[LEN_ZPATH];
	WORD		ret;
	WORD		cnt = 0;

 	fmemcpy( (void far *)tmp_path, (void far *)ppath, LEN_ZPATH );
	
	do{

	  dos_func(0x3a00, ADDR( &tmp_path[0] ) );
	  passw_strip( ADDR( &tmp_path[0] ) );
	  
	  if( DOS_ERR && DOS_AX == E_PASSWFAIL )
	    ret = passw_perror( (BYTE far *)&tmp_path[0], cnt++, TRUE );

	}while( ret && (DOS_ERR && DOS_AX==E_PASSWFAIL) );
	
	if( !DOS_ERR && *(char far *)(ppath+1) == ':' )
	    tree_delete(&tmp_path[0]);

	return(!DOS_ERR);
	
} /* end dos_rmdir() */

/****************************************************************
 *
 ****************************************************************/     
WORD dos_create(LONG pname, WORD attr)
{
	WORD		cont;
	WORD		cnt = 0;
	BYTE		tmp_name[LEN_ZPATH];

 	fmemcpy( (void far *)tmp_name, (void far *)pname , LEN_ZPATH );

	cont = FALSE;
	do{

	  DOS_CX = attr;
	  dos_func(0x3c00, ADDR( &tmp_name[0] ));
	  passw_strip( ADDR( &tmp_name[0] ) );
	  
	  if( DOS_ERR && DOS_AX == E_PASSWFAIL )
	  {
	    /* Fail for two reasons: protected FILE or PATH */
	    cont = _dos_chkpath( tmp_name );
	    if( cont==PATH_OK )
	      cont = passw_ferror( (BYTE far *)&tmp_name[0], cnt++ );
	  }

	}while( cont && (DOS_ERR && DOS_AX==E_PASSWFAIL) );

	return(DOS_AX);
}

/****************************************************************
 *
 ****************************************************************/     
WORD dos_mkdir(LONG ppath)
{
	dos_func(0x3900, ppath);

	if (!DOS_ERR && *(char far *)(ppath+1) == ':')
	    tree_add((BYTE *)ppath);

	return(!DOS_ERR);
}

/****************************************************************
 *
 ****************************************************************/     
WORD dos_delete(LONG pname)
{
	WORD		ret;
	WORD		cnt = 0;
	BYTE		tmp_name[LEN_ZPATH];

 	fmemcpy( (void far *)tmp_name, (void far *)pname , LEN_ZPATH );

      do{
      
      	dos_func(0x4100, ADDR( &tmp_name[0] ));
	passw_strip( ADDR( &tmp_name[0] ) );
	if (DOS_ERR)
	{
	  
	  if( DOS_AX == E_PASSWFAIL )
	    ret = passw_ferror( (BYTE far *)&tmp_name[0], cnt++ );
	  else
	    return(DOS_AX);
	}
      }while( (DOS_ERR && DOS_AX==E_PASSWFAIL) && ret );
      
      return(DOS_AX);
}

/****************************************************************
 *
 ****************************************************************/     
WORD dos_rename(LONG poname, LONG pnname)
{
	WORD		ret;
	WORD		cnt = 0;

    do{
    	DOS_DI = LOWORD(pnname);
	DOS_ES = HIWORD(pnname);
	dos_func(0x5600, poname);
	passw_strip( poname );
	
	if( DOS_ERR && DOS_AX == E_PASSWFAIL )
	  ret=passw_ferror( (BYTE far *)poname, cnt++ );
    
    }while( (DOS_ERR && DOS_AX==E_PASSWFAIL) && ret );
    return(DOS_AX);
}

/****************************************************************
 *
 ****************************************************************/     
WORD dos_write(WORD handle, WORD cnt, LONG pbuffer)
{
	DOS_CX = cnt;
	DOS_BX = handle;
	dos_func(0x4000, pbuffer);
	return(DOS_AX);
}

/****************************************************************
 *
 ****************************************************************/     
WORD dos_chmod(LONG pname, WORD func, WORD attr)
{
	WORD		ret;
	WORD		cnt = 0;
	BYTE		tmp_name[LEN_ZPATH];

 	fmemcpy( (void far *)tmp_name, (void far *)pname , LEN_ZPATH );

	ret = FALSE;
	do{

	  DOS_CX = attr;
	  dos_func(0x4300 + func, ADDR( &tmp_name[0] ));
	  passw_strip( ADDR( &tmp_name[0] ) );
	  if( DOS_ERR && DOS_AX == E_PASSWFAIL )
	    ret = passw_ferror( (BYTE far *)&tmp_name[0], cnt++ );

	}while( ret && (DOS_ERR && DOS_AX==E_PASSWFAIL) );

	return(DOS_CX);
}

/****************************************************************
 *
 ****************************************************************/     
VOID dos_setdt(WORD handle, WORD time, WORD date)
{
	DOS_AX = 0x5701;
	DOS_BX = handle;
	DOS_CX = time;
	DOS_DX = date;

	__DOS();
}

/****************************************************************
 *
 ****************************************************************/     
VOID dos_get_country(LONG nat)
{
	DOS_AX = 0x3800;	/* Get country info 	*/
	DOS_DX = LOWORD(nat);	/* Do the function	*/
	DOS_DS = HIWORD(nat);
	
	__DOS();
}

/****************************************************************
 * Check for presence of EMMXXXX0.  Returns TRUE if present, 
 *	 FALSE otherwise.
 ****************************************************************/     
WORD	lim_driver_present()
{
	WORD	ret = FALSE;
					/* First, try to open device	*/
	if ( ((DOS_BX = dos_open(ADDR("EMMXXXX0"), 0)) != 0) && !DOS_ERR )
	{				
					/* Now rule out coincidental	*/
					/*   existence of file by	*/
					/*    same name			*/
		
		DOS_AX = 0x4400;	/* IOCTL: get device info */
		__DOS();
		if (!DOS_ERR && (DOS_DX & 0x80))
		{
			DOS_AX = 0x4407;
			__DOS();
			if (!DOS_ERR && (DOS_AX & 0xFF))
				ret = TRUE;
		}
	}
	return( ret );
}

/****************************************************************
 * TaskMAX:	Installation Check
 * entry:	AX = 2700H
 * exit:	AL = 0FFH if switcher resident, 0H if not
 ****************************************************************/     
WORD tm_install_check()
{
	DOS_AX = 0x2700;
	__TM();
	return(DOS_AX&0xFF);	/* return low word only */
}
	
/****************************************************************
 * TaskMAX:	Switcher Status
 * entry:	AX = 2701H
 * exit		AX = max # of tasks supported
 *		BX = foreground task index in TASK_TABLE
 *		CX = # of currently active tasks
 *		DX = switcher version
 *		ES:SI -> TASK_IDS array (IDs of active tasks)
 *		ES:DI -> TASK_NAMES (8 bytes each, ASCIIZ)
 ****************************************************************/     
WORD	tm_status(WORD *max_tasks, WORD *our_index, WORD *version,
		LONG *task_ids, LONG *task_names)
{
	DOS_AX = 0x2701;
	__TM();
	*max_tasks = DOS_AX;
	*our_index = DOS_BX;
	*version = DOS_DX;
	*task_ids = MAKELONG( DOS_ES, DOS_SI );
	*task_names = MAKELONG(DOS_ES, DOS_DI );	
	return(DOS_CX);
}
	
/****************************************************************
 * TaskMAX:	Get EMS memory limit per task
 * entry:	AX = 2702
 * exit:	DX = maximum number of free LIM pages to return
 *		     from LIM function 2 (AH = 42H) to applications
 ****************************************************************/     
WORD	tm_get_ems_limit()
{
	DOS_AX = 0x2702;
	__TM();
	return(DOS_DX);
}

/****************************************************************
 * TaskMAX:	Set EMS memory limit per task
 * entry:	AX = 2703H
 *		DX = maximum number of free LIM pages to return
 *		     from LIM function 2 (AH=42H) to applications
 ****************************************************************/     
VOID	tm_set_ems_limit(WORD limit)
{
	DOS_AX = 0x2703;
	DOS_DX = limit;
	__TM();
}

/****************************************************************
 * TaskMAX:	Register current process as task manager
 * entry:	AX = 2704H
 *		DL = 1 
 * exit:	DL = 1/0 (previous state of task manager flag)
 ****************************************************************/     
WORD	tm_register_mgr()
{
	DOS_AX = 0x2704;
	DOS_DX = 1;
	__TM();
	return(DOS_DX&&0xFF);	/* lower half only */
}

/****************************************************************
 * TaskMAX:	Unregister current process as task manager
 * entry:	AX = 2704H
 *		DL = 0
 * exit:	DL = 1/0 (previous state of task manager flag)
 ****************************************************************/     
WORD	tm_unregister_mgr()
{
	DOS_AX = 0x2704;
	DOS_DX = 0;
	__TM();
	return(DOS_DX&&0xFF);	/* lower half only */
}

/****************************************************************
 * TaskMAX:	Enable direct switching
 * entry:	AX = 2705H
 *		DL = 1
 ****************************************************************/     
VOID	tm_enable_switching()
{
	DOS_AX = 0x2705;
	DOS_DX = 1;
	__TM();
}

/****************************************************************
 * TaskMAX:	Disable direct switching
 * entry:	AX = 2705H
 *		DL = 0
 ****************************************************************/     
VOID	tm_disable_switching()
{
	DOS_AX = 0x2705;
	DOS_DX = 0;
	__TM();
}

/****************************************************************
 * TaskMAX:	Switch to specific task
 * entry:	AX = 2706H
 *		DX = task index to switch to
 * exit:	DX = task index of last active task
 ****************************************************************/     
WORD	tm_switch(WORD index)
{
	DOS_AX = 0x2706;
	DOS_DX = index;
	__TM();
	return(DOS_DX);
}

/****************************************************************
 * TaskMAX:	Create a task. Make sure < 20.
 * exit:	DX = index of created task, -1 if dead.
 ****************************************************************/
WORD	tm_create_task(BYTE *progpath, BYTE *parm_str, BYTE *fcb_area)
{
	LONG	junk;
	
	if ( tm_status( (WORD*)&junk, (WORD*)&junk, (WORD*)&junk,
		&junk, &junk) >= MAX_TM_TASKS)
	{
		alert(1, ERTM20TK);
		return(-1);
	}
	else return ( do_create_task(progpath, parm_str, fcb_area));
}

/****************************************************************
 * TaskMAX:	Destroy existing task
 * entry:	AX = 2708H
 *		DX = index of task to kill
 ****************************************************************/     
VOID	tm_destroy_task(WORD index)
{
	DOS_AX = 0x2708;
	DOS_DX = index;
	__TM();
}

#if 0 /* May not need this */
/****************************************************************
 * TaskMAX:	Name Task
 * entry:	AX = 2709H
 *		DX = task ID
 *		DS:SI = eight byte name (all 0's to un-name)
 * exit:	ES:DI = name in task table
 *		BX = task ID
 *		AL = task_table[bx] (ID?)
 ****************************************************************/
WORD	tm_name_task(WORD task_id, FBYTE *new_name)
{
	DOS_AX = 0x2709;
	DOS_DX = task_id;
	DOS_DS = HIWORD(new_name);
	DOS_SI = LOWORD(new_name);
	__TM();
}
#endif /* 0 */

/****************************************************************
 * TaskMAX:	Check for open files
 * entry:	AX = 270CH
 *		DX = task index
 * exit		AX = # of open files
 ****************************************************************/
WORD	tm_check_open_files(WORD task_index)
{
	DOS_AX = 0x270C;
	DOS_DX = task_index;
	__TM();
	return (DOS_AX);
}

/****************************************************************
 * TaskMAX:	Check if task at root process
 * entry:	AX = 270DH
 *		DX = task index
 * exit		DX = 0000 if root process if running	 
 ****************************************************************/
BOOLEAN	tm_at_root_proc(WORD task_index)
{
	DOS_AX = 0x270D;
	DOS_DX = task_index;
	__TM();
	return(DOS_DX == 0);
}


/****************************************************************
 * TaskMAX:	Get swap space remaining
 * entry:	AX = 2714H
 * exit		CX = total swap space in 1 Kb blocks
 *		DX = available swap space in 1 Kb blocks
 ****************************************************************/
WORD	tm_get_swap_space(WORD *total)
{

	DOS_AX = 0x2714;
	__TM();
	*total = DOS_CX;
	return( DOS_DX );
}


/****************************************************************
 * LIM:		Get EMS memory limit per task
 * entry:	AX = 4200h
 * exit:	DX = number of pages
 ****************************************************************/     
WORD	lim_get_pages()
{
	DOS_AX = 0x4200;
	__LIM();
	return(DOS_DX);
}

/*
 *	EOF:	gemdos.c
 */
