/*	FNDEXOBJ.C		04/09/1990		Dan Brown	    */
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*   Copyright 1999, Caldera Thin Client Systems, Inc.                      */
/*   This software is licensed under the GNU Public License.                */
/*   See LICENSE.TXT for further information.                               */
/*                                                                          */
/*   Historical Copyright                                                   */
/*                                                                          */
/*    	Copyright (c) 1990 Digital Research Inc.			    */
/*    The software contained in this listing is proprietary to		    */
/*    Digital Research Inc., Monterey, California and is		    */
/*    covered by U.S. and other copyright protection.  Unaurthorized	    */
/*    copying, adaptation, distribution, use or display is prohibited	    */
/*    and may be subject to civil and criminal penalties.  Disclosure	    */
/*    to others is prohiited.  For the terms and conditions of soft-	    */
/*    ware code use refer to the appropriate Digital Research		    */
/*    license agreement.						    */
/*--------------------------------------------------------------------------*/
#include "shell.h"
#include "list.h"
#include "exproto.h"

/*--------------------------------------------------------------------------*/
/* NAME: find_exobj							    */
/*									    */
/* PURPOSE: Finds the object number of the given part of a complex resource */
/*	    object. The part number is in hte high byte of the object type. */
/*									    */
/* INPUT:   FDOBJECT	*tree	-   Pointer to tree.			    */
/*	    WORD	parent	-   Parent of complex object.		    */
/*	    WORD	part	-   Part number.			    */
/*									    */
/* OUTPUT:  WORD	return()-   object number of desired part. -1 means */
/*				    the part was not found.		    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
find_exobj(     FDOBJECT  *tree,
		WORD	parent,
		WORD	part
		)
{
    WORD    obj;			/* number of current object.	    */
    WORD    prev_obj;			/* number of the previous object.   */
    WORD    head;			/* number of the head object.	    */
    
    if( exobj_num( tree, parent ) == part ) /* Check if parent is the one.  */
        return( parent );

    obj = (tree+parent)->ob_head;
    while( obj != parent )		/* Walk complex object.		    */
    {
        if( exobj_num( tree, obj ) == part ) /* Check if part is found.	    */
            return( obj );

	head = (tree+obj)->ob_head;
        if( head > 0 )			/* Check if object has children.    */
        {
            obj = head;			/* If so, check children.	    */
        }
        else				/* If not, go to next object. if the*/
        {				/* previous object is a tail, walk  */
					/* back up the tree.		    */
            for( prev_obj = obj, obj = (tree+obj)->ob_next;
                 obj != parent && prev_obj == (tree+obj)->ob_tail;
                 prev_obj = obj, obj = (tree+obj)->ob_next );
        }
    }

    return( -1 );			/* Part was not found.		    */
}
