/*	EXOBJ.C		05/25/1988		Dan Brown		    */
/*****************************************************************************
exobj.c			PT 2.0  C Sources			        EXOBJ
******************************************************************************
   Copyright 1999, Caldera Thin Client Systems, Inc.                       
   This software is licensed under the GNU Public License.                 
   See LICENSE.TXT for further information.                                
                                                                           
   Historical Copyright                                                    
                                                                           

Copyright (c) 1985,1988,1991,1992 Digital Research Inc.	All rights reserved.  
The Software Code contained in this listing is proprietary to Digital Research
Inc., Monterey, California, and is covered by U.S. and other copyright
protection. Unauthorized copying, adaption, distribution, use or display
is prohibited and may be subject to civil and criminal penalties.
Disclosure to others is prohibited. For the terms and conditions of
software code use, refer to the appropriate Digital Research License
Agreement.
			U.S. GOVERNMENT RESTRICTED RIGHTS
				
This software product is provided with RESTRICTED RIGHTS.  Use,
duplication or disclosure by the Government is subject to restrictions as
set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or the
applicable provisions of the DOD FAR supplement 252.227-7013 subdivision
(b) (3) (ii) (May, 1981) or subdivision (c) (1) (ii) (May, 1987).
Contractor/manufacturer is Digital Research Inc. / 70 Garden Court / BOX
DRI / Monterey, CA 93940.
*******************************************************************************
$Header: m:/davinci/users//groups/panther/dsk/rcs/exobj.c 3.2 92/03/12 13:59:36 rsf Exp $

Date	Who	SPR#	Comments
------- ----	----	------------------------------------------------------
910618	RSF		Fix bug in updState_exobj, probably intro'd by 
			adaptation.
910325	RSF		Adapt for use in ViewMAX
******************************************************************************/

#include "shell.h"
#include "danutil.h"


/*--------------------------------------------------------------------------*/
/* NAME: get_data_ptr							    */
/*									    */
/* PURPOSE: Gets a pointer to the extended object data.			    */
/*--------------------------------------------------------------------------*/
    GLOBAL FBYTE
*get_data_ptr( 
	       TREE	tree,		/* Tree address.		    */
	       WORD	obj		/* object number.		    */
	       )
{
    FDOBJECT	*obj_ptr;
    FAPPLBLK	*ab;
    
    obj_ptr = tree + obj;
    ab = (FAPPLBLK *)obj_ptr->ob_spec;
    return( (FBYTE *)ab->ab_parm );
}

    GLOBAL VOID
updState_exobj( TREE	tree,
		WORD	start_obj,
		WORD	state,
		WORD	onoff,
		WORD	redraw
		)
{
    WORD	obj, prev_obj, head, new_state;
    FDOBJECT	*obj_ptr;
    RECT	r;
    WORD	g_str;
    
    obj = start_obj;
    obj_ptr = tree + obj;
    if( onoff == ON )
	new_state = obj_ptr->ob_state | state;
    else if( onoff == OFF )
	new_state = obj_ptr->ob_state & (~state);
    else
	new_state = state;

    g_str = FALSE;
    if( obj_ptr->ob_head >= 0 )
    {
	obj = obj_ptr->ob_head;
	do
	{
	    obj_ptr = tree + obj;
	    
	    if( onoff == ON )
		obj_ptr->ob_state |= state;
	    else if( onoff == OFF )
		obj_ptr->ob_state &= ~state;
	    else
		obj_ptr->ob_state = state;
	    
	    head = obj_ptr->ob_head;
	    if( head > 0 )
	    {
		obj = head;
	    }
	    else if( obj != start_obj )
	    {
		prev_obj = obj;
		obj = obj_ptr->ob_next;
		obj_ptr = tree + obj;
		while( obj != start_obj && prev_obj == obj_ptr->ob_tail )
		{
		    prev_obj = obj;
		    obj = obj_ptr->ob_next;
		    obj_ptr = tree + obj;
		}
	    }
	}while( obj != start_obj );
    }
    else
    {
	if( (g_str = ((obj_ptr->ob_type & 0x00FF) == G_STRING)) == FALSE )
	    obj_ptr->ob_state = new_state;
    }

    get_obloc( tree, start_obj, &r );
    if( g_str )
	objc_change( tree, start_obj, MAX_DEPTH, r.x, r.y, r.w, r.h,
		new_state, redraw );
    else if( redraw )
	objc_draw( tree, start_obj, MAX_DEPTH, r.x, r.y, r.w, r.h );
}

/*--------------------------------------------------------------------------*/
/* NAME: exobj_num							    */
/*									    */
/* PURPOSE: Gets the part number of the given object.			    */
/*									    */
/* INPUT:   FDOBJECT	*tree	-   Pointer to tree.			    */
/*	    WORD	obj	-   Object number to find part # of.	    */
/*									    */
/* OUTPUT:  WORD	return()-   Part number.			    */
/*									    */
/*--------------------------------------------------------------------------*/
    GLOBAL WORD
exobj_num(     FDOBJECT	*tree,
	       WORD	obj
	       )
{
    WORD	ret;
    
    ret = (WORD)(((tree+obj)->ob_type >> 8) & 0x00FF);
    return( ret );
}
