/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1992  Digital Research Inc.  All rights reserved.    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/ems.c 4.1 91/11/08 12:44:45 anderson Exp $
* $Log:	ems.c $
 * Revision 4.1  91/11/08  12:44:45  anderson
 * Interface to EMS driver.
 * 
*****************************************************************************/

/****************************************************************************
* File:		ems.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/

#include <dos.h>
#include "shell.h"


#define	EMM_INT		0x67

#define	EMM_STATUS	0x40
#define EMM_PAGE_ADDR	0x41
#define EMM_AVAIL	0x42
#define EMM_ALLOC	0x43
#define EMM_MAP		0x44
#define EMM_FREE	0x45
#define EMM_VERSION	0x46
#define EMM_NUM_PAGES	0x58

#define NAME_LEN	8
#define GET_VECTOR	0x35

/* some of the many EMM error codes */
#define EMM_BUSY	0x82
#define NO_HNDL_AVAIL	0x85
#define EXCEED_PPAGES	0x87
#define EXCEED_LPAGES	0x88

/****************************************************************
 *  Make a call to the EMM.  Return of FALSE = success.
 ****************************************************************/
MLOCAL BYTE	EMM_Call(BYTE function, union REGS *ireg, union REGS *oreg)
{
    ireg->h.ah = function;
    int86(EMM_INT, ireg, oreg);
    
    return(oreg->h.ah);
}

/****************************************************************
 *  See if an expanded memory manager is loaded by looking at
 *  the name field in the driver's device header.  Then check
 *  the EMS status to make sure hardware and driver are present
 *  and functional.
 ****************************************************************/
MLOCAL BYTE	EMS_Check(VOID)
{
    BYTE	 emmname[8]="EMMXXXX0";
    union  REGS	 regs;
    struct SREGS segreg;
    
    regs.h.al = EMM_INT;			/* check for EMM driver */
    regs.h.ah = GET_VECTOR;
    intdosx(&regs, &regs, &segreg);
    
    if (fmemcmp((FBYTE *)MK_FP(segreg.es, 10), (FBYTE *)emmname, NAME_LEN))
	return(FALSE);
    
    if (EMM_Call(EMM_STATUS, &regs, &regs))	/* 0 = present & functional */
	return(FALSE);

    return(TRUE);
    
} /* end EMS_Check() */

/****************************************************************
 *  Return the number of 16Kb pages of logical EMS available.
 ****************************************************************/
WORD	EMS_Avail(VOID)
{
    union  REGS  regs;

    if (EMM_Call(EMM_AVAIL, &regs, &regs))
	return(FALSE);

    return(regs.x.bx);
}

/****************************************************************
 *  Make sure EMM driver is loaded & ready, and hardware is OK.
 *  Get the EMM version number, the number of logical EMS pages
 *  available, and the address of the page frame.
 ****************************************************************/
BYTE	EMS_Init(BYTE *emm_vers, WORD *pf_addr, WORD *ppgs, WORD *lpgs)
{
    union  REGS	 regs;
    
    if (!EMS_Check())				/* make sure EMS is OK */
	return(FALSE);
    
    if (EMM_Call(EMM_VERSION, &regs, &regs))	/* record the EMM version # */
	return(FALSE);
    else *emm_vers = regs.h.al;

    if (EMM_Call(EMM_PAGE_ADDR, &regs, &regs))	/* get the page frame address */
	return(FALSE);
    else *pf_addr = regs.x.bx;

    regs.h.al = 1;
    if (EMM_Call(EMM_NUM_PAGES, &regs, &regs))	/* get # of physical pages */
	return(FALSE);				/* ...that can be mapped   */
    else *ppgs = regs.x.cx;
    if (*ppgs == 0)
	return(FALSE);
    
    *lpgs = EMS_Avail();			/* get # of logical pages of */
    if (*lpgs == 0)				/* ...available EMS memory   */
	return(FALSE);

    return(TRUE);
    
} /* end EMS_Init() */

/****************************************************************
 *  Allocate the requested number of 16Kb logical pages of EMS
 *  memory.  These will be assigned to a single handle if they 
 *  can be allocated successfully.  Function returns handle #.
 ****************************************************************/
WORD	EMS_Alloc(WORD num_pages)
{
    union  REGS  regs;
    
    regs.x.bx = num_pages;
    if (EMM_Call(EMM_ALLOC, &regs, &regs))
	return(FALSE);

    return(regs.x.dx);				/* handle number */
    
} /* end EMS_Alloc() */

/****************************************************************
 *  Map the requested logical EMS pages onto physical memory.
 ****************************************************************/
BYTE	EMS_Map(WORD handle, BYTE ppage, WORD lpage)
{
    union  REGS  regs;
    
    regs.h.al = ppage;
    regs.x.bx = lpage;
    regs.x.dx = handle;
    if (EMM_Call(EMM_MAP, &regs, &regs))
	return(FALSE);
    
    return(TRUE);
}

/****************************************************************
 *  Deallocate the EMS pages assigned to a handle and release the
 *  handle.
 ****************************************************************/
VOID	EMS_Free(WORD handle)
{
    union  REGS  regs;

    regs.x.dx = handle;
    EMM_Call(EMM_FREE, &regs, &regs);
						/* assume success? */
}


/*
 *	ems.c
 */
