/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1991,1992 Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/desktmax.c 3.5 92/04/10 13:40:02 sbc Exp $
* $Log:	desktmax.c $
 * Revision 3.5  92/04/10  13:40:02  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 3.4  92/04/03  17:11:54  sbc
 * WNODEs and PNODEs to fars, lots of other housekeeping
 * 
 * Revision 3.3  92/03/12  13:58:16  rsf
 * Merge in RSF's changes for icons on desktop and (LONG) => (TREE).
 * 
 * Revision 3.2  92/02/19  15:55:35  sbc
 * Replace refs to G.a_trees[] with calls to rsrc_gaddr().
 * 
 * Revision 3.1  91/08/19  16:39:43  system
 * ViewMAX 2 sources
 * 
 * Revision 3.19  91/08/15  15:11:28  fontes
 * SPR 806494: Verify availability of EMMXXXX0 before making LIM call
 * 
 * Revision 3.18  91/08/12  14:39:22  sbc
 * what
 * (^oops!) Fix problem in tm_checks() where fstrcpy() was used with a
 * source string that was possibly not null-terminated. SPR #806491.
 * 
 * Revision 3.17  91/07/26  13:28:45  sbc
 * modify calls to ini_read() and ini_write().
 * 
 * Revision 3.16  91/07/19  15:35:03  fontes
 * Fix for confused registration when multiple ViewMAXs; refresh of list after run
 * 
 * Revision 3.15  91/07/09  14:46:02  sbc
 * fun_alert() => alert(); alert defines ST* => ER*
 * 
 * Revision 3.14  91/07/02  09:00:52  sbc
 * rm debugging alerts for July 2 release.
 * 
 * Revision 3.13  91/07/01  15:29:22  fontes
 * Fix swap space display and a problem setting tmax_control at init
 * 
 * Revision 3.12  91/06/26  13:10:26  fontes
 * Change Swap Space display and differentiate TaskMAX being loaded from VM being task manager
 * 
 * Revision 3.11  91/06/24  14:54:24  sbc
 * hook up correct help alerts for TaskMAX and TaskMAX Preferences dialogs.
 * 
 * Revision 3.10  91/06/21  15:45:08  fontes
 * Record preference for control of TM
 * 
 * Revision 3.8  91/06/13  16:56:30  fontes
 * Re-worked TaskMAX interface
 * 
 * Revision 3.5  91/06/04  13:04:37  sbc
 * misc housekeeping and other ravings...
 * 
 * Revision 3.4  91/05/31  11:20:39  sbc
 * misc changes associated with rewrites in deskapp.c and inifiles.c
 * 
 * Revision 3.3  91/05/29  16:28:00  fontes
 * Don't show ViewMAX on active task list
 * 
 * Revision 3.1  91/05/16  14:44:10  fontes
 * Separate branch for Beta bug fixes, separate from split-mode windows
 * 
 * Revision 2.9  91/05/09  16:49:54  fontes
 * Use button enablement instead of alert for TM Run/Delete
 * 
 * Revision 2.4  91/04/29  13:18:35  whf
 * changed i/f to ini_write()
 * 
 * Revision 2.3  91/04/26  16:25:30  fontes
 * Changes in support of .ini routines
 * 
Date	Who	SPR#	Comments
-------	-------	----	------------------------------------------------------
910701	RSF		Swap Space Display, etc.
910528	RSF	806210	Boo-boo when tasknames are 8 chars long (TM doesn't \0
			teminate such).
			Use hourglass while going to or deleting task.
		806166	Leave highlight bar on return.
910509	RSF		Instead of alert, disable Run and Delete until a
			task has been selected.
910508	RSF		Stripped out hot key stuff. Removed *able_switching
			calls.  TaskMAX will then handle hot keys itself.
910507	RSF		Display alert if nothing selected for TM Run/Delete.
910506	RSF		Moved taskmax_avail here from desktop.c
			Added routine to discover TM's special keys from .ini
910430	RSF		Set start_fld to OK in TM dialog
910429	WHF		changed i/f to ini_write()
910426	RSF		.INI file handling.
910422	RSF		Convert to xform_do.
910421	RSF		Implement RUN/DELETE functionality.
910419	RSF		Ignore RUN/DELETE if no task selected.
910416-18 RSF		TaskMAX dialog implementation.
*****************************************************************************/

/****************************************************************************
* File:		desktmax.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/

#include "shell.h"
#include "list.h"
#include "exobdefs.h"
#include "danutil.h"
#include "exproto.h"
#include "inidefs.h"

#define DEBUG_TM 0

#define TSKNM_SIZE	 8
#define TSKNM_START	 3		/* Past a 2-digit index and sp	*/
					/* enough for 2-digit index,	*/
					/*	sp and null		*/
#define TSKITEM_SIZE	TSKNM_SIZE + TSKNM_START + 1
#define TM_KEYBUF_SIZE	10

#define K_per_PG	16
#define MAX_TM_EMS	2048	/* 32M  = 2048*16K */

typedef struct tname
{
	char	name[TSKNM_SIZE];
} TASKNAME;


GLOBAL WORD	taskmax_avail;	/* Whether TaskMAX is already loaded	*/
GLOBAL WORD	taskmax_control;/* Whether TaskMAX is controlled by a	*/
				/*   ViewMAX dialog.			*/


extern PREFS	prefs;
extern GLOBES	G;


MLOCAL UWORD	tm_lim_size;	/* LIM size setting in K. Initially from*/
				/* TASKMAX.INI, settable from TM prefs	*/

MLOCAL	WORD	emm_driver;	/* Whether EMMXXXX0 can be opened	*/

MLOCAL	FLISTITEM	*old_items = 0L;	/* Recyclable list items */

#if DEBUG_TM
MLOCAL	TASKNAME	test_tasks[3] = {"X","A","B"};
MLOCAL	BYTE		test_ids[3] = {0,1,2};
#endif

/****
  The information obtained by calls to tm_status
****/	  
MLOCAL	TASKNAME far	*task_names;	/* Task names, indexed by task	*/
					/* ID, each 8 bytes long.	*/
MLOCAL	BYTE far	*task_ids;	/* Array of task IDs		*/
MLOCAL	WORD		active_count;	/* Number of active tasks	*/
MLOCAL	WORD		vm_index;	/* ViewMAX's task index		*/



/****************************************************************************
*	This routine changes the LIMSize setting in the .INI file for
*	TaskMAX to the value passed in.  It returns success/failure.
*****************************************************************************/
GLOBAL WORD SaveTMLIMSize( void)
{
	BYTE	buffer[20];
/*	BYTE far	*tm_filename; */
	BYTE far	*memory_sect;
	BYTE far	*limsize_item;
	
	itoa(tm_lim_size, buffer, 10);
/*	rsrc_gaddr( R_STRING, INIFNTM, (TREE *)&tm_filename); */
	rsrc_gaddr( R_STRING, TMMEMSEC, (TREE *)&memory_sect);
	rsrc_gaddr( R_STRING, TMLIMITM, (TREE *)&limsize_item);	
	return( ini_write( INIFNTM, memory_sect, limsize_item, (BYTE far*)buffer) );
}


/***************************************************************************
*	This routine initializes the contents of the task listbox.
****************************************************************************/
MLOCAL void task_lb_init( 
	TREE	tree,		/* The TaskMAX Interface tree	*/
	WORD	start_index,	/* Task to highlight		*/
	BOOLEAN	redraw		/* Redraw the listbox		*/
	)
{
	BYTE		ii;
	BYTE		idx[TSKNM_START];	/* For itoa of Task index */
	FLISTITEM	*item;
	FLISTBOX	*lb;

	lb = (FLISTBOX *)get_data_ptr( tree, TMTSKLST );
	if ( !lb->items )
	{
		lb->items= (FLIST*)dos_alloc(sizeof(LIST));
	}
	else if (lb->items->start)
	{
					/* recycle any old list items	   */
		if (old_items)
		{
			lb->items->end->next = old_items;
			old_items->prev = lb->items->end;
		}
		old_items = lb->items->start;
	}
	ls_init(lb->items);

	if (active_count > 0)
	{
					/* construct list of tasknames	*/
		for (ii=0; ii<active_count; ii++)
		{
					/* Don't list ourselves.	*/
			if (ii == vm_index)
				continue;
			if (old_items)
			{
				item = old_items;
				old_items = old_items->next;
				old_items->prev = 0L;
			}
			else
			{
				item = (FLISTITEM*)dos_alloc(sizeof (LISTITEM));
				if (!item)
					return;
				item->it_ptr = (BYTE far*)dos_alloc(TSKITEM_SIZE+1);
				if (!item->it_ptr)
				{
					dos_free((LONG)item);
					return;
				}
			}
			if (ii == start_index)
			{
				item->state = SELECTED;
				(tree+TMRUN)->ob_state = NORMAL;
				(tree+TMDELETE)->ob_state = NORMAL;
			}
			else
				item->state = 0;
			item->flags = SELECTABLE;
			idx[0] = ' ';
			itoa(ii+1, &idx[ii+1>9 ? 0 : 1], 10 );
			fstrcpy(item->it_ptr, (char far *)idx);
			item->it_ptr[2] = ' ';
			fmemcpy(&item->it_ptr[TSKNM_START], 
				(char far *)task_names[task_ids[ii]].name, 
				TSKNM_SIZE);
					/* Make SURE it's null terminated */
			item->it_ptr[TSKITEM_SIZE-1] = '\0';
			add_to_list(lb->items, lb->items->end, item);
		}
	}
	lb_init( tree, TMTSKLST, redraw );

}


/****************************************************************************
 * This routine initializes the elements displayed within the TaskMAX dialog.
 * It returns the object that should be passed to xform_do as the starting
 * field (on which the keyboard focus will be placed).	 
*****************************************************************************/

MLOCAL WORD setup_tmax(
	WORD	start_index,	/* Index of task to highlight	*/
				/*   -1 if none to start.	*/
	BOOLEAN	redraw		/* redraw the listbox?		*/
	)
{
	TREE		tree;
	WORD		junk;
	WORD		init_state = NORMAL;
	WORD		start_fld = TMRUN;
	WORD		swap_space_total, swap_space_avail;
	LONG		swap_space_percent;
#if REL070291	
BYTE alert[128];	
#endif
	rsrc_gaddr( R_TREE, TASKMAX, &tree ) ;
	
		/* Enable RUN/DELETE if a task is selected	*/
	if (start_index < 0)
	{
		init_state = DISABLED;
		start_fld = TMCANCEL;
	}
	(tree+TMRUN)->ob_state = init_state;
	(tree+TMDELETE)->ob_state = init_state;

#if DEBUG_TM
	active_count = 3;
	vm_index = 1;
	task_names = &test_tasks[0];
	task_ids = test_ids;
#else
	active_count = tm_status(&junk, &vm_index, &junk, 
		(LONG*)&task_ids, (LONG*)&task_names);
#endif	
					/* Initialize the list structure   */
					/* for the active tasks.	   */
	task_lb_init( tree, start_index, redraw );

	/* Now plug in Swap Space */
	swap_space_avail = tm_get_swap_space( &swap_space_total );
	sprintf( G.g_1text, "%dK", swap_space_avail );
	tedinfo_set( tree, SWPSPINK, (char far *)G.g_1text );
						/* Compute % to tenths	*/
	swap_space_percent = (LONG)swap_space_avail * 1000L /swap_space_total;
						/* Then round off	*/
	if ( (swap_space_percent % 10) < 5 )
		swap_space_percent /= 10;
	else
		swap_space_percent = (swap_space_percent/10)+1;
	sprintf( G.g_1text, "%ld%%", swap_space_percent );
	tedinfo_set( tree, SWPPCENT, (char far *)G.g_1text );
	if (redraw)
	{
		draw_fld( tree, SWPSPINK );
		draw_fld( tree, SWPPCENT );
	}
	return (start_fld);
} 


/****************************************************************************
 * This routine initializes the preferences displayed within the 
 * TaskMAX dialog. It returns the current EMS memory limit per task.
*****************************************************************************/

MLOCAL WORD setup_tmax_prefs( void )
{
TREE		tree;
BYTE		maxK[10];
UWORD		current_EMS;		/* size in 16K pages	*/
UWORD		max_EMS = MAX_TM_EMS;	

	rsrc_gaddr( R_TREE, TMAXPREF, &tree ) ;
	(tree+VMCTLSTM)->ob_state = prefs.tmax_ctrl ? SELECTED : NORMAL;
	(tree+TMSTATUS)->ob_flags |= HIDETREE;
	if (taskmax_avail)
	{
					/* How much LIM is available? (pgs)*/
		current_EMS = tm_get_ems_limit();
		tm_set_ems_limit(MAX_TM_EMS);
		if (emm_driver)
		{
			max_EMS = lim_get_pages();
		}
		tm_set_ems_limit(current_EMS);
	}
	else
	{
		if (emm_driver)
		{
			max_EMS = lim_get_pages();
		}
		current_EMS = tm_lim_size/K_per_PG;
		if (!tm_install_check())
					/* Tell user that TM not loaded	*/
			(tree+TMSTATUS)->ob_flags &= ~HIDETREE;
	}
	
					/* Now setup LIM use slider */
	vb_setMax(tree, TMLIMUSE, max_EMS*K_per_PG, FALSE);
	vb_setVal(tree, TMLIMUSE, current_EMS*K_per_PG, FALSE);

					/* Label max end of slider */
	sprintf( maxK, "%uK", max_EMS*K_per_PG ) ;
	fstrcpy( (tree+TMMAXEMS)->ob_spec, (char far *)maxK );

					/* Set VM-TM control */
	return(current_EMS);	
} 

/****************************************************************************
 *	This routine computes the index of the selected task in the
 *	task list.  It takes ViewMAX's intentional omission from the
 *	list into account to find this index.
 ****************************************************************************/
WORD	get_task_index(FLIST *items, WORD vm_index)
{
	WORD	task_index;
	task_index = lst_selected(items);
	if (task_index >= 0)
	{		/* Adjust for undisplayed VM	*/
		if (task_index >= vm_index)
			task_index++; 
	}
	return (task_index);

}


/****************************************************************************
 *	This routine determines whether the task identified by the user
 *	has files open or is the root process.  If either of these conditions
 *	exist, the user must confirm his decision to delete the task.
 *	This routine returns TRUE if deletion should proceed.
 *	NOTE: Can't use fstrcpy() for task_name since .name field in task_names
 *	may not be null-terminated.
 ****************************************************************************/
BOOLEAN tm_checks(WORD task_index)
{
	WORD	open_count;
	BYTE	task_name[TSKNM_SIZE+1]	;
	BOOLEAN	ok_to_delete			= TRUE;
	
	fmemcpy((char far *)task_name, task_names[task_ids[task_index]].name,
					TSKNM_SIZE );
	task_name[ TSKNM_SIZE ] = '\0' ;
	
	if (tm_at_root_proc(task_index))
	{
		/* User must confirm */
		ok_to_delete = (alert_s( 1, ERROOTSK, task_name ) == 1);
	}
	
	if (ok_to_delete 
		&& ((open_count = tm_check_open_files(task_index)) > 0))
	{
		/* User must confirm */
		ok_to_delete = 
		    ( alert_sd( 1, ERTSKOPN, task_name, open_count ) == 1 );
	}
	
	return(ok_to_delete);
}


/****************************************************************************
 * This routine manages the TaskMAX Interface dialog.
*****************************************************************************/
 
void taskmax(WORD start_index)
{
	TREE		tree ;
	WORD		obj, ret;
	WORD		task_index, new_task;
	WORD		start_fld;
	BYTE		done = FALSE;
	BYTE		fcb_area[37];
	FLISTBOX	*lb;
	
	rsrc_gaddr( R_TREE, TASKMAX, &tree ) ;
	start_fld = setup_tmax( start_index, FALSE );
	show_hide( FMD_START, tree );
	lb = (FLISTBOX *)get_data_ptr( tree, TMTSKLST );
	
	while (!done)
	{
		draw_fld(tree, TMRUN);
		draw_fld(tree, TMDELETE);
		obj = xform_do( tree, start_fld);
#if HELP_ALERTS
		if ( obj == -1 ) {
		    do_help_alert( HTASKMAX ) ;
		    continue ;
		}
#endif
		/* Determine whether to carry on. */
		if ( (tree+TMCANCEL)->ob_state & SELECTED )
		{
			(tree+TMCANCEL)->ob_state &= ~SELECTED ;
			show_hide(FMD_FINISH, tree);
			return;
		}
		
		else if ( (tree+TMRUN)->ob_state & SELECTED )
		{
			graf_mouse(HOURGLASS, 0x0L);
			(tree+TMRUN)->ob_state &= ~SELECTED ;
				/* Compute the index to the selected	*/
				/*   task and start it.			*/
			task_index = get_task_index(lb->items, vm_index);
			if (task_index >= 0)
			{
				ret = tm_switch(task_index);
				if (ret < 0)
				{
					start_fld = setup_tmax( -1, TRUE);
				}
				else start_fld = setup_tmax(task_index, TRUE);
			}
			graf_mouse(ARROW, 0x0L);
		}
		
		else if ( (tree+TMINSERT)->ob_state & SELECTED )
		{
			graf_mouse(HOURGLASS, 0x0L);
			(tree+TMINSERT)->ob_state &= ~SELECTED ;
					/* Create new command.com */
			ret = pro_cmd( "\0", "\0", 0, "\0", FALSE);
			if (ret)
			{
				new_task = tm_create_task( 
					&G.g_cmd[0], &G.g_tail[0],
					&fcb_area[0]);
				if (new_task >= 0)
				{
					start_fld = setup_tmax( 
						new_task, TRUE );
				}
			}
			graf_mouse(ARROW, 0x0L);
			draw_fld( tree, TMINSERT );
		}

		else if ( (tree+TMDELETE)->ob_state & SELECTED )
		{
			graf_mouse(HOURGLASS, 0x0L);
			(tree+TMDELETE)->ob_state &= ~SELECTED ;

				/* Compute the index to the selected	*/
				/*   task and delete it.		*/
			task_index = get_task_index(lb->items, vm_index);
			if (task_index >= 0)
			{
					/* Check whether the task has	*/
					/*  open files or is the root	*/
					/*  process.			*/
				if ( tm_checks(task_index) )
				{
					tm_destroy_task(task_index);
					start_fld = setup_tmax( -1, TRUE );
				}
			}
			graf_mouse(ARROW, 0x0L);
		}
		else 
		{
			/* Must be list box elements */
			if (exobj_num((FDOBJECT*)tree, obj) == LB_A_SLOT)
			{
				/* Activate buttons.	   */
				(tree+TMRUN)->ob_state = NORMAL ;
				(tree+TMDELETE)->ob_state = NORMAL ;
				start_fld = TMRUN;
			}
		}
	}

	show_hide( FMD_FINISH, tree );
}

/****************************************************************************
 * This routine manages the TaskMAX Preferences dialog.
*****************************************************************************/
 
void taskmax_prefs()
{
	TREE		tree;
	WORD		current_EMS;
	BYTE		done = FALSE;
	WORD		obj, old_control_state;
	WORD		start_fld=VMCTLSTM;
	SLONG		new_EMS, junk;

	current_EMS = setup_tmax_prefs();
	rsrc_gaddr( R_TREE, TMAXPREF, &tree ) ;
	show_hide( FMD_START, tree );
	old_control_state = (tree+VMCTLSTM)->ob_state;
	
	while (!done)
	{
		obj = xform_do( tree, start_fld);
#if HELP_ALERTS
		if ( obj == -1 ) {
		    do_help_alert( HTASKPRF ) ;
		    continue ;
		}
#endif
		if (obj == TMLIMVAL)
		{
			(tree+obj)->ob_state &= ~SELECTED;
			draw_fld(tree, obj);
		}
		/* Determine whether to carry on. */
		if ( (tree+TMPFCAN)->ob_state & SELECTED )
		{
			(tree+TMPFCAN)->ob_state &= ~SELECTED ;
						/* Restore previous state */
			(tree+VMCTLSTM)->ob_state = old_control_state ;
			show_hide(FMD_FINISH, tree);
			return;
		}
		else if ( (tree+TMPFOK)->ob_state & SELECTED )
		{
			if (!(tree+VMCTLSTM)->ob_state & SELECTED)
			{
				prefs.tmax_ctrl = FALSE;
				/* Release control as task manager */
				if (taskmax_avail && taskmax_control)
				{
					taskmax_control = FALSE;
					tm_unregister_mgr();
				}
			}
			else
			{
				/* Try to take control as task manager */
				if (taskmax_avail)
				{
					
					if (!tm_register_mgr())
						taskmax_control = TRUE;
					else (tree+VMCTLSTM)->ob_state &= ~SELECTED;
				}
				prefs.tmax_ctrl = TRUE;
			}
			(tree+TMPFOK)->ob_state &= ~SELECTED ;
			/* Set EMS for TaskMAX and its .ini file */
			get_value(tree, TMLIMUSE, 
				&new_EMS, &junk);
			if ((WORD)new_EMS/16 != current_EMS)
			{
						/* Stash away for possible */
						/*  use by save prefs	   */
				tm_lim_size = (UWORD)new_EMS;	
				if (taskmax_avail)
					tm_set_ems_limit(
						(WORD)new_EMS/16);
			}
			break;
		}
	}

	show_hide( FMD_FINISH, tree );
}

/****************************************************************************
*	This routine sets the global variables "taskmax_avail,"
*	"taskmax_control" and "lim_driver_present."
*****************************************************************************/
GLOBAL	void check_for_taskmax()
{
	WORD	ret;
	BYTE	buffer[20];
/*	BYTE far	*tm_filename; */
	BYTE far	*memory_sect;
	BYTE far	*limsize_item;


	emm_driver = lim_driver_present();
	
					/* Is TaskMAX loaded?	*/
	taskmax_avail = tm_install_check();
					/* User Pref that VM	*/
					/*  control TaskMAX?	*/
	taskmax_control = prefs.tmax_ctrl;

					/* If VM dialog is preferred	*/
					/*   interface to TM, try to	*/
					/*   become the task manager.	*/
	if ( taskmax_control )
	{
		if (tm_register_mgr())
		{				/* Someone already	*/
						/*   registered as mgr	*/
						/*   so we can't be.	*/
			taskmax_control = FALSE;
		}
	}
					/* If TM loaded, find the ems	*/
					/*  limit directly; otherwise,	*/
					/*  get it from TASKMAX.INI.	*/
	if (taskmax_avail)
	{
		tm_lim_size = tm_get_ems_limit();
	}
	else
	{
	
/*		rsrc_gaddr( R_STRING, INIFNTM, (TREE *)&tm_filename); */
		rsrc_gaddr( R_STRING, TMMEMSEC, (TREE *)&memory_sect);
		rsrc_gaddr( R_STRING, TMLIMITM, (TREE *)&limsize_item);	
		ret = ini_read( INIFNTM, memory_sect, limsize_item,
				(BYTE far*)buffer, 20 );
		if (ret == INI_SUCCESS)
			tm_lim_size = (UWORD)atoi(buffer);
		else	tm_lim_size = 0;
	}
}

/* desktmax.c */
