/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985,1991  Digital Research Inc.  All rights reserved.    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/dsk/rcs/deskgraf.c 4.1 91/11/07 16:47:04 anderson Exp $
* $Log:	deskgraf.c $
 * Revision 4.1  91/11/07  16:47:04  anderson
 * Removed unused global variable.
 * 
 * Revision 3.1  91/08/19  16:38:30  system
 * ViewMAX 2 sources
 * 
* Revision 3.3  91/08/15  10:41:30  sbc
* replace calls to gsx_mon() and gsx_moff() with calls to graf_mouse()
* 
* Revision 3.2  91/06/04  13:04:54  sbc
* misc housekeeping and other ravings...
* 
* Revision 3.1  91/05/16  14:42:31  fontes
* Separate branch for Beta bug fixes, separate from split-mode windows
* 
* Revision 2.1.1.4  91/04/23  14:16:48  whf
* made gl_nplanes a global var
* 
* Revision 2.1.1.3  91/04/08  12:11:25  fontes
* Add set_mfdb()
* 
* Revision 2.1.1.2  91/03/25  14:19:28  anderson
* Converted to Medium model, prototyped, and generally cleaned up.
* 
*****************************************************************************
Date	Who	SPR#	Comments
-------	-------	----	-----------------------------------------------------
910423	WHF		Made gl_nplanes a global var
910322	RSF		Add set_mfdb routine.
****************************************************************************/


/****************************************************************************
* File:		deskgraf.c
*
* Description:	
*
* Build Info:	ndmake -f vm2.mak
*
* Overview:	
*  
*****************************************************************************/


#include "shell.h"
#include "funcdef.h"

#define ORGADDR 0x0L
						/* in GSXBIND.C		*/
#define vsf_interior( x )	gsx_1code(S_FILL_STYLE, x)
#define vsf_style( x )		gsx_1code(S_FILL_INDEX, x)
#define vsf_color( x )		gsx_1code(S_FILL_COLOR, x)
#define vsl_type( x )		gsx_1code(S_LINE_TYPE, x)
#define vsl_udsty( x )		gsx_1code(ST_UD_LINE_STYLE, x)
						/* External Routines	*/
GLOBAL WORD	gl_width;
GLOBAL WORD	gl_height;

MLOCAL WORD	gl_nrows;
MLOCAL WORD	gl_ncols;

GLOBAL WORD	gl_wchar;
GLOBAL WORD	gl_hchar;

GLOBAL WORD	gl_wschar;
GLOBAL WORD	gl_hschar;

MLOCAL WORD	gl_wptschar;
MLOCAL WORD	gl_hptschar;

GLOBAL WORD	gl_wbox;
GLOBAL WORD	gl_hbox;

MLOCAL WORD	gl_xclip;
MLOCAL WORD	gl_yclip;
MLOCAL WORD	gl_wclip;
MLOCAL WORD	gl_hclip;

GLOBAL WORD 	gl_nplanes;
GLOBAL WORD 	gl_handle;

MLOCAL FDB	gl_src;
MLOCAL FDB	gl_dst;

GLOBAL WS	gl_ws;
GLOBAL WORD	contrl[12];
GLOBAL WORD	intin[128];
GLOBAL WORD	ptsin[20];
GLOBAL WORD	intout[10];
GLOBAL WORD	ptsout[10];

GLOBAL LONG	ad_intin;

MLOCAL WORD	gl_mode;
MLOCAL WORD	gl_tcolor;
MLOCAL WORD	gl_lcolor;
MLOCAL WORD	gl_fis;
MLOCAL WORD	gl_patt;
MLOCAL WORD	gl_font;

GLOBAL GRECT	gl_rscreen;
GLOBAL GRECT	gl_rfull;
MLOCAL GRECT	gl_rzero;
#if 0	/* unused variable */
MLOCAL GRECT	gl_rcenter;
#endif
MLOCAL GRECT	gl_rmenu;


/*
*	Routine to set the clip rectangle.  If the w,h of the clip
*	is 0, then no clip should be set.  Ohterwise, set the 
*	appropriate clip.
*/
	WORD
gsx_sclip(pt)
	GRECT		*pt;
{
	r_get(pt, &gl_xclip, &gl_yclip, &gl_wclip, &gl_hclip);

	if ( gl_wclip && gl_hclip )
	{
	  ptsin[0] = gl_xclip;
	  ptsin[1] = gl_yclip;
	  ptsin[2] = gl_xclip + gl_wclip - 1;
	  ptsin[3] = gl_yclip + gl_hclip - 1;
	  vs_clip( TRUE, &ptsin[0]);
	}
	else
	  vs_clip( FALSE, &ptsin[0]);
	return( TRUE );
}

/*
*	Routine to get the current clip setting
*/
	VOID
gsx_gclip(pt)
	GRECT		*pt;
{
	r_set(pt, gl_xclip, gl_yclip, gl_wclip, gl_hclip);
}

#if FALSE
MLOCAL	VOID
gsx_xline( ptscount, ppoints )
	WORD		ptscount, *ppoints;
{
	static	WORD	hztltbl[2] = { 0x5555, 0xaaaa };
	static  WORD	verttbl[4] = { 0x5555, 0xaaaa, 0xaaaa, 0x5555 };
	WORD		*linexy,i;
	WORD		st;

	for ( i = 1; i < ptscount; i++ )
	{
	  if ( *ppoints == *(ppoints + 2) )
	  {
	    st = verttbl[( (( *ppoints) & 1) | ((*(ppoints + 1) & 1 ) << 1))];
	  }	
	  else
	  {
	    linexy = ( *ppoints < *( ppoints + 2 )) ? ppoints : ppoints + 2;
	    st = hztltbl[( *(linexy + 1) & 1)];
	  }
	  vsl_udsty( st );
	  v_pline( 2, ppoints );
	  ppoints += 2;
	}
	vsl_udsty( 0xffff );
}	

/*
*	Routine to draw a certain number of points in a polyline
*	relative to a given x,y offset.
*/
MLOCAL	VOID
gsx_pline(offx, offy, cnt, pts)
	WORD		offx, offy;
	WORD		cnt;
	WORD		*pts;
{
	WORD		i, j;

	for (i=0; i<cnt; i++)
	{
	  j = i * 2;
	  ptsin[j] = offx + pts[j];
	  ptsin[j+1] = offy + pts[j+1];
	}

	gsx_xline( cnt, &ptsin[0]);
}
#endif
/*
*	Routine to set the text, writing mode, and color attributes.
*/
	VOID
gsx_attr(text, mode, color)
	UWORD		text, mode, color;
{
	WORD		tmp;

	tmp = intin[0];
	contrl[1] = 0;
	contrl[3] = 1;
	contrl[6] = gl_handle;
	if (mode != gl_mode)
	{
	  contrl[0] = SET_WRITING_MODE;
	  intin[0] = gl_mode = mode;
	  gsx2();
	}
	contrl[0] = FALSE;
	if (text)
	{
	  if (color != gl_tcolor)
	  {
	    contrl[0] = S_TEXT_COLOR;
	    gl_tcolor = color;
	  }
	}	
	else
	{
	  if (color != gl_lcolor)
	  {
	    contrl[0] = S_LINE_COLOR;
	    gl_lcolor = color;
	  }
	}
	if (contrl[0])
	{
	  intin[0] = color;
	  gsx2();
	}
	intin[0] = tmp;
}

/*
*	Routine to fix up the MFDB of a particular raster form
*/
	VOID
gsx_fix(pfd, theaddr, wb, h)
	FDB		*pfd;
	LONG		theaddr;
	WORD		wb, h;
{
	if (theaddr == ORGADDR)
	{
	  pfd->fd_w = gl_ws.ws_xres + 1;
	  pfd->fd_wdwidth = pfd->fd_w / 16;
	  pfd->fd_h = gl_ws.ws_yres + 1;
	  pfd->fd_nplanes = gl_nplanes;
	}
	else
	{
	  pfd->fd_wdwidth = wb / 2;
	  pfd->fd_w = wb * 8;
	  pfd->fd_h = h;
	  pfd->fd_nplanes = 1;
	}
	pfd->fd_stand = FALSE;
	pfd->fd_addr = theaddr;
}

/*
 * Routine to set the fields in a memory form defn block (MFDB).
 */

    VOID
set_mfdb( mf, image, width, hgt, ff, np )
    FDB    *mf;
    FBYTE  *image;
    WORD    width, hgt, ff, np;
{
    mf->fd_addr = (LONG)image;
    mf->fd_wdwidth = (width+15) / 16;
    mf->fd_w = width;
    mf->fd_h = hgt;
    mf->fd_stand = ff;
    mf->fd_nplanes = np;
    mf->fd_r1 = mf->fd_r2 = mf->fd_r3 = 0;
}


/*
*	Routine to blit, to and from a specific area
*/
MLOCAL	VOID
gsx_blt(saddr, sx, sy, swb, daddr, dx, dy, dwb, w, h, rule, fgcolor, bgcolor)
	LONG		saddr;
	UWORD		sx, sy, swb;
	LONG		daddr;
	UWORD		dx, dy, dwb;
	UWORD		w, h, rule;
	WORD		fgcolor, bgcolor;
{
	gsx_fix(&gl_src, saddr, swb, h);
	gsx_fix(&gl_dst, daddr, dwb, h);

	graf_mouse(M_OFF, 0x0L);
	ptsin[0] = sx;
	ptsin[1] = sy;
	ptsin[2] = sx + w - 1;
	ptsin[3] = sy + h - 1;
	ptsin[4] = dx;
	ptsin[5] = dy;
	ptsin[6] = dx + w - 1;
	ptsin[7] = dy + h - 1 ;
	if (fgcolor == -1)
	  vro_cpyfm( rule, (WORD *)&ptsin[0], (WORD *)&gl_src, (WORD *)&gl_dst);
	else
	  vrt_cpyfm( rule, (WORD *)&ptsin[0], (WORD *)&gl_src, (WORD *)&gl_dst, fgcolor, bgcolor);
	graf_mouse(M_ON, 0x0L);
}

/*
*	Routine to blit around something on the screen
*/
	VOID
bb_screen(scrule, scsx, scsy, scdx, scdy, scw, sch)
	WORD		scrule, scsx, scsy, scdx, scdy, scw, sch;
{
	gsx_blt(0x0L, scsx, scsy, 0, 
		0x0L, scdx, scdy, 0,
		scw, sch, scrule, -1, -1);
}

/*
*	Routine to transform a standard form to device specific
*	form.
*/
	VOID
gsx_trans(saddr, swb, daddr, dwb, h)
	LONG		saddr;
	UWORD		swb;
	LONG		daddr;
	UWORD		dwb;
	UWORD		h;
{
	gsx_fix(&gl_src, saddr, swb, h);
	gl_src.fd_stand = TRUE;
	gl_src.fd_nplanes = 1;

	gsx_fix(&gl_dst, daddr, dwb, h);
	vrn_trnfm( (WORD *)&gl_src, (WORD *)&gl_dst );
}

/*
*	Routine to initialize all the global variables dealing
*	with a particular workstation open
*/
	VOID
gsx_start()
{
	WORD		char_height, nc;

	gl_xclip = 0;
	gl_yclip = 0;
	gl_width = gl_wclip = gl_ws.ws_xres + 1;
	gl_height = gl_hclip = gl_ws.ws_yres + 1;

	nc = gl_ws.ws_ncolors;
	gl_nplanes = 0;
	while (nc != 1)
	{
	  nc >>= 1;
	  gl_nplanes++;
	}
	char_height = gl_ws.ws_chminh;
	vst_height( char_height, &gl_wptschar, &gl_hptschar, 
				&gl_wschar, &gl_hschar );
	char_height = gl_ws.ws_chmaxh;
	vst_height( char_height, &gl_wptschar, &gl_hptschar, 
				&gl_wchar, &gl_hchar );
	gl_ncols = gl_width / gl_wchar;
	gl_nrows = gl_height / gl_hchar;
	gl_hbox = gl_hchar + 3;
	gl_wbox = (gl_hbox * gl_ws.ws_hpixel) / gl_ws.ws_wpixel;
	vsl_type( 7 );
	vsl_width( 1 );
	vsl_udsty( 0xffff );
	r_set(&gl_rscreen, 0, 0, gl_width, gl_height);
	r_set(&gl_rfull, 0, gl_hbox, gl_width, (gl_height - gl_hbox));
	r_set(&gl_rzero, 0, 0, 0, 0);
#if 0	/* unused variable */
	r_set(&gl_rcenter, (gl_width-gl_wbox)/2, (gl_height-(2*gl_hbox))/2, 
			gl_wbox, gl_hbox);
#endif		    
	r_set(&gl_rmenu, 0, 0, gl_width, gl_hbox);
	ad_intin = ADDR(&intin[0]);
}

	VOID
gsx_tblt(tb_f, x, y, tb_nc)
	WORD		tb_f;
	WORD		x, y;
	WORD		tb_nc;
{
	WORD		pts_height;

	if (tb_f == IBM)
	{
	  if (tb_f != gl_font)
	  {
	    pts_height = gl_ws.ws_chmaxh;
	    vst_height( pts_height, &gl_wptschar, &gl_hptschar, 
				&gl_wchar, &gl_hchar );
	    gl_font = tb_f;
	  }
	  y += gl_hptschar;
	}

	contrl[0] = 8;		/* TEXT */
	contrl[1] = 1;
	contrl[6] = gl_handle;
	ptsin[0] = x;
	ptsin[1] = y;
	contrl[3] = tb_nc;
	gsx2();
}

/*
*	Routine to do a filled bit blit, (a rectangle).
*/
	VOID
bb_fill(mode, fis, patt, hx, hy, hw, hh)
	WORD		mode, fis, patt, hx, hy, hw, hh;
{

	gsx_fix(&gl_dst, 0x0L, 0, 0);
	ptsin[0] = hx;
	ptsin[1] = hy;
	ptsin[2] = hx + hw - 1;
	ptsin[3] = hy + hh - 1;

	gsx_attr(TRUE, mode, gl_tcolor);
	if (fis != gl_fis)
	{
	  vsf_interior( fis);
	  gl_fis = fis;
	}
	if (patt != gl_patt)
	{
	  vsf_style( patt );
	  gl_patt = patt;
	}
	vr_recfl( (WORD *)&ptsin[0], (WORD *)&gl_dst );
}

/*
*	Routine to set up the points for drawing a box.
*/
MLOCAL	VOID gsx_bxpts(GRECT *pt)
{
	ptsin[0] = pt->g_x;
	ptsin[1] = pt->g_y;
	ptsin[2] = pt->g_x + pt->g_w - 1;
	ptsin[3] = pt->g_y;
	ptsin[4] = pt->g_x + pt->g_w - 1;
	ptsin[5] = pt->g_y + pt->g_h - 1;
	ptsin[6] = pt->g_x;
	ptsin[7] = pt->g_y + pt->g_h - 1;
	ptsin[8] = pt->g_x;
	ptsin[9] = pt->g_y;
}


/*
*	Routine to draw a box using the current attributes.
*/
MLOCAL	VOID gsx_box(GRECT *pt)
{
	gsx_bxpts(pt);
	v_pline( 5, &ptsin[0] );
}

/*
*	Routine to convert a rectangle to its inside dimensions.
*/
MLOCAL	VOID gr_inside(GRECT *pt, WORD th)
{
	pt->g_x += th;
	pt->g_y += th;
	pt->g_w -= ( 2 * th );
	pt->g_h -= ( 2 * th );
}


/*
*	Routine to draw a box of a certain thickness using the current
*	attribute settings
*/
VOID gr_box(WORD x, WORD y, WORD w, WORD h, WORD th)
{
	GRECT		t, n;

	r_set(&t, x, y, w, h);
	if (th != 0)
	{
	  if (th < 0)
	    th--;
	  do
	  {
	    th += (th > 0) ? -1 : 1;
	    rc_copy(&t, &n);
	    gr_inside(&n, th);
	    gsx_box(&n);
	  } while (th != 0);
	}
}


/*
 *	EOF:	deskgraf.c
 */
