/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   See LICENSE.TXT for further information.                                *
*                                                                           *
*   Historical Copyright                                                    *
*   Copyright (c) 1985,1991,1992  Digital Research Inc.			    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/dsk/rcs/deskapp.h 4.14 92/04/10 16:07:32 sbc Exp $
* $Log:	deskapp.h $
 * Revision 4.14  92/04/10  16:07:32  sbc
 * Rm unused members in WSAVE. Replace others with refs to equivs in WNODE
 * 
 * Revision 4.13  92/04/10  13:39:19  sbc
 * Rm redundant preferences vars. Create new struct PREFS
 * 
 * Revision 4.12  92/04/06  09:45:54  Fontes
 * Initial cut to extract/display Windows exe embedded icons.
 * 
 * Revision 4.11  92/03/26  14:43:42  sbc
 * WNODEs and PNODEs to far ptrs. Also merge in RSF's changes
 * 
 * Revision 4.10  92/02/28  14:06:13  sbc
 * Allow user to change folder icons as well as file icons.
 * 
 * Revision 4.9  92/02/27  09:40:27  sbc
 * Allow assignment of icon to ordinary FNODE.
 * 
 * Revision 4.8  92/02/20  15:56:49  sbc
 * Various changes to ANODE structure and defines
 * 
 * Revision 4.7  92/02/19  16:04:40  sbc
 * remove define NO_CLRICN_IMP (assume always TRUE). rework AF_, AT_ defines.
 * 
 * Revision 4.6  92/02/14  11:03:44  sbc
 * merged Tom Rolander's changes for Mobile Netware version of ViewMAX.
 * 
 * Revision 4.5  92/02/12  15:42:00  sbc
 * remove unused icon defines "IG_nRESV", "IG_TRASH".
 * change ID_GENERIC to be (NUM_IBLKS-1) so that data file icons start from
 * the end of G.g_iconlist[]. This makes it so all the app icons can be
 * contiguous from IA_GENERIC on.
 * 
 * Revision 4.4  92/02/06  12:09:18  sbc
 * rename WNODE member w_split to w_type
 * 
 * Revision 4.3  92/01/28  15:00:26  rsf
 * *** empty log message ***
 * 
 * Revision 4.3  92/01/21  13:33:54  Fontes
 * Screen Saver and Background work merged w/ Jan 7 sources from Heather
 * 
 * Revision 4.2  92/01/06  12:53:16  anderson
 * Color icon work from Becky.
 * 
 * Revision 4.1  91/11/07  16:42:01  anderson
 * Added variable to window context saving structure for X coordinate of any
 * tree side of a SMW.
 * 
 * Revision 3.1  91/08/19  16:31:07  system
 * ViewMAX 2 sources
 * 
*****************************************************************************/

#ifndef DESKAPP_INCLUDED
#define DESKAPP_INCLUDED

#define NO_INI_FILE	0 
#define NO_MEM		-1
#define NO_RSC_FILE	-2
#define NO_ICON_FILE	-3

#define OPEN_FILE	0x0001
#define CREATE_FILE	0x0002
#define DELETE_FILE	0x0004
#define TMP_FILE	0x8000		/* high bit */

#define AF_ISDESK	0x01			/* is placed on desk	*/
#define AF_ISPARM	0x02			/* takes parameters	*/
#define AF_ISDEF	0x80			/* default configuration*/

#define AT_ISFILE 0				/* file			*/
#define AT_ISFOLD 1				/* folder		*/
#define AT_ISDISK 2				/* disk or diskette	*/
#define AT_ISTRSH 3				/* trashcan		*/
#define AT_ISPITM 4				/* program item		*/
#define AT_ISWIND 5				/* Windows executable	*/
						/* required icons	*/
#define IG_HARD		0	
#define IG_FLOPPY	1
#define IG_NET		2
#ifdef USE_MOBILE_NETWARE													/* USE_MOBILE_NETWARE  tar  02/13/92 */
#define IG_MOBILE1	3
#define IG_MOBILE2	4
#define IG_MOBILE3	5
#define IG_MOBILE4	6
#define IG_FOLDER	7
#define IA_GENERIC	8			/* start of paired icons */
#else
#define IG_FOLDER	3
#define IA_GENERIC	4			/* start of paired icons */
#endif
#define ID_GENERIC (NUM_IBLKS-1)

#define NUM_ANODES (64+26)			/* # of appl. nodes + drives*/
#define NUM_INODES 100				/* # of program items */

#define SIZE_BUFF 1024				/* size of a string 	*/
						/*   buffer		*/
#define NUM_IBLKS 72
#define NUM_NAMICS ((NUM_IBLKS - 8)/2)		/* # of named icons	*/
						/*   possible		*/

#define WSAVE	struct window_save
WSAVE
{
	RECT	ws_box;
	BYTE	ws_cvrow;		/* scroller position */
	WORD	ws_t_x;
	BYTE	ws_t_cvind;		/* scroller positions for tree side */
	BYTE	ws_t_cvrow;
	BYTE	ws_pth[LEN_ZPATH];
};


#define PREFS	struct preferences
PREFS
{
	BYTE	confirm_copies;
	BYTE	confirm_delete;
	BYTE	confirm_ovrwrite;
	BYTE	dclk_speed;
	BYTE	menu_type;
	BYTE	auto_save;
	BYTE	tmax_ctrl;
	BYTE	bkgd_type;		
	BYTE	bkgd_name[LEN_ZFNAME];	
	BYTE	scrnsvr_time;		
	BYTE	scrnsvr_name[LEN_ZFNAME];		
	WSAVE	win[NUM_WNODES];
};

#endif /* ndef DESKAPP_INCLUDED */

/*
 *	EOF:	deskapp.h
 */
