/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/optimize.c 4.3 92/03/12 11:25:39 sbc Exp $
* $Log:	optimize.c $
 * Revision 4.3  92/03/12  11:25:39  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 

 *	Optimize for ViewMAX	(#if GEM)	11/18/91	K.H

 * Revision 4.2  92/02/27  15:24:09  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/01/27  16:11:21  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:18:19  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:54:32  system
 * Prototyping and cleanup plus fix to file selector code
 * 
*/

#include "portab.h"
#include "machine.h"
#include "obdefs.h"
#include "cproto.h"
#include "aproto.h"


EXTERN LONG	ad_sysglo;
GLOBAL BYTE	gl_rsname[16];

/*----------------------------------------------------------------------*/
VOID r_get( GRECT * pRect, WORD * x, WORD * y, WORD * w, WORD * h )
{
    *x = pRect->g_x ;
    *y = pRect->g_y ;
    *w = pRect->g_w ;
    *h = pRect->g_h ;
} /* r_get() */

/*----------------------------------------------------------------------*/
VOID r_set( GRECT * pRect, WORD x, WORD y, WORD w, WORD h )
{
    pRect->g_x = x ;
    pRect->g_y = y ;
    pRect->g_w = w ;
    pRect->g_h = h ;
} /* r_set() */

/*----------------------------------------------------------------------*/
BOOLEAN inside( WORD x, WORD y, GRECT * pRect )
{
    return(
	x >= pRect->g_x				&&
	x <= (pRect->g_x + pRect->g_w + 1)	&&
	y >= pRect->g_y				&&
	y <= (pRect->g_y + pRect->g_h + 1)
	) ;
} /* inside() */

/*----------------------------------------------------------------------*/
VOID rc_constrain( GRECT * pc, GRECT * pt )
{
	  if (pt->g_x < pc->g_x)
	    pt->g_x = pc->g_x;
	  if (pt->g_y < pc->g_y)
	    pt->g_y = pc->g_y;
	  if ((pt->g_x + pt->g_w) > (pc->g_x + pc->g_w))
	    pt->g_x = (pc->g_x + pc->g_w) - pt->g_w;
	  if ((pt->g_y + pt->g_h) > (pc->g_y + pc->g_h))
	    pt->g_y = (pc->g_y + pc->g_h) - pt->g_h;
}

/*----------------------------------------------------------------------*/
VOID rc_union( GRECT * p1, GRECT * p2)
{
	WORD		tx, ty, tw, th;

	tw = max(p1->g_x + p1->g_w, p2->g_x + p2->g_w);
	th = max(p1->g_y + p1->g_h, p2->g_y + p2->g_h);
	tx = min(p1->g_x, p2->g_x);
	ty = min(p1->g_y, p2->g_y);
	p2->g_x = tx;
	p2->g_y = ty;
	p2->g_w = tw - tx;
	p2->g_h = th - ty;
}

/*----------------------------------------------------------------------*/
WORD rc_intersect( GRECT * p1, GRECT * p2)
{
	WORD		tx, ty, tw, th;

	tw = min(p2->g_x + p2->g_w, p1->g_x + p1->g_w);
	th = min(p2->g_y + p2->g_h, p1->g_y + p1->g_h);
	tx = max(p2->g_x, p1->g_x);
	ty = max(p2->g_y, p1->g_y);
	p2->g_x = tx;
	p2->g_y = ty;
	p2->g_w = tw - tx;
	p2->g_h = th - ty;
	return( (tw > tx) && (th > ty) );
}

/*----------------------------------------------------------------------*/
BYTE *strscn( BYTE * ps, BYTE * pd, BYTE stop)
{
	while ( (*ps) &&
		(*ps != stop) )
	  *pd++ = *ps++;
	return(pd);
}

#if GEM
/*----------------------------------------------------------------------
*	Strip out period and turn into raw data.
*/
	VOID
fmt_str(instr, outstr)
	BYTE		*instr, *outstr;
{
	WORD		count;
	BYTE		*pstr;

	pstr = instr;
	while( (*pstr) && (*pstr != '.') )
	  *outstr++ = *pstr++;
	if (*pstr)
	{
	  count = 8 - (pstr - instr);
	  while ( count-- )
	    *outstr++ = ' ';
	  pstr++;
	  while (*pstr)
	    *outstr++ = *pstr++;
	}
	*outstr = NULL;
}

/*----------------------------------------------------------------------
*	Insert in period and make into true data.
*/
	VOID
unfmt_str(instr, outstr)
	BYTE		*instr, *outstr;
{
	BYTE		*pstr, temp;

	pstr = instr;
	while( (*pstr) && ((pstr - instr) < 8) )
	{
	  temp = *pstr++;
	  if (temp != ' ')
	    *outstr++ = temp;
	}
	if (*pstr)
	{
	  *outstr++ = '.';
	  while (*pstr)
	    *outstr++ = *pstr++;
	}
	*outstr = NULL;
}

/*----------------------------------------------------------------------*/
	VOID
fs_sset(tree, obj, pstr, ptext, ptxtlen)
	TREE		tree;
	WORD		obj;
	LONG		pstr;
	LONG		*ptext;
	WORD		*ptxtlen;
{
	LONG		spec;
	WORD		len;

	*ptext = LLGET( spec = (tree+obj)->ob_spec );
	*ptxtlen = LWGET( spec + 24 );
	len = fstrlen((BYTE FAR *)pstr);	/* allow for null	*/
	len = min(len, *ptxtlen - 1);
	fmemcpy((BYTE FAR *)*ptext, (BYTE FAR *)pstr, len);
	LBSET((BYTE FAR *)(*ptext+len), '\0');	/* add null		*/
}

/*----------------------------------------------------------------------*/
	VOID
fs_sget(tree, obj, pstr)
	TREE		tree;
	WORD		obj;
	LONG		pstr;
{
	LONG		ptext;

	ptext = LLGET( (tree+obj)->ob_spec );
	fstrcpy((BYTE FAR *)pstr, (BYTE FAR *)ptext);
}

/*----------------------------------------------------------------------*/
MLOCAL	WORD
inf_gindex(TREE tree, WORD baseobj, WORD numobj)
{
WORD		retobj;
OBJECT far *	pObj ;

	for (retobj=0; retobj < numobj; retobj++)
	{
	  pObj = tree + (baseobj+retobj) ;
	  if ( pObj->ob_state & SELECTED)
	    return(retobj);
	}
	return(-1);
}

/*----------------------------------------------------------------------
*	Return 0 if cancel was selected, 1 if okay was selected, -1 if
*	nothing was selected.
*/
	WORD
inf_what(tree, ok)
	TREE		tree;
	WORD		ok;
{
	WORD		field;

	field = inf_gindex(tree, ok, 2);

	if (field != -1)
	{ 
	  (tree+(ok+field))->ob_state = NORMAL ;
	  field = (field == 0);
	}
	return(field);
}
#endif /* GEM */

/*----------------------------------------------------------------------*/
	VOID
merge_str(pdst, ptmp, parms)
	BYTE		*pdst;
	BYTE		*ptmp;
	UWORD		parms[];	
{
	WORD		num;
	WORD		do_value;
	BYTE		lholder[12];
	BYTE		*pnum, *psrc;
	LONG		lvalue, divten;
	WORD		digit;

	num = 0;
	while(*ptmp)
	{
	  if (*ptmp != '%')
	    *pdst++ = *ptmp++;
	  else
	  {
	    ptmp++;
	    do_value = FALSE;
	    switch(*ptmp++)
	    {
	      case '%':
		*pdst++ = '%';
		break;
	      case 'L':
		lvalue = *((LONG *) &parms[num]);
		num += 2;
		do_value = TRUE;
		break;
	      case 'W':
		lvalue = parms[num];
		num++;
		do_value = TRUE;
		break;
	      case 'S':
		psrc = (BYTE *) parms[num]; 
		num++;
		while(*psrc)
		  *pdst++ = *psrc++;
		break;
	    }
	    if (do_value)
	    {
	      pnum = &lholder[0];
	      while(lvalue)
	      {
		divten = lvalue / 10;
		digit = (WORD)(lvalue - (divten * 10));
		*pnum++ = '0' + digit;
		lvalue = divten;
	      }
	      if (pnum == &lholder[0])
		*pdst++ = '0';
	      else
	      {
		while(pnum != &lholder[0])
		  *pdst++ = *--pnum;
	      }
	    }
	  }
	}
	*pdst = NULL;
}

#if GEM
/*----------------------------------------------------------------------
*	Routine to see if the test filename matches one of a set of 
*	comma delimited wildcard strings.
*		e.g.,	pwld = "*.COM,*.EXE,*.BAT"
*		 	ptst = "MYFILE.BAT"
*/
	WORD
wildcmp(pwld, ptst)
	BYTE		*pwld;
	BYTE		*ptst;
{
	BYTE		*pwild;
	BYTE		*ptest;
						/* skip over *.*, and	*/
						/*   *.ext faster	*/
	while(*pwld)
	{
	  ptest = ptst;
	  pwild = pwld;
						/* move on to next 	*/
						/*   set of wildcards	*/
	  pwld = strchr(pwld, ',');
	  if (*pwld)
	    pwld++;
						/* start the checking	*/
	  if (pwild[0] == '*')
	  {
	    if (pwild[2] == '*')
	      return(TRUE);
	    else
	    {
	      pwild = &pwild[2];
	      ptest = strchr(ptest, '.');
	      if (*ptest)
	        ptest++;
	    }
	  }
						/* finish off comparison*/
	  while( (*ptest) && 
	         (*pwild) &&
		 (*pwild != ',') )
	  {
	    if (*pwild == '?')
	    {
	       pwild++;
	       if (*ptest != '.')
	         ptest++;
	    }
	    else
	    {
	      if (*pwild == '*')
	      {
	        if (*ptest != '.')
		  ptest++;
	        else		
		  pwild++;
	      }
	      else
	      {
	        if (*ptest == *pwild)
	        {
	          pwild++;
	          ptest++;
	        }
	        else
	          break;
	      }
	    }
	  }
						/* eat up remaining 	*/
						/*   wildcard chars	*/
	  while( (*pwild == '*') ||
	         (*pwild == '?') ||
	         (*pwild == '.') )
	    pwild++;
						/* if any part of wild-	*/
						/*   card or test is	*/
						/*   left then no match	*/
	  if ( ((*pwild == NULL) || (*pwild == ',')) && 
	       (!*ptest) )
	    return( TRUE );
	}
	return(FALSE);
}
#endif /* GEM */

#if !(DBCS)
/*----------------------------------------------------------------------
*	Routine to insert a character in a string by
*/
	VOID
ins_char(str, pos, chr, tot_len)
	REG BYTE	*str;
	WORD		pos;
	BYTE		chr;
	REG WORD	tot_len;
{
	REG WORD	ii, len;

	len = strlen(str);

	for (ii = len; ii > pos; ii--)
	  str[ii] = str[ii-1];
	str[ii] = chr;
	if (len+1 < tot_len)
	  str[len+1] = NULL;
	else
	  str[tot_len-1] = NULL;
}
#endif /* !(DBCS) */

/*----------------------------------------------------------------------
*	Used to get strings of 16 bytes or less from resource.
*/
	BYTE
*op_gname(index)
	WORD	index;
{
	LONG	pname;

	rs_gaddr(ad_sysglo, R_STRING, index, &pname);
	fstrcpy((BYTE FAR *)gl_rsname, (BYTE FAR *)pname);
	return(&gl_rsname[0]);
}

/* end of optimize.c */
