/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: g:/groups/panther/aes/rcs/gemshlib.c 4.5 92/04/09 15:00:25 sbc Exp $
* $Log:	gemshlib.c $
 * Revision 4.5  92/04/09  15:00:25  sbc
 * AES no longer frees the prev background for a new one. (done in dsk)
 * 
 * Revision 4.3  92/03/12  11:25:30  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 

*	911014 K.H	Added supporting double byte character.		
*			(#if DBCS)					

* Revision 4.2  92/02/27  15:23:25  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/02/03  11:23:46  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/01/27  16:10:45  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:17:44  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:54:17  system
 * Prototyping and cleanup plus fix to file selector code
 * 
 *	910502 RSF	Cleared up "constant out of range" warning that
 *			was causing sh_envrn to fail.			
 *	910517 WHF	Added sh_signoff()				
*************************************************************************/

#include "portab.h"
#include "machine.h"
#include "obdefs.h"
#include "struct.h"
#include "basepage.h"
#include "dos.h"
#include "viewrun.h"
#include "gemlib.h"
#include "viewapps.h"
#include "cproto.h"
#include "aproto.h"

extern WORD	DOS_AX;
extern WORD	DOS_ERR;

						/* in GSXIF.C		*/
extern GRECT	gl_rscreen;

extern LONG	ad_envrn;
extern TREE	ad_stdesk;
extern LONG	ad_armice;
extern LONG	ad_hgmice;

extern TREE	desk_tree[];

extern THEGLO	D;

extern FDB	gl_tmp;

GLOBAL SHELL	sh[NUM_PDS];

GLOBAL BYTE FAR	*ad_scmd;
GLOBAL BYTE FAR	*ad_stail;

GLOBAL void FAR	*ad_s1fcb;
GLOBAL void FAR	*ad_s2fcb;

GLOBAL void FAR *ad_ssave;
GLOBAL void FAR *ad_dta;
GLOBAL void FAR *ad_path;

GLOBAL void FAR *ad_pfile;

GLOBAL WORD	gl_shgem;

MLOCAL BYTE FAR	*sh_msg = NULL;

/*----------------------------------------------------------------------*/
MLOCAL BOOLEAN sh_look( BYTE FAR *buf, char *cp )
{
	char far *bp;
	WORD ii;
#if DBCS
	WORD i;

	for( i=0, ii=0, bp=(char far *)buf; bp[i]!=0; i++ )
	{
	    if (dbcs_lead(bp[i]) && bp[i+1])
		i++;
	    else if (bp[i] == '\\')
		ii = i;
	}
#else /* DBCS */
	for( ii=0, bp=buf; bp[ii]!=0; ii++ ) ;	/* Find EOS */
	while( ii>0 && bp[ii]!='\\' ) ii--;	/* backup to last backslash */
#endif /* DBCS */	
	ii++;					/* forward to after backslash */
	while( *cp  &&  (toupper(bp[ii]) == *cp) ) 
		ii++, cp++;			/* loop while equal */
	if( *cp )				/* did we match all chars? */
		return FALSE;
	else	return TRUE;
}

/*----------------------------------------------------------------------*/
MLOCAL void sh_savesignoff( void )
{
	char *cp;
	WORD cpl;

	cp = rs_str(STSIGNOF);
	cpl = strlen(cp)+1;
	sh_msg = (BYTE FAR *)dos_alloc((LONG)cpl);
	fmemcpy( sh_msg, (BYTE FAR *)cp, cpl);
}

/*----------------------------------------------------------------------*/
MLOCAL BYTE *sh_parse( REG BYTE *psrc, REG BYTE *pfcb )
{
	REG BYTE	*ptmp;
	BYTE		*sfcb;
	BYTE		drv;

	sfcb = pfcb;
						/* scan off white space	*/
	while ( (*psrc) &&
	        (*psrc == ' ') )
	  psrc++;
	if (*psrc == NULL)
	  return(psrc);
						/* remember the start	*/
	ptmp = psrc;
						/* look for a colon	*/
	while ( (*psrc) &&
		(*psrc != ' ') &&
		(*psrc != ':') )
	  psrc++;
						/* pick off drive letter*/
	drv = 0;
	if ( *psrc == ':' )
	{
	  drv = toupper(*(psrc - 1)) - 'A' + 1;
	  psrc++;
	}
	else
	  psrc = ptmp;
	*pfcb++ = drv;
	if (*psrc == NULL)
	  return(psrc);
						/* scan off filename	*/
	while ( (*psrc) &&
		(*psrc != ' ') &&
		(*psrc != '*') &&
		(*psrc != '.') &&
		(pfcb <= &sfcb[8]) )
#if DBCS
	  *pfcb++ = *psrc++;
#else /* DBCS */
	  *pfcb++ = toupper(*psrc++);
#endif /* DBCS */      
						/* pad out with blanks	*/
	while ( pfcb <= &sfcb[8] )
	  *pfcb++ = (*psrc == '*') ? ('?') : (' ');
	if (*psrc == '*')
	  psrc++;
						/* scan off file ext.	*/
	if ( *psrc == '.')
	{
	  psrc++;
	  while ( (*psrc) &&
		  (*psrc != ' ') &&
		  (*psrc != '*') &&
		  (pfcb <= &sfcb[11]) )
#if DBCS
	    *pfcb++ = *psrc++;
#else /* DBCS */
	    *pfcb++ = toupper(*psrc++);
#endif /* DBCS */	
	}
	while ( pfcb <= &sfcb[11] )
	  *pfcb++ = (*psrc == '*') ? ('?') : (' ');
#if DBCS
	if (dbcs_expected())		/* are we looking out for DBCS? */
	{				/*  yes - DON'T CHANGE DBCS CHARS */
	  for (pfcb = sfcb; pfcb <= &sfcb[11]; pfcb++)
    	    if (dbcs_lead(*pfcb))	/* is this first of a DBCS pair? */
	    	pfcb++;			/*  yes - skip over it */
	    else
	    	*pfcb = toupper(*pfcb);	/*  no - upper case it */
	}
	else
	  for (pfcb = sfcb; pfcb <= &sfcb[11]; pfcb++)
    	    *pfcb = toupper(*pfcb);
#endif /* DBCS */
	if (*psrc == '*')
	  psrc++;
						/* return pointer to	*/
						/*   remainder of line	*/
	return(psrc);
}

/*----------------------------------------------------------------------
*	Routine to fix up the command tail and parse FCBs for a coming
*	exec.
*/
MLOCAL void sh_fixtail( WORD iscpm )
{
	REG WORD	i;
	WORD		len;
	BYTE		*s_tail;
	BYTE		*ptmp;
	BYTE		s_fcbs[32];
						/* reuse part of globals*/
	s_tail = &D.g_dir[0];
	i = 0;

	if (iscpm)
	{
	  s_tail[i++] = NULL;
	  ptmp = &D.s_cmd[0];
	  while ( (*ptmp) &&
		  (*ptmp != '.') )
	    s_tail[i++] = *ptmp++;
	}

	fmemcpy((BYTE FAR *)&s_tail[i], ad_stail, 128 - i);

	if (iscpm)
	{
						/* pick up the length	*/
	  len = s_tail[i];
						/* null over carriage ret*/
	  s_tail[i + len + 1] = NULL;
	    					/* copy down space,tail	*/
	  strcpy( &s_tail[i], &s_tail[i+1]);

	  
	}
	else
	{
						/* zero the fcbs	*/
	  memset( &s_fcbs[0], 0, 32 );
	  memset( &s_fcbs[1], ' ', 11 );
	  memset( &s_fcbs[17], ' ', 11 );
	  
						/* parse the fcbs	*/
	  if ( s_tail[0] )
	  {
	    s_tail[ 1 + s_tail[0] ] = NULL;
	    ptmp = sh_parse(&s_tail[1], &s_fcbs[0]);
	    if (*ptmp != NULL)
	      sh_parse(ptmp, &s_fcbs[16]);
	    s_tail[ 1 + s_tail[0] ] = 0x0d;
	  }
						/* copy into true fcbs	*/
	  fmemcpy(ad_s1fcb, (BYTE FAR *)&s_fcbs[0], 16); 
	  fmemcpy(ad_s2fcb, (BYTE FAR *)&s_fcbs[16], 16); 
	}
						/* copy into true tail	*/
	fmemcpy(ad_stail, (BYTE FAR *)s_tail, 128);
}

/*----------------------------------------------------------------------*/
void sh_read( BYTE FAR * pcmd, BYTE FAR * ptail)
{
	fmemcpy(pcmd, ad_scmd, 128);
	fmemcpy(ptail, ad_stail, 128);
}

/*-----------------------------------------------------------------------
*	Routine to set the next application to run
*
*		isgem = 0   then run in character mode
*		isgem = 1   them run in graphic mode
*
*		isover = 0  then run above DESKTOP
*		isover = 1  then run over DESKTOP
*		isover = 2  then run over AES and DESKTOP
*/
	WORD
sh_write(doex, isgem, isover, pcmd, ptail)
	WORD		doex, isgem, isover;
	BYTE FAR	*pcmd;
	BYTE FAR	*ptail;
{
	SHELL		*psh;

	fmemcpy(ad_scmd, pcmd, 128);
	fmemcpy(ad_stail, ptail, 128);
	if (isover > 0)
	{
					/* stepaside to run	*/
	  psh = &sh[rlr->p_pid];
	  psh->sh_isgem = (isgem != FALSE);
	  psh->sh_doexec = doex;
	  psh->sh_dodef = FALSE;
	  psh->sh_fullstep = isover - 1;
	  if( 0 == LBGET(ptail)  &&  sh_look(pcmd,"COMMAND") )
		sh_savesignoff();
	}
	else
	{
	  sh_fixtail(FALSE);
						/* run it above us	*/
	  if ( sh_find(ad_scmd) )
	  {
	    dos_exec((LONG)ad_scmd, HIWORD(ad_envrn),
	    	     (LONG)ad_stail, (LONG)ad_s1fcb, (LONG)ad_s2fcb);
	  }
	  else
	    return(FALSE);
	}
	return(TRUE);				/* for the future	*/
}

/*------------------------------------------------------------------------
*	Used by the DESKTOP to recall 1024 bytes worth of previously
*	'put' desktop-context information.
*/
void sh_get( BYTE far * pbuffer, WORD len)
{
	fmemcpy(pbuffer, (BYTE FAR *)ad_ssave, len);
}

/*-------------------------------------------------------------------------
*	Used by the DESKTOP to save away 1024 bytes worth of desktop-
*	context information.
*/
void sh_put( BYTE far * pdata, WORD len )
{
	fmemcpy((BYTE FAR *)ad_ssave, pdata, len);
}

/*------------------------------------------------------------------------
*	Convert the screen to graphics-mode in preparation for the 
*	running of a GEM-based graphic application.
*/
void sh_tographic( void )
{
						/* retake ints that may	*/
						/*   have been stepped	*/
						/*   on by char. appl.	*/
						/*   including err. 	*/
						/*   handler and gem.int*/
	cli();
	retake();
	sti();
						/* convert to graphic	*/
	gsx_graphic(TRUE);
						/* set initial clip rect*/
	gsx_sclip(&gl_rscreen);
						/* allocate screen space*/
	gsx_malloc();
						/* start up the mouse	*/
	ratinit();
						/* put mouse to hourglass*/
	gsx_mfset(ad_hgmice);
}

/*------------------------------------------------------------------------
*	Convert the screen and system back to alpha-mode in preparation for
*	the running of a DOS-based character application.
*/
MLOCAL void sh_toalpha( void )
{
						/* put mouse to arrow	*/
	gsx_mfset(ad_armice);
						/* give back the error	*/
						/*   handler since ours	*/
						/*   is graphic		*/
	cli();
	giveerr();
	sti();
						/* turn off the mouse	*/
	gsx_moff();

						/* return screen space	*/
	dos_free(gl_tmp.fd_addr);
						/* close workstation	*/
	gsx_graphic(FALSE);
}

/*----------------------------------------------------------------------*/
MLOCAL void sh_draw( LONG lcmd, WORD start, WORD depth )
{
	TREE		tree;

	if (gl_shgem)
	{
	  tree = ad_stdesk;
	  gsx_sclip(&gl_rscreen);
	  LLSET(ad_pfile, lcmd);
	  ob_draw(tree, start, depth);
	}
}

/*----------------------------------------------------------------------*/
MLOCAL void sh_show( LONG lcmd )
{
	WORD		i;

	for(i=1; i<3; i++)
	  sh_draw(lcmd, i, 0);
}

/*-----------------------------------------------------------------------
*	Routine to take a full path, and scan back from the end to 
*	find the starting byte of the particular filename
*/
BYTE * sh_name( REG BYTE * ppath)
{
	REG BYTE	*pname;
#if DBCS
	REG BYTE	*pp;

	for(pp=ppath, pname=ppath-1; *pp; pp++)
	{
	  if (dbcs_lead(*pp) && *(pp+1))
	    pp++;
	  else if ((*pp == '\\') || (*pp == ':'))
	    pname = pp;
	}
#else /* DBCS */
	pname = &ppath[strlen(ppath)];
	while ( (pname >= ppath) &&
		(*pname != '\\') &&
		(*pname != ':') )
	  pname--;
#endif /* DBCS */
	pname++;
	return(pname);
}

/*------------------------------------------------------------------------
*	Search for a particular string in the DOS environment and return
*	a long pointer to the character after the string if it is found. 
*	Otherwise, return a NULLPTR
*/
void sh_envrn( LONG far * ppath, REG BYTE far * psrch)
{
	LONG		lp;
	WORD		len, findend;
	BYTE		last, tmp, loc1[10], loc2[10];

	len = fstrlen( psrch ) - 1 ;
	fstrcpy((BYTE FAR *)&loc2[0], psrch);

	loc1[len] = NULL;

	lp = ad_envrn;
	findend = FALSE;
	tmp = NULL;
	do
	{
	  last = tmp;
	  tmp = LBGET(lp);
	  lp++;
	  if ( (findend) &&
	       (tmp == NULL) )
	  {
	    findend = FALSE;
	    tmp = 0xFF;
	  }
	  else
	  {
	    if (((last == NULL) || (last == -1)) && (tmp == loc2[0]))
	    {
	      fmemcpy((BYTE FAR *)loc1, (BYTE FAR *)lp, len);
	      if ( !strcmp(loc1, &loc2[1]) )
	      {
	        lp += len;
		break;
	      }
	    }
	    else
	      findend = TRUE;
	  }
	  } while( tmp );
	  if (!tmp)
		lp = 0x0L;

	LLSET(ppath, lp);
}

/*----------------------------------------------------------------------------
*	Search first, search next style routine to pick up each path
*	in the PATH= portion of the DOS environment.  It returns the
*	next higher number to look for until there are no more
*	paths to find.
*/
MLOCAL WORD sh_path( WORD whichone, BYTE FAR *dp, REG BYTE *pname )
{
	REG BYTE	tmp, last;
	LONG		lp;
	REG WORD	i;
#if DBCS
	REG WORD	type = CT_ADE;
#endif /* DBCS */
						/* find PATH= in the	*/
						/*   command tail which	*/
						/*   is a double null-	*/
						/*   terminated string	*/
	sh_envrn((LONG FAR *)&lp, (BYTE FAR *)rs_str(STPATH));
	if (!lp)
		return(0);

						/* if found count in to	*/
						/*   appropriate path	*/
	i = whichone;
	tmp = ';';
	while (i)
	{
	  while (( tmp = LBGET(lp)) != 0 )
	  {
	    lp++;
	    if (tmp == ';')
	      break;
	  }
	  i--;
	}
	if (!tmp)
	  return(0);
						/* copy over path	*/
	while ( ( tmp = LBGET(lp) ) != 0)
	{
	  if ( tmp != ';' )
	  {
#if DBCS
	    type = chkctype(tmp, type);
#endif /* DBCS */
	    LBSET(dp++, tmp);
	    last = tmp;
	    lp++;
	  }
	  else
	    break;
	}
						/* see if extra slash	*/
						/*   is needed		*/
#if DBCS
	if ( (type != CT_ADE) ||
	     ((last != '\\') && (last != ':')) )
#else /* DBCS */
	if ( (last != '\\') &&
	     (last != ':') )
#endif /* DBCS */		 
	  LBSET(dp++, '\\');
						/* append file name	*/
	fstrcpy(dp, (BYTE FAR *)pname);
						/* make whichone refer	*/
						/*   to next path	*/
	return(whichone+1);
}

/*----------------------------------------------------------------------*/
void sh_curdir( BYTE far * ppath)
{
	WORD	drive;
						/* remember current	*/
						/*  directory		*/
	drive = dos_gdrv();
	LBSET(ppath++, (drive + 'A') );
	LBSET(ppath++, ':');
	LBSET(ppath++, '\\');
	dos_gdir( drive+1, (LONG)ppath );
}

/*----------------------------------------------------------------------
*	Routine to verify that a file is present.  It first looks in the
*	current directory and then looks down the search path.
*/
WORD sh_find( BYTE far * pspec )
{
	WORD		path;
	BYTE		gotdir, *pname, tmpname[66];

	dos_sdta((LONG)ad_dta);

	fstrcpy((BYTE FAR *)ad_path, pspec);	/* copy to local buffer	*/
	pname = sh_name(&D.g_dir[0]);		/* get ptr to name	*/
	gotdir = (pname != &D.g_dir[0]);
	if (!gotdir)
	{
	  strcpy( tmpname, pname );		/* save name		*/
	  sh_curdir(ad_path);			/* get current drive/dir*/
	  if (D.g_dir[3] != NULL)		/* if not at root	*/
	    strcat( D.g_dir, "\\" );		/*  add foreslash	*/
	  strcat( D.g_dir, tmpname );		/* append name to drive	*/
	}
						/* and directory.	*/
	path = 0;
	do
	{

	  dos_sfirst((LONG)ad_path, F_RDONLY | F_SYSTEM);

	  if ( (DOS_AX == E_PATHNOTFND) ||
	        ((DOS_ERR) && 
	         ((DOS_AX == E_NOFILES) ||
	          (DOS_AX == E_PATHNOTFND) ||
		  (DOS_AX == E_FILENOTFND))) )
	  {
	    path = sh_path(path, ad_path, &tmpname[0]);
	    DOS_ERR = TRUE;
	  }
	  else
	    path = 0;
	} while ( !gotdir && DOS_ERR && path );

	if (!DOS_ERR)
	  fstrcpy(pspec, ad_path);

	return(!DOS_ERR);
}

/*-------------------------------------------------------------------------
*	Read the default application to invoke.
*/
void sh_rdef( BYTE far * lpcmd, BYTE far * lpdir)
{
	SHELL		*psh;

	psh = &sh[rlr->p_pid];

	fstrcpy(lpcmd, (BYTE FAR *)psh->sh_desk);
	fstrcpy(lpdir, (BYTE FAR *)psh->sh_cdir);
}

/*-----------------------------------------------------------------------
*	Write the default application to invoke
*/
void sh_wdef( BYTE far * lpcmd, BYTE far * lpdir)
{
	SHELL		*psh;

	psh = &sh[rlr->p_pid];

	fstrcpy((BYTE FAR *)psh->sh_desk, lpcmd);
	fstrcpy((BYTE FAR *)psh->sh_cdir, lpdir);
}

/*----------------------------------------------------------------------*/
MLOCAL void sh_chgrf( SHELL *psh )
{
	if ( psh->sh_isgem != gl_shgem )
	{
	  gl_shgem = psh->sh_isgem;
	  if ( gl_shgem )
	    sh_tographic();
	  else
	    sh_toalpha();
	}
}

/*----------------------------------------------------------------------*/
MLOCAL void sh_chdef( SHELL *psh )
{
						/* if we should exec	*/
						/*   the default command*/
						/*   then let it be	*/
						/*   known that it is	*/
						/*   a gem appl.	*/
	psh->sh_isdef = FALSE;
	if ( psh->sh_dodef )
	{
	  psh->sh_isdef = psh->sh_isgem = TRUE;
	  psh->sh_fullstep = 0;
	  dos_sdrv(psh->sh_cdir[0] - 'A');
	  dos_chdir(ADDR(&psh->sh_cdir[0]));
	  strcpy( D.s_cmd, psh->sh_desk );
	}

}

/*----------------------------------------------------------------------*/
MLOCAL void sh_ldapp( void )
{
	WORD		ret, badtry, retry;
	SHELL		*psh;

	psh = &sh[rlr->p_pid];
	badtry = 0;	

	strcpy( psh->sh_desk, rs_str(STDESKTP) ) ;
	strcpy( psh->sh_cdir, D.s_cdir ) ;
	do
	{
	  sh_chdef(psh);
						/* set up so that we	*/
						/*   will exec the 	*/
						/*   default next time	*/
						/*   unless the		*/
						/*   application does	*/
						/*   a set command	*/
	  psh->sh_dodef = TRUE;
						/* init graph/char mode	*/
	  sh_chgrf(psh);
	  if (gl_shgem)
	  {
	    wm_start();
	    ratinit();
	  }
						/* fix up/parse cmd tail*/ 
	  sh_fixtail(psh->sh_fullstep == 2);
	  sh_draw((LONG)ad_scmd, 0, 0);		/* redraw the desktop	*/

						/* clear his desk field	*/
	  desk_tree[rlr->p_pid] = 0x0L;
	  	  	  	  	  /* exec it	  	  */
					  /* handle bad try msg	*/
	  if (badtry)
	  {
	    ret = (badtry == ALNOFIT) ? 0x0101 : 0x0001; /* Enable CANCEL */
	    ret = fm_show(badtry, NULLPTR, ret);	/* button on ALNOFIT*/
	    if (badtry == ALNOFIT)
	      break;
	    badtry = 0;
	  }

	  do
	  {
	    retry = FALSE;
	    if ( sh_find(ad_scmd) )
	    {
	      sh_show((LONG)ad_scmd);
	      p_nameit(rlr, sh_name(&D.s_cmd[0]));
	      if (psh->sh_fullstep == 0)
	      {
	        dos_exec((LONG)ad_scmd, HIWORD(ad_envrn), (LONG)ad_stail, 
			 (LONG)ad_s1fcb, (LONG)ad_s2fcb);
	      }
	      else if (psh->sh_fullstep == 1)
	      {
	        gsx_exec((LONG)ad_scmd, HIWORD(ad_envrn), (LONG)ad_stail, 
			 (LONG)ad_s1fcb, (LONG)ad_s2fcb);
	        DOS_ERR = psh->sh_doexec = FALSE;
	      }
	      if (DOS_ERR)
		badtry = (psh->sh_isdef) ? ALNOFIT : AL08ERR;

	      if (wind_spb.sy_owner == rlr)	/* if he still owns screen*/
		  unsync(&wind_spb);		/*   then take him off.	*/

	    }
	    else
	    {
	      if ( (gl_shgem) &&
		   (psh->sh_isdef) )
	      {
		ret = fm_show(ALOKDESK, NULLPTR, 0x0201);
		if (ret == 1)
		  retry = TRUE;
		else
		  retry = psh->sh_doexec = FALSE;
	      }
	      else
		badtry = AL18ERR;
	    }
	  } while (retry && !badtry);
						/* clear his desk field	*/
	  desk_tree[rlr->p_pid] = 0x0L;

	} while(psh->sh_doexec);
}

/*----------------------------------------------------------------------*/
void sh_main( void )
{
						/* do the exec		*/
	sh_ldapp();

						/* get back to alpha	*/
						/*   mode if necessary	*/
	if (gl_shgem)
	  sh_toalpha();
}

/*----------------------------------------------------------------------*/
void sh_signoff( void )
{
	if( sh_msg == NULL ) return;
	dos_write( STDOUT, fstrlen(sh_msg), (LONG)sh_msg );
}


/* gemshlib.c */
