/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1991, 1992 Digital Research Inc.		    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemsclib.c 4.3 92/03/12 11:25:12 sbc Exp $
* $Log:	gemsclib.c $
 * Revision 4.3  92/03/12  11:25:12  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 

*	Add supporting double byte character set. (#if DBCS)		
*						10/15/91	K.H	
*	Optimized for ViewMAX. (#if GEM)	11/26/91	K.H	

* Revision 4.2  92/02/27  15:22:57  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/02/03  11:23:06  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.1  92/01/03  13:17:40  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:53:46  system
 * Prototyping and cleanup plus fix to file selector code
 * 
**************************************************************************/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "crysbind.h"
#include "dos.h"
#include "viewrun.h"
#include "viewapps.h"
#include "cproto.h"
#include "aproto.h"

#if GEM
#define NUM_SCRAPS	6

EXTERN LONG		ad_dta;
EXTERN LONG		ad_sysglo;

GLOBAL LONG		ad_scrap;
GLOBAL BYTE	*sc_types[NUM_SCRAPS] =
			 {"CSV", "TXT", "GEM",
			  "IMG", "DCA", "USR"};
GLOBAL WORD	sc_bits[NUM_SCRAPS] =
			 {SC_FTCSV,SC_FTTXT,SC_FTGEM,
			  SC_FTIMG,SC_FTDCA,SC_FTUSR};

MLOCAL	WORD
sc_clrd(WORD isread)
{
	LONG		ptmp, ptype;
	WORD		bitvect, ii;

	ptmp = ad_scrap;
	while(LBGET(ptmp))			/* find null		*/
	  ptmp++;
	rs_gaddr(ad_sysglo, R_STRING, STSCRAP, &ptype);
	fstrcpy((BYTE FAR *)ptmp, (BYTE FAR *)ptype); 
	ptype = ptmp+fstrlen((BYTE FAR *)ptype);/* point just past '.'	*/
	bitvect = 0;
	dos_sdta(ad_dta);			/* make sure dta ok	*/
	for (ii = 0; ii < NUM_SCRAPS; ii++)
	{					/* cat on file type	*/
	  fstrcpy((BYTE FAR *)ptype, (BYTE FAR *)sc_types[ii]);
	  if (dos_sfirst(ad_scrap, F_SUBDIR))
	  {
	    if (isread)
	      bitvect |= sc_bits[ii];		/* set corresponding bit */
	    else
	      dos_delete(ad_scrap);		/* delete scrap.*	*/
	  }
	}
	if ( !isread)
	  bitvect = TRUE;
	LBSET(ptmp, 0);				/* keep just path name	*/
	return(bitvect);
}

/************************************************************************/
/*									*/
/* sc_read() -- get info about current scrap directory			*/
/*									*/
/*	copies the current scrap directory path to the passed-in 	*/
/*	address and returns a bit vector with bits set for specific	*/
/*	file types present in the directory.  Looks for scrap.* files.	*/
/*									*/
/************************************************************************/

	WORD
sc_read(pscrap)
	LONG		pscrap;
{
						/* current scrap directory */
	fstrcpy( (BYTE FAR *)pscrap, (BYTE FAR *)ad_scrap);
						/* cat on backslash	*/
	fstrcat( (BYTE FAR *)pscrap, (BYTE FAR *)"\\");
	return( sc_clrd(TRUE) );
}

/************************************************************************/
/*									*/
/* sc_write() -- sets the current scrap directory			*/
/*									*/
/*	pscrap must be the long address of a valid path.  Returns	*/
/*	TRUE if no error occurs in validating the path name.		*/
/*									*/
/************************************************************************/

	WORD
sc_write(pscrap)
	LONG		pscrap;
{
	WORD		len;
#if DBCS
	REG WORD	i;
	REG WORD	type = CT_ADE;
#endif /* DBCS */
						/* new scrap directory	*/
	len = fstrlen( (BYTE FAR *)pscrap);
#if DBCS
	if (dbcs_expected())		/* are we looking out for DBCS? */
	    for(i=0; i<len; i++)
	        type = chkctype(LBGET(ad_scrap + i), type);
	if (type == CT_ADE)
#endif /* DBCS */
	fstrcpy((BYTE FAR *)ad_scrap, (BYTE FAR *)pscrap);
	if (LBGET(ad_scrap + --len) == '\\')	/* remove backslash	*/
	  LBSET(ad_scrap + len, '\0');
	dos_sdta(ad_dta);			/* use our dta 		*/
	return(dos_sfirst(ad_scrap, F_SUBDIR));	/* make sure path ok	*/
}

/************************************************************************/
/*									*/
/* sc_clear() -- delete scrap files from current scrap directory	*/
/*									*/
/*	Assumes *ad_scrap holds a valid directory path.  Returns TRUE	*/
/*									*/
/************************************************************************/

	WORD
sc_clear()
{
	return( sc_clrd(FALSE) );
}

#endif /* GEM */

/* gemsclib.c */
