/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemoblib.c 4.3 92/03/12 11:24:59 sbc Exp $
* $Log:	gemoblib.c $
 * Revision 4.3  92/03/12  11:24:59  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 

*	911107		K.H	Fixed just_draw filled out selected object
*				with width-1 and height-1.
*	911015		K.H	Added supporting double byte character set.
*				(#if DBCS)

 * Revision 4.2  92/02/27  15:22:36  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.5  92/02/11  11:12:29  Fontes
 * Background image display implementation
 * 
 * Revision 4.4  92/01/27  16:09:27  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.3  92/01/03  13:17:18  Fontes
 * Susan's cleanup
 * 
 * Revision 4.1  91/11/19  13:49:34  Fontes
 * Removed unnecessary global ad_ib
 * 
*	911125		RSF	Began color icon work.
*======================================================================
*	910516		WHF	Changed "puff factor" on HIGHLIGHT stuff
*	910502		RSF	Clean up warnings.
*	910326		WHF	3D drawing changes
*	05 MAY 90	JFL	Make drop shadows thicker and prettier
*	   DEC 89	JFL	Changes for ViewMAX
****************************************************************************/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "funcdef.h"
#include "viewapps.h"
#include "cproto.h"
#include "aproto.h"

#define RED_UNDERLINES	1

EXTERN WORD	gl_width;

EXTERN WORD	gl_wclip;
EXTERN WORD	gl_hclip;

EXTERN WORD	gl_wchar;
EXTERN WORD	gl_hchar;

EXTERN LONG	ad_intin;
EXTERN WORD	intin[];

EXTERN BOOLEAN	gl_domono;


EXTERN THEGLO	D;

GLOBAL LONG	ad_tmpstr;
GLOBAL LONG	ad_rawstr;
GLOBAL LONG 	ad_fmtstr;
EXTERN LONG	ad_valstr;
GLOBAL LONG 	ad_edblk;
GLOBAL LONG     ad_bi;

GLOBAL TEDINFO	edblk;
GLOBAL BITBLK	bi;

MLOCAL ICONBLK	ib;


/*
*	Routine to take an unformatted raw string and based on a
*	template string build a formatted string.
*/
	VOID
ob_format(just, raw_str, tmpl_str, fmt_str)
	WORD		just;
	BYTE		*raw_str, *tmpl_str, *fmt_str;
{
	REG BYTE	*pfbeg, *ptbeg, *prbeg;
	BYTE		*ptend, *prend;
/*	BYTE		*pfend;	(RSF) unused */
	REG WORD	inc, ptlen, prlen;
#if DBCS
	REG WORD	i;
	BYTE		addc = 0;
#endif /* DBCS */

	if (*raw_str == '@')
#if DBCS
	{
	  *raw_str = NULL;
	  addc = 1;
	}
#else /* DBCS */
	  *raw_str = NULL;
#endif /* DBCS */
	pfbeg = fmt_str;
	ptbeg = tmpl_str;
	prbeg = raw_str;

	ptlen = strlen(tmpl_str);
	prlen = strlen(raw_str);

	inc = 1;
	pfbeg[ptlen] = NULL;
	if (just == TE_RIGHT)
	{
	  inc = -1;
	  pfbeg = pfbeg + ptlen - 1;
	  ptbeg = ptbeg + ptlen - 1;
	  prbeg = prbeg + prlen - 1;
	}

/*	pfend = pfbeg + (inc * ptlen);	(RSF) unused */
	ptend = ptbeg + (inc * ptlen);
	prend = prbeg + (inc * prlen);
#if DBCS
	i = ptbeg - tmpl_str;
#endif /* DBCS */
	while( ptbeg != ptend )
	{
#if DBCS
	  if ( !isequalto(tmpl_str, i, '_') )
#else /* DBCS */
	  if ( *ptbeg != '_')
#endif /* DBCS */	      
	    *pfbeg = *ptbeg;
	  else
	  {
	    if ( prbeg != prend )
	    {
	      *pfbeg = *prbeg;
	      prbeg += inc;
	    }
	    else
	      *pfbeg = '_';
	  } /* else */
	  pfbeg += inc;
	  ptbeg += inc;
#if DBCS
	  i += inc;
#endif /* DBCS */
	} /* while */
#if DBCS
	if (addc)
	  *raw_str = '@';
#endif /* DBCS */
} /* ob_format */


/*
*	Routine to load up and call a user defined object draw or change 
*	routine.
*/

MLOCAL	WORD
ob_user(TREE tree, WORD obj, GRECT *pt, LONG spec, 
	WORD curr_state, WORD new_state)
{
	PARMBLK		pb;

	pb.pb_tree = tree;
	pb.pb_obj = obj;
	pb.pb_prevstate = curr_state;
	pb.pb_currstate = new_state;
	memmove( (void *)&pb.pb_x, (void *)pt, sizeof( GRECT ) ) ;
	gsx_gclip((GRECT*)&pb.pb_xc);
	pb.pb_parm = LLGET(spec+4);
	return(  far_call(LLGET(spec), ADDR(&pb)) );
}

MLOCAL	VOID
draw_hilite(WORD obtype, GRECT *t)
{
	WORD	puff_amt;

	vsl_udsty( 0xAAAA );
	vsl_type( 7 );
	gsx_attr(FALSE, MD_XOR, BLACK);
	switch( obtype ) {
          case G_ICON: 
	  case G_CLRICN:
		puff_amt = 1; break;
	  case G_STRING: 
		puff_amt = 3; break;
	  default: 
		puff_amt = 5; break;
         }
	 gr_box(t->g_x-puff_amt, t->g_y-puff_amt, 
		 t->g_w+2*puff_amt, t->g_h+2*puff_amt, 2);
	 vsl_type( 1 );
}

	VOID
ob_highlight( tree, obj )
	TREE	tree;
	WORD	obj;
{
	WORD	state, obtype, flags, th;
	LONG	spec;
	GRECT 	t;

	ob_sst(tree, obj, &spec, &state, &obtype, &flags, &t, &th);

	ob_actxywh(tree, obj, &t);

	if ( obtype!=G_USERDEF ) 
	{
		draw_hilite(obtype, &t);
	}
}

MLOCAL	WORD
exobj_num(     TREE		tree,
	       WORD		obj
	       )
{
    WORD	ret;
    
    ret = (WORD)(((tree+obj)->ob_type >> 8) & 0x00FF);
    return( ret );
}

/*
*	Routine to find the object that is previous to us in the
*	tree.  The idea is we get our parent and then walk down
*	his list of children until we find a sibling who points to
*	us.  If we are the first child or we have no parent then
*	return NIL.
*/
MLOCAL	WORD
get_prev(REG TREE tree, WORD parent, REG WORD obj)
{
	REG WORD	nobj, pobj;

	pobj = (tree+parent)->ob_head ;
	if (pobj != obj)
	{
	  while (TRUE)
	  {
	    nobj = (tree+pobj)->ob_next ;
	    if (nobj != obj)
	      pobj = nobj;
	    else
	      return(pobj);
	  }
	}
	return(NIL);
} /* get_prev */


/*
*	Routine to draw an object from an object tree.
*/
	VOID
just_draw(tree, obj, sx, sy)
	REG TREE	tree;
	REG WORD	obj;
	REG WORD	sx, sy;
{
	WORD		bcol, tcol, ipat, icol, tmode, th;
	WORD		state, obtype, len, flags;
	LONG		spec;
	WORD		tmpx, tmpy, tmpth;
#if RED_UNDERLINES	
	BYTE		ch,n;
#else /* RED_UNDERLINES */
	BYTE		ch,n,sav_ch;
#endif /* RED_UNDERLINES */
	GRECT		t, c;
	BOOLEAN		doit3d;
	BYTE		sav[80];
	
	ch = ob_sst(tree, obj, &spec, &state, &obtype, &flags, &t, &th);


	if((obtype==G_BUTTON) || (flags&FLAG3D))
	{	
		doit3d = TRUE; 
		flags |= USECOLORCAT;
	} 
	else	doit3d = FALSE;

	if ( (flags & HIDETREE) ||
	     (spec == -1L) )
	  return;

	t.g_x = sx;
	t.g_y = sy;
						/* do trivial reject	*/
						/*  with full extent	*/
						/*  including, outline, */
						/*  shadow, & thickness	*/
	if (gl_wclip && gl_hclip)
	{
	  memmove( (void *)&c, (void *)&t, sizeof( GRECT ) ) ;
	  if (state & OUTLINED)
	    gr_inside(&c, -5);
	  else
	    gr_inside(&c, ((th < 0) ? (5 * th) : (-5 * th)) );
	
	  if ( !(gsx_chkclip(&c)) )
	    return;
	}
						/* for all tedinfo	*/
						/*   types get copy of	*/
						/*   ted and crack the	*/
						/*   color word and set	*/
						/*   the text color	*/
	if ( obtype != G_STRING )
	{
	  tmpth = (th < 0) ? 0 : th;
	  tmode = MD_REPLACE;
	  tcol = BLACK;
	  switch( obtype )
	  {
	    case G_BOXTEXT:
	    case G_FBOXTEXT:
	    case G_TEXT:
	    case G_FTEXT:
		  fmemcpy((BYTE FAR *)ad_edblk, (BYTE FAR *)spec, 
			  sizeof(TEDINFO));
		  gr_crack(edblk.te_color, &bcol,&tcol, &ipat, &icol, &tmode);
		break;
	  }
						/* for all box types	*/
						/*   crack the color 	*/
						/*   if not ted and	*/
						/*   draw the box with	*/
						/*   border		*/
	  switch( obtype )
	  {
	    case G_BOX:
	    case G_BOXCHAR:
	    case G_IBOX:
		gr_crack(LOWORD(spec), &bcol, &tcol, &ipat, &icol, &tmode);
	    case G_BUTTON:
		if (obtype == G_BUTTON )
		{
#if 000
		  gsx_attr(FALSE, MD_REPLACE, WHITE); /* Erase any previous box */
		  gr_box(t.g_x, t.g_y, t.g_w, t.g_h, -3);
#endif
		  icol = CC_BUTTON;
		}
	    case G_BOXTEXT:
	    case G_FBOXTEXT:

		if( doit3d )
		  gr_3dbox( &t, th );		/*910326WHF*/
		else
		{				/* draw box's border	*/
		  if ( th != 0 )
		  {
		    gsx_attr(FALSE, MD_REPLACE, bcol);
		    gr_box(t.g_x, t.g_y, t.g_w, t.g_h, th);
		  }
		}
						/* draw filled box	*/
		if( obtype != G_IBOX )
		{
		    gr_inside(&t, tmpth); 
		    if( doit3d ) gr_inside(&t, 1);	/* acct for 3d brdr */
		    if( flags & USECOLORCAT )	/*910327WHF*/
		    {
			grcc_rect( icol, &t );
			if( doit3d & !gl_domono )
			    inner_dots( &t, WHITE, LBLACK );
		    }
		    else
			gr_rect(icol, ipat, &t); 
		    if( doit3d ) gr_inside(&t, -1);	/* acct for 3d brdr */
		    gr_inside(&t, -tmpth); 
		}
		break;
	  }
	  gsx_attr(TRUE, tmode, tcol);
						/* do whats left for	*/
						/*   all the other types*/
	  switch( obtype )
	  {
	    case G_FTEXT:
	    case G_FBOXTEXT:
		fstrcpy((BYTE FAR *)ad_rawstr, (BYTE FAR *)edblk.te_ptext);
		fstrcpy((BYTE FAR *)ad_tmpstr, (BYTE FAR *)edblk.te_ptmplt);
		fstrcpy((BYTE FAR *)ad_valstr, (BYTE FAR *)edblk.te_pvalid);
		if( flags & EDITABLE ){	/* Block out a silent (no-show) field*/
		  for( n=0 ; D.g_rawstr[n] ; n++ ){
		    sav[n]=D.g_rawstr[n];
		    if( toupper(D.g_valstr[n])=='S' )
		      D.g_rawstr[n]=0xFE;
		  }
		}
		ob_format(edblk.te_just, &D.g_rawstr[0], &D.g_tmpstr[0], 
			&D.g_fmtstr[0]);
						/* fall thru to gr_gtext*/
	    case G_BOXCHAR:
		edblk.te_ptext = ad_fmtstr;
		if (obtype == G_BOXCHAR)
		{
		  D.g_fmtstr[0] = ch;
		  D.g_fmtstr[1] = NULL;
		  edblk.te_just = TE_CNTR;
		  edblk.te_font = IBM;
		}
						/* fall thru to gr_gtext*/
	    case G_TEXT:
	    case G_BOXTEXT:
		gr_inside(&t, tmpth);
		gr_gtext(edblk.te_just, edblk.te_font, edblk.te_ptext, 
				&t);
		gr_inside(&t, -tmpth);
		if( (flags & EDITABLE) && 
			(obtype==G_FTEXT || obtype==G_FBOXTEXT) ){
		  for( n=0 ; D.g_rawstr[n] ; n++ ){
		    LBSET( edblk.te_ptext+n,sav[n] );
		  }
		}
		break;
	    case G_IMAGE:
		fmemcpy((BYTE FAR *)ad_bi, (BYTE FAR *)spec, sizeof(BITBLK));
		gsx_blt(bi.bi_pdata, bi.bi_x, bi.bi_y, bi.bi_wb,
				0x0L, t.g_x, t.g_y, gl_width/8, bi.bi_wb * 8,
				bi.bi_hl, MD_TRANS, bi.bi_color, WHITE);
		break;
	    case G_ICON:
		fmemcpy((BYTE FAR *)&ib, (BYTE FAR *)spec, sizeof(ICONBLK));
		ib.ib_xicon += t.g_x;
		ib.ib_yicon += t.g_y; 
		ib.ib_xtext += t.g_x;
		ib.ib_ytext += t.g_y; 
		gr_gicon(state, ib.ib_pmask, ib.ib_pdata, ib.ib_ptext,
		  ib.ib_char, ib.ib_xchar, ib.ib_ychar,
		  (GRECT*)&ib.ib_xicon, (GRECT*)&ib.ib_xtext);
		state &= ~SELECTED;
		break;
	    case G_CLRICN:

		fmemcpy((BYTE FAR *)&ib, (BYTE FAR *)spec, sizeof(ICONBLK));
		ib.ib_xicon += t.g_x;
		ib.ib_yicon += t.g_y; 
		ib.ib_xtext += t.g_x;
		ib.ib_ytext += t.g_y; 
		gr_clricon(state, ib.ib_pmask, ib.ib_pdata, ib.ib_ptext,
		  ib.ib_char, ib.ib_xchar, ib.ib_ychar,
		  (GRECT*)&ib.ib_xicon, (GRECT*)&ib.ib_xtext);
		state &= ~SELECTED;
		break;
	    case G_USERDEF:
		state = ob_user(tree, obj, &t, spec, state, state);
		break;
	    case G_DTMFDB:
		gr_dtmfdb((FDB FAR *)spec, &t);
		break;
	  } /* switch type */
	}
	if ( (obtype == G_STRING) ||
	     (obtype == G_TITLE) ||
             (obtype == G_BUTTON) )
	{
	  len = lbwmov((short far *)ad_intin, (unsigned char far *)spec);
	  if (len)
	  { 
	    gsx_attr(TRUE, MD_TRANS, BLACK);
	    tmpy = t.g_y + ((t.g_h-gl_hchar)/2);
	    if (obtype == G_BUTTON)
	      tmpx = t.g_x + ((t.g_w-(len*gl_wchar))/2);
	    else
	      tmpx = t.g_x;
#if DBCS
	    for( n=0 ; n<len && intin[n] && intin[n]!='_' ; n++ )
	      if (dbcs_lead(intin[n]) && intin[n+1])
		n++;
#else /* DBCS */
	    for( n=0 ; n<len && intin[n] && intin[n]!='_' ; n++ );
#endif /* DBCS */	
	    if( !intin[n] || n==len || exobj_num(tree, obj) )
	      gsx_tblt(IBM, tmpx, tmpy, len);
	    else{
#if RED_UNDERLINES		
	      intin[n]=0;	/* output string preceeding '_' char */
	      gsx_tblt(IBM, tmpx, tmpy, n );

	      if ( DISABLED & (tree+obj)->ob_state ) {
			/* draw greyed out items with grey underlines */
		gsx_attr(TRUE, MD_TRANS, BLACK ) ;
	      } else {	/* draw in red */
		gsx_attr(TRUE, MD_TRANS, RED ) ;
	      }

	      tmpx += (n*gl_wchar) ;
	      lbwmov( (short far *)ad_intin, (unsigned char far *)"_" ) ;
	      gsx_tblt(IBM, tmpx, tmpy, 1 );
	    
	      spec+=(n+1);	
	      gsx_attr(TRUE, MD_TRANS, BLACK); /* back to black */
				      /* ..and put the rest of the string */
	      lbwmov( (short far *)ad_intin, (unsigned char far *)spec ); 
	      gsx_tblt(IBM, tmpx, tmpy, len-(n+1) );

#else /* RED_UNDERLINES */
	      sav_ch=intin[n+1];
	      intin[n+1]=0;	/* Output string up to '_' character */
	      gsx_tblt(IBM, tmpx, tmpy, n+1 );
	      intin[n+1]=sav_ch;
	      spec+=(n+1);	/* Point past '_' and backspace 1 */
	      lbwmov( ad_intin, spec ); /* ..and put the rest of the string */
	      gsx_tblt(IBM, tmpx+(n*gl_wchar), tmpy, len-(n+1) );
#endif /* RED_UNDERLINES */
	    }				/* ..starting on top of the '_' */
	  }
	}
	if (state)
	{
	  if ( state & OUTLINED )
	  {
	      gsx_attr(FALSE, MD_REPLACE, BLACK);
	      gr_box(t.g_x-3, t.g_y-3, t.g_w+6, t.g_h+6, 1);
	      gsx_attr(FALSE, MD_REPLACE, WHITE);
	      gr_box(t.g_x-2, t.g_y-2, t.g_w+4, t.g_h+4, 2);
	  }

	  if (th > 0)			/* ensure t is inside the border */
	    gr_inside(&t, th);
	  else 
	    th = -th;

	  if ( (state & SHADOWED) && th )
	  {
	    vsf_color(1);	/* All drop shadows cast a dgrey shadow */
	    bb_fill(MD_ERASE, FIS_PATTERN, 4, t.g_x+t.g_w+th, t.g_y+(4*th),
				4*th, t.g_h+th );
	    bb_fill(MD_ERASE, FIS_PATTERN, 4, t.g_x+(4*th), t.g_y+t.g_h+th, 
			t.g_w+th, 4*th);
	  }
	  if ( state & CHECKED )
	  {
	    gsx_attr(TRUE, MD_TRANS, BLACK);
	    intin[0] = 0x10;				/* a check mark	*/
	    gsx_tblt(IBM, t.g_x+2, t.g_y, 1);
	  }
	  if ( state & CROSSED )
	  {
	    gsx_attr(FALSE, MD_TRANS, WHITE);
	    gsx_cline(t.g_x, t.g_y, t.g_x+t.g_w-1, t.g_y+t.g_h-1);
	    gsx_cline(t.g_x, t.g_y+t.g_h-1, t.g_x+t.g_w-1, t.g_y);
	  }
	  if ( state & DISABLED )
	  {
	    vsf_color(WHITE);
	    bb_fill(MD_TRANS, FIS_PATTERN, IP_4PATT, t.g_x, t.g_y,
			 t.g_w, t.g_h);
	  }

	  if (state & SELECTED)
	  {
	    if( doit3d && !gl_domono)
	    {
	      gr_3dpress( &t, -th );		/*910326WHF*/
	    }
	    else
	      bb_fill( MD_XOR, FIS_SOLID, IP_SOLID, t.g_x, t.g_y, t.g_w, t.g_h);
	  }

	  if ( (state & HIGHLIGHTED || state & UNHIGHLIGHTED) 
	  	&& (obtype!=G_USERDEF) && (obtype!=G_DTMFDB)) /* New state to draw a field outline */
	  {
	      draw_hilite(obtype, &t);
	  }

	}
} /* just_draw */


/*
*	Object draw routine that walks tree and draws appropriate objects.
*/
	VOID
ob_draw(tree, obj, depth)
	REG TREE	tree;
	WORD		obj, depth;
{
	WORD		last, pobj;
	WORD		sx, sy;

	pobj = get_par(tree, obj, &last);

	if (pobj != NIL)
	  ob_offset(tree, pobj, &sx, &sy);
	else
	  sx = sy = 0;

	gsx_moff();
	everyobj(tree, obj, last, just_draw, sx, sy, depth);
	gsx_mon();
}


/*
*	Routine to find out which object a certain mx,my value is
*	over.  Since each parent object contains its children the
*	idea is to walk down the tree, limited by the depth parameter,
*	and find the last object the mx,my location was over.
*/

/************************************************************************/
/* o b _ f i n d							*/
/************************************************************************/
	WORD
ob_find(tree, currobj, depth, mx, my)
	REG TREE	tree;
	REG WORD	currobj;
	REG WORD	depth;
	WORD		mx, my;
{
	WORD		lastfound;
	WORD		dosibs, done, junk;
	GRECT		t, o;
	WORD		parent, childobj, flags;

	lastfound = NIL;

	if (currobj == 0)
	  r_set(&o, 0, 0, 0, 0);
	else
	{
	  parent = get_par(tree, currobj, &junk);
	  ob_actxywh(tree, parent, &o);
	}
	
	done = FALSE;
	dosibs = FALSE;

	while( !done )
	{
						/* if inside this obj,	*/
						/*   might be inside a	*/
						/*   child, so check	*/
	  ob_relxywh(tree, currobj, &t);
	  t.g_x += o.g_x;
	  t.g_y += o.g_y;

	  flags = (tree+currobj)->ob_flags ;
	  if ( (inside(mx, my, &t)) &&
	       (!(flags & HIDETREE)) )
	  {
	    lastfound = currobj;

	    childobj = (tree+currobj)->ob_tail ;
	    if ( (childobj != NIL) && depth)
	    {
	      currobj = childobj;
	      depth--;
	      o.g_x = t.g_x;
	      o.g_y = t.g_y;
	      dosibs = TRUE;
	    }
	    else
	      done = TRUE;
	  }
	  else
	  {
	    if ( (dosibs) &&
	         (lastfound != NIL) )
	    {
	        currobj = get_prev(tree, lastfound, currobj);
	        if (currobj == NIL)
	          done = TRUE;
	    }
	    else
	      done = TRUE;
	  }
	}
						/* if no one was found	*/
						/*   this will return	*/
						/*   NIL		*/
	return(lastfound);
} /* ob_find */


/*
*	Routine to add a child object to a parent object.  The child
*	is added at the end of the parent's current sibling list.
*	It is also initialized.
*/
	VOID
ob_add(tree, parent, child)
	REG TREE	tree;
	REG WORD	parent, child;
{
	REG WORD	lastkid;

	if ( (parent != NIL) &&
	     (child != NIL) )
	{
						/* initialize child	*/
	  (tree+child)->ob_next = parent ;

	  lastkid = (tree+parent)->ob_tail ;
	  if (lastkid == NIL)
						/* this is parent's 1st	*/
						/*   kid, so both head	*/
						/*   and tail pt to it	*/
		  (tree+parent)->ob_head = child ;
	  else
						/* add kid to end of 	*/
						/*   kid list		*/
		  (tree+lastkid)->ob_next = child ;
	
 	  (tree+parent)->ob_tail = child ;
	}
} /* ob_add */

/*
*	Routine to delete an object from the tree.
*/
	VOID
ob_delete(tree, obj)
	REG TREE	tree;
	REG WORD	obj;
{
	REG WORD	parent;
	WORD		prev, nextsib;

	if (obj != ROOT)
	  parent = get_par(tree, obj, &nextsib);
	else
	  return;

	if ( obj == (tree+parent)->ob_head )
	{
						/* this is head child	*/
						/*   in list		*/
	  if ( obj == (tree+parent)->ob_tail )
	  {
						/* this is only child	*/
						/*   in list, so fix	*/
						/*   head & tail ptrs	*/
	    nextsib = NIL;
	    (tree+parent)->ob_tail = NIL ;
	  }
						/*   move head ptr to 	*/
						/*   next child in list	*/
	  (tree+parent)->ob_head = nextsib ;
	}
	else
	{
						/* it's somewhere else,	*/
						/*   so move pnext	*/
						/*   around it		*/
	  prev = get_prev(tree, parent, obj);
	  (tree+prev)->ob_next = nextsib ;
	  if ( obj == (tree+parent)->ob_tail )
						/* this is last child	*/
						/*   in list, so move	*/
						/*   tail ptr to prev	*/
						/*   child in list	*/
	    (tree+parent)->ob_tail = prev ;
	}
} /* ob_delete */

/*
*	Routine to change the order of an object relative to its
*	siblings in the tree.  0 is the head of the list and NIL
*	is the tail of the list.
*/
	VOID
ob_order(tree, mov_obj, new_pos)
	REG TREE	tree;
	REG WORD	mov_obj;
	WORD		new_pos;
{
	REG WORD	parent;
	WORD		chg_obj, ii, junk;

	if (mov_obj != ROOT)
	  parent = get_par(tree, mov_obj, &junk);
	else
	  return;

	ob_delete(tree, mov_obj);
	chg_obj = (tree+parent)->ob_head ;
	if (new_pos == 0)
	{
						/* put mov_obj at head	*/
						/*   of list		*/
	  (tree+mov_obj)->ob_next = chg_obj ;
	  (tree+parent)->ob_head = mov_obj ;
	}
	else
	{
						/* find new_pos		*/
	  if (new_pos == NIL)
	    chg_obj = (tree+parent)->ob_tail ;
	  else
	  {
	    for (ii = 1; ii < new_pos; ii++)
	      chg_obj = (tree+chg_obj)->ob_next ;
	  } /* else */
						/* now add mov_obj 	*/
						/*   after chg_obj	*/
	  (tree+mov_obj)->ob_next = (tree+chg_obj)->ob_next ;
	  (tree+chg_obj)->ob_next = mov_obj ;
	}
	if ( parent == (tree+mov_obj)->ob_next )
	  (tree+parent)->ob_tail = mov_obj ;
} /* ob_order */

/************************************************************************/
/* o b _ e d i t 							*/
/************************************************************************/
/* see OBED.C								*/

/*
*	Routine to change the state of an object and redraw that
*	object using the current clip rectangle.
*/
	VOID
ob_change(tree, obj, new_state, redraw)
	REG TREE	tree;
	REG WORD	obj;
	UWORD		new_state;
	WORD		redraw;
{
	WORD		flags, obtype, th;
	GRECT		t;
	UWORD		curr_state;
	LONG		spec;

	ob_sst(tree, obj, &spec, (WORD*)&curr_state, &obtype, 
		&flags, &t, &th);
	
	if ( (curr_state == new_state) || (spec == -1L) )
	  return;	

        (tree+obj)->ob_state = new_state ;

	if (redraw)
	{
	  ob_offset(tree, obj, &t.g_x, &t.g_y);

	  gsx_moff();

	  th = (th < 0) ? 0 : th;

	  if ( obtype == G_USERDEF )
	  {
	    ob_user(tree, obj, &t, spec, curr_state, new_state);
	    redraw = FALSE;
	  }
	  else
	  {
	    if ( (obtype != G_ICON)  && (obtype != G_CLRICN) &&
		 (obtype != G_BUTTON)  &&  !(flags & FLAG3D)  &&  /*910326WHF*/
	       ((new_state ^ curr_state) & SELECTED) )
	    {
	      bb_fill(MD_XOR, FIS_SOLID, IP_SOLID, t.g_x+th, t.g_y+th,
			t.g_w-(2*th), t.g_h-(2*th));
	      redraw = FALSE;
	    }
	  }

	  if (redraw)
	      just_draw(tree, obj, t.g_x, t.g_y);

	  gsx_mon();
	}
	return;
} /* ob_change */

	UWORD
ob_fs(tree, ob, pflag)
	TREE		tree;
	WORD		ob;
	WORD		*pflag;
{
	*pflag = (tree+ob)->ob_flags ;
	return( (tree+ob)->ob_state ) ;
}

/************************************************************************/
/* o b _ a c t x y w h							*/
/************************************************************************/
	VOID
ob_actxywh(tree, obj, pt)
	REG TREE	tree;
	REG WORD	obj;
	REG GRECT	*pt;
{
	ob_offset(tree, obj, &pt->g_x, &pt->g_y);
	pt->g_w = (tree+obj)->ob_width ;
	pt->g_h = (tree+obj)->ob_height ;
} /* ob_actxywh */


/************************************************************************/
/* o b _ r e l x y w h							*/
/************************************************************************/
	VOID
ob_relxywh(tree, obj, pt)
	TREE		tree;
	WORD		obj;
	GRECT		*pt;
{
	fmemcpy( (char far *)pt, 
	    (char far *)&((tree+obj)->ob_x), sizeof(GRECT) );
} /* ob_relxywh */

	VOID
ob_setxywh(tree, obj, pt)
	TREE		tree;
	WORD		obj;
	GRECT		*pt;
{
	fmemcpy( (char far *)(&(tree+obj)->ob_x), 
	    (char far *)pt, sizeof(GRECT) );
}


/*
*	Routine to find the x,y offset of a particular object relative
*	to the physical screen.  This involves accumulating the offsets
*	of all the objects parents up to and including the root.
*/
	VOID
ob_offset(tree, obj, pxoff, pyoff)
	REG TREE	tree;
	REG WORD	obj;
	REG WORD	*pxoff, *pyoff;
{
	WORD		junk;

	*pxoff = *pyoff = 0;
	do
	{
						/* have our parent--	*/
						/*  add in his x, y	*/
	  *pxoff += (tree+obj)->ob_x ;
	  *pyoff += (tree+obj)->ob_y ;
	  obj = get_par(tree, obj, &junk);
	} while ( obj != NIL );
}


/* end of gemoblib.c */
