/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemfslib.c 4.3 92/03/12 11:25:16 sbc Exp $
* $Log:	gemfslib.c $
 * Revision 4.3  92/03/12  11:25:16  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 

 *	Added supporting double byte character.	(#if DBCS)		
 *						10/14/91	K.H	
 *	Optimized for ViewMAX. (#if GEM)	11/26/91	K.H	
     
 * Revision 4.2  92/02/27  15:23:00  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/02/03  11:21:04  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.2  92/01/27  16:11:13  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:16:16  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:53:50  system
 * Prototyping and cleanup plus fix to file selector code
 * 
*****************************************************************************/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "obdefs.h"
#include "dos.h"
#include "gemlib.h"
#include "viewrun.h"
#include "viewapps.h"
#include "cproto.h"
#include "aproto.h"

#if GEM
#define NM_NAMES (F9NAME-F1NAME+1)
#define NAME_OFFSET F1NAME
#define LEN_FTITLE 18				/* BEWARE, requires change*/
						/*  in GEM.RSC		*/

EXTERN WORD	gl_hbox;

EXTERN LONG	ad_armice;
EXTERN LONG	ad_hgmice;

EXTERN LONG	ad_dta;
EXTERN BYTE	gl_dta[128];

EXTERN UWORD	gl_bvdisk;

EXTERN THEGLO	D;

GLOBAL BYTE	gl_fsobj[4] = {FTITLE, FILEBOX, SCRLBAR, 0x0};
GLOBAL TREE	ad_fstree;
GLOBAL LONG	ad_fsdta;
GLOBAL GRECT	gl_rfs;

GLOBAL LONG	ad_tmp1;
GLOBAL BYTE	gl_tmp1[LEN_FSNAME];
GLOBAL LONG	ad_tmp2;
GLOBAL BYTE	gl_tmp2[LEN_FSNAME];

GLOBAL WORD	gl_shdrive;
GLOBAL WORD	gl_fspos;

typedef struct fsname
{
	char name[LEN_FSNAME];
}
FSNAME;

MLOCAL	FSNAME FAR *ad_fsnames;

/*
*	Routine to back off the end of a file string.
*/
MLOCAL	BYTE *fs_back(REG BYTE *pstr, REG BYTE *pend)
{
#if DBCS
	REG BYTE	*pp;

	for(pp = pstr; pp <= pend; pp++)
	{
	  if (dbcs_lead(*pp))
	    pp++;
	  else if ((*pp == '\\') || (*pp == ':'))
	    pstr = pp;
	}
	pend = pstr;
#else /* DBCS */
						/* back off to last	*/
						/*   slash		*/
	while ( (*pend != ':') &&
		(*pend != '\\') &&
		(pend != pstr) )
	  pend--;
#endif /* DBCS */
						/* if a : then insert	*/
						/*   a backslash	*/
	if (*pend == ':')
	{
	  pend++;
	  ins_char(pend, 0, '\\', 64);
	}
	return(pend);
}


/*
*	Routine to back up a path and return the pointer to the beginning
*	of the file specification part
*/
MLOCAL	BYTE
*fs_pspec(REG BYTE *pstr, REG BYTE *pend)
{
	pend = fs_back(pstr, pend);
	if (*pend == '\\')
	  pend++;
	else
	{
	  strcpy( pstr, "A:\\*.*" );
	  pstr[0] += (BYTE) dos_gdrv();
	  pend = pstr + 3;
	}
	return(pend);
}

/*
*	Routine to compare based on type and then on name if its a file
*	else, just based on name
*/

MLOCAL	WORD
fs_comp( void )
{
	WORD		chk;

	if ( (gl_tmp1[0] == ' ') &&
	     (gl_tmp2[0] == ' ') )
	{
	  chk = strcmp( strchr(&gl_tmp1[0], '.'), 
			strchr(&gl_tmp2[0], '.') );
	  if ( chk )
	    return( chk );
	}
	return ( strcmp(&gl_tmp1[0], &gl_tmp2[0]) );
}


MLOCAL	WORD
fs_add(WORD thefile, WORD fs_index)
{

	fstrcpy((BYTE FAR *)ad_fsnames[fs_index].name,
			(BYTE FAR *)(ad_fsdta - 1));
	D.g_fslist[thefile] = fs_index;
	fs_index ++;

	return(fs_index);
}


/*
*	Make a particular path the active path.  This involves
*	reading its directory, initializing a file list, and filling
*	out the information in the path node.  Then sort the files.
*/
MLOCAL	WORD
fs_active(LONG ppath, BYTE *pspec, WORD *pcount)
{
	WORD		ret, thefile;
	WORD		fs_index;
	REG WORD	i, j, gap;
	BYTE		temp;
	
	gsx_mfset(ad_hgmice);

	thefile = 0;
	fs_index = 0;

	if (gl_shdrive)
	{
	  strcpy( &gl_dta[29], "\007 A:" );
	  for(i=0; i<16; i++)
	  {
	    if ( (gl_bvdisk >> i) & 0x0001 )
	    {
	      gl_dta[31] = 'A' + (15 - i);
	      fs_index = fs_add(thefile, fs_index);
	      thefile++;
	    }
	  }
	}
	else
	{
	  dos_sdta(ad_dta);
	  ret = dos_sfirst(ppath, F_SUBDIR);
	  while ( ret )
	  {
						/* if it is a real file	*/
						/*   or directory then	*/
						/*   save it and set	*/
						/*   first byte to tell	*/
						/*   which		*/
	    if (gl_dta[30] != '.')
	    {
	      gl_dta[29] = (gl_dta[21] & F_SUBDIR) ? 0x07 : ' ';
	      if ( (gl_dta[29] == 0x07) ||
		   (wildcmp(pspec, &gl_dta[30])) )
	      {
		fs_index = fs_add(thefile, fs_index);
	        thefile++;
	      }
	    }
	    ret = dos_snext();

	    if (thefile >= NM_FILES)
	    {
	      ret = FALSE;
	      v_sound(TRUE, 660, 4);
	    }
	  }
	}
	*pcount = thefile;
						/* sort files using shell*/
						/*   sort on page 108 of */
						/*   K&R C Prog. Lang.	*/
	for(gap = thefile/2; gap > 0; gap /= 2)
	{
	  for(i = gap; i < thefile; i++)
	  {
	    for (j = i-gap; j >= 0; j -= gap)
	    {
	      fstrcpy((BYTE FAR *)ad_tmp1, 
		      (BYTE FAR *)ad_fsnames[D.g_fslist[j]].name);
	      fstrcpy((BYTE FAR *)ad_tmp2, 
		      (BYTE FAR *)ad_fsnames[D.g_fslist[j+gap]].name);
	      if ( fs_comp() <= 0 )
		break;
	      temp = D.g_fslist[j];
	      D.g_fslist[j] = D.g_fslist[j+gap];
	      D.g_fslist[j+gap] = temp;
	    }
	  }
	}
	gsx_mfset( ad_armice );
	return(TRUE);
}


/*
*	Routine to adjust the scroll counters by one in either
*	direction, being careful not to overrun or underrun the
*	tail and heads of the list
*/
MLOCAL	WORD
fs_1scroll(REG WORD curr, REG WORD count, REG WORD touchob)
{
	REG WORD	newcurr;

	newcurr = (touchob == FUPAROW) ? (curr - 1) : (curr + 1);
	if (newcurr < 0)
	  newcurr++;
	if ( (count - newcurr) < NM_NAMES )
	  newcurr--;
	return( (count > NM_NAMES) ? newcurr : curr );
}


/*
*	Routine to take the filenames that will appear in the window, 
*	based on the current scrolled position, and point at them 
*	with the sub-tree of G_STRINGs that makes up the window box.
*/
MLOCAL	VOID
fs_format(REG TREE tree, WORD currtop, WORD count)
{
	REG WORD	i, cnt;
	REG WORD	y, h, th;
	LONG		adtext;
	WORD		tlen;
						/* build in real text	*/
						/*   strings		*/
	gl_fspos = currtop;			/* save new position	*/
	cnt = min(NM_NAMES, count - currtop);
	for(i=0; i<NM_NAMES; i++)
	{
	  if (i < cnt)
	  {
	    fstrcpy((BYTE FAR*)ad_tmp2,  
		    (BYTE FAR *)ad_fsnames[D.g_fslist[currtop+i]].name);
	    fmt_str(&gl_tmp2[1], &gl_tmp1[1]);
	    gl_tmp1[0] = gl_tmp2[0];
	  }
	  else
	  {
	    gl_tmp1[0] = ' ';
	    gl_tmp1[1] = NULL;
	  }
	  fs_sset(tree, NAME_OFFSET+i, ad_tmp1, &adtext, &tlen);
	  (tree+(NAME_OFFSET+i))->ob_type =
				      (gl_shdrive) ? G_BOXTEXT : G_FBOXTEXT ;
	  (tree+(NAME_OFFSET+i))->ob_state = NORMAL ;
	}
						/* size and position the*/
						/*   elevator		*/
	y = 0;
	th = h = (tree+FSVSLID)->ob_height ;
	if ( count > NM_NAMES)
	{
	  h = (WORD)mul_div(NM_NAMES, h, count);
	  h = max(gl_hbox/2, h);		/* min size elevator	*/
	  y = (WORD)mul_div(currtop, th-h, count-NM_NAMES);
	}
	(tree+FSVELEV)->ob_y = y ;
	(tree+FSVELEV)->ob_height = h ;
}


/*
*	Routine to select or deselect a file name in the scrollable 
*	list.
*/
MLOCAL	VOID
fs_sel(WORD sel, WORD state)
{
	if (sel)
	  ob_change(ad_fstree, F1NAME + sel - 1, state, TRUE);
}


/*
*	Routine to handle scrolling the directory window a certain number
*	of file names.
*/
MLOCAL	WORD
fs_nscroll(REG TREE tree, REG WORD *psel, WORD curr, WORD count, 
		WORD touchob, WORD n)
{
	REG WORD	i, newcurr, diffcurr;
	WORD		sy, dy, neg;
	GRECT		r[2];
						/* single scroll n times*/
	newcurr = curr;
	for (i=0; i<n; i++)
	  newcurr = fs_1scroll(newcurr, count, touchob);
						/* if things changed 	*/
						/*   then redraw	*/
	diffcurr = newcurr - curr;
	if (diffcurr)
	{
	  curr = newcurr;
	  fs_sel(*psel, NORMAL);
	  *psel = 0;
	  fs_format(tree, curr, count);
	  gsx_gclip((GRECT*)&r[1].g_x);
	  ob_actxywh(tree, F1NAME, (GRECT*)&r[0].g_x);

	  if (( neg = (diffcurr < 0)) != 0 )
	    diffcurr = -diffcurr;

	  if (diffcurr < NM_NAMES)
	  {
	    sy = r[0].g_y + (r[0].g_h * diffcurr);
	    dy = r[0].g_y;

	    if (neg)
	    {
	      dy = sy;
	      sy = r[0].g_y;
	    }

	    bb_screen(S_ONLY, r[0].g_x, sy, r[0].g_x, dy, r[0].g_w, 
				r[0].g_h * (NM_NAMES - diffcurr) );
	    if ( !neg )
	      r[0].g_y += r[0].g_h * (NM_NAMES - diffcurr);
	  }
	  else
	    diffcurr = NM_NAMES;

	  r[0].g_h *= diffcurr;
	  for(i=0; i<2; i++)
	  {
	    gsx_sclip((GRECT*)&r[i].g_x);
	    ob_draw(tree, ((i) ? FSVSLID : FILEBOX), MAX_DEPTH);
	  }
	}
	return(curr);
}


/*
*	Routine to call when a new directory has been specified.  This
*	will activate the directory, format it, and display ir[0].
*/
MLOCAL	WORD
fs_newdir(LONG ftitle, LONG fpath, BYTE *pspec, TREE tree, 
		WORD *pcount, WORD pos)
{
	BYTE		*ptmp;
	WORD		len;
					/* BUGFIX 2.1 added len calculation*/
					/*  so FTITLE doesn't run over into*/
					/*  F1NAME.			*/
	ob_draw(tree, FSDIRECT, MAX_DEPTH);
	fs_active(fpath, pspec, pcount);
	if (pos+ NM_NAMES > *pcount)	/* in case file deleted		*/
	  pos = max(0, *pcount - NM_NAMES);
	fs_format(tree, pos, *pcount);
	len = fstrlen((BYTE FAR *)pspec);
	len = (len > LEN_FTITLE) ? LEN_FTITLE : len;
	LBSET(ftitle, ' ');
	ftitle++;
	fmemcpy((BYTE FAR *)ftitle, (BYTE FAR *)pspec, len);
	ftitle += len;
	LBSET(ftitle, ' ');
	ftitle++;
	LBSET(ftitle, NULL);
	ptmp = &gl_fsobj[0];
	while(*ptmp)
	  ob_draw(tree, *ptmp++, MAX_DEPTH);
	return(TRUE);
}



/*
*	File Selector input routine that takes control of the mouse
*	and keyboard, searchs and sort the directory, draws the file 
*	selector, interacts with the user to determine a selection
*	or change of path, and returns to the application with
*	the selected path, filename, and exit button.
*/
	WORD
fs_input(pipath, pisel, pbutton)
	LONG		pipath, pisel;
	WORD		*pbutton;
{
	REG WORD	touchob, value, fnum;
	WORD		curr, count, sel;
	WORD		mx, my;
	REG TREE	tree;
	LONG		ad_fpath, ad_fname, ad_ftitle, ad_locstr;
	WORD		fname_len, fpath_len, temp_len; 
	WORD		dclkret, cont, firsttime, newname, elevpos;
	REG BYTE	*pstr, *pspec;
	GRECT		pt;
	BYTE		locstr[64];

					/* get out quick if path is	*/
					/*   nullptr or if pts to null.	*/
	if (pipath == 0x0L)
	  return(FALSE);
	if ( LBGET(pipath) == NULL)
	  return(FALSE);
						/* get memory for 	*/
						/*   the string buffer	*/

	ad_fsnames = (FSNAME FAR *)dos_alloc( (LONG)(LEN_FSNAME * NM_FILES) );
	if (!ad_fsnames)
	  return(FALSE);

	tree = ad_fstree;
	ad_locstr = ADDR(&locstr[0]);
						/* init strings in form	*/
	ad_ftitle = LLGET( (tree+FTITLE)->ob_spec );
	fstrcpy((BYTE FAR *)ad_ftitle, (BYTE FAR *)" *.* ");
	if (fstrcmp(pipath, LLGET( (tree+FSDIRECT)->ob_spec )))
	  elevpos = 0;
	else					
	  elevpos = gl_fspos;			/* same dir as last time */	
  	fs_sset(tree, FSDIRECT, pipath, &ad_fpath, &temp_len);
	fstrcpy((BYTE FAR *)ad_tmp1, (BYTE FAR *)pisel);
	fmt_str(&gl_tmp1[0], &gl_tmp2[0]);
	fs_sset(tree, FSSELECT, ad_tmp2, &ad_fname, &fname_len);
						/* set clip and start	*/
						/*   form fill-in by	*/
						/*   drawing the form	*/
	gsx_sclip(&gl_rfs);	
	fm_dial(FMD_START, &gl_rfs);
	D.g_dir[0] = NULL;			
	ob_draw(tree, ROOT, 2);
						/* init for while loop	*/
						/*   by forcing initial	*/
						/*   fs_newdir call	*/
	sel = 0;
	newname = gl_shdrive = FALSE;
	cont = firsttime = TRUE;
	while( cont )
	{
	  touchob = (firsttime) ? 0x0 : fm_do(tree, FSSELECT);
	  gsx_mxmy(&mx, &my);
	
	  fpath_len = fstrlen( (BYTE FAR *)ad_fpath );
	  fstrcpy((BYTE FAR *)ad_locstr, (BYTE FAR *)ad_fpath);
	  if ( strcmp(&D.g_dir[0], &locstr[0]) )
	  {
	    fs_sel(sel, NORMAL);
	    if ( (touchob == FSOK) ||
		 (touchob == FSCANCEL) )
	      ob_change(tree, touchob, NORMAL, TRUE);
	    strcpy( D.g_dir, locstr ) ;
	    pspec = fs_pspec(&D.g_dir[0], &D.g_dir[fpath_len]);	    
/*	    fstrcpy(ad_fpath, ADDR(&D.g_dir[0])); */
  	    fs_sset(tree, FSDIRECT, ADDR(&D.g_dir[0]), &ad_fpath, &temp_len);
	    pstr = fs_pspec(&locstr[0], &locstr[fpath_len]);	    
	    strcpy( pstr, "*.*" );
	    fs_newdir(ad_ftitle, ad_locstr, pspec, tree, &count, elevpos);
	    curr = elevpos;
	    sel = touchob = elevpos = 0;
	    firsttime = FALSE;
	  }

	  value = 0;
	  dclkret = ((touchob & 0x8000) != 0);
	  switch( (touchob &= 0x7fff) )
	  {
	    case FSOK:
	    case FSCANCEL:
		cont = FALSE;
		break;
	    case FUPAROW:
	    case FDNAROW:
		value = 1;
		break;
	    case FSVSLID:
		ob_actxywh(tree, FSVELEV, &pt);
		pt.g_x -= 3;
		pt.g_w += 6;
		if ( inside(mx, my, &pt) )
		  goto dofelev;
		touchob = (my <= pt.g_y) ? FUPAROW : FDNAROW;
		value = NM_NAMES;
		break;
	    case FSVELEV:
dofelev:	fm_own(TRUE);
		ob_relxywh(tree, FSVSLID, &pt);
		pt.g_x += 3;		/* APPLE	*/
		pt.g_w -= 6;
		(tree+FSVSLID)->ob_x = pt.g_x ;
		(tree+FSVSLID)->ob_width = pt.g_w ;
		value = gr_slidebox(tree, FSVSLID, FSVELEV, TRUE);
		pt.g_x -= 3;
		pt.g_w += 6;
		(tree+FSVSLID)->ob_x = pt.g_x ;
		(tree+FSVSLID)->ob_width = pt.g_w ;
		fm_own(FALSE);
		value = curr - (WORD)mul_div(value, count-NM_NAMES, 1000);
		if (value >= 0)
		  touchob = FUPAROW;
		else
		{
		  touchob = FDNAROW;
		  value = -value;
		}
		break;
	    case F1NAME:
	    case F2NAME:
	    case F3NAME:
	    case F4NAME:
	    case F5NAME:
	    case F6NAME:
	    case F7NAME:
	    case F8NAME:
	    case F9NAME:
		fnum = touchob - F1NAME + 1;
		if ( fnum <= count )
		{
		  if ( (sel) &&
		       (sel != fnum) )
		    fs_sel(sel, NORMAL);
		  if ( sel != fnum)
		  {
		    sel = fnum;
		    fs_sel(sel, SELECTED);
		  }
						/* get string and see	*/
						/*   if file or folder	*/
		  fs_sget(tree, touchob, ad_tmp1);
		  if (gl_tmp1[0] == ' ')
		  {
						/* copy to selection	*/
		    newname = TRUE;
		    if (dclkret)
		      cont = FALSE;
		  }
		  else
		  {
		    if (gl_shdrive)
		    {
						/* prepend in drive name*/
		      if (locstr[1] == ':')
		        locstr[0] = gl_tmp1[2];
		    }
		    else
		    {
						/* append in folder name*/
		      pstr = fs_pspec(&locstr[0], &locstr[fpath_len]);
		      strcpy( gl_tmp2, pstr - 1 );
		      unfmt_str(&gl_tmp1[1], pstr);
		      strcat( pstr, gl_tmp2 );
		    }
		    firsttime = TRUE;
		  }
		  gl_shdrive = FALSE;
		}
		break;
	    case FCLSBOX:
		pspec = pstr = fs_back(&locstr[0], &locstr[fpath_len]);
		if (*pstr-- == '\\')
		{
		  firsttime = TRUE;
		  if (*pstr != ':')
		  {
		    pstr = fs_back(&locstr[0], pstr);
		    if (*pstr == '\\')
		      strcpy( pstr, pspec );
		  }
		  else
		  {
		    if (gl_bvdisk)
		      gl_shdrive = TRUE;
		  }
		}
		break;
	    case FTITLE:
		firsttime = TRUE;
		break;
	  }
	  if (firsttime)
	  {
	   /* fstrcpy(ad_fpath, ad_locstr); */
  	    fs_sset(tree, FSDIRECT, ad_locstr, &ad_fpath, &temp_len);
	    D.g_dir[0] = NULL;
	    gl_tmp1[1] = NULL;
	    newname = TRUE;
	  }
	  if (newname)
	  {
	    fstrcpy((BYTE FAR *)ad_fname, (BYTE FAR *)(ad_tmp1 + 1));
	    ob_draw(tree, FSSELECT, MAX_DEPTH);
	    if (!cont)
	      ob_change(tree, FSOK, SELECTED, TRUE);
	    newname = FALSE;
	  }
	  if (value)
	    curr = fs_nscroll(tree, &sel, curr, count, touchob, value);
	}
						/* return path and	*/
						/*   file name to app	*/
	fstrcpy((BYTE FAR *)pipath, (BYTE FAR *)ad_fpath);
	fstrcpy((BYTE FAR *)ad_tmp1, (BYTE FAR *)ad_fname);
	unfmt_str(&gl_tmp1[0], &gl_tmp2[0]);
	fstrcpy((BYTE FAR *)pisel, (BYTE FAR *)ad_tmp2);
						/* start the redraw	*/
	fm_dial(FMD_FINISH, &gl_rfs);
						/* return exit button	*/
	*pbutton = inf_what(tree, FSOK);

	dos_free((LONG)ad_fsnames);

	return( TRUE );
}

#endif /* GEM */

/* gemfslib.c */

