/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License                  *
*   For further information, please see LICENSE.TXT                         *
*                                                                           *
*   Historical Copyright                                                    *
*                                                                           *
*   Copyright (c) 1985, 1987, 1990, 1991, 1992  Digital Research Inc.	    *
*   All rights reserved.						    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/gemfmalt.c 4.3 92/03/12 11:25:07 sbc Exp $
* $Log:	gemfmalt.c $
 * Revision 4.3  92/03/12  11:25:07  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 

 * 911014 K.H	Add supporting double byte character set. (#if DBCS)	
     
 * Revision 4.2  92/02/27  15:22:45  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.4  92/02/03  11:23:20  Fontes
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.3  92/01/27  16:30:22  Fontes
 * Improper type in call to rs_obfix, fixed
 * 
 * Revision 4.2  92/01/27  16:13:03  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.1  92/01/03  13:16:05  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:53:35  system
 * Prototyping and cleanup plus fix to file selector code
 * 
*****************************************************************************/

#include "portab.h"
#include "machine.h"
#include "struct.h"
#include "basepage.h"
#include "obdefs.h"
#include "gemlib.h"
#include "viewrun.h"
#include "viewapps.h"
#include "cproto.h"
#include "aproto.h"

#define MSG_OFF 2
#define BUT_OFF 7
#define NUM_ALOBJS 10
#define NUM_ALSTRS 8 
#define MAX_MSGLEN 40
#define INTER_WSPACE 1
#define INTER_HSPACE 0


EXTERN LONG	ad_sysglo;
EXTERN LONG	ad_armice;

GLOBAL BYTE	gl_nils[6] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
GLOBAL LONG	ad_nils;

/*
*	Routine to break a string into smaller strings.  Breaks occur
*	whenever an | or a ] is encountered.
*/
MLOCAL	VOID
fm_strbrk(
	TREE		tree,
	LONG		palstr,
	WORD		stroff,
	WORD		*pcurr_id,
	WORD		*pnitem,
	WORD		*pmaxlen)
{
	REG WORD	nitem, curr_id;
	REG WORD	len, maxlen;
	REG BYTE	tmp;
	BYTE FAR	*pstr;
	REG BYTE	nxttmp;
#if DBCS
	REG WORD	type = CT_ADE;
#endif

	nitem = maxlen = 0; 
	curr_id = *pcurr_id;
	tmp = NULL;
	while( tmp != ']')
	{
	  pstr = (BYTE FAR *)((tree+(stroff + nitem))->ob_spec);
	  len = 0;
						/* get 1st char of new	*/
						/*   string		*/
	  do
	  {
	    tmp = LBGET(palstr + curr_id);
	    curr_id++;
	    nxttmp = LBGET(palstr + curr_id);
#if DBCS
	    if ( (type = chkctype(tmp, type)) == CT_ADE )
#endif
	    if ( (tmp == ']') ||
		 (tmp == '|') )
	    {
	      if (tmp == nxttmp)
		curr_id++;
	      else
	      {
		nxttmp = tmp;
	        tmp = NULL;
	      }
	    }
	    *(pstr + len++) = tmp;
	  } while ( tmp != NULL );
	  tmp = nxttmp;
	  maxlen = max(len - 1, maxlen);
	  nitem++;
	}
	*pcurr_id = curr_id;
	*pnitem = nitem;
	*pmaxlen = maxlen;
}


/*
*	Routine to parse a string into an icon #, multiple message
*	strings, and multiple button strings.  For example,
*
*		[0][This is some text|for the screen.][Ok|Cancel]
*		0123456
*
*	becomes:
*		icon# = 0;
*		1st msg line = This is some text
*		2nd msg line = for the screen.
*		1st button = Ok
*		2nd button = Cancel
*/

MLOCAL	VOID
fm_parse(
	REG TREE	tree,
	LONG		palstr,
	WORD		*picnum,
	WORD		*pnummsg, 
	WORD		*plenmsg,
	WORD		*pnumbut, 
	WORD		*plenbut)
{
	WORD		curr_id;

	*picnum = LBGET(palstr + 1) - '0';
	curr_id = 4;
	fm_strbrk(tree, palstr, MSG_OFF, &curr_id, pnummsg, plenmsg);
	curr_id++;
	fm_strbrk(tree, palstr, BUT_OFF, &curr_id, pnumbut, plenbut);
	*plenbut += 1;
}

MLOCAL	VOID
fm_build(
	REG TREE	tree,
	WORD		haveicon,
	WORD		nummsg, 
	WORD		mlenmsg,
	WORD		numbut, 
	WORD		mlenbut)
{
	REG WORD	i, k;
	GRECT		al, ic, bt, ms;

	r_set(&al, 0, 0, 1+INTER_WSPACE, 1+INTER_HSPACE);
	r_set(&ms, 1 + INTER_WSPACE, 1 + INTER_HSPACE, mlenmsg, 1);

	if (haveicon)
	{
	  r_set(&ic, 1+INTER_WSPACE, 1+INTER_HSPACE, 4, 4);
	  al.g_w += ic.g_w + INTER_WSPACE;
	  al.g_h += ic.g_h + INTER_HSPACE + 1;
	  ms.g_x = ic.g_x + ic.g_w + INTER_WSPACE + 1;
	}

	al.g_w += ms.g_w + INTER_WSPACE + 1;
	r_set(&bt, al.g_w, 1 + INTER_HSPACE, mlenbut, 1);

	al.g_w += bt.g_w + INTER_WSPACE + 1;
	al.g_h = max(al.g_h, 2 + (2 * INTER_HSPACE) + nummsg );
	al.g_h = max(al.g_h, 2 + INTER_HSPACE + (numbut * 2) - 1);
	al.g_h |= 0xfd00;
						/* init. root object	*/
	ob_setxywh(tree, ROOT, &al);
	ad_nils = ADDR(&gl_nils[0]);
	for(i=0; i<NUM_ALOBJS; i++) {
	  fmemcpy((BYTE FAR *)&(tree+i)->ob_next, 
			  (BYTE FAR *)ad_nils, 6);
      }
						/* add icon object	*/
	if (haveicon)
	{
	  ob_setxywh(tree, 1, &ic);
	  ob_add(tree, ROOT, 1);
	}
						/* add msg objects	*/
	for(i=0; i<nummsg; i++)
	{
	  ob_setxywh(tree, MSG_OFF+i, &ms);
	  ms.g_y++;
	  ob_add(tree, ROOT, MSG_OFF+i);
	}
						/* add button objects	*/
	for(i=0; i<numbut; i++)
	{
	  k = BUT_OFF+i;
	  (tree+k)->ob_flags = SELECTABLE | EXIT ;
	  (tree+k)->ob_state = NORMAL ;
	  ob_setxywh(tree, k, &bt);
	  bt.g_y++;
	  bt.g_y++;
	  ob_add(tree, ROOT, k);
	}
						/* set last object flag	*/
	(tree+(BUT_OFF+numbut-1))->ob_flags = SELECTABLE | EXIT | LASTOB ;
}

	WORD
fm_alert(defbut, palstr)
	WORD		defbut;
	LONG		palstr;
{
	REG WORD	i;
	WORD		inm, nummsg, mlenmsg, numbut, mlenbut;
	TREE		tree;
	LONG		plong;	
	GRECT		d, t;
	WORD		button_id ;

						/* init tree pointer	*/
	rs_gaddr(ad_sysglo, R_TREE, 1, (LONG*)&tree);
	gsx_mfset(ad_armice);

	fm_parse(tree, palstr, &inm, &nummsg, &mlenmsg, &numbut, &mlenbut);
	fm_build(tree, (inm != 0), nummsg, mlenmsg, numbut, mlenbut);

	if (defbut)
	{
	    button_id = BUT_OFF + (defbut&0xFF) - 1 ;
	    (tree+button_id)->ob_flags |= DEFAULT ;
	    if( defbut>>8 ){
		button_id = BUT_OFF + (defbut>>8) - 1 ;
		(tree+button_id)->ob_flags |= ESCCANCEL ;
	    } 
	}

	if (inm != 0)
	{
	  rs_gaddr(ad_sysglo, R_BITBLK, inm-1, &plong);
	  *((LONG FAR *)&(tree+1)->ob_spec) = plong ;
	}
						/* convert to pixels	*/
	for(i=0; i<NUM_ALOBJS; i++)
	  rs_obfix((LONG)tree, i);
						/* fix up icon, 32x32	*/
	(tree+1)->ob_type = G_IMAGE ;
	LLSET( (LONG)(WORD far *)&(tree+1)->ob_width, 0x00200020L);	
						/* center tree on screen*/
	ob_center(tree, &d);
						/* save screen under-	*/
						/*   neath the alert	*/
	wm_update(TRUE);
	gsx_gclip(&t);
	bb_save(&d);
						/* draw the alert	*/
	gsx_sclip(&d);
	ob_draw(tree, ROOT, MAX_DEPTH);
						/* let user pick button	*/
	i = fm_do(tree, 0);
						/* restore saved screen	*/
	gsx_sclip(&d);
	bb_restore(&d);
	gsx_sclip(&t);
	wm_update(FALSE);
						/* return selection	*/
	return( i - BUT_OFF + 1 );
}

