/****************************************************************************
*   Copyright 1999, Caldera Thin Client Systems, Inc.                       *
*   This software is licensed under the GNU Public License.                 *
*   For further information, see LICENSE.TXT                                *
*                                                                           *
*   Historical Copyright:                                                   *
*                                                                           *
*   Copyright (c) 1991,1992  Digital Research Inc.  All rights reserved.    *
*   The Software Code contained in this listing is proprietary to Digital   *
*   Research Inc., Monterey, California, and is covered by U.S. and other   *
*   copyright protection.  Unauthorized copying, adaption, distribution,    *
*   use or display is prohibited and may be subject to civil and criminal   *
*   penalties.  Disclosure to others is prohibited.  For the terms and      *
*   conditions of software code use, refer to the appropriate Digital       *
*   Research License Agreement.						    *
*****************************************************************************
*		      U.S. GOVERNMENT RESTRICTED RIGHTS			    *
*                    ---------------------------------                      *
*  This software product is provided with RESTRICTED RIGHTS.  Use, 	    *
*  duplication or disclosure by the Government is subject to restrictions   *
*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
*  the applicable provisions of the DOD FAR supplement 252.227-7013 	    *
*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
*  BOX DRI / Monterey, CA 93940.					    *
*****************************************************************************
* $Header: m:/davinci/users//groups/panther/aes/rcs/cproto.h 4.3 92/03/12 11:24:24 sbc Exp $
* $Log:	cproto.h $
 * Revision 4.3  92/03/12  11:24:24  sbc
 * Merge in Keiko Hatamori's changes required for Double-Byte Character Support
 * 
 * Revision 4.2  92/02/27  15:21:27  rsf
 * Conversion to medium model. Replace GEM.H with VIEWRUN.H
 * 
 * Revision 4.4  92/02/11  11:32:15  Fontes
 * Background image display implementation
 * 
 * Revision 4.3  92/01/27  16:08:46  Fontes
 * LONG -> TREE for trees, plus some cleanup and commenting
 * 
 * Revision 4.2  92/01/03  13:19:53  Fontes
 * Susan's cleanup
 * 
 * Revision 4.0  91/09/05  11:57:11  system
 * Prototyping and cleanup plus fix to file selector code
 * 
*/

/****************************************************************************
* File:		cproto.h
*
* Description:	Function prototypes for C routines in ViewMAX III AES.
*
*****************************************************************************/

/* Include crucial data structure definitions */
#ifndef OBDEFS_H
#include "obdefs.h"
#endif

#ifndef GSXDEFS_H
#include "gsxdefs.h"
#endif

#ifndef STRUCT_H
#include "struct.h"
#endif

#ifndef GEMLIB_H
#include "gemlib.h"
#endif

						/* in GSXBIND.C		*/
#define vsl_type( x )		gsx_1code(S_LINE_TYPE, x)
#define vsf_color( x )		gsx_1code(S_FILL_COLOR, x)
#define vsl_udsty( x )		gsx_1code(ST_UD_LINE_STYLE, x)

/* gemaplib.c */

extern	WORD ap_init( void );
extern	void ap_rdwr(WORD code, PD *p, WORD length, LONG pbuff);
extern	WORD ap_find(LONG pname);
extern	void ap_exit(void);

/* gemevlib.c */

extern	WORD ev_block(WORD code, LONG lvalue);
extern	UWORD ev_button(
		WORD bflgclks, UWORD bmask, UWORD bstate, UWORD* rets);
extern	UWORD ev_mouse(MOBLK *pmo, UWORD *rets);
extern	void ev_timer(LONG count);
extern	WORD ev_multi(WORD flags, MOBLK	*pmo1, MOBLK *pmo2, LONG tmcount,
		LONG buparm, LONG mebuff, UWORD *prets);
extern	WORD ev_dclick(WORD rate, WORD setit);

/* gemgraf.c  */

extern	void gsx_setclr(WORD clr, WORD fgclr, WORD bkclr, 
		WORD style, WORD pattern );
extern	void gsx_sclip(GRECT *pt);
extern	void gsx_gclip(GRECT *pt);
extern	WORD gsx_chkclip(GRECT *pt);
extern	void gsx_cline(UWORD x1, UWORD y1, UWORD x2, UWORD y2);
extern	void gsx_attr(UWORD text, UWORD mode, UWORD color);
extern	void gsx_xbox(GRECT *pt);
extern	void gsx_xcbox(GRECT *pt);
extern	void gsx_fix(FDB *pfd, LONG theaddr, WORD wb, WORD h);
extern	void gsx_blt(LONG saddr, UWORD sx, UWORD sy, UWORD swb, LONG daddr, 
		UWORD dx, UWORD dy, UWORD dwb, UWORD w, UWORD h, UWORD rule,
		WORD fgcolor, WORD bgcolor);
extern	void bb_screen(WORD scrule, WORD scsx, WORD scsy, WORD scdx, 
		WORD scdy, WORD scw, WORD sch);
extern	void gsx_trans( LONG saddr, UWORD swb, LONG daddr, UWORD dwb,
		UWORD h);
extern	void gsx_start( void );
extern	void bb_fill(WORD mode, WORD fis, WORD patt, WORD hx, WORD hy, 
		WORD hw, WORD hh);
extern	void gsx_tblt(WORD tb_f, WORD x, WORD y, WORD tb_nc);
extern	void grcc_rect(WORD clr, GRECT *pt );
extern	void gr_inside(GRECT *pt, WORD th);
extern	void gr_rect( UWORD icolor, UWORD ipattern, GRECT *pt);
extern  WORD gr_just( WORD just, WORD font, LONG ptext, WORD w, WORD h,
		GRECT *pt);
extern  void gr_gtext( WORD just, WORD font, LONG ptext, GRECT *pt);
extern  void gr_crack( UWORD color, WORD *pbc, WORD *ptc, WORD *pip, 
		WORD *pic, WORD *pmd);
extern  void gr_gicon( WORD state, LONG pmask, LONG pdata, LONG ptext,
		WORD ch, WORD chx, WORD chy, GRECT *pi, GRECT *pt);
extern  void gr_clricon( WORD state, LONG pmask, LONG pdata, LONG ptext,
		WORD ch, WORD chx, WORD chy, GRECT *pi, GRECT *pt);
extern	void gr_dtmfdb( FDB far *spec, GRECT *t);
extern	void gr_box(WORD x, WORD y, WORD w, WORD h, WORD th);
extern	void gr_3dbox( GRECT *tt, WORD th );
extern	void gr_3dpress( GRECT *tt, WORD th );
extern	void inner_dots( GRECT * pt, WORD clrlite, WORD clrdark );


/* gemobed.c  */

extern	void ob_center(TREE tree, GRECT *pt);
extern	WORD ob_edit(
		TREE	tree,
		WORD	obj,
		WORD	in_char,
		WORD	*idx,
		WORD	kind);
	
/* gemsclib.c */
#if GEM
extern	WORD sc_read(LONG pscrap);
extern	WORD sc_write(LONG pscrap);
extern	WORD sc_clear( void );
#endif /* GEM */

/* gemasync.c */

extern	void azombie(EVB *e, UWORD ret);
extern	void evinsert(EVB *e, EVB **root);
extern	EVSPEC mwait(EVSPEC mask);
extern	EVSPEC iasync(WORD afunc, LONG aparm);
extern	UWORD apret(EVSPEC mask);
extern	EVSPEC acancel(EVSPEC m);

/* gemflag.c  */

extern	void tchange(LONG c);
extern	WORD tak_flag(SPB *sy);
extern	void amutex(EVB *e, LONG ls);
extern	void unsync(SPB *sy);

/* gemgrlib.c */

extern	void gr_stepcalc(WORD orgw, WORD org, GRECT *pt, WORD *pcx, WORD *pcy,
		WORD *pcnt, WORD *pxstep, WORD *pystep);
extern	void gr_rubwind(WORD xorigin, WORD yorigin, WORD wmin, WORD hmin,
		GRECT *poff, WORD *pwend, WORD *phend);
extern	void gr_rubbox(WORD xorigin, WORD yorigin, WORD wmin, WORD hmin, 
		WORD *pwend, WORD *phend);
extern	void gr_dragbox(WORD w, WORD h, WORD sx, WORD sy, GRECT *pc,
		WORD *pdx, WORD *pdy);
extern	void gr_2box(WORD flag1, WORD cnt, GRECT *pt, WORD xstep, 
		WORD ystep, WORD flag2);
extern	void gr_movebox(WORD w, WORD h, WORD srcx, WORD srcy, 
		WORD dstx, WORD dsty);
extern	void gr_growbox(GRECT *po, GRECT *pt);
extern	void gr_shrinkbox(GRECT *po, GRECT *pt);
extern	WORD gr_watchbox(TREE tree, WORD obj, WORD instate, WORD outstate);
extern	WORD gr_slidebox(TREE tree, WORD parent, WORD obj, WORD isvert);
extern	void gr_mkstate(WORD *pmx, WORD *pmy, WORD *pmstat, WORD *pkstat);
extern	WORD gr_setbkgd(BYTE FAR *image_name, WORD mode);

/* gemobjop.c */

extern	LONG obaddr(TREE tree, WORD obj, WORD fld_off);
extern	BYTE ob_sst(TREE tree, WORD obj, LONG *pspec, WORD *pstate, 
		WORD *ptype, WORD *pflags, GRECT *pt, WORD *pth);
extern	void everyobj(TREE tree, WORD this, WORD last, void (*routine)(), 
		WORD startx, WORD starty, WORD maxdep);
extern	WORD get_par(TREE tree, WORD obj, WORD *pnobj);

/* gemshlib.c */

extern	void sh_read(BYTE FAR *pcmd, BYTE FAR *ptail);
extern	WORD sh_write(WORD doex, WORD isgem, WORD isover, 
		BYTE FAR *pcmd, BYTE FAR *ptail);
extern	void sh_get(BYTE FAR *pbuffer, WORD len);
extern	void sh_put(BYTE FAR *pdata, WORD len);
extern	void sh_tographic(void);
extern	BYTE *sh_name(BYTE *ppath);
extern	void sh_envrn(LONG FAR *ppath, BYTE FAR *psrch);
extern	void sh_curdir(BYTE FAR *ppath);
extern	WORD sh_find(BYTE FAR *pspec);
extern  void sh_rdef(BYTE FAR *lpcmd, BYTE FAR *lpdir);
extern	void sh_wdef(BYTE FAR *lpcmd, BYTE FAR *lpdir);
extern	void sh_main( void );
extern	void sh_signoff(void);

/* gemfmalt.c */

extern	WORD fm_alert(WORD defbut, LONG palstr);

/* gemgsxif.c */

extern	ULONG gsx_mcalc( void );
extern	void  gsx_malloc( void );
extern	void  gsx_mret(LONG *pmaddr, LONG *pmlen);
extern	void  gsx_ncode(WORD code, WORD n, WORD m);
extern	void  gsx_1code(WORD code, WORD value);
extern	void  gsx_init( void );
extern	void  gsx_exec(LONG pcspec, WORD segenv, LONG pcmdln,
		LONG pfcb1, LONG pfcb2);
extern	void  gsx_graphic(WORD tographic);
extern	void  ratinit( void );
extern	void  bb_save(GRECT *ps);
extern	void  bb_restore(GRECT *pr);
extern	WORD  gsx_tick(LONG tcode, LONG *ptsave);
extern	void  gsx_mfset(LONG pmfnew);
extern	void  gsx_mxmy(WORD *pmx, WORD *pmy);
extern	WORD  gsx_kstate( void );
extern	void  gsx_moff( void );
extern	void  gsx_mon( void );
extern	WORD  gsx_char( void );
extern	void  v_pline( WORD count, WORD *pxyarray );
extern	void  vst_clip( WORD clip_flag, WORD *pxyarray );
extern	void  vst_height( WORD height, WORD *pchr_width, WORD *pchr_height, 
		WORD *pcell_width, WORD *pcell_height );
extern	void  vr_recfl( WORD *pxyarray, WORD *pdesMFDB );
extern	void  vro_cpyfm( WORD wr_mode, WORD *pxyarray, 
		FDB *psrcMFDB, FDB *pdesMFDB );
extern	void  vrt_cpyfm(WORD wr_mode, WORD *pxyarray, WORD *psrcMFDB, 
		WORD *pdesMFDB, WORD fgcolor, WORD bgcolor );
extern	void  vrn_trnfm( WORD *psrcMFDB, WORD *pdesMFDB );
extern	void  vsl_width( WORD width );
extern	void  vq_color( WORD index, WORD set_flag, WORD *rgb);
extern	void  vs_color( WORD *rgb );
extern	WORD  v_sound( BOOLEAN isfreq, WORD freq, WORD dura);

/* gemoblib.c */

extern	void ob_format(WORD just, BYTE *raw_str, BYTE *tmpl_str, 
		BYTE *fmt_str);
extern	void ob_highlight( TREE tree, WORD obj );
extern	void just_draw(TREE tree, WORD obj, WORD sx, WORD sy);
extern	void ob_draw(TREE tree, WORD obj, WORD depth);
extern	WORD ob_find(TREE tree, WORD currobj, WORD depth, WORD mx, WORD my);
extern	void ob_add(TREE tree, WORD parent, WORD child);
extern	void ob_delete(TREE tree, WORD obj);
extern	void ob_order(TREE tree, WORD mov_obj, WORD new_pos);
extern	void ob_change(TREE tree, WORD obj, UWORD new_state, WORD redraw);
extern	UWORD ob_fs(TREE tree, WORD ob, WORD *pflag);
extern	void  ob_actxywh(TREE tree, WORD obj, GRECT *pt);
extern	void  ob_relxywh(TREE tree, WORD obj, GRECT *pt);
extern	void  ob_setxywh(TREE tree, WORD obj, GRECT *pt);
extern	void  ob_offset(TREE tree, WORD obj, WORD *pxoff, WORD *pyoff);

/* gemsuper.c */

extern	UWORD crysbind(WORD opcode, LONG pglobal, UWORD *int_in, 
		UWORD *int_out, LONG *addr_in);
extern	void super(LONG pcrys_blk);
extern	void nsuper(LONG pcrys_blk);

/* gemctrl.c  */

extern	void ct_msgup(WORD message, PD *owner, WORD wh, 
		WORD m1, WORD m2, WORD m3, WORD m4);
#if FIXLATER
extern	void ct_chgown(PD *mpd, PD *cpd, GRECT *pr);
#else
extern	void ct_chgown(PD *mpd, GRECT *pr);
#endif
extern	void ct_mouse(WORD grabit);
extern	void ctlmgr( void );

/* gemfmlib.c */

extern	void fm_own(WORD beg_ownit);
extern	WORD fm_keybd(TREE tree, WORD obj, WORD *pchar, WORD *pnew_obj);
extern	WORD fm_button(TREE tree, WORD new_obj, WORD clks, WORD *pnew_obj);
extern	WORD fm_do(TREE tree, WORD start_fld);
extern	WORD fm_dial(WORD fmd_type, GRECT *pt);
extern	WORD fm_show(WORD string, UWORD *pwd, WORD level);
extern	WORD eralert(WORD n, WORD d);
extern	WORD fm_error(WORD n);

/* geminit.c  */

extern	WORD sizeglo( void );
extern	WORD sizeuda( void );
extern	void gem_main( void );
extern	void all_run( void );
extern	void sh_desk(WORD obj, LONG plong);
extern	void sh_rdinf( void );

/* gempd.c    */

extern	PD  *pd_index(WORD i);
extern	PD  *fpdnm(BYTE *pname, UWORD pid);
extern	void p_nameit(PD *p, BYTE *pname);
extern	PD  *pstart(void (*pcode)(), BYTE *pfilespec, LONG ldaddr);
extern	void insert_process(PD *pi, PD **root);

/* gemwmlib.c */

extern	void w_nilit(WORD num, OBJECT *olist);
extern	void w_getsize(WORD which, WORD w_handle, GRECT *pt);
extern	void w_setactive( void );
extern	void w_drawdesk(GRECT *pc);
extern	void w_bldactive(WORD w_handle);
extern	void ap_sendmsg(WORD *ap_msg, WORD type, PD* towhom, 
		WORD w3, WORD w4, WORD w5, WORD w6, WORD w7);
extern	void w_update( WORD bottom, GRECT *pt, WORD top, WORD moved,
		WORD usetrue);
extern	void wm_start( void );
extern	WORD wm_create(WORD kind, GRECT *pt);
extern	void wm_open(WORD w_handle, GRECT *pt);
extern	void wm_close(WORD w_handle);
extern	void wm_delete(WORD w_handle);
extern	void wm_get(WORD w_handle, WORD w_field, WORD *poutwds);
extern	void wm_set(WORD w_handle, WORD w_field, WORD *pinwds);
extern	WORD wm_find(WORD x, WORD y);
extern	void wm_update(WORD beg_update);
extern	void wm_calc(WORD wtype, UWORD kind, WORD x, WORD y, WORD w, WORD h, 
		WORD *px, WORD *py, WORD *pw, WORD *ph);
extern	void change_desktop(FDB FAR *bmp);

/* gemdisp.c  */
	
extern	void forkq( void (*fcode)(), WORD lodata, WORD hidata);
extern	void forker( void );
extern	void chkkbd( void );
extern	void dispx( void );	
	
/* gemfslib.c */
#if GEM
extern	WORD fs_input(LONG pipath, LONG pisel, WORD *pbutton);
#endif /* GEM */

/* geminput.c */

extern	UWORD in_mrect(MOBLK *pmo);
extern	void  b_click(WORD state);
extern	void  b_delay(WORD amnt);
extern	void  set_ctrl(GRECT *pt);
extern	void  get_ctrl(GRECT *pt);
extern	void  get_mown(PD **pmown);
extern	void  set_mown(PD *mp);
extern	UWORD dq(CQUEUE *qptr);
extern	void  fq(void);
extern	void  evremove(EVB *e, UWORD ret);
extern	void  kchange(UWORD ch, WORD kstat);
extern	void  post_keybd(CDA *c, UWORD ch);
extern	void  bchange(WORD new, WORD clicks);
extern	WORD  downorup(WORD new, LONG buparm);
extern	void  m_forkq(void (*fcode)(), WORD ratx, WORD raty);
extern	void  mchange(WORD rx, WORD ry);
extern	void  akbin(EVB *e);
extern	void  adelay(EVB *e, LONG c);
extern	void  abutton(EVB *e, LONG p);
extern	void  amouse(EVB *e, LONG pmo);

/* gemqueue.c */

extern	void aqueue(WORD isqwrite, EVB *e, LONG lm);

/* gemwrect.c */

extern	void   or_start( void );
extern	ORECT *get_orect( void );
extern	void   newrect(TREE tree, WORD wh);

/* gemdos.c   */

extern	void  dos_chdir(LONG pdrvpath);
extern	WORD  dos_gdir(WORD drive, LONG pdrvpath);
extern	WORD  dos_gdrv( void );
extern	WORD  dos_sdrv(WORD newdrv);
extern	void  dos_term( void );
extern	void  dos_sdta(LONG ldta);
extern	WORD  dos_gpsp( void );
extern	WORD  dos_sfirst(LONG pspec, WORD attr);
extern	WORD  dos_snext( void );
extern	WORD  dos_open(BYTE FAR *pname, WORD access);
extern	WORD  dos_close(WORD handle);
extern	WORD  dos_delete(LONG ppath);
extern	WORD  dos_read(WORD handle, WORD cnt, LONG pbuffer);
extern	LONG  dos_lseek(WORD handle, WORD smode, LONG sofst);
extern	void  dos_exec(LONG pcspec, WORD segenv, LONG pcmdln, 
		LONG pfcb1, LONG pfcb2);
extern	LONG  dos_alloc(LONG nbytes);
extern	LONG  dos_avail( void );
extern	WORD  dos_free(LONG maddr);
extern	WORD  dos_write(WORD handle, WORD cnt, LONG pbuffer);

/* gemglobe.c */

/* gemmnlib.c */

extern	void  mn_init(void);
extern	void  menu_keys(TREE tree,WORD parent);
extern	UWORD do_chg(TREE tree, WORD iitem, UWORD chgvalue, WORD dochg, 
		WORD dodraw, WORD chkdisabled);
extern	WORD  find_shortcut( WORD key );
extern	WORD  mn_do(WORD *ptitle, WORD *pitem, WORD key);
extern	void  mn_bar(TREE tree, WORD showit, WORD pid);
extern	void  mn_clsda( void );
extern	WORD  mn_register(WORD pid, LONG pstr);
extern	void  mn_unregister(WORD da_id);

/* gemrslib.c */

extern	void  rs_obfix(LONG tree, WORD curob);
extern	BYTE *rs_str(UWORD stnum);
extern	WORD  rs_free(LONG pglobal);
extern	WORD  rs_gaddr(LONG pglobal, UWORD rtype, UWORD rindex, LONG *rsaddr);
extern	WORD  rs_saddr(LONG pglobal, UWORD rtype, UWORD rindex, LONG rsaddr);
extern	WORD  rs_readit(LONG pglobal, BYTE FAR *rsfname);
extern	void  rs_fixit(LONG pglobal);
extern	WORD  rs_load(LONG pglobal, BYTE FAR *rsfname);

/* optimize.c */

extern	void  r_get( GRECT * pRect, WORD * x, WORD * y, WORD * w, WORD * h );
extern	void  r_set( GRECT * pRect, WORD x, WORD y, WORD w, WORD h );
extern	BOOLEAN inside( WORD x, WORD y, GRECT * pRect );
extern	void  rc_constrain(GRECT *pc, GRECT *pt);
extern	void  rc_union(GRECT *p1, GRECT *p2);
extern	WORD  rc_intersect(GRECT *p1, GRECT *p2);
extern	BYTE  *strscn( BYTE * ps, BYTE * pd, BYTE stop);
#if GEM
extern	void  fmt_str(BYTE *instr, BYTE *outstr);
extern	void  unfmt_str(BYTE *instr, BYTE *outstr);
extern	void  fs_sset(TREE tree, WORD obj, LONG pstr, 
		LONG *ptext, WORD *ptxtlen);
extern	void  fs_sget(TREE tree, WORD obj, LONG pstr);
extern	WORD  inf_what(TREE tree, WORD ok);
extern	WORD  wildcmp(BYTE *pwld, BYTE *ptst);
#endif /* GEM */
extern	void  merge_str(BYTE *pdst, BYTE *ptmp, UWORD *parms);
#if !(DBCS)
extern	void  ins_char(BYTE *str, WORD pos, BYTE chr, WORD tot_len);
#endif /* !(DBCS) */
extern	BYTE *op_gname(WORD index);

/* gemcicon.c */
extern	FDB FAR *load_bmp_file(char far *fname);
extern	ICONBLK FAR *load_ico_file(char *fname);
extern	void	render_bmp(FDB FAR *fdb, WORD x, WORD y);
extern	void	render_ico(FDB FAR *mask, FDB FAR *data, WORD x, WORD y);

/* end of cproto.h */
