#*****************************************************************************
#*   Copyright (c) 1985,1992  Digital Research Inc.  All rights reserved.    *
#*   The Software Code contained in this listing is proprietary to Digital   *
#*   Research Inc., Monterey, California, and is covered by U.S. and other   *
#*   copyright protection.  Unauthorized copying, adaption, distribution,    *
#*   use or display is prohibited and may be subject to civil and criminal   *
#*   penalties.  Disclosure to others is prohibited.  For the terms and      *
#*   conditions of software code use, refer to the appropriate Digital       *
#*   Research License Agreement.					     *
#*****************************************************************************
#*		      U.S. GOVERNMENT RESTRICTED RIGHTS			     *
#*                    ---------------------------------                      *
#*  This software product is provided with RESTRICTED RIGHTS.  Use, 	     *
#*  duplication or disclosure by the Government is subject to restrictions   *
#*  as set forth in FAR 52.227-19 (c) (2) (June, 1987) when applicable or    *
#*  the applicable provisions of the DOD FAR supplement 252.227-7013 	     *
#*  subdivision (b)(3)(ii) (May 1981) or subdivision (c)(1)(ii) (May 1987).  *
#*  Contractor/manufacturer is Digital Research Inc. / 70 Garden Court /     *
#*  BOX DRI / Monterey, CA 93940.					     *
#*****************************************************************************
# $Header: g:/groups/panther/aes/rcs/aes.mak 4.7 92/04/08 14:26:27 sbc Exp $
# $Log:	aes.mak $
# Revision 4.7  92/04/08  14:26:27  sbc
# change to Borland C++
# 
# 
#*****************************************************************************

#*****************************************************************************
#* File:	aes_bp.mak
#*
#* Description:	Makefile for ViewMAX II AES component.
#*
#* Build Info:	ndmake -f aes.mak
#*
#* Toolset:	Turbo C++ v2.0; RASM86 v1.4; TLINK v4.0
#*
#* Notes:
#*	
#   >>  All .obj files are kept in an \obj subdirectory of the working
#	directory.
#
#*****************************************************************************

#-----------------------------------------------------------------------------
#	Allow TLINK to use OBJS macro
#	without overflowing line length
#-----------------------------------------------------------------------------
.RESPONSE_LINK:	TLINK

#-----------------------------------------------------------------------------
#	Suffixes for compiling rules:
#	OTC = Object Turbo C
#	OTM = Object Turbo Mixed C and Assembler
#	OTA = Object Turbo Assembler
#	ORA = Object Rasm Assembler
#-----------------------------------------------------------------------------
.SUFFIXES .otc .otm .c .ota .asm .ora .a86

#-----------------------------------------------------------------------------
#	How to Build
#-----------------------------------------------------------------------------
#  -c	= compile only, don't link
#  -o	= put object files in \obj
#  -r	= register variables ON		(.a86 modules MUST preserve SI & DI!)
#  -Z	= register optimization ON
#  -v 	= source debugging ON
#  -O	= jump optimization ON
#  -i8  = make significant id length 8
#  -u-  = generate leading underbars OFF
#  -zCCODE = Code segment name
#  -zDDATA = BSS segment name
#  -zRDATA = Data segment name
#  -zBDATA = BSS class name
#-----------------------------------------------------------------------------
MODEL=m
AFLAGS=$$pz sz

#
#	(-v and /v give you symbols - swap the definitions
#		to get symbols or not)
#
MORE_CFLAGS=-v
MORE_CFLAGS=
CFLAGS=-m$(MODEL) -I$(TCPINC) -zCCODE -zDDATA -zRDATA -zBDATA $(MORE_CFLAGS)

MORE_LFLAGS=/v
MORE_LFLAGS=
LFLAGS=/m/n$(MORE_LFLAGS)

#-----------------------------------------------------------------------------
#	Rules for compiling, assembling
#-----------------------------------------------------------------------------
.c.otc :
	( del $(OBJ)\$*.otc ;						\
	  $(TCP) $(CFLAGS) -o$(OBJ)\$*.otc $< )

.c.otm :
	( del $(OBJ)\$*.otm ;						\
	  $(TCP) $(CFLAGS) -B -o$(OBJ)\$*.otm $< )

.a86.ora :
	( del $(OBJ)\$*.ora ;						\
	  $(RASM) $< $(AFLAGS) ;					\
	  $(TOOLS)\mv $*.obj $(OBJ)\$*.ora )

.asm.ota :
	( del $(OBJ)\$*.ota ;						\
	  $(TASM) $<,$(OBJ)\$*.ota )

#-----------------------------------------------------------------------------
#	Path to RCS and .OBJ files
#	(Check out from the server!)
#-----------------------------------------------------------------------------
OBJ=.\obj
VPATH=.;$(OBJ)

#-----------------------------------------------------------------------------
#	ASSEMBLER START- must be at start of EXE
#-----------------------------------------------------------------------------
OTA_START=codeseg.ota
ORA_START=gemstart.ora	

#-----------------------------------------------------------------------------
#	ASSEMBLER FINISH- must be at end of EXE
#-----------------------------------------------------------------------------
ORA_END=proend.ora 

#-----------------------------------------------------------------------------
#	OTHER ASSEMBLER
#-----------------------------------------------------------------------------
ORAs=	gemgmain.ora	gemasm.ora	gsx2.ora	longasm.ora	\
	gemdosif.ora	
OTAs=

#-----------------------------------------------------------------------------
#	C OBJECT FILES
#-----------------------------------------------------------------------------
OTCs=	fruntime.otc	gemaplib.otc	gemasync.otc	gembase.otc	\
	gemcicon.otc	gemctrl.otc	gemdisp.otc	gemdos.otc	\
	gemevlib.otc	gemflag.otc	gemfmalt.otc	gemfmlib.otc	\
	gemfslib.otc	gemglobe.otc	gemgraf.otc	gemgrlib.otc	\
	gemgsxif.otc	geminit.otc	geminput.otc	gemmnlib.otc	\
	gemobed.otc	gemobjop.otc	gemoblib.otc	gempd.otc	\
	gemqueue.otc	gemrslib.otc	gemsclib.otc	gemshlib.otc	\
	gemsuper.otc	gemwmlib.otc	gemwrect.otc	optimize.otc	\
	viewapps.otc

#-----------------------------------------------------------------------------
#	Object files
#	(in link order!)
#-----------------------------------------------------------------------------
OBJs=	$(OTA_START) $(ORA_START) $(OTCs) $(ORAs) $(OTAs) $(ORA_END)

#-----------------------------------------------------------------------------
#	Default target
#-----------------------------------------------------------------------------
viewmax.ovl:	$(OBJs)
		$(TLINK4) $(LFLAGS) $(OBJs),	\
			 vmaes.exe,		\
			 vmaes.map,		\
			 $(TCPLIB)\c$(MODEL).lib	

##  Use the next line only when LFLAGS has /v in it.  Stops ndmake otherwise!
##		tdstrip -s vmaes.exe

		copy vmaes.exe viewmax.ovl
		xsum viewmax.ovl

#-----------------------------------------------------------------------------
#	Source files
#-----------------------------------------------------------------------------
gemstart.a86 	proend.a86 	gemgmain.a86	gemasm.a86	\
gsx2.a86	longasm.a86	gemdosif.a86	:
	$(RCS)\co $(RCSFLAGS) $(NET)\aes\rcs\$*.a86

codeseg.asm:
	$(RCS)\co $(RCSFLAGS) $(NET)\aes\rcs\$*.asm

fruntime.c	gemaplib.c	gemasync.c	gembase.c	\
gemcicon.c	gemctrl.c	gemdisp.c	gemdos.c	\
gemevlib.c	gemflag.c	gemfmalt.c	gemfmlib.c	\
gemfslib.c	gemglobe.c	gemgraf.c	gemgrlib.c	\
gemgsxif.c	geminit.c	geminput.c	gemmnlib.c	\
gemobed.c	gemobjop.c	gemoblib.c	gempd.c		\
gemqueue.c	gemrslib.c	gemsclib.c	gemshlib.c	\
gemsuper.c	gemwmlib.c	gemwrect.c	optimize.c	\
viewapps.c :
	$(RCS)\co $(RCSFLAGS) $(NET)\aes\rcs\$*.c

fruntime.h	portab.h	crysbind.h	bind.h		\
machine.h	basepage.h	gemlib.h	viewrun.h	\
struct.h	dos.h		funcdef.h	obdefs.h	\
gemkeybd.h	gsxdefs.h	gemflag.h	aproto.h	\
cproto.h	viewapps.h :
	$(RCS)\co $(RCSFLAGS) $(NET)\aes\rcs\$*.h

#-----------------------------------------------------------------------------
#	Source dependencies
#-----------------------------------------------------------------------------
$(ORAs) $(ORA_START) $(ORA_END)						\
		: $*.a86

$(OTAs) $(OTA_START) 							\
		: $*.asm

$(OTCs) 								\
		: $*.c portab.h machine.h aproto.h cproto.h

gemaplib.otc:	struct.h basepage.h obdefs.h gemlib.h viewrun.h 

gemasync.otc:	struct.h basepage.h obdefs.h gemlib.h 

gembase.otc:	gembase.c struct.h

gemctrl.otc:	struct.h basepage.h obdefs.h gemlib.h gemkeybd.h

gemdisp.otc:	struct.h basepage.h obdefs.h gemlib.h 

gemdos.otc:	dos.h 

gemevlib.otc:	struct.h basepage.h obdefs.h gemlib.h 

gemflag.otc: 	struct.h basepage.h obdefs.h gemlib.h 

gemfmalt.otc:	struct.h basepage.h obdefs.h gemlib.h viewrun.h viewapps.h

gemfmlib.otc:	struct.h basepage.h obdefs.h gemlib.h viewrun.h

gemfslib.otc:	struct.h obdefs.h viewapps.h dos.h gemlib.h viewrun.h

gemglobe.otc:	struct.h obdefs.h viewrun.h gemlib.h

gemgraf.otc:	obdefs.h gsxdefs.h bind.h funcdef.h 

gemcicon.otc:	bind.h obdefs.h gsxdefs.h 

gemgrlib.otc:	struct.h basepage.h obdefs.h gemlib.h 

gemgsxif.otc:	dos.h obdefs.h gsxdefs.h bind.h funcdef.h viewrun.h
 
geminit.otc:	obdefs.h struct.h funcdef.h basepage.h gemlib.h 	\
		crysbind.h viewrun.h dos.h fruntime.h viewapps.h

geminput.otc:	struct.h basepage.h obdefs.h gemlib.h 

gemmnlib.otc:	struct.h basepage.h obdefs.h gemlib.h viewapps.h	\
 
gemobed.otc:	struct.h basepage.h obdefs.h viewrun.h gemlib.h 	\
		viewapps.h

gemobjop.otc:	obdefs.h

gemoblib.otc:	struct.h basepage.h obdefs.h gemlib.h funcdef.h viewapps.h
 
gempd.otc:	struct.h basepage.h obdefs.h gemlib.h 

gemqueue.otc:	struct.h basepage.h obdefs.h gemlib.h 

gemrslib.otc:	struct.h basepage.h obdefs.h gemlib.h viewapps.h	\
 
gemsclib.otc:	struct.h basepage.h obdefs.h gemlib.h crysbind.h dos.h 	\
		viewrun.h viewapps.h

gemshlib.otc:	obdefs.h struct.h viewapps.h basepage.h dos.h viewrun.h	\
		gemlib.h 

gemsuper.otc:	struct.h basepage.h obdefs.h gemlib.h crysbind.h 	\
		viewrun.h 

gemwmlib.otc:	struct.h basepage.h obdefs.h gemlib.h 
 
gemwrect.otc:	struct.h basepage.h obdefs.h gemlib.h 

optimize.otc:	obdefs.h

viewapps.otc:	viewapps.h

#-----------------------------------------------------------------------------
#	EOF: aes.mak
#-----------------------------------------------------------------------------
