(* sample.pas - Sample ST Pascal plus Applikation

        Mark Rose       16 JAN 86
        Adapted from apskel.c by Ron Zdybl, Atari Corp.
*)

(*$M 16384,0,10000*)
PROGRAM Sample;

Uses Gembind;

VAR dummy,
    handle,
    wcell,
    hcell,
    wind_kind,
    min_width,
    min_height,
    xold,
    yold,
    hold,
    wold : integer ;
    msg : Message_Buffer ;
    wind_full : boolean ;
    wind_name : Window_Title ;


PROCEDURE Draw_Sample;
VAR x, y, w, h : integer;
BEGIN
  Paint_Style(Solid);
  Paint_Color(White);
  Work_Rect(handle, x, y, w, h);
  Paint_Rect(x, y, w, h);
  Paint_Style(17);
  Paint_Color(Black);
  Paint_Oval( x + (w DIV 2), y + (h DIV 2), w DIV 2, h DIV 2 );
END;

PROCEDURE Do_Redraw(xc, yc, wc, hc : integer);
VAR x, y, w, h : integer;
BEGIN
  Hide_Mouse;
  First_Rect(handle, x, y, w, h);
  WHILE (w <> 0) OR (h <> 0) DO
  BEGIN
    IF Rect_Intersect(xc, yc, wc, hc, x, y, w, h) THEN
    BEGIN
      Set_Clip(x, y, w, h);
      Draw_Sample;
    END ;
    Next_Rect(handle, x, y, w, h);
  END;
  Show_Mouse;
END;

PROCEDURE Event_Loop;
VAR x, y, w, h,
    event : integer;

BEGIN
  REPEAT
    event := Get_Event( E_Message OR E_Keyboard, 0, 0, 0, 0,
                        false, 0, 0, 0, 0,
                        false, 0, 0, 0, 0,
                        msg, dummy, dummy, dummy, x, y, dummy);
    Begin_Update;
    IF event AND E_Message <> 0 THEN
      CASE msg[0] OF
        WM_Redraw : Do_Redraw(msg[4], msg[5], msg[6], msg[7]);
        WM_Sized, WM_Moved :
              BEGIN
                IF msg[6] < min_width THEN msg[6] := min_width;
                IF msg[7] < min_height THEN msg[7] := min_height;
                Set_WSize(handle, msg[4], msg[5], msg[6], msg[7]);
              END;
        WM_Fulled :
              BEGIN
                IF wind_full THEN Set_WSize( handle, xold, yold, wold, hold)
                ELSE
                BEGIN
                  Border_Rect(handle, xold, yold, wold, hold);
                  Work_Rect(0, x, y, w, h);
                  Set_WSize(handle, x, y, w, h);
                END;
                wind_full := NOT wind_full
              END;
      END; (* CASE msg[0] OF *)

    IF event AND E_Keyboard <> 0 THEN
    BEGIN
      Work_Rect(handle, x, y, w, h);
      Do_Redraw(x, y, w, h);
    END;

    End_Update;

  UNTIL (event AND E_Message <> 0) AND (msg[0] = WM_Closed);
END;

BEGIN
  IF Init_Gem >= 0 THEN
  BEGIN
    Init_Mouse;
    Sys_Font_Size(dummy, dummy, wcell, hcell);
    min_width := wcell * 4;
    min_height := hcell * 4;
    wind_kind := G_Size OR G_Move OR G_Full OR G_Close OR G_Name;
    wind_name := ' Pascal Sample ';
    handle := New_Window(wind_kind, wind_name, 0, 0, min_width, min_height);
    Open_Window(handle, 0, hcell, min_width, min_height);
    Set_Mouse(M_Arrow);

    wind_full := false;

    Event_Loop;

    Close_Window(handle);
    Delete_Window(handle);

    Exit_Gem;
  END
END.
