;=========================================================================;
;  3270PC HIGH LEVEL LANGUAGE APPLICATION PROGRAM INTERFACE               ;
;  COBLIM - IBM COBOL Language Interface module.                          ;
;           V 1.0  05/28/84                                               ;
;                                                                         ;
; 1753180 (C) COPYRIGHT IBM CORPORATION 1984                              ;
; LICENSED MATERIAL - PROGRAM PROPERTY OF IBM                             ;
;=========================================================================;
CSEG            SEGMENT PARA PUBLIC 'CODE'
                ASSUME  CS:CSEG,DS:CSEG
;
;
LIMSTART:       JMP     REAL_START      ;PSEUDO START TO SKIP DSECTS
;
;===================================================================
; Language Interface Module (LIM) PARAMETER CONTROL BLOCK (PCB)
;
PPCBID          DB      'PCB'           ;PCB HDR
PFUNCODE        DB      0               ;USERS FUNCTION REQ CODE
PDSEG           DW      0               ;USERS DATA SEG
PDOFFS          DW      0               ;OFFSET TO USERS DATA
PDLEN           DW      0               ;DATA LENGTH
PSESSID         DB      0               ;RESERVED
PRETCODE        DW      0               ;RETURN CODE (1 BYTE EXCEPT FOR SRCH)
URETCODEADR     DW      0               ;NOT IN PCB, NEED ADDR TO PASS BACK TO
;====================================================================
        ASSUME  CS:CSEG,DS:CSEG,ES:NOTHING
;=================================================================
;
COBLIM  PROC    FAR
        PUBLIC  COBLIM
REAL_START:
;
        PUSH    BP              ;SAVE BP
        MOV     BP,SP           ;SET BASE PARM LIST
        MOV     AX,DS           ;COBOL DS IN AX
        MOV     ES,AX           ;ES NOW = HIS DS
        MOV     AX,CSEG         ;OK TO DESTROY AX, GET MY SEGREG SET
        MOV     DS,AX           ;SET MY SEGREG, HIS ES: STILL = OLD DS:
        MOV     AX,ES           ;GET HIS DSEG PTR
        MOV     PDSEG,AX        ;SAVE SEGREG POINTER      DSEG IN PCB
        MOV     SI,[BP]+12      ;GET FUNCTION CODE ADDRESS
        MOV     AL,ES:1 [SI]    ;GET FUNCTION CODE (2ND NIBBLE OF WORD)
        MOV     PFUNCODE,AL     ;SAVE FUNCTION BYTE       FUN CODE IN PCB
        MOV     SI,[BP]+6       ;GET RETCODE ADDRESS
        MOV     URETCODEADR,SI  ;SAVE RET CODE ADDR
;
;  SPECIAL CASE: GETSTR USES RETCODE TO PASS IN OFFSET PARM
;
        MOV     AX,ES:0 [SI]    ;GET RETCODE VALU (IN CASE ITS THE OFFSET)
        XCHG    AL,AH           ;FLIP VALUES FOR COBOL FORMAT DATA
        MOV     PRETCODE,AX     ;PUT INTO PCB            RETCODE IN PCB
        MOV     SI,[BP]+8       ;GET LENGTH ADDR
        MOV     AX,ES:0 [SI]    ;GET LENGTH VALU
        XCHG    AL,AH           ;FLIP VALUES FOR COBOL
        MOV     PDLEN,AX        ;SAVE IN PCB              LEN IN PCB
        MOV     AX,[BP]+10      ;GET PTR TO STRING
        MOV     PDOFFS,AX       ;SAVE STRING ADDRESS      STR PTR IN PCB
        MOV     PSESSID,0FFH    ;NO OP THIS FOR NOW.....
;
;  READY FOR THE INTERRUPT ......    (CHANGE IF INT NUM CHANGES)
;
        MOV     AX,0
        MOV     ES,AX                    ;POINT ES TO 0 SEG (LOW CORE)
        CMP     WORD PTR ES:0110H,0H     ;IS THERE AN INT POINTER
        JE      NOINT44
;
        LEA     SI,PPCBID                ;CALL WITH DS:SI POINTING TO PCB
        INT     44H                      ;CALL PCIRES
;
EXIT:
        MOV     AX,CSEG                  ;RESET MY SEGREGS
        MOV     DS,AX                    ;MY DS = CS
        MOV     AX,PDSEG                 ;GET COBOLS SEGREGS
        MOV     ES,AX
        MOV     DI,URETCODEADR           ;GET HIS RETCODE ADDR
        MOV     BX,PRETCODE              ;GET THE RETURN WORD
        XCHG    BL,BH                    ;FLIP BACKWARDS THE DATA FOR COBOL
        MOV     WORD PTR ES:0 [DI],BX    ;MOVE THE RETCODE WORD TO COBOL
        MOV     DS,AX                    ;RESET COBOL DS
;
        POP     BP
        RET     8                        ;RETURN TO COBOL
NOINT44:
        MOV     PRETCODE,1               ;CODE 1 = NOT AVAILABLE
        JMP     EXIT
COBLIM  ENDP
;=========================================================================
CSEG    ENDS
        END
