;=========================================================================;
;  CBASLIM - Compiled BASIC Language Interface module.                    ;
;           V 1.0  04/14/84                                               ;
;   3270PC HIGH LEVEL LANGUAGE APPLICATION PROGRAM INTERFACE 1753180      ;
;(C)COPYRIGHT 1984 IBM CORP.  LICENSED MATERIAL PROPERTY OF IBM           ;
;=========================================================================;
;
;  STRATEGY NOTE: For code compatability reasons, it is assumed the user
;                 may test under BASICA and run production compiled. The
;                 compiled LIM therefore uses the same call structure
;                 that is used by BASICA. In the BASICA environment a set
;                 of initialization code is executed to find a core resident
;                 module. In compiled BASIC this code is not required but
;                 will not hurt anything to leave it in place. The
;                 compiled BASIC interface is LINKed into the program and
;                 is not core resident.
;
CSEG            SEGMENT PARA PUBLIC 'CODE'
                ASSUME  CS:CSEG,DS:CSEG
BLISTART:       JMP     REAL_START      ;PSEUDO START TO SKIP DSECTS
;
;===================================================================
; Language Interface Module (LIM) PARAMETER CONTROL BLOCK (PCB)
;
PPCBID          DB      'PCB'           ;PCB HDR
PFUNCODE        DB      0               ;USERS FUNCTION REQ CODE
PDSEG           DW      0               ;USERS DATA SEG
PDOFFS          DW      0               ;OFFSET TO USERS DATA
PDLEN           DW      0               ;DATA LENGTH
PSESSID         DB      0               ;RESERVED
PRETCODE        DW      0               ;RETURN CODE (1 BYTE EXCEPT FOR SRCH)
URETCODEADR     DW      0               ;NOT IN PCB, NEED ADDR TO PASS BACK TO
USTRDWLEN       DW      0               ;USERS STRING DESCRIPTOR WORD LENGTH
;====================================================================
        ASSUME  CS:CSEG,DS:CSEG,ES:NOTHING
BLIM    PROC    FAR
        PUBLIC  BLIM            ;EXTERNAL MODULE NAME = BLIM
REAL_START:
;=========================================================================
;       MAIN PCI COMPILED BASIC ENTRY POINT
;               - ENTRY & CALL ANALYSIS
;               - CONTROL BLOCK VALIDATION & BUILD
;               - INT44 TO CALL MAIN PCI ROUTINE
;               - CALL WITH DS:SI POINTING TO THE USER PCB
;
BASICEPA:
        PUSH    BP              ;SAVE BP
        MOV     BP,SP           ;SET BASE PARM LIST
        MOV     AX,CSEG         ;OK TO DESTROY AX, GET MY SEGREG SET
        MOV     DS,AX           ;SET MY SEGREG, HIS ES: STILL = OLD DS:
        MOV     AX,ES           ;GET HIS DSEG PTR
        MOV     PDSEG,AX        ;SAVE SEGREG POINTER      DSEG IN PCB
        MOV     SI,[BP]+12      ;GET FUNCTION CODE ADDRESS
        MOV     AX,ES:0 [SI]    ;GET FUNCTION CODE
        MOV     PFUNCODE,AL     ;SAVE FUNCTION BYTE       FUN CODE IN PCB
        MOV     SI,[BP]+6       ;GET RETCODE ADDRESS
        MOV     URETCODEADR,SI  ;SAVE RET CODE ADDR
;
;  SPECIAL CASE: GETSTR USES RETCODE TO PASS IN OFFSET PARM
;
        MOV     AX,ES:0 [SI]    ;GET RETCODE VALU (IN CASE ITS THE OFFSET)
        MOV     PRETCODE,AX     ;PUT INTO PCB            RETCODE IN PCB
        MOV     SI,[BP]+8       ;GET LENGTH ADDR
        MOV     AX,ES:0 [SI]    ;GET LENGTH VALU
        MOV     PDLEN,AX        ;SAVE IN PCB              LEN IN PCB
        MOV     SI,[BP]+10      ;GET PTR TO STRING DESCRIPTOR WORD
        MOV     AX,ES:0 [SI]    ;GET COMPILED BASICS WORD LENGTH VALUE <<compiled
        MOV     USTRDWLEN,AX    ;SAVE TO CHECK STRING LENGTH ERRS
                                ;OTHERWISE WE DON'T CARE ABOUT THIS LENGTH VALU
        MOV     AX,ES:0 [SI]+2  ;GET POINTER TO ACTUAL STRING <<compiled>>
        MOV     PDOFFS,AX       ;SAVE STRING ADDRESS      STR PTR IN PCB
        MOV     PSESSID,0FFH    ;NO OP THIS FOR NOW.....
;
;  CHECK PARM VALIDITY
;
        CMP     PFUNCODE,0      ;GATE SW ?
        JE      CB_GATE
        CMP     PFUNCODE,05     ;COPY PS?
        JE      CB_COPYPS
        CMP     PFUNCODE,08     ;COPY STR
        JE      CB_COPYS
;
;  READY FOR THE INTERRUPT ...... (NOTE THAT CURRENT STACK IS 6 WORDS)
;
;
CB_DOIT:
        PUSH    ES              ;SAVE ES
        MOV     AX,0            ;SET ES TO LOW CORE
        MOV     ES,AX
        CMP     WORD PTR ES:0110H,0H    ;IS THERE SOME POINTER AT INT44 ?
        POP     ES              ;RESTORE ES
        JE      NOINT44         ;DONT DO THE INT
        LEA     SI,PPCBID       ;CALL WITH DS:SI POINTING TO PCB
        INT     44H             ;CALL PCIRES
;
PRE_EXIT:
        MOV     AX,CSEG         ;RESET MY SEGREGS
        MOV     DS,AX           ;MY DS = CS
        MOV     AX,PDSEG        ;GET BASICS SEGREGS
        MOV     ES,AX
        MOV     DI,URETCODEADR  ;GET HIS RETCODE ADDR
        MOV     BX,PRETCODE     ;GET THE RETURN WORD
        MOV     WORD PTR ES:0 [DI],BX  ;MOVE THE RETCODE WORD TO BASIC
        MOV     DS,AX           ;RESET BASIC DS
;
        POP     BP
        RET     8               ;RETURN TO BASIC
;
NOINT44:
        MOV     AX,01           ;CAN'T CONNECT RC (PCIRES NOT LOADED)
        MOV     PRETCODE,AX     ;SET IT
        JMP     PRE_EXIT
CB_GATE:
        MOV     PRETCODE,0      ;NO GATE SW IMPLEMENTED IN STD LIMS
        JMP     PRE_EXIT
CB_COPYPS:
        CMP     USTRDWLEN,1920  ;IS USERS STR DESCRIPT WORD AT LEAST 1920 ?
        JNL     CB_DOIT
        JMP     CB_PARMERR
CB_COPYS:                       ;COPY STRING
        MOV     AX,USTRDWLEN    ;GET HIS STRING LEN
        CMP     AX,PDLEN        ;COMPARE TO REQUESTED LEN
        JL      CB_PARMERR      ;WON'T FIT
        JMP     CB_DOIT
CB_PARMERR:
        MOV     PRETCODE,02     ;PARM ERR
        JMP     PRE_EXIT
BLIM    ENDP
;=========================================================================
CSEG    ENDS
        END
