
/*
Generate a simple C30 program that consists of six instructions.

Author: Chris Moy
Version: @(#)testmake.cc	1.3	08/22/97
*/

#include <stdio.h>

#include "byteswap.cc"

#define LONGWORDS 6

unsigned long info[LONGWORDS] = {
	0x08600001L,			/* LDI 1,R0 */
	0x13fb0020L,			/* RPTS 00020h */
	0x02600001L,			/* ADDI 1,R0 */
	0x0c800000L,			/* NOP */
	0x0c800000L,			/* NOP */
	0x0c800000L			/* NOP */
};

void main() {
	const char* filename = "testloop.c30";
	FILE* output = fopen(filename, "w");

        if (byteSwappedvsPC()) {
	  int i;
	  for (i = 0; i < LONGWORDS; i++) {
            info[i] = swapBytes(info[i]);
	  }
	}

	if (output) {
	  fwrite(info, sizeof(unsigned long), LONGWORDS, output);
	  fclose(output);
        }
	else {
	  fprintf(stderr, "Could not open '%s' for writing.\n", filename);
	}
}
