/*

Freely Distributable C30 Simulator Package

Copyright (c) 1996-1998 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Chi Duong, Brian Evans, and Chris Moy
Version: @(#)simulator.h	1.16	01/19/98

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

*/

#ifndef _C30SIM_SIMULATOR_H
#define _C30SIM_SIMULATOR_H

#include <stdio.h>
#include "state.h"
#include "pipeline.h"
#include "assm_fun.h"

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define C30_PROG_ROM_ADDRESS 0x00c0L
#define C30_PROG_RAM0_ADDRESS 0x00809800L
#define C30_PROG_RAM1_ADDRESS 0x00809c00L

#define C30SIM_MAX_BUFFER_LENGTH 256

#define C30SIM_EXIT_PROGRAM           -1
#define C30SIM_NO_ERROR                0
#define C30SIM_MISSING_ARGUMENTS       1
#define C30SIM_EXTRA_CHARS             2
#define C30SIM_ZERO_BREAKPOINT         3
#define C30SIM_NO_MORE_BREAKPOINTS     4
#define C30SIM_INVALID_ADDRESS         5
#define C30SIM_NO_BREAKPOINT           6
#define C30SIM_UNKNOWN_BREAKPOINT      7
#define C30SIM_INVALID_FILENAME        8
#define C30SIM_INVALID_LOCATION        9
#define C30SIM_INVALID_VALUE          10
#define C30SIM_INVALID_BREAKPOINT     11
#define C30SIM_NOT_IMPLEMENTED        12
#define C30SIM_NO_LOAD_COMMAND        13
#define C30SIM_NONPOSITIVE_STEPS      14
#define C30SIM_INVALID_PC             15
#define C30SIM_UNRECOGNIZED_COMMAND   16
#define C30SIM_UNRECOGNIZED_BOARD     17
#define C30SIM_ERROR_READING_FILE     18
#define C30SIM_ERROR_IN_ASSM          19
#define C30SIM_INVALID_COMMAND_FORMAT 20
#define C30SIM_UNSAFE_FILENAME        21
#define C30SIM_MAX_ERROR_NUMBER       21

/* Max. number of DSK breakpoints is given in DSK3D/SCREEN.H by MAX_BRK_PT */
#define C30SIM_BREAKSMAX 32

struct c30SimState_t {
  c30ProcType processor;
  int board;
  uint32 currentAddr;
  int numberOfBreakpoints;
  uint32 breakpoints[C30SIM_BREAKSMAX];
  state st;
  state oldst;
  pipeline pipe;
  char currentProg[C30SIM_MAX_BUFFER_LENGTH];
};
typedef struct c30SimState_t c30SimState;

struct C30SimCommandFunctions_t {
    const char* name;
    int length;
    int (*function)(const char*, c30SimState*);
    const char* comment;
};
typedef struct C30SimCommandFunctions_t C30SimCommandFunctions;
 
int C30SimClearBreakpoints(c30SimState* c30simptr);
int C30SimFindBreakpoint(c30SimState* c30simptr, uint32 address);
const char* C30SimCommandErrorMessage(int errorNumber);

int C30SimAssembleCommand(const char* input, c30SimState *c30simptr);
int C30SimBreakAddCommand(const char* input, c30SimState *c30simptr);
int C30SimBreakDelCommand(const char* input, c30SimState *c30simptr);
int C30SimC30StateCommand(const char* input, c30SimState *c30simptr);
int C30SimCopyrightCommand(const char* input, c30SimState *c30simptr);
int C30SimCycleCommand(const char* input, c30SimState *c30simptr);
int C30SimDasmOffCommand(const char* input, c30SimState *c30simptr);
int C30SimDasmOnCommand(const char* input, c30SimState *c30simptr);
int C30SimDummyCommand(const char* input, c30SimState* c30simptr );
int C30SimExitCommand(const char* input, c30SimState* c30simptr );
int C30SimLoadCommand(const char* input, c30SimState *c30simptr);
int C30SimModifyCommand(const char* input, c30SimState *c30simptr);
int C30SimNotAvailCommand(const char* input, c30SimState* c30simptr);
int C30SimReadCommand(const char* input, c30SimState *c30simptr);
int C30SimReloadCommand(const char* input, c30SimState *c30simptr);
int C30SimResetCommand(const char* input, c30SimState *c30simptr);
int C30SimRunCommand(const char* input, c30SimState *c30simptr);
int C30SimRunFreeCommand(const char* input, c30SimState *c30simptr);
int C30SimRunUntilCommand(const char* input, c30SimState *c30simptr);
int C30SimSimStateCommand(const char* input, c30SimState *c30simptr);
int C30SimStepCommand(const char* input, c30SimState *c30simptr);
int C30SimUpdateCommand(const char* input, c30SimState *c30simptr);
int C30SimVersionCommand(const char* input, c30SimState *c30simptr);

int C30SimAddBoard(const char* boardName, C30SimCommandFunctions* newCommands,
            c30ProcType processor, int outputMode);
C30SimCommandFunctions* C30SimSearchForFunction(
	    const char* input, C30SimCommandFunctions* commandInfo);
int C30SimFindBoardIdNum(const char* boardDesc);
C30SimCommandFunctions* C30SimBoardCommandTable(int boardId);
int C30SimProcessorBoardCompatibility(c30ProcType processor, int board);
int C30SimBoardProcessor(int board, c30ProcType* processorPtr);
const char* C30SimBoardName(int board);
int C30SimInitSimState(
            c30SimState* c30simptr, c30ProcType processor, int board);
int C30SimHelpCommand(const char* input, c30SimState* c30simptr);
int C30SimEndSimState(c30SimState* c30simptr);

int C30SimEvaluateCommand(const char* input, c30SimState* c30simptr);

#endif
