//----------------------------------------------------------------
// ASSM_FUN.H
// Keith Larson
// TMS320 DSP Applications
// (c) Copyright 1995, 1996
// Texas Instruments Incorporated
//
// This is unsupported freeware code with no implied warranties or
// liabilities.  See the disclaimer document for details
//----------------------------------------------------------------
#ifndef __ASSM_FUN
#define __ASSM_FUN
#include <stdio.h>
#include "typedefs.h"
#include "errormsg.h"
//---------- defines for MATHERR.CPP -----------
#ifdef __cplusplus
   typedef void (*fptr)(int);
#else
   typedef void (*fptr)();
#endif
extern void  Catcher(void);
//---------- defines for ASSM_FUN.CPP -----------
extern FILE  *dsk_file;
extern int   if_level;
extern int   g_pass;
extern int   g_line;    // avoid passing pointers through several levles
extern int   g_pass;    // of the expression analyzer
extern int   last_ref;
extern int   current_seg;
extern int   Enhanced_Enable;   // ASMC40.CPP
//extern char  C3Xmode;
extern char  if_on;
extern char  if_stack[];
extern char  g_strg1[];     // global var used for passing strings
extern char  g_strg2[];     // to error display functions
extern char  g_file[];
extern char  NON_COFF_MATH_F;
extern char  W_GLBL_FLAG;
extern ulong CURRENT_DP;      // DASMC40.CPP
extern ulong ENTRY;
extern ulong Global_Raw_Code; // Decode raw code for enhanced indirect
extern float DSK3A_rev;
extern int   inc_lvl;
extern long  loop_count;

struct operand
{
  unsigned int  shf;  // shift, >16 bit is meaningless
  unsigned long val;  // Value of converted object
  unsigned long msk;  // Mask to apply to value
};

typedef struct 
{
  unsigned long raw;
  unsigned long mask;
  operand A;          // Maximum of 6 operands to be packed into object
  operand B;
  operand C;
  operand D;
  operand E;
  operand F;
  operand G;
} OBJ;
//------  Registers Table -----
struct RegTbl
{
  char *s; // Pointer to register string
  char  v; // value of register
};
extern RegTbl C30Reg[];
#define MAXREG 28    // Last register for C3x
#define MAX_MOD 25   // Last entry in Mod Field Table
extern char  *Mod[];
//----- Conditions-Flags Table -----
#define MAX_COND   20      // <cond> = 11 ==> error, 21 possible codes
extern char  *Cond_tab[];
#define MAX_TRAP   31
#define IF_LVL_MAX 16
char  *argend       (char *ptr, char field);
int   isC4code      (int x);
int   bad_label     (char *ptr);
int   floatreg      (long x, int mode);
int   seg_add       (char *ptr, long addr);
int   isreg         (char *ptr, operand &op, int shf, ulong msk);
ulong obj_pack      (OBJ &obj);
MSGS  newseg        (int args, char *ptr, long *addr, int dir);
MSGS  passx         (char *name, char pass);
MSGS  assm          (char *strg1, char *strg2, OBJ &obj);
//MSGS  ref_add       (char *ptr, ulong value, int type, int addressable);
MSGS  assm_error_msg(MSGS err, char *strg);
void  BuildFastLook (void);
#endif
