/*

Freely Distributable C30 Simulator Package

Copyright (c) 1996-1998 The University of Texas
All Rights Reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.

Authors: Chi Duong, Brian Evans, and Chris Moy
Version: @(#)dsk_cmds.cc	1.4	01/19/98

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084

To add simulator commands for a debugger for a particular
board, add an entry to simulatorCommandTables.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "dsk_cmds.h"
#include "loadc30.h"

C30SimCommandFunctions C30SimDSKCommandFunctionsList[] = {
    { "?",        1, C30SimNotAvailCommand,
      "displays the value of the expression." },
    { "bload",    5, C30SimLoadCommand,
      "load binary data only from the specified filename." },
    { "coff2hex", 8, C30SimNotAvailCommand,
      "converts a COFF file (.out) to a HEX file." },
    { "cb",       2, C30SimBreakDelCommand,
      "deletes the specified breakpoint or all breakpoints if no breakpoint is specified." },
    { "cload",    5, C30SimNotAvailCommand,
      "reads the DSK3D (debugger) context from a file" },
    { "cmdbufload", 10, C30SimNotAvailCommand,
      "copies 'cmd string' to buffer xx." },
    { "copyright",   9, C30SimCopyrightCommand,
      "displays the copyright information for the simulator." },
    { "cread",    5, C30SimNotAvailCommand,
      "reads the DSK3D (debugger) context from a file" },
    { "csave",    5, C30SimNotAvailCommand,
      "saves the DSK3D (debugger) context to a file." },
    { "csaveall", 8, C30SimNotAvailCommand,
      "saves the DSK3D (debugger) context and all on-chip memory to a file." },
    { "csaveallcoff", 12, C30SimNotAvailCommand,
      "saves the DSK3D (debugger) context and all on-chip memory to COFF file." },
    { "csaveallhex", 11, C30SimNotAvailCommand,
      "saves the DSK3D (debugger) context and all on-chip memory to COFF file." },
    { "dasm",     4, C30SimNotAvailCommand,
      "disassembles the command at the specified address." },
    { "dasm0",    5, C30SimNotAvailCommand,
      "sets the disassembler (DASM) window display mode" },
    { "dasm1",    5, C30SimNotAvailCommand,
      "sets the disassembler (DASM) window display mode" },
    { "dasm2",    5, C30SimNotAvailCommand,
      "sets the disassembler (DASM) window display mode" },
    { "dasm3",    5, C30SimNotAvailCommand,
      "sets the disassembler (DASM) window display mode" },
    { "db",       2, C30SimSimStateCommand,
      "displays the state of the C30 simulator such as breakpoints." },
    { "dos",      3, C30SimNotAvailCommand,
      "gives a DOS prompt or executes a DOS program." },
    { "dsk2coff", 8, C30SimNotAvailCommand,
      "converts a DSK file (.dsk) to a COFF (.out) file." },
    { "dsk2hex",  7, C30SimNotAvailCommand,
      "converts a DSK file (.dsk) to a HEX file." },
    { "dsk3a",    5, C30SimNotAvailCommand,
      "assembles the specified filename." },
    { "edit",     4, C30SimNotAvailCommand,
      "opens an editor for the specified filename." },
    { "end",      3, C30SimNotAvailCommand,
      "ends a TAKE file." },
    { "exit",     4, C30SimExitCommand,
      "exits the simulator." },
    { "file2hex", 8, C30SimNotAvailCommand,
      "converts a DSK file to a HEX file." },
    { "flf",      3, C30SimLoadCommand,
      "performs a fast load from a HEX file." },
    { "float",    5, C30SimNotAvailCommand,
      "sets the CPU display format in floating-point format." },
    { "go",       2, C30SimRunUntilCommand,
      "executes the current program until the specified breakpoint is reached." },
    { "help",     4, C30SimHelpCommand,
      "prints out the list of commands or help on a specific command." },
    { "lf",       2, C30SimLoadCommand,
      "loads specified program beginning at specified location." },
    { "load",     4, C30SimLoadCommand,
      "loads specified program beginning at specified location." },
    { "maxflen",  7, C30SimNotAvailCommand,
      "sets the maximum output file length." },
    { "mem",      3, C30SimNotAvailCommand,
      "displays memory at the specified address in 32-bit hexadecimal format." },
    { "memd",     4, C30SimNotAvailCommand,
      "displays memory at the specified address in signed format." },
    { "memf",     4, C30SimNotAvailCommand,
      "displays memory at the specified address in floating-point format." },
    { "mem2coff", 8, C30SimNotAvailCommand,
      "display a range of memory in HEX format." },
    { "mem2hex",  7, C30SimNotAvailCommand,
      "display a range of memory in HEX format." },
    { "memi",     4, C30SimNotAvailCommand,
      "displays memory at the specified address in signed format." },
    { "meml",     4, C30SimNotAvailCommand,
      "displays memory at the specified address in signed format." },
    { "memqxx",   6, C30SimNotAvailCommand,
      "displays memory at the specified address in Q format." },
    { "memu",     4, C30SimNotAvailCommand,
      "displays memory at the specified address in unsigned format." },
    { "memud",    5, C30SimNotAvailCommand,
      "displays memory at the specified address in unsigned format." },
    { "memui",    5, C30SimNotAvailCommand,
      "displays memory at the specified address in unsigned format." },
    { "memul",    5, C30SimNotAvailCommand,
      "displays memory at the specified address in unsigned format." },
    { "memx",     4, C30SimNotAvailCommand,
      "displays memory at the specified address in 32-bit hexadecimal format." },
    { "mm",       2, C30SimNotAvailCommand,
      "modifies the memory with the specified value or fills the memory with copies of the specified value." },
    { "mov",      3, C30SimNotAvailCommand,
      "src,dst,n copies n words of memory from the source address src to the destination address dest" },
    { "move",     4, C30SimNotAvailCommand,
      "src,dst,n copies n words of memory from the source address src to the destination address dest" },
    { "pause",    5, C30SimNotAvailCommand,
      "pauses a TAKE file." },
    { "quit",     4, C30SimExitCommand,
      "exits the simulator." },
    { "reg40",    5, C30SimNotAvailCommand,
      "sets the CPU display format in 40-bit hexadecimal format." },
    { "reload",   6, C30SimReloadCommand,
      "executes the last load command." },
    { "reset",    5, C30SimResetCommand,
      "resets the C30 DSK board and clears the breakpoints." },
    { "run",      3, C30SimRunCommand,
      "executes the current program until a breakpoint is encountered." },
    { "runf",     4, C30SimRunFreeCommand,
      "executes the current program and ignores breakpoints." },
    { "save",     4, C30SimNotAvailCommand,
      "name,addr,length,t saves leng length words of memory beginning at address addr of datatype t." },
    { "sb",       2, C30SimBreakAddCommand,
      "adds a breakpoint at the specified location." },
    { "sc",       2, C30SimNotAvailCommand,
      "clears symbols." },
    { "sclear",   5, C30SimNotAvailCommand,
      "clears symbols." },
    { "sload",    5, C30SimNotAvailCommand,
      "load symbols from the specified filename." },
    { "ss",       2, C30SimStepCommand,
      "(single step) executes one instruction cycle." },
    { "step",     4, C30SimStepCommand,
      "executes the number of specified instruction cycles (one by default)." },
    { "sym",      3, C30SimNotAvailCommand,
      "displays the symbol table." },
    { "symbols",  7, C30SimNotAvailCommand,
      "displays the symbol table." },
    { "take",     4, C30SimNotAvailCommand,
      "loads commands from a file." },
    { "version",  7, C30SimVersionCommand,
      "displays the version of the simulator." },
    { "xg",       2, C30SimRunUntilCommand,
      "single step the program until it reaches the specified address." },
    { "xn",       2, C30SimStepCommand,
      "executes the number of specified instruction cycles (one by default)." },
    { "xoff",     4, C30SimNotAvailCommand,
      "disables PG6 extended opcodes." },
    { "xon",      3, C30SimNotAvailCommand,
      "enables PG6 extended opcodes." },
    { "",         0, 0, "" }
};
