# Copyright (c) 1990-1996 The Regents of the University of California.
# All rights reserved.
# 
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in all
# copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
# THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
# PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
# CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
# ENHANCEMENTS, OR MODIFICATIONS.
# 
# 						PT_COPYRIGHT_VERSION_2
# 						COPYRIGHTENDKEY
# Version @(#)latexinfo.mk	1.9 01/01/96
# Author:	T. M. Parks
# Created:	11 January 1994
#
# This file is included by the makefile in $PTOLEMY/doc/kernel_man
# that builds the kernel manual

# Command used for getting files from SCCS. (Gnu make)
GET=safe-get

# Add more directories to TEXINPUTS TeX search path for input files
# -- define it in shell format, e.g. MORE_TEXINPUTS=dir1:dir2:
# -- end the definition with a : to which TeX will add default directories
MORE_TEXINPUTS=

LATEXINFO= /usr/tools/gnu/src/latexinfo
TEXINPUTS= .:$(ROOT)/doc/tex:$(LATEXINFO)/styles:$(MORE_TEXINPUTS)

INFO=	-l $(ROOT)/doc/elisp/default.el -l $(LATEXINFO)/.emacs \
	-l latexinfo -l latexinfo-ext -l latexnfo-mde

EMACS= LATEXINFO=$(LATEXINFO) TEXINPUTS=$(TEXINPUTS) emacs-18
TEX= TEXINPUTS=$(TEXINPUTS) latex

# Intermediate files generated by LaTeX.
TEX_CLEAN= $*.aux $*.log $*.lof $*.lot $*.toc $*.glo $*.idx $*.bbl $*.blg

# Intermeditate files generated by LaTeXinfo.
INFO_CLEAN= $*.cp $*.pg $*.fn $*.vr $*.tp $*.ky \
	$*.cps $*.pgs $*.fns $*.vrs $*.tps $*.kys \
	$*.tex~ $*.info~

# Convert from TeXinfo to LaTeXinfo.
# This is done in interactive mode.
%.convert:	%.tex
	$(EMACS) $(INFO) -l t2latexinfo $<

# Update all nodes and menus in a master file and all included files,
# then generate an info file from the LaTeXinfo source.
%.info:		%.tex
	$(EMACS) -batch $(INFO) -f disable-read-only $< \
		-f latexinfo-build-buffer \
		-f latexinfo-update-everything \
		-f latexinfo-format-buffer \
		-f save-buffer -kill

# Intermediate files generated by LaTeX.
%.aux %.log %.lof %.lot %.toc %.glo %.idx %.bbl %.blg:	%.tex
	$(TEX) $<

# Index files generated by LaTeXinfo
%.cp %.pg %.fn %.vr %.tp %.ky:	%.tex
	$(TEX) $<

%.cps:	%.cp
	texindex $<

%.pgs:	%.pg
	texindex $<

%.fns:	%.fn
	texindex $<

%.vrs:	%.vr
	texindex $<

%.tps:	%.tp
	texindex $<

%.kys:	%.ky
	texindex $<

# Output file generated by LaTeX.
%.dvi:	%.tex
	$(TEX) $<

# Convert LaTeX output to PostScript.
%.ps:	%.dvi
	dvips -o $@ $<

# Remove all intermediate files.
%.clean:
	rm -f $(TEX_CLEAN) $(INFO_CLEAN)
