/*

$Log: sim.h,v $
 * Revision 1.6  1994/03/22  22:18:55  ted
 * added a number of procedure declarations to quiet down
 * gcc -Wall
 *
 * Revision 1.5  1993/02/02  01:04:56  ted
 * fixed erroneous declaration of condition bits to be unsigned
 * again.
 *
 * Revision 1.4  1993/01/30  00:00:35  ted
 * added word and byte declarations
 *
 * Revision 1.3  1993/01/28  02:05:20  ted
 * simple speed ups based on better inlining,
 * and passing a pointer to the state instead of
 * passing the actual state.
 *
 * Revision 1.2  1993/01/27  23:22:34  ted
 * added some commands for multi-stepping and support for breakpoints
 * and disassembling
 *

*/

#ifndef _SIM_H_
#define _SIM_H_

#include <stdio.h>

#ifndef _COMMON11_H_
typedef unsigned char byte;	/* 8 bit quantity */
typedef unsigned long word;	/* 16 bits + a bit */

typedef struct m6811_s {
    long t;			/* time in cycles */
    word d, x, y;		/* normal regs */
    word sp;			/* stack pointer */
    word pc;			/* program counter */
    unsigned int overflow:1;	/* overflow bit (V) */
    unsigned int negative:1;	/* negative bit (N) */
    unsigned int zero:1;	/* zero bit */
    unsigned int carry:1;	/* carry bit (C) */
    unsigned int idisable:1;	/* disable interrupts (I) */
    unsigned int half_carry:1;	/* half carry (H) */
    unsigned int x_interrupt:1;	/* x interrupt (X) */
    unsigned int stop_disable:1; /* stop disable (S) */
} m6811;
#endif

void set_half_carry(m6811 *state, int value);
void set_x_interrupt(m6811 *state, int value);
void set_stop_disable(m6811 *state, int value);
void set_overflow(m6811 *state, int value);
void set_negative(m6811 *state, int value);
void set_carry(m6811 *state, int value);
void set_idisable(m6811 *state, int value);
void set_zero(m6811 *state, int value);

int get_half_carry(m6811 *state);
int get_x_interrupt(m6811 *state);
int get_stop_disable(m6811 *state);
int get_overflow(m6811 *state);
int get_negative(m6811 *state);
int get_carry(m6811 *state);
int get_idisable(m6811 *state);
int get_zero(m6811 *state);

byte get_a(m6811 *state);
byte get_b(m6811 *state);
word get_x(m6811 *state);
word get_y(m6811 *state);
word get_s(m6811 *state);
word get_d(m6811 *state);
word get_pc(m6811 *state);
byte get_ccw(m6811 *state); /* added */

void set_a(m6811 *state, byte value);
void set_b(m6811 *state, byte value);
void set_d(m6811 *state, word value);
void set_x(m6811 *state, word value);
void set_y(m6811 *state, word value);
void set_s(m6811 *state, word value);
void set_pc(m6811 *state, word value);
void set_ccw(m6811 *state, byte value);
void set_mem8(byte *m, word address, byte value);
void set_mem16(byte *m, word address, word value);
byte get_mem8(byte *m, word add);
word get_mem16(byte *m, word add);

void bad_op(m6811 state);
void not_done(m6811 state, byte *);

#ifdef NEVER
/* load memory from s records */
 void load_code(FILE *f, byte *memory); 

/* display machine state */
void show_state(m6811 *state, byte m[], short breaks[]);
#endif

/* step one instruction.  modify state, possibly modify memory */
void single_step(m6811 *state, byte *m);

/* initialize the disassembler */
void init_dis();

/* disassemble some code.  put the disassembly out to f */
short disassemble(FILE *buf, byte *code, word add);

/* these functions must be defined EXTERNALLY */
void Error(const char *fmt, ...);
void handle_stop();

#endif /* _SIM_H_ */
