/*
 
Freely Distributable 68HC11 Simulator Package
 
Copyright (c) 1997-1998 The University of Texas
All Rights Reserved.
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
  
The GNU Public License is available in the file LICENSE, or you
can write to the Free Software Foundation, Inc., 59 Temple Place -
Suite 330, Boston, MA 02111-1307, USA, or you can find it on the
World Wide Web at http://www.fsf.org.
 
Authors: Brian Evans and Saleem Marwat
Version: @(#)main.h	1.3	01/19/98

Department of Electrical and Computer Engineering
The University of Texas, Austin, TX 78712-1084
*/

#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "foreign.h"
#include "sim.h"

#define M68HC11_PROMPT  "6811>"
#define M68HC11_MEMSIZE  65536
#define M68HC11_PAGELEN    256
#define BUFFER_LENGTH      128
#define M68HC11_PAGE0_VAL 0xaa;

extern char msg[];
extern long n_chars;
extern long caught_signal;
extern int debug;
extern char *VersionString;

void    debug_multi_step(int n, m6811* state, byte* memory, short* breaks);
Boolean hexScan(char *str, short *val);
void    interrupt();
long    load_code(FILE* f, byte* memory);
int     main(int argc, char *argv[]);
void    MC6811state(m6811 *state, byte* memory,
		    short* breaks, const char* programName);
void    mem_dump(m6811* state, byte* memory, word add, short n);
short   multi_step(short n, m6811* state, byte* memory, short* breaks);
void    not_done(m6811 state, byte *memory);
char*   readStringFromStream(char* buffer, int len, FILE* streamptr);
void    registers(m6811 *state);
void    reset(m6811* state, byte* memory, short* breaks);
void    setReg(m6811* state, char ch, int num);
void    showBreaks(m6811* state, short* breaks);
void    show_state(m6811* state, byte* memory, short* breaks);
